#include "mbed.h"
#include "motors.h"
#include "PID.h"

/*=================================================
--------------- CODIGO DOS MOTORES ----------------
=================================================*/

//------------------ FUNCOES ----------------------
float velocidadePadrao = 0.18;

PwmOut rodaEsquerda(p25); // Potencias da roda e direções
DigitalOut direcaoEsquerda (p26);
PwmOut rodaDireita(p24);
DigitalOut direcaoDireita (p23);
AnalogIn batMeasure (p22);


void Setup_Motores(void)//Funcao de setup dos motores, ajustando o periodo para inicializar o pwm
{ 
rodaEsquerda.period(0.01); 
rodaDireita.period(0.01); 
}

void ControleMotores (float VelocidadeEsquerda, float VelocidadeDireita ){ //Função drive, controla a velocidade de cada roda
    
    if (VelocidadeEsquerda <= 0){
        VelocidadeEsquerda = abs(VelocidadeEsquerda);//Utiliza o modulo da velocidade, pois esta nao pode ser negativa
        direcaoEsquerda = 0;//Muda a direcao da roda.
        rodaEsquerda.write(VelocidadeEsquerda);
    }
    else { direcaoEsquerda = 1; rodaEsquerda.write(VelocidadeEsquerda); }//Mantem a direcao da roda.
    
    if (VelocidadeDireita <= 0){
        VelocidadeDireita = abs(VelocidadeDireita);
        direcaoDireita = 0;
        rodaDireita.write(VelocidadeDireita);    
    }
    else { direcaoDireita = 1; rodaDireita.write(VelocidadeDireita); }
}

void Aceleracao(float velocidadeDesejada,int comando)
{
    int bandeira = 0; //bandeira para controle do while
    float novaVelocidade = velocidadePadrao;
    if(comando==1)
    {
    while(bandeira == 0)
    {
        novaVelocidade = novaVelocidade + 0.01;
        wait_us(1);//Deve ser testado se e necessario esse wait
        if (novaVelocidade <= velocidadeDesejada)
        {
            bandeira = 1;
        }
    }
    }
    else
    {
        while(bandeira == 0)
    {
        novaVelocidade = novaVelocidade - 0.01;
        wait_us(1);//Deve ser testado se e necessario esse wait
        if (novaVelocidade <= velocidadeDesejada)
        {
            bandeira = 1;
        }
    }
    }
}

float transformaPWM(float velocidadePWM)
{
    float leituraBateria = batMeasure;
    int kv=1100;
    int R=13;                                           //Raio da roda
    float rpm=leituraBateria*kv;
    float velocidadeNova = (2*3.14*R/60)*rpm ;           //Ao calcular essa velocidade temos o equivalente da velocidadePWM=1
                                                        
    velocidadeNova=velocidadeNova*velocidadePWM;         //Logo em seguida multiplicamos pela velocidadePWM, dando a porcentagem desejada da nossa velocidade
    return velocidadeNova;
}

float VelocidadeBateria(float velocidadeBase) // Funcao de setup da velocidade base dos motores
{
    float leituraBateria = batMeasure; //Lendo a carga da bateria em um numero de 0 a 1
    float tensaoBateria = 12.6 * leituraBateria; // Carga atual da bateria em Volts
    float novaVelocidade = velocidadeBase * 8.4/tensaoBateria;// Calculando a nova velocidade de acordo com a medida de carga atual da bateria
    return novaVelocidade;
}

/*float ajustaVelocidade(float velocidadeEsperada, float velocidadeReal)
{
    Correcao_roda=PID_roda();
    velocidadeEsperada=velocidadeReal + Correcao_roda
    return velocidadeEsperada;
}*/

void ParadaFinal()//Para o seguidor de linha
{ 
while(1) 
{ 
 rodaEsquerda.write(0); 
 rodaDireita.write(0);
 }
}
    
