#include "mbed.h"

#define debug true;
float perimetroDaRodaPorTick = (22*3.14*2)/(12*10); // perimetro da roda / (precisao do encoder * reducao)
//poderia ser define mas da alguem erro, acredito q seja por causa do OS 6

// acertar os pinos do encoder
InterruptIn encoderDireitoInterrupt (p29);
InterruptIn encoderEsquerdoInterrupt (p30);

DigitalIn encoderDireitoDigital (p28);
DigitalIn encoderEsquerdoDigital(p27);

Timer TempoParaVelocidadeDireita ;
Timer TempoParaVelocidadeEsquerda;

int contadorDeGirosDireito = 0;
int contadorDeGirosEsquerdo = 0;
int contadorDoMapa = 0; 

float velocidadeRodaDireita;
float velocidadeRodaEsquerda;
float mapaDaPista[100][2]; // 100 deve mudar 

#ifdef debug
    Serial pc(USBTX, USBRX); // Serial para conexao pelo pc
#endif
void ContaGirosDireito ()
{
    if(encoderDireitoDigital == 1)
    {
        contadorDeGirosDireito +=1 ; // Conta o giro
        velocidadeRodaDireita = perimetroDaRodaPorTick/TempoParaVelocidadeDireita.read();//calcula a velocidade
        TempoParaVelocidadeDireita.reset();
        
    } 
    else 
    {
        contadorDeGirosDireito -=1;// Conta o giro
        velocidadeRodaDireita = -perimetroDaRodaPorTick/TempoParaVelocidadeDireita.read();//calcula a velocidade
        TempoParaVelocidadeDireita.reset();
    }
    return;
}

void ContaGirosEsquerdo ()
{
    if(encoderEsquerdoDigital == 1)
    {
        contadorDeGirosEsquerdo += 1 ;// Conta o giro
        velocidadeRodaEsquerda = perimetroDaRodaPorTick/TempoParaVelocidadeEsquerda.read();//calcula a velocidade
        TempoParaVelocidadeEsquerda.reset();
    } 
    else 
    {
        contadorDeGirosEsquerdo -= 1;// Conta o giro
        velocidadeRodaEsquerda = -perimetroDaRodaPorTick/TempoParaVelocidadeEsquerda.read();//calcula a velocidade
        TempoParaVelocidadeEsquerda.reset();
    }
    return;
}

void MapeamentoDaPista() //coloca no mapa da pista o quanto cada roda percorreu
{
    if (contadorDeGirosDireito > 1000 || contadorDeGirosEsquerdo > 1000)
    {
        // Faz a contagem de giros do motor e guarda a distancia percorrida
        mapaDaPista[contadorDoMapa][0] = (contadorDeGirosEsquerdo * perimetroDaRodaPorTick)+mapaDaPista[contadorDoMapa-1][0];
        mapaDaPista[contadorDoMapa][1] = (contadorDeGirosDireito * perimetroDaRodaPorTick)+mapaDaPista[contadorDoMapa-1][1];
        contadorDeGirosDireito = 0;
        contadorDeGirosEsquerdo = 0;
        contadorDoMapa += 1;
    }
    return;
}


// main() runs in its own thread in the OS
int main()
{
    encoderDireitoInterrupt.rise(&ContaGirosDireito);
    encoderEsquerdoInterrupt.rise(&ContaGirosEsquerdo);
    TempoParaVelocidadeDireita.start();
    TempoParaVelocidadeEsquerda.start();
    while (true) {
        MapeamentoDaPista();
        #ifdef debug
            pc.printf ("Giros da roda direita: %i", (contadorDeGirosDireito));
            pc.printf ("Giros da roda esquerda: %i",(contadorDeGirosEsquerdo));
            pc.printf("Velocidade: %f",velocidadeRodaDireita);
        #endif
        
    }
}

