//================================================================================
//===========================  PID  CONTROL - PID.CPP  ===========================
//================================================================================

//*****************************  INCLUDES - INICIO  ******************************

#include "mbed.h"
#include "PID.h"
#include "Sensor.h"
#include "Motor.h"

//*****************************  INCLUDES -  FINAL  ******************************
//################################################################################
//################################################################################  
//****************************  DEFINICOES - INICIO  *****************************

#define Kp 0.05  //Definicao da constante proporcional do PID - Melhor valor 0.5
#define Kd 08.812 //Definicao da constante derivativa   do PID - Melhor valor 8.812
#define Ki -0.03  //Definicao da constante integrativa  do PID - Melhor valor -0.03

#define MIN_SPEED   0.0 //Definicao da velocidade minima em %
#define BASE_SPEED 20.0 //Definicao da velocidade base (no SetPoint) em %
#define MAX_SPEED  80.0 //Definicao da velocidade maxima em %

#define GANHO_CURVA 10 //Definicao do ganho em curva (quando o LF perder a linha) Valor original: 32
#define SET_POINT   45 //Definicao da leitura no SetPoint

#define MIN_INTEGRAL -50 //Definicao do valor minimo da integral do PID
#define MAX_INTEGRAL +50 //Definicao do valor maximo da integral do PID

Serial PCPID(USBTX,USBRX);

int LastError  = 0; //Definicao da variavel que armazenara o ultimo erro
int LastSensor = 0; //Definicao da variavel que armazenara a ultima posicao
int Integral   = 0; //Definicao  da variavel que armazera a soma dos erros

DigitalIn sM(p10);  //Definicao da porta do sensor traseiro do meio

//*****************************  DEFINICOES - FINAL  *****************************
//################################################################################
//################################################################################
//******************************* FUNCOES - INICIO  ******************************

//Define o mbed como um resistor de PullUp
void Meio_Setup(void){ sM.mode(PullUp); }

//Funcao que realiza o controle do Robo
void PID_Control(int Error, float *LeftSpeed, float *RightSpeed) {
    
    float Control; //Inicializacao da variavel de controle
    
    Error = Error - SET_POINT;
    PCPID.printf("Error: %d\n\r",Error);
    
    //Calculo do controle a partir do Erro\ Error = Error;
    if(Error > 25 || Error < -25){ Control = (Error * 5 * Kp) + ((Error - LastError)* 5 * Kd) + (Integral* 5 * Ki); }
    else { Control = (Error * Kp) + ((Error - LastError) * Kd) + (Integral * Ki); }
    PCPID.printf("Control: %d\n\r",Control);
    LastError = Error; //Atualizacao do ultimo Erro
    Integral += Error; //Atualizacao da samoa dos Erros
    
    //Caso o Erro seja zero (ja esta em linha reta) 
    //Se nao limita-se o valor da variavel 
    if (Error == 0) { Integral = 0; }
    else { if (Integral > MAX_INTEGRAL) { Integral = MAX_INTEGRAL; }
           if (Integral < MIN_INTEGRAL) { Integral = MIN_INTEGRAL; } }
           
    //Caso todos os sensores frontais leiam preto
    //o LF gira para o lado do ultimo sensor que leu a linha    
    if (Get_Preto()) {
           if(LastSensor > 0){ (*LeftSpeed) = -50; (*RightSpeed) = GANHO_CURVA;  } // Valor original: 40
           if(LastSensor < 0){ (*LeftSpeed) = GANHO_CURVA; (*RightSpeed) = -50;  } 
    }
    
    //Se pelo menos um sensor estiver lendo entra no else
    else {       
    LastSensor = Error;
    
    if(Error == 0 && sM.read() == 0){ //Caso o sensor fontal do meio esteja lendo a linha 
     (*LeftSpeed)  = 45;              //e o traseiro central também esteja, ativa o Turbo
     (*RightSpeed) = 45;
    }
    //Caso não entre em Turbo, atualiza a velocidade  
    else{
     (*LeftSpeed)  = BASE_SPEED - Control; //Atualizacao da velocidade esquerda
     (*RightSpeed) = BASE_SPEED + Control; //Atualizacao da velocidade direita
    }
    
    //Limitacao das velocidades do motor direito e esquerdo
    if ((*LeftSpeed)  > MAX_SPEED) { (*LeftSpeed)  = MAX_SPEED; }
    if ((*LeftSpeed)  < MIN_SPEED) { (*LeftSpeed)  = MIN_SPEED; }
    if ((*RightSpeed) > MAX_SPEED) { (*RightSpeed) = MAX_SPEED; }
    if ((*RightSpeed) < MIN_SPEED) { (*RightSpeed) = MIN_SPEED; }
    }
}

//******************************** FUNCOES - FINAL  ******************************