//================================================================================
//=========================  READ  SENSORS - SENSOR.CPP  =========================
//================================================================================

//*****************************  INCLUDES - INICIO  ******************************

#include "mbed.h"
#include "Sensor.h"

//*****************************  INCLUDES -  FINAL  ******************************
//################################################################################
//################################################################################
//****************************  DEFINICOES - INICIO  *****************************

//Definicao da porta de cada sensor
//| s1 | s2 | s3 | s4 | s5 | s6 | s7 | s8 |
/*InterruptIn s1(p5);  
InterruptIn s2(p6);
InterruptIn s3(p7);
InterruptIn s4(p8);
InterruptIn s5(p9);
InterruptIn s6(p12);
InterruptIn s7(p13);
InterruptIn s8(p14);*/

DigitalIn s1(p5);  
DigitalIn s2(p6);
DigitalIn s3(p7);
DigitalIn s4(p8);
DigitalIn s5(p9);
DigitalIn s6(p12);
DigitalIn s7(p13);
DigitalIn s8(p14);
//DigitalIn sR(p30);

#define LINHA 1 //LINHA = 1 -> Linha branca e fundo preto
                //LINHA = 0 -> Linha preta e fundo branco
                
int Position = 0;  //Variavel que armazenara a ponsicao dos sensores
int PRETO = 0;     //Variavel que indica se perdeu a linha
int lastRead = 1;  //Variavel que indica ultima leitura do sensor lateral direito
int atualRead = 1; //Variavel que indica leitura atual do sensor lateral direito

//*****************************  DEFINICOES - FINAL  *****************************
//################################################################################
//################################################################################
//******************************* FUNCOES - INICIO  ******************************

//Funcao que inicializa os sensores
//Define o mbed como um resistor de PullUp
void Sensors_Setup(void) {
    s1.mode(PullUp); 
    s2.mode(PullUp);
    s3.mode(PullUp);
    s4.mode(PullUp);
    s5.mode(PullUp);
    s6.mode(PullUp);
    s7.mode(PullUp);
    s8.mode(PullUp);
    //sR.mode(PullUp);
}

//Funcao que checa as linhas de inicio, fim e cruzamentos
//So ira retornar true quando sair da linha branca para a pista preta novamente
/*bool Check_Final(void){
    atualRead = sR.read();
    if(lastRead == 0 && atualRead != lastRead) {lastRead = atualRead; return true; }
    else{ lastRead = atualRead; return false; }
}*/

//Funcao que realiza a leitura de cada sensor
void Read_Sensors(void) {
    
    //| s1 | s2 | s3 | s4 | s5 | s6 | s7 | s8 |
    //| 10 | 20 | 30 | 40 | 50 | 60 | 70 | 80 |
    
    int Leitura = 0, Num_Sensors; Position = 0;
    
    if (LINHA) {
        Num_Sensors = 8;
        
        Leitura = s1.read(); Position += Leitura*10; Num_Sensors -= Leitura;
        Leitura = s2.read(); Position += Leitura*20; Num_Sensors -= Leitura;
        Leitura = s3.read(); Position += Leitura*30; Num_Sensors -= Leitura;
        Leitura = s4.read(); Position += Leitura*40; Num_Sensors -= Leitura;
        Leitura = s5.read(); Position += Leitura*50; Num_Sensors -= Leitura;
        Leitura = s6.read(); Position += Leitura*60; Num_Sensors -= Leitura;
        Leitura = s7.read(); Position += Leitura*70; Num_Sensors -= Leitura;
        Leitura = s8.read(); Position += Leitura*80; Num_Sensors -= Leitura;
        
        if(Position == 360) { PRETO = 1; }
        else { PRETO = 0; }
            
        Position = (360 - Position) / Num_Sensors;
    }
    
    else {
        Num_Sensors = 0;
        
        Leitura = s1.read(); Position += Leitura*10; Num_Sensors += Leitura;
        Leitura = s2.read(); Position += Leitura*20; Num_Sensors += Leitura;
        Leitura = s3.read(); Position += Leitura*30; Num_Sensors += Leitura;
        Leitura = s4.read(); Position += Leitura*40; Num_Sensors += Leitura;
        Leitura = s5.read(); Position += Leitura*50; Num_Sensors += Leitura;
        Leitura = s6.read(); Position += Leitura*60; Num_Sensors += Leitura;
        Leitura = s7.read(); Position += Leitura*70; Num_Sensors += Leitura;
        Leitura = s8.read(); Position += Leitura*80; Num_Sensors += Leitura;
        
        if(Position == 0) { PRETO = 1; }
        else { PRETO = 0; }
        
        Position = Position / Num_Sensors;  
    } 
}

//Funcao que retorna o valor da posicao dos sensores
int Get_Position(void) { return Position; }

//Funcao que retorna se os sensores frontais perderam a linha
int Get_Preto(void) { return PRETO; }

//******************************** FUNCOES - FINAL  ******************************