//================================================================================
//=========================  MOTORS CONTROL - MOTOR.CPP  =========================
//================================================================================

//*****************************  INCLUDES - INICIO  ******************************

#include "mbed.h"
#include "Motor.h"

//*****************************  INCLUDES -  FINAL  ******************************
//################################################################################
//################################################################################
//****************************  DEFINICOES - INICIO  *****************************

PwmOut LeftMotor(p23);  //Definicao da porta do motor da esquerda
PwmOut RightMotor(p24); //Definicao da porta do motor da direita

#define MIN  990
#define MAX  2040
#define MID ((MAX+MIN)/2)

int RLeft, RRight;

//*****************************  DEFINICOES - FINAL  *****************************
//################################################################################
//################################################################################
//******************************* FUNCOES - INICIO  ******************************

//Funcao que gera o sinal PPM do motor da esquerda
void Set_Left(int pulse)  { LeftMotor.pulsewidth_us(pulse);  }

//Funcao que gera o sinal PPM do motor da direita
void Set_Right(int pulse) { RightMotor.pulsewidth_us(pulse); }

//Funcao que inicializa os motores
void Motors_Setup(void) { RightMotor.period_ms(16); LeftMotor.period_ms(16); Set_Left(MID); Set_Right(MID); }//original 16

//Funcao que desloca os motores de acordo com o sinal PPM recebido
void Drive(int LeftSpeed, int RightSpeed) {
    
    if (LeftSpeed < 0) { LeftSpeed = (MID - abs(LeftSpeed)*5); } //original 5
    else { LeftSpeed = (MID + abs(LeftSpeed)*5); } //original 5
        
    if (RightSpeed < 0) { RightSpeed = (MID - abs(RightSpeed)*5); } //original 5
    else { RightSpeed = (MID + abs(RightSpeed)*5); } //original 5
    
    Set_Left(LeftSpeed); Set_Right(RightSpeed);
    RLeft = LeftSpeed; RRight = RightSpeed;
    
}

int Get_Left(void) { return RLeft; }
int Get_Right(void) { return RRight; }

//Funcao que matem o robo parado infinitamente
void Stop(void){ while(1){ Motors_Setup(); } }
//******************************** FUNCOES - FINAL  ******************************