/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K22P121M120SF7RM, Rev. 1, March 24, 2014
**     Version:             rev. 2.5, 2014-05-06
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-07-23)
**         Initial version.
**     - rev. 1.1 (2013-09-17)
**         RM rev. 0.4 update.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-20)
**         Update according to reference manual rev. 0.6,
**     - rev. 2.3 (2014-01-13)
**         Update according to reference manual rev. 0.61,
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK22F51212.h
**     - rev. 2.5 (2014-05-06)
**         Update according to reference manual rev. 1.0,
**         Update of system and startup files.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_CRC_REGISTERS_H__
#define __HW_CRC_REGISTERS_H__

#include "MK22F51212.h"
#include "fsl_bitaccess.h"

/*
 * MK22F51212 CRC
 *
 * Cyclic Redundancy Check
 *
 * Registers defined in this header file:
 * - HW_CRC_DATAL - CRC_DATAL register.
 * - HW_CRC_DATAH - CRC_DATAH register.
 * - HW_CRC_DATALL - CRC_DATALL register.
 * - HW_CRC_DATALU - CRC_DATALU register.
 * - HW_CRC_DATAHL - CRC_DATAHL register.
 * - HW_CRC_DATAHU - CRC_DATAHU register.
 * - HW_CRC_DATA - CRC Data register
 * - HW_CRC_GPOLY - CRC Polynomial register
 * - HW_CRC_GPOLYL - CRC_GPOLYL register.
 * - HW_CRC_GPOLYH - CRC_GPOLYH register.
 * - HW_CRC_GPOLYLL - CRC_GPOLYLL register.
 * - HW_CRC_GPOLYLU - CRC_GPOLYLU register.
 * - HW_CRC_GPOLYHL - CRC_GPOLYHL register.
 * - HW_CRC_GPOLYHU - CRC_GPOLYHU register.
 * - HW_CRC_CTRL - CRC Control register
 * - HW_CRC_CTRLHU - CRC_CTRLHU register.
 *
 * - hw_crc_t - Struct containing all module registers.
 */

#define HW_CRC_INSTANCE_COUNT (1U) /*!< Number of instances of the CRC module. */

/*******************************************************************************
 * HW_CRC_DATAL - CRC_DATAL register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_DATAL - CRC_DATAL register. (RW)
 *
 * Reset value: 0xFFFFU
 */
typedef union _hw_crc_datal
{
    uint16_t U;
    struct _hw_crc_datal_bitfields
    {
        uint16_t DATAL : 16;           /*!< [15:0] DATAL stores the lower 16 bits of
                                        * the 16/32 bit CRC */
    } B;
} hw_crc_datal_t;

/*!
 * @name Constants and macros for entire CRC_DATAL register
 */
/*@{*/
#define HW_CRC_DATAL_ADDR(x)     ((x) + 0x0U)

#define HW_CRC_DATAL(x)          (*(__IO hw_crc_datal_t *) HW_CRC_DATAL_ADDR(x))
#define HW_CRC_DATAL_RD(x)       (HW_CRC_DATAL(x).U)
#define HW_CRC_DATAL_WR(x, v)    (HW_CRC_DATAL(x).U = (v))
#define HW_CRC_DATAL_SET(x, v)   (HW_CRC_DATAL_WR(x, HW_CRC_DATAL_RD(x) |  (v)))
#define HW_CRC_DATAL_CLR(x, v)   (HW_CRC_DATAL_WR(x, HW_CRC_DATAL_RD(x) & ~(v)))
#define HW_CRC_DATAL_TOG(x, v)   (HW_CRC_DATAL_WR(x, HW_CRC_DATAL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATAL bitfields
 */

/*!
 * @name Register CRC_DATAL, field DATAL[15:0] (RW)
 */
/*@{*/
#define BP_CRC_DATAL_DATAL   (0U)          /*!< Bit position for CRC_DATAL_DATAL. */
#define BM_CRC_DATAL_DATAL   (0xFFFFU)     /*!< Bit mask for CRC_DATAL_DATAL. */
#define BS_CRC_DATAL_DATAL   (16U)         /*!< Bit field size in bits for CRC_DATAL_DATAL. */

/*! @brief Read current value of the CRC_DATAL_DATAL field. */
#define BR_CRC_DATAL_DATAL(x) (HW_CRC_DATAL(x).U)

/*! @brief Format value for bitfield CRC_DATAL_DATAL. */
#define BF_CRC_DATAL_DATAL(v) ((uint16_t)((uint16_t)(v) << BP_CRC_DATAL_DATAL) & BM_CRC_DATAL_DATAL)

/*! @brief Set the DATAL field to a new value. */
#define BW_CRC_DATAL_DATAL(x, v) (HW_CRC_DATAL_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_DATAH - CRC_DATAH register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_DATAH - CRC_DATAH register. (RW)
 *
 * Reset value: 0xFFFFU
 */
typedef union _hw_crc_datah
{
    uint16_t U;
    struct _hw_crc_datah_bitfields
    {
        uint16_t DATAH : 16;           /*!< [15:0] DATAH stores the high 16 bits of the
                                        * 16/32 bit CRC */
    } B;
} hw_crc_datah_t;

/*!
 * @name Constants and macros for entire CRC_DATAH register
 */
/*@{*/
#define HW_CRC_DATAH_ADDR(x)     ((x) + 0x2U)

#define HW_CRC_DATAH(x)          (*(__IO hw_crc_datah_t *) HW_CRC_DATAH_ADDR(x))
#define HW_CRC_DATAH_RD(x)       (HW_CRC_DATAH(x).U)
#define HW_CRC_DATAH_WR(x, v)    (HW_CRC_DATAH(x).U = (v))
#define HW_CRC_DATAH_SET(x, v)   (HW_CRC_DATAH_WR(x, HW_CRC_DATAH_RD(x) |  (v)))
#define HW_CRC_DATAH_CLR(x, v)   (HW_CRC_DATAH_WR(x, HW_CRC_DATAH_RD(x) & ~(v)))
#define HW_CRC_DATAH_TOG(x, v)   (HW_CRC_DATAH_WR(x, HW_CRC_DATAH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATAH bitfields
 */

/*!
 * @name Register CRC_DATAH, field DATAH[15:0] (RW)
 */
/*@{*/
#define BP_CRC_DATAH_DATAH   (0U)          /*!< Bit position for CRC_DATAH_DATAH. */
#define BM_CRC_DATAH_DATAH   (0xFFFFU)     /*!< Bit mask for CRC_DATAH_DATAH. */
#define BS_CRC_DATAH_DATAH   (16U)         /*!< Bit field size in bits for CRC_DATAH_DATAH. */

/*! @brief Read current value of the CRC_DATAH_DATAH field. */
#define BR_CRC_DATAH_DATAH(x) (HW_CRC_DATAH(x).U)

/*! @brief Format value for bitfield CRC_DATAH_DATAH. */
#define BF_CRC_DATAH_DATAH(v) ((uint16_t)((uint16_t)(v) << BP_CRC_DATAH_DATAH) & BM_CRC_DATAH_DATAH)

/*! @brief Set the DATAH field to a new value. */
#define BW_CRC_DATAH_DATAH(x, v) (HW_CRC_DATAH_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_DATALL - CRC_DATALL register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_DATALL - CRC_DATALL register. (RW)
 *
 * Reset value: 0xFFU
 */
typedef union _hw_crc_datall
{
    uint8_t U;
    struct _hw_crc_datall_bitfields
    {
        uint8_t DATALL : 8;            /*!< [7:0] CRCLL stores the first 8 bits of the
                                        * 32 bit DATA */
    } B;
} hw_crc_datall_t;

/*!
 * @name Constants and macros for entire CRC_DATALL register
 */
/*@{*/
#define HW_CRC_DATALL_ADDR(x)    ((x) + 0x0U)

#define HW_CRC_DATALL(x)         (*(__IO hw_crc_datall_t *) HW_CRC_DATALL_ADDR(x))
#define HW_CRC_DATALL_RD(x)      (HW_CRC_DATALL(x).U)
#define HW_CRC_DATALL_WR(x, v)   (HW_CRC_DATALL(x).U = (v))
#define HW_CRC_DATALL_SET(x, v)  (HW_CRC_DATALL_WR(x, HW_CRC_DATALL_RD(x) |  (v)))
#define HW_CRC_DATALL_CLR(x, v)  (HW_CRC_DATALL_WR(x, HW_CRC_DATALL_RD(x) & ~(v)))
#define HW_CRC_DATALL_TOG(x, v)  (HW_CRC_DATALL_WR(x, HW_CRC_DATALL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATALL bitfields
 */

/*!
 * @name Register CRC_DATALL, field DATALL[7:0] (RW)
 */
/*@{*/
#define BP_CRC_DATALL_DATALL (0U)          /*!< Bit position for CRC_DATALL_DATALL. */
#define BM_CRC_DATALL_DATALL (0xFFU)       /*!< Bit mask for CRC_DATALL_DATALL. */
#define BS_CRC_DATALL_DATALL (8U)          /*!< Bit field size in bits for CRC_DATALL_DATALL. */

/*! @brief Read current value of the CRC_DATALL_DATALL field. */
#define BR_CRC_DATALL_DATALL(x) (HW_CRC_DATALL(x).U)

/*! @brief Format value for bitfield CRC_DATALL_DATALL. */
#define BF_CRC_DATALL_DATALL(v) ((uint8_t)((uint8_t)(v) << BP_CRC_DATALL_DATALL) & BM_CRC_DATALL_DATALL)

/*! @brief Set the DATALL field to a new value. */
#define BW_CRC_DATALL_DATALL(x, v) (HW_CRC_DATALL_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_DATALU - CRC_DATALU register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_DATALU - CRC_DATALU register. (RW)
 *
 * Reset value: 0xFFU
 */
typedef union _hw_crc_datalu
{
    uint8_t U;
    struct _hw_crc_datalu_bitfields
    {
        uint8_t DATALU : 8;            /*!< [7:0] DATALL stores the second 8 bits of the
                                        * 32 bit CRC */
    } B;
} hw_crc_datalu_t;

/*!
 * @name Constants and macros for entire CRC_DATALU register
 */
/*@{*/
#define HW_CRC_DATALU_ADDR(x)    ((x) + 0x1U)

#define HW_CRC_DATALU(x)         (*(__IO hw_crc_datalu_t *) HW_CRC_DATALU_ADDR(x))
#define HW_CRC_DATALU_RD(x)      (HW_CRC_DATALU(x).U)
#define HW_CRC_DATALU_WR(x, v)   (HW_CRC_DATALU(x).U = (v))
#define HW_CRC_DATALU_SET(x, v)  (HW_CRC_DATALU_WR(x, HW_CRC_DATALU_RD(x) |  (v)))
#define HW_CRC_DATALU_CLR(x, v)  (HW_CRC_DATALU_WR(x, HW_CRC_DATALU_RD(x) & ~(v)))
#define HW_CRC_DATALU_TOG(x, v)  (HW_CRC_DATALU_WR(x, HW_CRC_DATALU_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATALU bitfields
 */

/*!
 * @name Register CRC_DATALU, field DATALU[7:0] (RW)
 */
/*@{*/
#define BP_CRC_DATALU_DATALU (0U)          /*!< Bit position for CRC_DATALU_DATALU. */
#define BM_CRC_DATALU_DATALU (0xFFU)       /*!< Bit mask for CRC_DATALU_DATALU. */
#define BS_CRC_DATALU_DATALU (8U)          /*!< Bit field size in bits for CRC_DATALU_DATALU. */

/*! @brief Read current value of the CRC_DATALU_DATALU field. */
#define BR_CRC_DATALU_DATALU(x) (HW_CRC_DATALU(x).U)

/*! @brief Format value for bitfield CRC_DATALU_DATALU. */
#define BF_CRC_DATALU_DATALU(v) ((uint8_t)((uint8_t)(v) << BP_CRC_DATALU_DATALU) & BM_CRC_DATALU_DATALU)

/*! @brief Set the DATALU field to a new value. */
#define BW_CRC_DATALU_DATALU(x, v) (HW_CRC_DATALU_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_DATAHL - CRC_DATAHL register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_DATAHL - CRC_DATAHL register. (RW)
 *
 * Reset value: 0xFFU
 */
typedef union _hw_crc_datahl
{
    uint8_t U;
    struct _hw_crc_datahl_bitfields
    {
        uint8_t DATAHL : 8;            /*!< [7:0] DATAHL stores the third 8 bits of the
                                        * 32 bit CRC */
    } B;
} hw_crc_datahl_t;

/*!
 * @name Constants and macros for entire CRC_DATAHL register
 */
/*@{*/
#define HW_CRC_DATAHL_ADDR(x)    ((x) + 0x2U)

#define HW_CRC_DATAHL(x)         (*(__IO hw_crc_datahl_t *) HW_CRC_DATAHL_ADDR(x))
#define HW_CRC_DATAHL_RD(x)      (HW_CRC_DATAHL(x).U)
#define HW_CRC_DATAHL_WR(x, v)   (HW_CRC_DATAHL(x).U = (v))
#define HW_CRC_DATAHL_SET(x, v)  (HW_CRC_DATAHL_WR(x, HW_CRC_DATAHL_RD(x) |  (v)))
#define HW_CRC_DATAHL_CLR(x, v)  (HW_CRC_DATAHL_WR(x, HW_CRC_DATAHL_RD(x) & ~(v)))
#define HW_CRC_DATAHL_TOG(x, v)  (HW_CRC_DATAHL_WR(x, HW_CRC_DATAHL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATAHL bitfields
 */

/*!
 * @name Register CRC_DATAHL, field DATAHL[7:0] (RW)
 */
/*@{*/
#define BP_CRC_DATAHL_DATAHL (0U)          /*!< Bit position for CRC_DATAHL_DATAHL. */
#define BM_CRC_DATAHL_DATAHL (0xFFU)       /*!< Bit mask for CRC_DATAHL_DATAHL. */
#define BS_CRC_DATAHL_DATAHL (8U)          /*!< Bit field size in bits for CRC_DATAHL_DATAHL. */

/*! @brief Read current value of the CRC_DATAHL_DATAHL field. */
#define BR_CRC_DATAHL_DATAHL(x) (HW_CRC_DATAHL(x).U)

/*! @brief Format value for bitfield CRC_DATAHL_DATAHL. */
#define BF_CRC_DATAHL_DATAHL(v) ((uint8_t)((uint8_t)(v) << BP_CRC_DATAHL_DATAHL) & BM_CRC_DATAHL_DATAHL)

/*! @brief Set the DATAHL field to a new value. */
#define BW_CRC_DATAHL_DATAHL(x, v) (HW_CRC_DATAHL_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_DATAHU - CRC_DATAHU register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_DATAHU - CRC_DATAHU register. (RW)
 *
 * Reset value: 0xFFU
 */
typedef union _hw_crc_datahu
{
    uint8_t U;
    struct _hw_crc_datahu_bitfields
    {
        uint8_t DATAHU : 8;            /*!< [7:0] DATAHU stores the fourth 8 bits of the
                                        * 32 bit CRC */
    } B;
} hw_crc_datahu_t;

/*!
 * @name Constants and macros for entire CRC_DATAHU register
 */
/*@{*/
#define HW_CRC_DATAHU_ADDR(x)    ((x) + 0x3U)

#define HW_CRC_DATAHU(x)         (*(__IO hw_crc_datahu_t *) HW_CRC_DATAHU_ADDR(x))
#define HW_CRC_DATAHU_RD(x)      (HW_CRC_DATAHU(x).U)
#define HW_CRC_DATAHU_WR(x, v)   (HW_CRC_DATAHU(x).U = (v))
#define HW_CRC_DATAHU_SET(x, v)  (HW_CRC_DATAHU_WR(x, HW_CRC_DATAHU_RD(x) |  (v)))
#define HW_CRC_DATAHU_CLR(x, v)  (HW_CRC_DATAHU_WR(x, HW_CRC_DATAHU_RD(x) & ~(v)))
#define HW_CRC_DATAHU_TOG(x, v)  (HW_CRC_DATAHU_WR(x, HW_CRC_DATAHU_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATAHU bitfields
 */

/*!
 * @name Register CRC_DATAHU, field DATAHU[7:0] (RW)
 */
/*@{*/
#define BP_CRC_DATAHU_DATAHU (0U)          /*!< Bit position for CRC_DATAHU_DATAHU. */
#define BM_CRC_DATAHU_DATAHU (0xFFU)       /*!< Bit mask for CRC_DATAHU_DATAHU. */
#define BS_CRC_DATAHU_DATAHU (8U)          /*!< Bit field size in bits for CRC_DATAHU_DATAHU. */

/*! @brief Read current value of the CRC_DATAHU_DATAHU field. */
#define BR_CRC_DATAHU_DATAHU(x) (HW_CRC_DATAHU(x).U)

/*! @brief Format value for bitfield CRC_DATAHU_DATAHU. */
#define BF_CRC_DATAHU_DATAHU(v) ((uint8_t)((uint8_t)(v) << BP_CRC_DATAHU_DATAHU) & BM_CRC_DATAHU_DATAHU)

/*! @brief Set the DATAHU field to a new value. */
#define BW_CRC_DATAHU_DATAHU(x, v) (HW_CRC_DATAHU_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_DATA - CRC Data register
 ******************************************************************************/

/*!
 * @brief HW_CRC_DATA - CRC Data register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The CRC Data register contains the value of the seed, data, and checksum.
 * When CTRL[WAS] is set, any write to the data register is regarded as the seed
 * value. When CTRL[WAS] is cleared, any write to the data register is regarded as
 * data for general CRC computation. In 16-bit CRC mode, the HU and HL fields are
 * not used for programming the seed value, and reads of these fields return an
 * indeterminate value. In 32-bit CRC mode, all fields are used for programming
 * the seed value. When programming data values, the values can be written 8 bits,
 * 16 bits, or 32 bits at a time, provided all bytes are contiguous; with MSB of
 * data value written first. After all data values are written, the CRC result
 * can be read from this data register. In 16-bit CRC mode, the CRC result is
 * available in the LU and LL fields. In 32-bit CRC mode, all fields contain the
 * result. Reads of this register at any time return the intermediate CRC value,
 * provided the CRC module is configured.
 */
typedef union _hw_crc_data
{
    uint32_t U;
    struct _hw_crc_data_bitfields
    {
        uint32_t LL : 8;               /*!< [7:0] CRC Low Lower Byte */
        uint32_t LU : 8;               /*!< [15:8] CRC Low Upper Byte */
        uint32_t HL : 8;               /*!< [23:16] CRC High Lower Byte */
        uint32_t HU : 8;               /*!< [31:24] CRC High Upper Byte */
    } B;
} hw_crc_data_t;

/*!
 * @name Constants and macros for entire CRC_DATA register
 */
/*@{*/
#define HW_CRC_DATA_ADDR(x)      ((x) + 0x0U)

#define HW_CRC_DATA(x)           (*(__IO hw_crc_data_t *) HW_CRC_DATA_ADDR(x))
#define HW_CRC_DATA_RD(x)        (HW_CRC_DATA(x).U)
#define HW_CRC_DATA_WR(x, v)     (HW_CRC_DATA(x).U = (v))
#define HW_CRC_DATA_SET(x, v)    (HW_CRC_DATA_WR(x, HW_CRC_DATA_RD(x) |  (v)))
#define HW_CRC_DATA_CLR(x, v)    (HW_CRC_DATA_WR(x, HW_CRC_DATA_RD(x) & ~(v)))
#define HW_CRC_DATA_TOG(x, v)    (HW_CRC_DATA_WR(x, HW_CRC_DATA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATA bitfields
 */

/*!
 * @name Register CRC_DATA, field LL[7:0] (RW)
 *
 * When CTRL[WAS] is 1, values written to this field are part of the seed value.
 * When CTRL[WAS] is 0, data written to this field is used for CRC checksum
 * generation.
 */
/*@{*/
#define BP_CRC_DATA_LL       (0U)          /*!< Bit position for CRC_DATA_LL. */
#define BM_CRC_DATA_LL       (0x000000FFU) /*!< Bit mask for CRC_DATA_LL. */
#define BS_CRC_DATA_LL       (8U)          /*!< Bit field size in bits for CRC_DATA_LL. */

/*! @brief Read current value of the CRC_DATA_LL field. */
#define BR_CRC_DATA_LL(x)    (HW_CRC_DATA(x).B.LL)

/*! @brief Format value for bitfield CRC_DATA_LL. */
#define BF_CRC_DATA_LL(v)    ((uint32_t)((uint32_t)(v) << BP_CRC_DATA_LL) & BM_CRC_DATA_LL)

/*! @brief Set the LL field to a new value. */
#define BW_CRC_DATA_LL(x, v) (HW_CRC_DATA_WR(x, (HW_CRC_DATA_RD(x) & ~BM_CRC_DATA_LL) | BF_CRC_DATA_LL(v)))
/*@}*/

/*!
 * @name Register CRC_DATA, field LU[15:8] (RW)
 *
 * When CTRL[WAS] is 1, values written to this field are part of the seed value.
 * When CTRL[WAS] is 0, data written to this field is used for CRC checksum
 * generation.
 */
/*@{*/
#define BP_CRC_DATA_LU       (8U)          /*!< Bit position for CRC_DATA_LU. */
#define BM_CRC_DATA_LU       (0x0000FF00U) /*!< Bit mask for CRC_DATA_LU. */
#define BS_CRC_DATA_LU       (8U)          /*!< Bit field size in bits for CRC_DATA_LU. */

/*! @brief Read current value of the CRC_DATA_LU field. */
#define BR_CRC_DATA_LU(x)    (HW_CRC_DATA(x).B.LU)

/*! @brief Format value for bitfield CRC_DATA_LU. */
#define BF_CRC_DATA_LU(v)    ((uint32_t)((uint32_t)(v) << BP_CRC_DATA_LU) & BM_CRC_DATA_LU)

/*! @brief Set the LU field to a new value. */
#define BW_CRC_DATA_LU(x, v) (HW_CRC_DATA_WR(x, (HW_CRC_DATA_RD(x) & ~BM_CRC_DATA_LU) | BF_CRC_DATA_LU(v)))
/*@}*/

/*!
 * @name Register CRC_DATA, field HL[23:16] (RW)
 *
 * In 16-bit CRC mode (CTRL[TCRC] is 0), this field is not used for programming
 * a seed value. In 32-bit CRC mode (CTRL[TCRC] is 1), values written to this
 * field are part of the seed value when CTRL[WAS] is 1. When CTRL[WAS] is 0, data
 * written to this field is used for CRC checksum generation in both 16-bit and
 * 32-bit CRC modes.
 */
/*@{*/
#define BP_CRC_DATA_HL       (16U)         /*!< Bit position for CRC_DATA_HL. */
#define BM_CRC_DATA_HL       (0x00FF0000U) /*!< Bit mask for CRC_DATA_HL. */
#define BS_CRC_DATA_HL       (8U)          /*!< Bit field size in bits for CRC_DATA_HL. */

/*! @brief Read current value of the CRC_DATA_HL field. */
#define BR_CRC_DATA_HL(x)    (HW_CRC_DATA(x).B.HL)

/*! @brief Format value for bitfield CRC_DATA_HL. */
#define BF_CRC_DATA_HL(v)    ((uint32_t)((uint32_t)(v) << BP_CRC_DATA_HL) & BM_CRC_DATA_HL)

/*! @brief Set the HL field to a new value. */
#define BW_CRC_DATA_HL(x, v) (HW_CRC_DATA_WR(x, (HW_CRC_DATA_RD(x) & ~BM_CRC_DATA_HL) | BF_CRC_DATA_HL(v)))
/*@}*/

/*!
 * @name Register CRC_DATA, field HU[31:24] (RW)
 *
 * In 16-bit CRC mode (CTRL[TCRC] is 0), this field is not used for programming
 * a seed value. In 32-bit CRC mode (CTRL[TCRC] is 1), values written to this
 * field are part of the seed value when CTRL[WAS] is 1. When CTRL[WAS] is 0, data
 * written to this field is used for CRC checksum generation in both 16-bit and
 * 32-bit CRC modes.
 */
/*@{*/
#define BP_CRC_DATA_HU       (24U)         /*!< Bit position for CRC_DATA_HU. */
#define BM_CRC_DATA_HU       (0xFF000000U) /*!< Bit mask for CRC_DATA_HU. */
#define BS_CRC_DATA_HU       (8U)          /*!< Bit field size in bits for CRC_DATA_HU. */

/*! @brief Read current value of the CRC_DATA_HU field. */
#define BR_CRC_DATA_HU(x)    (HW_CRC_DATA(x).B.HU)

/*! @brief Format value for bitfield CRC_DATA_HU. */
#define BF_CRC_DATA_HU(v)    ((uint32_t)((uint32_t)(v) << BP_CRC_DATA_HU) & BM_CRC_DATA_HU)

/*! @brief Set the HU field to a new value. */
#define BW_CRC_DATA_HU(x, v) (HW_CRC_DATA_WR(x, (HW_CRC_DATA_RD(x) & ~BM_CRC_DATA_HU) | BF_CRC_DATA_HU(v)))
/*@}*/

/*******************************************************************************
 * HW_CRC_GPOLY - CRC Polynomial register
 ******************************************************************************/

/*!
 * @brief HW_CRC_GPOLY - CRC Polynomial register (RW)
 *
 * Reset value: 0x00001021U
 *
 * This register contains the value of the polynomial for the CRC calculation.
 * The HIGH field contains the upper 16 bits of the CRC polynomial, which are used
 * only in 32-bit CRC mode. Writes to the HIGH field are ignored in 16-bit CRC
 * mode. The LOW field contains the lower 16 bits of the CRC polynomial, which are
 * used in both 16- and 32-bit CRC modes.
 */
typedef union _hw_crc_gpoly
{
    uint32_t U;
    struct _hw_crc_gpoly_bitfields
    {
        uint32_t LOW : 16;             /*!< [15:0] Low Polynominal Half-word */
        uint32_t HIGH : 16;            /*!< [31:16] High Polynominal Half-word */
    } B;
} hw_crc_gpoly_t;

/*!
 * @name Constants and macros for entire CRC_GPOLY register
 */
/*@{*/
#define HW_CRC_GPOLY_ADDR(x)     ((x) + 0x4U)

#define HW_CRC_GPOLY(x)          (*(__IO hw_crc_gpoly_t *) HW_CRC_GPOLY_ADDR(x))
#define HW_CRC_GPOLY_RD(x)       (HW_CRC_GPOLY(x).U)
#define HW_CRC_GPOLY_WR(x, v)    (HW_CRC_GPOLY(x).U = (v))
#define HW_CRC_GPOLY_SET(x, v)   (HW_CRC_GPOLY_WR(x, HW_CRC_GPOLY_RD(x) |  (v)))
#define HW_CRC_GPOLY_CLR(x, v)   (HW_CRC_GPOLY_WR(x, HW_CRC_GPOLY_RD(x) & ~(v)))
#define HW_CRC_GPOLY_TOG(x, v)   (HW_CRC_GPOLY_WR(x, HW_CRC_GPOLY_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLY bitfields
 */

/*!
 * @name Register CRC_GPOLY, field LOW[15:0] (RW)
 *
 * Writable and readable in both 32-bit and 16-bit CRC modes.
 */
/*@{*/
#define BP_CRC_GPOLY_LOW     (0U)          /*!< Bit position for CRC_GPOLY_LOW. */
#define BM_CRC_GPOLY_LOW     (0x0000FFFFU) /*!< Bit mask for CRC_GPOLY_LOW. */
#define BS_CRC_GPOLY_LOW     (16U)         /*!< Bit field size in bits for CRC_GPOLY_LOW. */

/*! @brief Read current value of the CRC_GPOLY_LOW field. */
#define BR_CRC_GPOLY_LOW(x)  (HW_CRC_GPOLY(x).B.LOW)

/*! @brief Format value for bitfield CRC_GPOLY_LOW. */
#define BF_CRC_GPOLY_LOW(v)  ((uint32_t)((uint32_t)(v) << BP_CRC_GPOLY_LOW) & BM_CRC_GPOLY_LOW)

/*! @brief Set the LOW field to a new value. */
#define BW_CRC_GPOLY_LOW(x, v) (HW_CRC_GPOLY_WR(x, (HW_CRC_GPOLY_RD(x) & ~BM_CRC_GPOLY_LOW) | BF_CRC_GPOLY_LOW(v)))
/*@}*/

/*!
 * @name Register CRC_GPOLY, field HIGH[31:16] (RW)
 *
 * Writable and readable in 32-bit CRC mode (CTRL[TCRC] is 1). This field is not
 * writable in 16-bit CRC mode (CTRL[TCRC] is 0).
 */
/*@{*/
#define BP_CRC_GPOLY_HIGH    (16U)         /*!< Bit position for CRC_GPOLY_HIGH. */
#define BM_CRC_GPOLY_HIGH    (0xFFFF0000U) /*!< Bit mask for CRC_GPOLY_HIGH. */
#define BS_CRC_GPOLY_HIGH    (16U)         /*!< Bit field size in bits for CRC_GPOLY_HIGH. */

/*! @brief Read current value of the CRC_GPOLY_HIGH field. */
#define BR_CRC_GPOLY_HIGH(x) (HW_CRC_GPOLY(x).B.HIGH)

/*! @brief Format value for bitfield CRC_GPOLY_HIGH. */
#define BF_CRC_GPOLY_HIGH(v) ((uint32_t)((uint32_t)(v) << BP_CRC_GPOLY_HIGH) & BM_CRC_GPOLY_HIGH)

/*! @brief Set the HIGH field to a new value. */
#define BW_CRC_GPOLY_HIGH(x, v) (HW_CRC_GPOLY_WR(x, (HW_CRC_GPOLY_RD(x) & ~BM_CRC_GPOLY_HIGH) | BF_CRC_GPOLY_HIGH(v)))
/*@}*/
/*******************************************************************************
 * HW_CRC_GPOLYL - CRC_GPOLYL register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_GPOLYL - CRC_GPOLYL register. (RW)
 *
 * Reset value: 0xFFFFU
 */
typedef union _hw_crc_gpolyl
{
    uint16_t U;
    struct _hw_crc_gpolyl_bitfields
    {
        uint16_t GPOLYL : 16;          /*!< [15:0] POLYL stores the lower 16 bits of
                                        * the 16/32 bit CRC polynomial value */
    } B;
} hw_crc_gpolyl_t;

/*!
 * @name Constants and macros for entire CRC_GPOLYL register
 */
/*@{*/
#define HW_CRC_GPOLYL_ADDR(x)    ((x) + 0x4U)

#define HW_CRC_GPOLYL(x)         (*(__IO hw_crc_gpolyl_t *) HW_CRC_GPOLYL_ADDR(x))
#define HW_CRC_GPOLYL_RD(x)      (HW_CRC_GPOLYL(x).U)
#define HW_CRC_GPOLYL_WR(x, v)   (HW_CRC_GPOLYL(x).U = (v))
#define HW_CRC_GPOLYL_SET(x, v)  (HW_CRC_GPOLYL_WR(x, HW_CRC_GPOLYL_RD(x) |  (v)))
#define HW_CRC_GPOLYL_CLR(x, v)  (HW_CRC_GPOLYL_WR(x, HW_CRC_GPOLYL_RD(x) & ~(v)))
#define HW_CRC_GPOLYL_TOG(x, v)  (HW_CRC_GPOLYL_WR(x, HW_CRC_GPOLYL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLYL bitfields
 */

/*!
 * @name Register CRC_GPOLYL, field GPOLYL[15:0] (RW)
 */
/*@{*/
#define BP_CRC_GPOLYL_GPOLYL (0U)          /*!< Bit position for CRC_GPOLYL_GPOLYL. */
#define BM_CRC_GPOLYL_GPOLYL (0xFFFFU)     /*!< Bit mask for CRC_GPOLYL_GPOLYL. */
#define BS_CRC_GPOLYL_GPOLYL (16U)         /*!< Bit field size in bits for CRC_GPOLYL_GPOLYL. */

/*! @brief Read current value of the CRC_GPOLYL_GPOLYL field. */
#define BR_CRC_GPOLYL_GPOLYL(x) (HW_CRC_GPOLYL(x).U)

/*! @brief Format value for bitfield CRC_GPOLYL_GPOLYL. */
#define BF_CRC_GPOLYL_GPOLYL(v) ((uint16_t)((uint16_t)(v) << BP_CRC_GPOLYL_GPOLYL) & BM_CRC_GPOLYL_GPOLYL)

/*! @brief Set the GPOLYL field to a new value. */
#define BW_CRC_GPOLYL_GPOLYL(x, v) (HW_CRC_GPOLYL_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_GPOLYH - CRC_GPOLYH register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_GPOLYH - CRC_GPOLYH register. (RW)
 *
 * Reset value: 0xFFFFU
 */
typedef union _hw_crc_gpolyh
{
    uint16_t U;
    struct _hw_crc_gpolyh_bitfields
    {
        uint16_t GPOLYH : 16;          /*!< [15:0] POLYH stores the high 16 bits of
                                        * the 16/32 bit CRC polynomial value */
    } B;
} hw_crc_gpolyh_t;

/*!
 * @name Constants and macros for entire CRC_GPOLYH register
 */
/*@{*/
#define HW_CRC_GPOLYH_ADDR(x)    ((x) + 0x6U)

#define HW_CRC_GPOLYH(x)         (*(__IO hw_crc_gpolyh_t *) HW_CRC_GPOLYH_ADDR(x))
#define HW_CRC_GPOLYH_RD(x)      (HW_CRC_GPOLYH(x).U)
#define HW_CRC_GPOLYH_WR(x, v)   (HW_CRC_GPOLYH(x).U = (v))
#define HW_CRC_GPOLYH_SET(x, v)  (HW_CRC_GPOLYH_WR(x, HW_CRC_GPOLYH_RD(x) |  (v)))
#define HW_CRC_GPOLYH_CLR(x, v)  (HW_CRC_GPOLYH_WR(x, HW_CRC_GPOLYH_RD(x) & ~(v)))
#define HW_CRC_GPOLYH_TOG(x, v)  (HW_CRC_GPOLYH_WR(x, HW_CRC_GPOLYH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLYH bitfields
 */

/*!
 * @name Register CRC_GPOLYH, field GPOLYH[15:0] (RW)
 */
/*@{*/
#define BP_CRC_GPOLYH_GPOLYH (0U)          /*!< Bit position for CRC_GPOLYH_GPOLYH. */
#define BM_CRC_GPOLYH_GPOLYH (0xFFFFU)     /*!< Bit mask for CRC_GPOLYH_GPOLYH. */
#define BS_CRC_GPOLYH_GPOLYH (16U)         /*!< Bit field size in bits for CRC_GPOLYH_GPOLYH. */

/*! @brief Read current value of the CRC_GPOLYH_GPOLYH field. */
#define BR_CRC_GPOLYH_GPOLYH(x) (HW_CRC_GPOLYH(x).U)

/*! @brief Format value for bitfield CRC_GPOLYH_GPOLYH. */
#define BF_CRC_GPOLYH_GPOLYH(v) ((uint16_t)((uint16_t)(v) << BP_CRC_GPOLYH_GPOLYH) & BM_CRC_GPOLYH_GPOLYH)

/*! @brief Set the GPOLYH field to a new value. */
#define BW_CRC_GPOLYH_GPOLYH(x, v) (HW_CRC_GPOLYH_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_GPOLYLL - CRC_GPOLYLL register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_GPOLYLL - CRC_GPOLYLL register. (RW)
 *
 * Reset value: 0xFFU
 */
typedef union _hw_crc_gpolyll
{
    uint8_t U;
    struct _hw_crc_gpolyll_bitfields
    {
        uint8_t GPOLYLL : 8;           /*!< [7:0] POLYLL stores the first 8 bits of the
                                        * 32 bit CRC */
    } B;
} hw_crc_gpolyll_t;

/*!
 * @name Constants and macros for entire CRC_GPOLYLL register
 */
/*@{*/
#define HW_CRC_GPOLYLL_ADDR(x)   ((x) + 0x4U)

#define HW_CRC_GPOLYLL(x)        (*(__IO hw_crc_gpolyll_t *) HW_CRC_GPOLYLL_ADDR(x))
#define HW_CRC_GPOLYLL_RD(x)     (HW_CRC_GPOLYLL(x).U)
#define HW_CRC_GPOLYLL_WR(x, v)  (HW_CRC_GPOLYLL(x).U = (v))
#define HW_CRC_GPOLYLL_SET(x, v) (HW_CRC_GPOLYLL_WR(x, HW_CRC_GPOLYLL_RD(x) |  (v)))
#define HW_CRC_GPOLYLL_CLR(x, v) (HW_CRC_GPOLYLL_WR(x, HW_CRC_GPOLYLL_RD(x) & ~(v)))
#define HW_CRC_GPOLYLL_TOG(x, v) (HW_CRC_GPOLYLL_WR(x, HW_CRC_GPOLYLL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLYLL bitfields
 */

/*!
 * @name Register CRC_GPOLYLL, field GPOLYLL[7:0] (RW)
 */
/*@{*/
#define BP_CRC_GPOLYLL_GPOLYLL (0U)        /*!< Bit position for CRC_GPOLYLL_GPOLYLL. */
#define BM_CRC_GPOLYLL_GPOLYLL (0xFFU)     /*!< Bit mask for CRC_GPOLYLL_GPOLYLL. */
#define BS_CRC_GPOLYLL_GPOLYLL (8U)        /*!< Bit field size in bits for CRC_GPOLYLL_GPOLYLL. */

/*! @brief Read current value of the CRC_GPOLYLL_GPOLYLL field. */
#define BR_CRC_GPOLYLL_GPOLYLL(x) (HW_CRC_GPOLYLL(x).U)

/*! @brief Format value for bitfield CRC_GPOLYLL_GPOLYLL. */
#define BF_CRC_GPOLYLL_GPOLYLL(v) ((uint8_t)((uint8_t)(v) << BP_CRC_GPOLYLL_GPOLYLL) & BM_CRC_GPOLYLL_GPOLYLL)

/*! @brief Set the GPOLYLL field to a new value. */
#define BW_CRC_GPOLYLL_GPOLYLL(x, v) (HW_CRC_GPOLYLL_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_GPOLYLU - CRC_GPOLYLU register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_GPOLYLU - CRC_GPOLYLU register. (RW)
 *
 * Reset value: 0xFFU
 */
typedef union _hw_crc_gpolylu
{
    uint8_t U;
    struct _hw_crc_gpolylu_bitfields
    {
        uint8_t GPOLYLU : 8;           /*!< [7:0] POLYLL stores the second 8 bits of
                                        * the 32 bit CRC */
    } B;
} hw_crc_gpolylu_t;

/*!
 * @name Constants and macros for entire CRC_GPOLYLU register
 */
/*@{*/
#define HW_CRC_GPOLYLU_ADDR(x)   ((x) + 0x5U)

#define HW_CRC_GPOLYLU(x)        (*(__IO hw_crc_gpolylu_t *) HW_CRC_GPOLYLU_ADDR(x))
#define HW_CRC_GPOLYLU_RD(x)     (HW_CRC_GPOLYLU(x).U)
#define HW_CRC_GPOLYLU_WR(x, v)  (HW_CRC_GPOLYLU(x).U = (v))
#define HW_CRC_GPOLYLU_SET(x, v) (HW_CRC_GPOLYLU_WR(x, HW_CRC_GPOLYLU_RD(x) |  (v)))
#define HW_CRC_GPOLYLU_CLR(x, v) (HW_CRC_GPOLYLU_WR(x, HW_CRC_GPOLYLU_RD(x) & ~(v)))
#define HW_CRC_GPOLYLU_TOG(x, v) (HW_CRC_GPOLYLU_WR(x, HW_CRC_GPOLYLU_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLYLU bitfields
 */

/*!
 * @name Register CRC_GPOLYLU, field GPOLYLU[7:0] (RW)
 */
/*@{*/
#define BP_CRC_GPOLYLU_GPOLYLU (0U)        /*!< Bit position for CRC_GPOLYLU_GPOLYLU. */
#define BM_CRC_GPOLYLU_GPOLYLU (0xFFU)     /*!< Bit mask for CRC_GPOLYLU_GPOLYLU. */
#define BS_CRC_GPOLYLU_GPOLYLU (8U)        /*!< Bit field size in bits for CRC_GPOLYLU_GPOLYLU. */

/*! @brief Read current value of the CRC_GPOLYLU_GPOLYLU field. */
#define BR_CRC_GPOLYLU_GPOLYLU(x) (HW_CRC_GPOLYLU(x).U)

/*! @brief Format value for bitfield CRC_GPOLYLU_GPOLYLU. */
#define BF_CRC_GPOLYLU_GPOLYLU(v) ((uint8_t)((uint8_t)(v) << BP_CRC_GPOLYLU_GPOLYLU) & BM_CRC_GPOLYLU_GPOLYLU)

/*! @brief Set the GPOLYLU field to a new value. */
#define BW_CRC_GPOLYLU_GPOLYLU(x, v) (HW_CRC_GPOLYLU_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_GPOLYHL - CRC_GPOLYHL register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_GPOLYHL - CRC_GPOLYHL register. (RW)
 *
 * Reset value: 0xFFU
 */
typedef union _hw_crc_gpolyhl
{
    uint8_t U;
    struct _hw_crc_gpolyhl_bitfields
    {
        uint8_t GPOLYHL : 8;           /*!< [7:0] POLYHL stores the third 8 bits of the
                                        * 32 bit CRC */
    } B;
} hw_crc_gpolyhl_t;

/*!
 * @name Constants and macros for entire CRC_GPOLYHL register
 */
/*@{*/
#define HW_CRC_GPOLYHL_ADDR(x)   ((x) + 0x6U)

#define HW_CRC_GPOLYHL(x)        (*(__IO hw_crc_gpolyhl_t *) HW_CRC_GPOLYHL_ADDR(x))
#define HW_CRC_GPOLYHL_RD(x)     (HW_CRC_GPOLYHL(x).U)
#define HW_CRC_GPOLYHL_WR(x, v)  (HW_CRC_GPOLYHL(x).U = (v))
#define HW_CRC_GPOLYHL_SET(x, v) (HW_CRC_GPOLYHL_WR(x, HW_CRC_GPOLYHL_RD(x) |  (v)))
#define HW_CRC_GPOLYHL_CLR(x, v) (HW_CRC_GPOLYHL_WR(x, HW_CRC_GPOLYHL_RD(x) & ~(v)))
#define HW_CRC_GPOLYHL_TOG(x, v) (HW_CRC_GPOLYHL_WR(x, HW_CRC_GPOLYHL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLYHL bitfields
 */

/*!
 * @name Register CRC_GPOLYHL, field GPOLYHL[7:0] (RW)
 */
/*@{*/
#define BP_CRC_GPOLYHL_GPOLYHL (0U)        /*!< Bit position for CRC_GPOLYHL_GPOLYHL. */
#define BM_CRC_GPOLYHL_GPOLYHL (0xFFU)     /*!< Bit mask for CRC_GPOLYHL_GPOLYHL. */
#define BS_CRC_GPOLYHL_GPOLYHL (8U)        /*!< Bit field size in bits for CRC_GPOLYHL_GPOLYHL. */

/*! @brief Read current value of the CRC_GPOLYHL_GPOLYHL field. */
#define BR_CRC_GPOLYHL_GPOLYHL(x) (HW_CRC_GPOLYHL(x).U)

/*! @brief Format value for bitfield CRC_GPOLYHL_GPOLYHL. */
#define BF_CRC_GPOLYHL_GPOLYHL(v) ((uint8_t)((uint8_t)(v) << BP_CRC_GPOLYHL_GPOLYHL) & BM_CRC_GPOLYHL_GPOLYHL)

/*! @brief Set the GPOLYHL field to a new value. */
#define BW_CRC_GPOLYHL_GPOLYHL(x, v) (HW_CRC_GPOLYHL_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_CRC_GPOLYHU - CRC_GPOLYHU register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_GPOLYHU - CRC_GPOLYHU register. (RW)
 *
 * Reset value: 0xFFU
 */
typedef union _hw_crc_gpolyhu
{
    uint8_t U;
    struct _hw_crc_gpolyhu_bitfields
    {
        uint8_t GPOLYHU : 8;           /*!< [7:0] POLYHU stores the fourth 8 bits of
                                        * the 32 bit CRC */
    } B;
} hw_crc_gpolyhu_t;

/*!
 * @name Constants and macros for entire CRC_GPOLYHU register
 */
/*@{*/
#define HW_CRC_GPOLYHU_ADDR(x)   ((x) + 0x7U)

#define HW_CRC_GPOLYHU(x)        (*(__IO hw_crc_gpolyhu_t *) HW_CRC_GPOLYHU_ADDR(x))
#define HW_CRC_GPOLYHU_RD(x)     (HW_CRC_GPOLYHU(x).U)
#define HW_CRC_GPOLYHU_WR(x, v)  (HW_CRC_GPOLYHU(x).U = (v))
#define HW_CRC_GPOLYHU_SET(x, v) (HW_CRC_GPOLYHU_WR(x, HW_CRC_GPOLYHU_RD(x) |  (v)))
#define HW_CRC_GPOLYHU_CLR(x, v) (HW_CRC_GPOLYHU_WR(x, HW_CRC_GPOLYHU_RD(x) & ~(v)))
#define HW_CRC_GPOLYHU_TOG(x, v) (HW_CRC_GPOLYHU_WR(x, HW_CRC_GPOLYHU_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLYHU bitfields
 */

/*!
 * @name Register CRC_GPOLYHU, field GPOLYHU[7:0] (RW)
 */
/*@{*/
#define BP_CRC_GPOLYHU_GPOLYHU (0U)        /*!< Bit position for CRC_GPOLYHU_GPOLYHU. */
#define BM_CRC_GPOLYHU_GPOLYHU (0xFFU)     /*!< Bit mask for CRC_GPOLYHU_GPOLYHU. */
#define BS_CRC_GPOLYHU_GPOLYHU (8U)        /*!< Bit field size in bits for CRC_GPOLYHU_GPOLYHU. */

/*! @brief Read current value of the CRC_GPOLYHU_GPOLYHU field. */
#define BR_CRC_GPOLYHU_GPOLYHU(x) (HW_CRC_GPOLYHU(x).U)

/*! @brief Format value for bitfield CRC_GPOLYHU_GPOLYHU. */
#define BF_CRC_GPOLYHU_GPOLYHU(v) ((uint8_t)((uint8_t)(v) << BP_CRC_GPOLYHU_GPOLYHU) & BM_CRC_GPOLYHU_GPOLYHU)

/*! @brief Set the GPOLYHU field to a new value. */
#define BW_CRC_GPOLYHU_GPOLYHU(x, v) (HW_CRC_GPOLYHU_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CRC_CTRL - CRC Control register
 ******************************************************************************/

/*!
 * @brief HW_CRC_CTRL - CRC Control register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register controls the configuration and working of the CRC module.
 * Appropriate bits must be set before starting a new CRC calculation. A new CRC
 * calculation is initialized by asserting CTRL[WAS] and then writing the seed into
 * the CRC data register.
 */
typedef union _hw_crc_ctrl
{
    uint32_t U;
    struct _hw_crc_ctrl_bitfields
    {
        uint32_t RESERVED0 : 24;       /*!< [23:0]  */
        uint32_t TCRC : 1;             /*!< [24]  */
        uint32_t WAS : 1;              /*!< [25] Write CRC Data Register As Seed */
        uint32_t FXOR : 1;             /*!< [26] Complement Read Of CRC Data Register */
        uint32_t RESERVED1 : 1;        /*!< [27]  */
        uint32_t TOTR : 2;             /*!< [29:28] Type Of Transpose For Read */
        uint32_t TOT : 2;              /*!< [31:30] Type Of Transpose For Writes */
    } B;
} hw_crc_ctrl_t;

/*!
 * @name Constants and macros for entire CRC_CTRL register
 */
/*@{*/
#define HW_CRC_CTRL_ADDR(x)      ((x) + 0x8U)

#define HW_CRC_CTRL(x)           (*(__IO hw_crc_ctrl_t *) HW_CRC_CTRL_ADDR(x))
#define HW_CRC_CTRL_RD(x)        (HW_CRC_CTRL(x).U)
#define HW_CRC_CTRL_WR(x, v)     (HW_CRC_CTRL(x).U = (v))
#define HW_CRC_CTRL_SET(x, v)    (HW_CRC_CTRL_WR(x, HW_CRC_CTRL_RD(x) |  (v)))
#define HW_CRC_CTRL_CLR(x, v)    (HW_CRC_CTRL_WR(x, HW_CRC_CTRL_RD(x) & ~(v)))
#define HW_CRC_CTRL_TOG(x, v)    (HW_CRC_CTRL_WR(x, HW_CRC_CTRL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_CTRL bitfields
 */

/*!
 * @name Register CRC_CTRL, field TCRC[24] (RW)
 *
 * Width of CRC protocol.
 *
 * Values:
 * - 0 - 16-bit CRC protocol.
 * - 1 - 32-bit CRC protocol.
 */
/*@{*/
#define BP_CRC_CTRL_TCRC     (24U)         /*!< Bit position for CRC_CTRL_TCRC. */
#define BM_CRC_CTRL_TCRC     (0x01000000U) /*!< Bit mask for CRC_CTRL_TCRC. */
#define BS_CRC_CTRL_TCRC     (1U)          /*!< Bit field size in bits for CRC_CTRL_TCRC. */

/*! @brief Read current value of the CRC_CTRL_TCRC field. */
#define BR_CRC_CTRL_TCRC(x)  (BITBAND_ACCESS32(HW_CRC_CTRL_ADDR(x), BP_CRC_CTRL_TCRC))

/*! @brief Format value for bitfield CRC_CTRL_TCRC. */
#define BF_CRC_CTRL_TCRC(v)  ((uint32_t)((uint32_t)(v) << BP_CRC_CTRL_TCRC) & BM_CRC_CTRL_TCRC)

/*! @brief Set the TCRC field to a new value. */
#define BW_CRC_CTRL_TCRC(x, v) (BITBAND_ACCESS32(HW_CRC_CTRL_ADDR(x), BP_CRC_CTRL_TCRC) = (v))
/*@}*/

/*!
 * @name Register CRC_CTRL, field WAS[25] (RW)
 *
 * When asserted, a value written to the CRC data register is considered a seed
 * value. When deasserted, a value written to the CRC data register is taken as
 * data for CRC computation.
 *
 * Values:
 * - 0 - Writes to the CRC data register are data values.
 * - 1 - Writes to the CRC data register are seed values.
 */
/*@{*/
#define BP_CRC_CTRL_WAS      (25U)         /*!< Bit position for CRC_CTRL_WAS. */
#define BM_CRC_CTRL_WAS      (0x02000000U) /*!< Bit mask for CRC_CTRL_WAS. */
#define BS_CRC_CTRL_WAS      (1U)          /*!< Bit field size in bits for CRC_CTRL_WAS. */

/*! @brief Read current value of the CRC_CTRL_WAS field. */
#define BR_CRC_CTRL_WAS(x)   (BITBAND_ACCESS32(HW_CRC_CTRL_ADDR(x), BP_CRC_CTRL_WAS))

/*! @brief Format value for bitfield CRC_CTRL_WAS. */
#define BF_CRC_CTRL_WAS(v)   ((uint32_t)((uint32_t)(v) << BP_CRC_CTRL_WAS) & BM_CRC_CTRL_WAS)

/*! @brief Set the WAS field to a new value. */
#define BW_CRC_CTRL_WAS(x, v) (BITBAND_ACCESS32(HW_CRC_CTRL_ADDR(x), BP_CRC_CTRL_WAS) = (v))
/*@}*/

/*!
 * @name Register CRC_CTRL, field FXOR[26] (RW)
 *
 * Some CRC protocols require the final checksum to be XORed with 0xFFFFFFFF or
 * 0xFFFF. Asserting this bit enables on the fly complementing of read data.
 *
 * Values:
 * - 0 - No XOR on reading.
 * - 1 - Invert or complement the read value of the CRC Data register.
 */
/*@{*/
#define BP_CRC_CTRL_FXOR     (26U)         /*!< Bit position for CRC_CTRL_FXOR. */
#define BM_CRC_CTRL_FXOR     (0x04000000U) /*!< Bit mask for CRC_CTRL_FXOR. */
#define BS_CRC_CTRL_FXOR     (1U)          /*!< Bit field size in bits for CRC_CTRL_FXOR. */

/*! @brief Read current value of the CRC_CTRL_FXOR field. */
#define BR_CRC_CTRL_FXOR(x)  (BITBAND_ACCESS32(HW_CRC_CTRL_ADDR(x), BP_CRC_CTRL_FXOR))

/*! @brief Format value for bitfield CRC_CTRL_FXOR. */
#define BF_CRC_CTRL_FXOR(v)  ((uint32_t)((uint32_t)(v) << BP_CRC_CTRL_FXOR) & BM_CRC_CTRL_FXOR)

/*! @brief Set the FXOR field to a new value. */
#define BW_CRC_CTRL_FXOR(x, v) (BITBAND_ACCESS32(HW_CRC_CTRL_ADDR(x), BP_CRC_CTRL_FXOR) = (v))
/*@}*/

/*!
 * @name Register CRC_CTRL, field TOTR[29:28] (RW)
 *
 * Identifies the transpose configuration of the value read from the CRC Data
 * register. See the description of the transpose feature for the available
 * transpose options.
 *
 * Values:
 * - 00 - No transposition.
 * - 01 - Bits in bytes are transposed; bytes are not transposed.
 * - 10 - Both bits in bytes and bytes are transposed.
 * - 11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
#define BP_CRC_CTRL_TOTR     (28U)         /*!< Bit position for CRC_CTRL_TOTR. */
#define BM_CRC_CTRL_TOTR     (0x30000000U) /*!< Bit mask for CRC_CTRL_TOTR. */
#define BS_CRC_CTRL_TOTR     (2U)          /*!< Bit field size in bits for CRC_CTRL_TOTR. */

/*! @brief Read current value of the CRC_CTRL_TOTR field. */
#define BR_CRC_CTRL_TOTR(x)  (HW_CRC_CTRL(x).B.TOTR)

/*! @brief Format value for bitfield CRC_CTRL_TOTR. */
#define BF_CRC_CTRL_TOTR(v)  ((uint32_t)((uint32_t)(v) << BP_CRC_CTRL_TOTR) & BM_CRC_CTRL_TOTR)

/*! @brief Set the TOTR field to a new value. */
#define BW_CRC_CTRL_TOTR(x, v) (HW_CRC_CTRL_WR(x, (HW_CRC_CTRL_RD(x) & ~BM_CRC_CTRL_TOTR) | BF_CRC_CTRL_TOTR(v)))
/*@}*/

/*!
 * @name Register CRC_CTRL, field TOT[31:30] (RW)
 *
 * Defines the transpose configuration of the data written to the CRC data
 * register. See the description of the transpose feature for the available transpose
 * options.
 *
 * Values:
 * - 00 - No transposition.
 * - 01 - Bits in bytes are transposed; bytes are not transposed.
 * - 10 - Both bits in bytes and bytes are transposed.
 * - 11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
#define BP_CRC_CTRL_TOT      (30U)         /*!< Bit position for CRC_CTRL_TOT. */
#define BM_CRC_CTRL_TOT      (0xC0000000U) /*!< Bit mask for CRC_CTRL_TOT. */
#define BS_CRC_CTRL_TOT      (2U)          /*!< Bit field size in bits for CRC_CTRL_TOT. */

/*! @brief Read current value of the CRC_CTRL_TOT field. */
#define BR_CRC_CTRL_TOT(x)   (HW_CRC_CTRL(x).B.TOT)

/*! @brief Format value for bitfield CRC_CTRL_TOT. */
#define BF_CRC_CTRL_TOT(v)   ((uint32_t)((uint32_t)(v) << BP_CRC_CTRL_TOT) & BM_CRC_CTRL_TOT)

/*! @brief Set the TOT field to a new value. */
#define BW_CRC_CTRL_TOT(x, v) (HW_CRC_CTRL_WR(x, (HW_CRC_CTRL_RD(x) & ~BM_CRC_CTRL_TOT) | BF_CRC_CTRL_TOT(v)))
/*@}*/
/*******************************************************************************
 * HW_CRC_CTRLHU - CRC_CTRLHU register.
 ******************************************************************************/

/*!
 * @brief HW_CRC_CTRLHU - CRC_CTRLHU register. (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_crc_ctrlhu
{
    uint8_t U;
    struct _hw_crc_ctrlhu_bitfields
    {
        uint8_t TCRC : 1;              /*!< [0]  */
        uint8_t WAS : 1;               /*!< [1]  */
        uint8_t FXOR : 1;              /*!< [2]  */
        uint8_t RESERVED0 : 1;         /*!< [3]  */
        uint8_t TOTR : 2;              /*!< [5:4]  */
        uint8_t TOT : 2;               /*!< [7:6]  */
    } B;
} hw_crc_ctrlhu_t;

/*!
 * @name Constants and macros for entire CRC_CTRLHU register
 */
/*@{*/
#define HW_CRC_CTRLHU_ADDR(x)    ((x) + 0xBU)

#define HW_CRC_CTRLHU(x)         (*(__IO hw_crc_ctrlhu_t *) HW_CRC_CTRLHU_ADDR(x))
#define HW_CRC_CTRLHU_RD(x)      (HW_CRC_CTRLHU(x).U)
#define HW_CRC_CTRLHU_WR(x, v)   (HW_CRC_CTRLHU(x).U = (v))
#define HW_CRC_CTRLHU_SET(x, v)  (HW_CRC_CTRLHU_WR(x, HW_CRC_CTRLHU_RD(x) |  (v)))
#define HW_CRC_CTRLHU_CLR(x, v)  (HW_CRC_CTRLHU_WR(x, HW_CRC_CTRLHU_RD(x) & ~(v)))
#define HW_CRC_CTRLHU_TOG(x, v)  (HW_CRC_CTRLHU_WR(x, HW_CRC_CTRLHU_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CRC_CTRLHU bitfields
 */

/*!
 * @name Register CRC_CTRLHU, field TCRC[0] (RW)
 *
 * Values:
 * - 0 - 16-bit CRC protocol.
 * - 1 - 32-bit CRC protocol.
 */
/*@{*/
#define BP_CRC_CTRLHU_TCRC   (0U)          /*!< Bit position for CRC_CTRLHU_TCRC. */
#define BM_CRC_CTRLHU_TCRC   (0x01U)       /*!< Bit mask for CRC_CTRLHU_TCRC. */
#define BS_CRC_CTRLHU_TCRC   (1U)          /*!< Bit field size in bits for CRC_CTRLHU_TCRC. */

/*! @brief Read current value of the CRC_CTRLHU_TCRC field. */
#define BR_CRC_CTRLHU_TCRC(x) (BITBAND_ACCESS8(HW_CRC_CTRLHU_ADDR(x), BP_CRC_CTRLHU_TCRC))

/*! @brief Format value for bitfield CRC_CTRLHU_TCRC. */
#define BF_CRC_CTRLHU_TCRC(v) ((uint8_t)((uint8_t)(v) << BP_CRC_CTRLHU_TCRC) & BM_CRC_CTRLHU_TCRC)

/*! @brief Set the TCRC field to a new value. */
#define BW_CRC_CTRLHU_TCRC(x, v) (BITBAND_ACCESS8(HW_CRC_CTRLHU_ADDR(x), BP_CRC_CTRLHU_TCRC) = (v))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field WAS[1] (RW)
 *
 * Values:
 * - 0 - Writes to CRC data register are data values.
 * - 1 - Writes to CRC data reguster are seed values.
 */
/*@{*/
#define BP_CRC_CTRLHU_WAS    (1U)          /*!< Bit position for CRC_CTRLHU_WAS. */
#define BM_CRC_CTRLHU_WAS    (0x02U)       /*!< Bit mask for CRC_CTRLHU_WAS. */
#define BS_CRC_CTRLHU_WAS    (1U)          /*!< Bit field size in bits for CRC_CTRLHU_WAS. */

/*! @brief Read current value of the CRC_CTRLHU_WAS field. */
#define BR_CRC_CTRLHU_WAS(x) (BITBAND_ACCESS8(HW_CRC_CTRLHU_ADDR(x), BP_CRC_CTRLHU_WAS))

/*! @brief Format value for bitfield CRC_CTRLHU_WAS. */
#define BF_CRC_CTRLHU_WAS(v) ((uint8_t)((uint8_t)(v) << BP_CRC_CTRLHU_WAS) & BM_CRC_CTRLHU_WAS)

/*! @brief Set the WAS field to a new value. */
#define BW_CRC_CTRLHU_WAS(x, v) (BITBAND_ACCESS8(HW_CRC_CTRLHU_ADDR(x), BP_CRC_CTRLHU_WAS) = (v))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field FXOR[2] (RW)
 *
 * Values:
 * - 0 - No XOR on reading.
 * - 1 - Invert or complement the read value of CRC data register.
 */
/*@{*/
#define BP_CRC_CTRLHU_FXOR   (2U)          /*!< Bit position for CRC_CTRLHU_FXOR. */
#define BM_CRC_CTRLHU_FXOR   (0x04U)       /*!< Bit mask for CRC_CTRLHU_FXOR. */
#define BS_CRC_CTRLHU_FXOR   (1U)          /*!< Bit field size in bits for CRC_CTRLHU_FXOR. */

/*! @brief Read current value of the CRC_CTRLHU_FXOR field. */
#define BR_CRC_CTRLHU_FXOR(x) (BITBAND_ACCESS8(HW_CRC_CTRLHU_ADDR(x), BP_CRC_CTRLHU_FXOR))

/*! @brief Format value for bitfield CRC_CTRLHU_FXOR. */
#define BF_CRC_CTRLHU_FXOR(v) ((uint8_t)((uint8_t)(v) << BP_CRC_CTRLHU_FXOR) & BM_CRC_CTRLHU_FXOR)

/*! @brief Set the FXOR field to a new value. */
#define BW_CRC_CTRLHU_FXOR(x, v) (BITBAND_ACCESS8(HW_CRC_CTRLHU_ADDR(x), BP_CRC_CTRLHU_FXOR) = (v))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field TOTR[5:4] (RW)
 *
 * Values:
 * - 00 - No Transposition.
 * - 01 - Bits in bytes are transposed, bytes are not transposed.
 * - 10 - Both bits in bytes and bytes are transposed.
 * - 11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
#define BP_CRC_CTRLHU_TOTR   (4U)          /*!< Bit position for CRC_CTRLHU_TOTR. */
#define BM_CRC_CTRLHU_TOTR   (0x30U)       /*!< Bit mask for CRC_CTRLHU_TOTR. */
#define BS_CRC_CTRLHU_TOTR   (2U)          /*!< Bit field size in bits for CRC_CTRLHU_TOTR. */

/*! @brief Read current value of the CRC_CTRLHU_TOTR field. */
#define BR_CRC_CTRLHU_TOTR(x) (HW_CRC_CTRLHU(x).B.TOTR)

/*! @brief Format value for bitfield CRC_CTRLHU_TOTR. */
#define BF_CRC_CTRLHU_TOTR(v) ((uint8_t)((uint8_t)(v) << BP_CRC_CTRLHU_TOTR) & BM_CRC_CTRLHU_TOTR)

/*! @brief Set the TOTR field to a new value. */
#define BW_CRC_CTRLHU_TOTR(x, v) (HW_CRC_CTRLHU_WR(x, (HW_CRC_CTRLHU_RD(x) & ~BM_CRC_CTRLHU_TOTR) | BF_CRC_CTRLHU_TOTR(v)))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field TOT[7:6] (RW)
 *
 * Values:
 * - 00 - No Transposition.
 * - 01 - Bits in bytes are transposed, bytes are not transposed.
 * - 10 - Both bits in bytes and bytes are transposed.
 * - 11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
#define BP_CRC_CTRLHU_TOT    (6U)          /*!< Bit position for CRC_CTRLHU_TOT. */
#define BM_CRC_CTRLHU_TOT    (0xC0U)       /*!< Bit mask for CRC_CTRLHU_TOT. */
#define BS_CRC_CTRLHU_TOT    (2U)          /*!< Bit field size in bits for CRC_CTRLHU_TOT. */

/*! @brief Read current value of the CRC_CTRLHU_TOT field. */
#define BR_CRC_CTRLHU_TOT(x) (HW_CRC_CTRLHU(x).B.TOT)

/*! @brief Format value for bitfield CRC_CTRLHU_TOT. */
#define BF_CRC_CTRLHU_TOT(v) ((uint8_t)((uint8_t)(v) << BP_CRC_CTRLHU_TOT) & BM_CRC_CTRLHU_TOT)

/*! @brief Set the TOT field to a new value. */
#define BW_CRC_CTRLHU_TOT(x, v) (HW_CRC_CTRLHU_WR(x, (HW_CRC_CTRLHU_RD(x) & ~BM_CRC_CTRLHU_TOT) | BF_CRC_CTRLHU_TOT(v)))
/*@}*/

/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/*******************************************************************************
 * hw_crc_t - module struct
 ******************************************************************************/
/*!
 * @brief All CRC module registers.
 */
#pragma pack(1)
typedef struct _hw_crc
{
    union {
        struct {
            __IO hw_crc_datal_t DATAL;     /*!< [0x0] CRC_DATAL register. */
            __IO hw_crc_datah_t DATAH;     /*!< [0x2] CRC_DATAH register. */
        } ACCESS16BIT;
        struct {
            __IO hw_crc_datall_t DATALL;   /*!< [0x0] CRC_DATALL register. */
            __IO hw_crc_datalu_t DATALU;   /*!< [0x1] CRC_DATALU register. */
            __IO hw_crc_datahl_t DATAHL;   /*!< [0x2] CRC_DATAHL register. */
            __IO hw_crc_datahu_t DATAHU;   /*!< [0x3] CRC_DATAHU register. */
        } ACCESS8BIT;
        __IO hw_crc_data_t DATA;           /*!< [0x0] CRC Data register */
    };
    union {
        __IO hw_crc_gpoly_t GPOLY;         /*!< [0x4] CRC Polynomial register */
        struct {
            __IO hw_crc_gpolyl_t GPOLYL;   /*!< [0x4] CRC_GPOLYL register. */
            __IO hw_crc_gpolyh_t GPOLYH;   /*!< [0x6] CRC_GPOLYH register. */
        } GPOLY_ACCESS16BIT;
        struct {
            __IO hw_crc_gpolyll_t GPOLYLL; /*!< [0x4] CRC_GPOLYLL register. */
            __IO hw_crc_gpolylu_t GPOLYLU; /*!< [0x5] CRC_GPOLYLU register. */
            __IO hw_crc_gpolyhl_t GPOLYHL; /*!< [0x6] CRC_GPOLYHL register. */
            __IO hw_crc_gpolyhu_t GPOLYHU; /*!< [0x7] CRC_GPOLYHU register. */
        } GPOLY_ACCESS8BIT;
    };
    union {
        __IO hw_crc_ctrl_t CTRL;           /*!< [0x8] CRC Control register */
        struct {
            uint8_t _reserved0[3];
            __IO hw_crc_ctrlhu_t CTRLHU;   /*!< [0xB] CRC_CTRLHU register. */
        } CTRL_ACCESS8BIT;
    };
} hw_crc_t;
#pragma pack()

/*! @brief Macro to access all CRC registers. */
/*! @param x CRC module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_CRC(CRC_BASE)</code>. */
#define HW_CRC(x)      (*(hw_crc_t *)(x))

/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma pop
#elif defined(__CWCC__)
  #pragma pop
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

#endif /* __HW_CRC_REGISTERS_H__ */
/* EOF */
