#include "MMA845x.h"
#include "PinDetect.h"
#include "mbed.h"
 
Serial pc(USBTX, USBRX);

I2C accel(I2C_SDA0, I2C_SCL0);

AnalogIn ambientLight(p6);

PinDetect  user_btn_1 ( p11, PullUp );
PinDetect  user_btn_2 ( p0,  PullUp );

//InterruptIn int2(p0);

//InterruptIn user_btn_1(p11);

PwmOut ledR(LED1);
PwmOut ledG(LED3);
PwmOut ledB(LED2);

int accel_int_mode = 0;
int opMode = 0;
int opModeMax = 3;


//MMA845x(I2C &i2c, InterruptIn &int1, InterruptIn &int2, MMA845x_SA0 const i2c_addr);
MMA845x accel_0(accel, p4, p23, MMA845x::SA0_VSS);
//MMA845x accel_0(accel, int1, int2, MMA845x::SA0_VSS);

#ifdef USE_EEPROM
SPI spi1(SPI_PSELMOSI1, SPI_PSELMISO1, SPI_PSELSCK1);
DigitalOut spi_cs(SPI_PSELSS1);
#endif

void toggleLED(PwmOut *led)
{
    if (led->read() < 0.001)
    {
        printf("led on");
        led->write(.2);
    }
    else
    {
        printf("led off, %f",led->read());
        led->write(0);
    }
}

void btn_1_press(void)
{
    if (++opMode == opModeMax) {opMode = 0;}
    printf("OpMode = %d\n\r",opMode);
    switch ( opMode )
    {
        case 0:
            accel_0.disable();
            ledR = 0.2;
            ledG = 0;
            ledB = 0;
            
            break;
        case 1:
            ledR = 0;
            ledG = 0.2;
            ledB = 0;
            accel_0.enablePulseMode();
            break;
        default:
            ledR = 0;
            ledG = 0;
            ledB = 0.2;
            accel_0.enableDataReadyMode();
            break;
    }
}

void btn_2_press(void)
{
    //ledR = !ledR;
    //printf("Button 2 Pressed!\n\r");
    switch ( opMode )
    {
        case 0:
            break;
        case 2:
            if (accel_int_mode == 0)
            {
                accel_int_mode = 1;
            }
            else
            {
                accel_int_mode = 0;
            }
            accel_0.setIntMode(accel_int_mode);
            break;
        default:
            break;
            //do nothing
    }
}

void zTap(void)
{       
    switch ( opMode )
    {
        case 0:
            break;
        case 1:
            toggleLED(&ledB);  
            break;
        default:
            toggleLED(&ledG);  
            break;
    }
      
}
void SysTick_Handler (void)
{
    toggleLED(&ledB); 
}

int main()
{
    pc.baud(115200);
    //int readings[3] = {0, 0, 0};
    ledR.period_ms(10);
    ledG.period_ms(10);
    ledB.period_ms(10);
    
    ledR = .1;
    ledG = .1;
    ledB = .1;
    
    
    //SysTick_Config(1000);
    //SysTick_Enable();
    //systick.attach_us(&systimer, 2500);
    
    user_btn_1.setAssertValue( 0 );
    user_btn_2.setAssertValue( 0 );
    user_btn_1.attach_asserted( &btn_1_press );
    //user_btn_1.mode( PullUp );
    //user_btn_1.rise( &btn_1_press );
    user_btn_2.attach_asserted( &btn_2_press );
    user_btn_1.setSampleFrequency( 20000 ); 
    user_btn_2.setSampleFrequency( 20000 ); // Defaults to 20ms.
    
    accel_0.attachZAxisPulse( &zTap );
    
    //int adr = 0x3A;
    char data[2];
    char cmd = 0x0D;
    accel.write(0x3A, &cmd, 1, true);
    accel.read(0x3A, &data[0], 1);
    printf("\n\r\n\rWho am I?: 0x%.2X\n\r",data[0]);
    
    //accel_0.enableMotionMode();
    //accel_0.registerDump();
    accel_0.enableDataReadyMode();
    
    
    //--------------------
    //int x = accel_0.getX();
    //int y = accel_0.getY();
    //int z = accel_0.getZ();
    //printf("X: %d, Y: %d, Z: %d\n\r", x , y, z);
    

    while (1) {
        sleep();
    }

}
