#include "mbed.h"
#include <time.h>

// Function Definition
void stop(void);
void motorControl(void);

AnalogIn analog_value(A0);
//AnalogIn switch1_value(A1);
//AnalogIn switch2_value(A2);
InterruptIn switch1(A1);
InterruptIn switch2(A2);
//InterruptIn button1(A3);
DigitalOut in1(D6);
DigitalOut in2(D3);
PwmOut enable1(A4);

float meas_r;
float meas_v;
float sw;
float sww;

void stop(){
    while((switch1 == 1) || (switch2 == 1)){
        in1 = 0;
        in2 = 0;
        enable1 = 0;
        wait(0.5);
    }
}

void motorControl(){
    meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
    meas_v = meas_r * 3300; // Converts value in the 0V-3.3V range
    printf("%0.3f \n", meas_v);
    
            if (meas_v < 200) { //left
                in1 = 1;
                in2 = 0;
                enable1.period_ms(100); 
                enable1 = 0.4;
                } 
            else if (meas_v > 600){ //right
                in1 = 0;
                in2 = 1;
                enable1.period_ms(100); 
                enable1 = 0.4;} 
            else if (meas_v > 200 && meas_v < 600) { //straight
               in1 = 0;
                in2 = 0;
                enable1 = 0; }
            else { //stop
                in1 = 0;
                in2 = 0;
                enable1 = 0;}
}
    

int main() {
    
    //switch1.rise(&stop);
    //switch2.rise(&stop);
    //button1.rise(&stop);
    
    while(1) {
        //sw = switch2.read();
        //sww = sw * 3300;
        //printf("%0.3f \n", sww);
        motorControl();
        wait(1);
        
    }
}