/* i2c-scanner-rhombio-l476dmw1k
 * 
 * Copyright (c) 2019 rhomb.io
 * 
 * MIT License
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"


I2C i2c(I2C_SDA, I2C_SCL); 
DigitalOut led(LED1);


int main()
{
    led = 1;
     
    i2c.frequency(100000);
    printf("Rhomb.io example code - I2C Scanner\n\r");
    printf("-----------------------------------\n\r");
   
    while (1) {
        printf("Searching for I2C devices...\n\r");

        int count = 0;
        for (int address = 0; address < 255; address +=2) { // check only for device's read addres
            if (!i2c.write(address, NULL, 0)) { // 0 returned is ok
                printf("I2C device found at address 0x%02X (0x%02X in 8-bit)\n\r", address >> 1, address);  // the address is without LSB, which is R/W flag. shoft it right once
                count++;
                led = 1;
            }
            wait(0.02);
        }
        if (count)
            printf("%d", count);
        else
            printf("No");
        printf(" device%c found\n\r\n", count == 1?'\0':'s');
        led = 0;
        wait (1.8);
    }
}