#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx

float dcPWM = 0;
float iGRP = 0;

AnalogIn grpControl(p15); //Analog Input to control Gripper-Motor's PWM
AnalogIn grpCurrent(p16); //Analog Input to read Gripper-Motor's current
InterruptIn check(p17); //Interrupt event to check Gripper-Motor's current

PwmOut grpPWM(p30); //PWM Out for Gripper Motor

//Check potensiometer voltage (GrpControl)
//GrpControl analog read range [0.0f - 1.0f]
//GrpPWM pwm out duty cycle range [0.1f - 0.9f]
void updatePwmOut(AnalogIn analogPin, PwmOut *pwmPin) {
    float dCycle = 0.1;
    
    dCycle += 0.8 * analogPin.read();
    (*pwmPin).write(dCycle);
         
//End of updateGrpPWM()   
}

//Read the current of Brushed Motor RE-25 DC through Motor Controller ESCON 36/2
//the current of Brushed Motor RE-25 DC range [(-3.0A) - (3.0A)]
//GrpCurrent analog read range [0.0f - 0.1f]
float readGrpCurrent(AnalogIn analogPin) {
    float iReadOut = 0;
    
    iReadOut = (6 * analogPin.read()) - 3;
    return iReadOut;
    
//End of readGrpCurrent   
}

void checkGrpCurrent() {    
    iGRP = readGrpCurrent(grpCurrent);
    pc.printf("Gripper-Motor's current : '%f'\n", iGRP);
}

int main() {
    while(1) {
        check.fall(&checkGrpCurrent);
        updatePwmOut(grpControl, &grpPWM);
        wait_ms(1);
    }
//End of main()    
}