/*********************************************************
*Renbed_RGB_Digital                                      *
*Author: Elijah Orr & Dan Argust                         *
*                                                        *  
*A program that controls an RGB LED                      *
*********************************************************/

/* include the mbed library made by mbed.org that contains 
classes/functions designed to make programming mbed 
microcontrollers easier */
#include "mbed.h"

/* Set up 3 pins as digital out to control the colour
cathodes of the RGB LED */
DigitalOut Red(P1_24);
DigitalOut Green(P1_26);
DigitalOut Blue(P0_19);

/* Set the on and off states of the lights */
const int on = 0;
const int off = 1;

int main()
{
    /* open a for loop with no parameters to start an infinite loop */
    for(;;){
        Red = off;
        Blue = off;
        Green = off;                
        wait_ms(1000);
        
        Red = on;
        wait_ms(1000);
        
        Red = off;
        Green = on;
        wait_ms(1000);
        
        Green = off;
        Blue = on;
        wait_ms(1000);
    }
}
        
        