/*******************************************************************************
* Used to drive RenBuggy with 2 wheels for a specified amount of time.         *
* Copyright (c) 2014 Mark Jones                                                *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
* RenBuggyTimed.h                                                              *
*                                                                              *
* V1.0 31/03/2014                                           Mark Jones         *
*******************************************************************************/

#ifndef RENBUGGYTIMED_H
#define RENBUGGYTIMED_H

#include "mbed.h"

/**
* RenBuggyTimed example:
* @code

#include "RenBuggyTimed.h"

RenBuggy myBuggy(p5, p6, p8, p7);

int main() {
    
    myBuggy.forward(4);
    myBuggy.left(3);
    myBuggy.forward(4);
    myBuggy.right(3);
    
    return 0;
}
@endcode
*/

/**
* The class used to control a timed version
* of the RenBuggy with 2 wheels.
*/
class RenBuggy {
    
    private:
    PwmOut m_motorL;
    PwmOut m_motorR;
    
    DigitalOut m_brakeL;
    DigitalOut m_brakeR;
    
    public:
    /**
    * Constructs the class with the pins for the pwm outputs
    * and the digital outputs, to move and stop.
    */
    RenBuggy(PinName leftMotor, PinName rightMotor, 
                    PinName leftBrake, PinName rightBrake);
    /**
    * Deconstructs the buggy.
    */           
    ~RenBuggy();
    
    /**
    * Moves the buggy forward for a specified amount of time.
    */
    void forward(float time);
    
    /**
    * Turns the buggy forward and left for a specified amount of time.
    */
    void left(float time);
    
    /**
    * Turns the buggy forward and right for a specified amount of time.
    */
    void right(float time);
    
    /**
    * Applies the brakes.
    */
    void stop();

};

#endif  // RENBUGGYTIMED_H