/*******************************************************************************
* Used to drive RenBuggy with 2 wheels for a specified amount of time.         *
* Copyright (c) 2014 Mark Jones                                                *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
* RenBuggyTimed.cpp                                                            *
*                                                                              *
* V1.0 31/03/2014                                           Mark Jones         *
*******************************************************************************/

#ifndef RENBUGGYTIMED_C
#define RENBUGGYTIMED_C

#include "RenBuggyTimed.h"

RenBuggy::RenBuggy(PinName leftMotor, PinName rightMotor, 
                    PinName leftBrake, PinName rightBrake) :
                    m_motorL(leftMotor), m_motorR(rightMotor),
                    m_brakeL(leftBrake), m_brakeR(rightBrake) {
                        
                        
}

RenBuggy::~RenBuggy() {
}

void RenBuggy::forward(float time) {
    
    m_motorL = m_motorR = 1.0;
    wait(time);
}

void RenBuggy::left(float time) {
    
    m_motorL = 0.2;
    m_motorR = 1.0;
    wait(time);
}

void RenBuggy::right(float time) {
    
    m_motorL = 1.0;
    m_motorR = 0.2;
    wait(time);
}

void RenBuggy::stop() {
    
    m_motorL = m_motorR = 0;
    m_brakeL = m_brakeR = 1.0;
}

#endif // RENBUGGYTIMED_C