/*******************************************************************************
* Used to drive RenBuggy with 2 wheels for a specified amount of time.         *
* Copyright (c) 2014 Renishaw plc                                              *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
* RenBuggy_Timed_Program                                                       *
*                                                                              *
* V1.0 8/5/2014                                           Jon Fuge             *
*******************************************************************************/

// We are using the buggy with no wheel encoders so we need to use the timed
// library.
#include "RenBuggyTimed.h"

RenBuggy myBuggy(p5, p6, p8, p7); // Configure control pins for the buggy

// For this buggy, we only need to use the motor control pins p5 & p6.
// p5 controls the left motor
// p6 controls the right motor

int main() {
    int iCircleTime;
    int iForwardTime;
    
    iCircleTime = 22; // This is the time in seconds to do one full circle
    iForwardTime = 1; // This is the time to move forwards
    
    myBuggy.stop();
    myBuggy.left(iCircleTime);
    myBuggy.forward(iForwardTime);
    myBuggy.right(iCircleTime);
    myBuggy.forward(iForwardTime);
    myBuggy.stop();
    
    return 0;
}