/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_UART_REGISTERS_H__
#define __HW_UART_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 UART
 *
 * Serial Communication Interface
 *
 * Registers defined in this header file:
 * - HW_UART_BDH - UART Baud Rate Registers: High
 * - HW_UART_BDL - UART Baud Rate Registers: Low
 * - HW_UART_C1 - UART Control Register 1
 * - HW_UART_C2 - UART Control Register 2
 * - HW_UART_S1 - UART Status Register 1
 * - HW_UART_S2 - UART Status Register 2
 * - HW_UART_C3 - UART Control Register 3
 * - HW_UART_D - UART Data Register
 * - HW_UART_MA1 - UART Match Address Registers 1
 * - HW_UART_MA2 - UART Match Address Registers 2
 * - HW_UART_C4 - UART Control Register 4
 * - HW_UART_C5 - UART Control Register 5
 * - HW_UART_ED - UART Extended Data Register
 * - HW_UART_MODEM - UART Modem Register
 * - HW_UART_IR - UART Infrared Register
 * - HW_UART_PFIFO - UART FIFO Parameters
 * - HW_UART_CFIFO - UART FIFO Control Register
 * - HW_UART_SFIFO - UART FIFO Status Register
 * - HW_UART_TWFIFO - UART FIFO Transmit Watermark
 * - HW_UART_TCFIFO - UART FIFO Transmit Count
 * - HW_UART_RWFIFO - UART FIFO Receive Watermark
 * - HW_UART_RCFIFO - UART FIFO Receive Count
 * - HW_UART_C7816 - UART 7816 Control Register
 * - HW_UART_IE7816 - UART 7816 Interrupt Enable Register
 * - HW_UART_IS7816 - UART 7816 Interrupt Status Register
 * - HW_UART_WP7816T0 - UART 7816 Wait Parameter Register
 * - HW_UART_WP7816T1 - UART 7816 Wait Parameter Register
 * - HW_UART_WN7816 - UART 7816 Wait N Register
 * - HW_UART_WF7816 - UART 7816 Wait FD Register
 * - HW_UART_ET7816 - UART 7816 Error Threshold Register
 * - HW_UART_TL7816 - UART 7816 Transmit Length Register
 *
 * - hw_uart_t - Struct containing all module registers.
 */

#define HW_UART_INSTANCE_COUNT (6U) /*!< Number of instances of the UART module. */
#define HW_UART0 (0U) /*!< Instance number for UART0. */
#define HW_UART1 (1U) /*!< Instance number for UART1. */
#define HW_UART2 (2U) /*!< Instance number for UART2. */
#define HW_UART3 (3U) /*!< Instance number for UART3. */
#define HW_UART4 (4U) /*!< Instance number for UART4. */
#define HW_UART5 (5U) /*!< Instance number for UART5. */

/*******************************************************************************
 * HW_UART_BDH - UART Baud Rate Registers: High
 ******************************************************************************/

/*!
 * @brief HW_UART_BDH - UART Baud Rate Registers: High (RW)
 *
 * Reset value: 0x00U
 *
 * This register, along with the BDL register, controls the prescale divisor for
 * UART baud rate generation. To update the 13-bit baud rate setting
 * (SBR[12:0]), first write to BDH to buffer the high half of the new value and then write
 * to BDL. The working value in BDH does not change until BDL is written. BDL is
 * reset to a nonzero value, but after reset, the baud rate generator remains
 * disabled until the first time the receiver or transmitter is enabled, that is,
 * when C2[RE] or C2[TE] is set.
 */
typedef union _hw_uart_bdh
{
    uint8_t U;
    struct _hw_uart_bdh_bitfields
    {
        uint8_t SBR : 5;               /*!< [4:0] UART Baud Rate Bits */
        uint8_t SBNS : 1;              /*!< [5] Stop Bit Number Select */
        uint8_t RXEDGIE : 1;           /*!< [6] RxD Input Active Edge Interrupt Enable
                                        * */
        uint8_t LBKDIE : 1;            /*!< [7] LIN Break Detect Interrupt or DMA
                                        * Request Enable */
    } B;
} hw_uart_bdh_t;

/*!
 * @name Constants and macros for entire UART_BDH register
 */
/*@{*/
#define HW_UART_BDH_ADDR(x)      ((x) + 0x0U)

#define HW_UART_BDH(x)           (*(__IO hw_uart_bdh_t *) HW_UART_BDH_ADDR(x))
#define HW_UART_BDH_RD(x)        (HW_UART_BDH(x).U)
#define HW_UART_BDH_WR(x, v)     (HW_UART_BDH(x).U = (v))
#define HW_UART_BDH_SET(x, v)    (HW_UART_BDH_WR(x, HW_UART_BDH_RD(x) |  (v)))
#define HW_UART_BDH_CLR(x, v)    (HW_UART_BDH_WR(x, HW_UART_BDH_RD(x) & ~(v)))
#define HW_UART_BDH_TOG(x, v)    (HW_UART_BDH_WR(x, HW_UART_BDH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_BDH bitfields
 */

/*!
 * @name Register UART_BDH, field SBR[4:0] (RW)
 *
 * The baud rate for the UART is determined by the 13 SBR fields. See Baud rate
 * generation for details. The baud rate generator is disabled until C2[TE] or
 * C2[RE] is set for the first time after reset.The baud rate generator is disabled
 * when SBR = 0. Writing to BDH has no effect without writing to BDL, because
 * writing to BDH puts the data in a temporary location until BDL is written.
 */
/*@{*/
#define BP_UART_BDH_SBR      (0U)          /*!< Bit position for UART_BDH_SBR. */
#define BM_UART_BDH_SBR      (0x1FU)       /*!< Bit mask for UART_BDH_SBR. */
#define BS_UART_BDH_SBR      (5U)          /*!< Bit field size in bits for UART_BDH_SBR. */

/*! @brief Read current value of the UART_BDH_SBR field. */
#define BR_UART_BDH_SBR(x)   (HW_UART_BDH(x).B.SBR)

/*! @brief Format value for bitfield UART_BDH_SBR. */
#define BF_UART_BDH_SBR(v)   ((uint8_t)((uint8_t)(v) << BP_UART_BDH_SBR) & BM_UART_BDH_SBR)

/*! @brief Set the SBR field to a new value. */
#define BW_UART_BDH_SBR(x, v) (HW_UART_BDH_WR(x, (HW_UART_BDH_RD(x) & ~BM_UART_BDH_SBR) | BF_UART_BDH_SBR(v)))
/*@}*/

/*!
 * @name Register UART_BDH, field SBNS[5] (RW)
 *
 * SBNS selects the number of stop bits present in a data frame. This field
 * valid for all 8, 9 and 10 bit data formats available. This field is not valid when
 * C7816[ISO7816E] is enabled.
 *
 * Values:
 * - 0 - Data frame consists of a single stop bit.
 * - 1 - Data frame consists of two stop bits.
 */
/*@{*/
#define BP_UART_BDH_SBNS     (5U)          /*!< Bit position for UART_BDH_SBNS. */
#define BM_UART_BDH_SBNS     (0x20U)       /*!< Bit mask for UART_BDH_SBNS. */
#define BS_UART_BDH_SBNS     (1U)          /*!< Bit field size in bits for UART_BDH_SBNS. */

/*! @brief Read current value of the UART_BDH_SBNS field. */
#define BR_UART_BDH_SBNS(x)  (BITBAND_ACCESS8(HW_UART_BDH_ADDR(x), BP_UART_BDH_SBNS))

/*! @brief Format value for bitfield UART_BDH_SBNS. */
#define BF_UART_BDH_SBNS(v)  ((uint8_t)((uint8_t)(v) << BP_UART_BDH_SBNS) & BM_UART_BDH_SBNS)

/*! @brief Set the SBNS field to a new value. */
#define BW_UART_BDH_SBNS(x, v) (BITBAND_ACCESS8(HW_UART_BDH_ADDR(x), BP_UART_BDH_SBNS) = (v))
/*@}*/

/*!
 * @name Register UART_BDH, field RXEDGIE[6] (RW)
 *
 * Enables the receive input active edge, RXEDGIF, to generate interrupt
 * requests.
 *
 * Values:
 * - 0 - Hardware interrupts from RXEDGIF disabled using polling.
 * - 1 - RXEDGIF interrupt request enabled.
 */
/*@{*/
#define BP_UART_BDH_RXEDGIE  (6U)          /*!< Bit position for UART_BDH_RXEDGIE. */
#define BM_UART_BDH_RXEDGIE  (0x40U)       /*!< Bit mask for UART_BDH_RXEDGIE. */
#define BS_UART_BDH_RXEDGIE  (1U)          /*!< Bit field size in bits for UART_BDH_RXEDGIE. */

/*! @brief Read current value of the UART_BDH_RXEDGIE field. */
#define BR_UART_BDH_RXEDGIE(x) (BITBAND_ACCESS8(HW_UART_BDH_ADDR(x), BP_UART_BDH_RXEDGIE))

/*! @brief Format value for bitfield UART_BDH_RXEDGIE. */
#define BF_UART_BDH_RXEDGIE(v) ((uint8_t)((uint8_t)(v) << BP_UART_BDH_RXEDGIE) & BM_UART_BDH_RXEDGIE)

/*! @brief Set the RXEDGIE field to a new value. */
#define BW_UART_BDH_RXEDGIE(x, v) (BITBAND_ACCESS8(HW_UART_BDH_ADDR(x), BP_UART_BDH_RXEDGIE) = (v))
/*@}*/

/*!
 * @name Register UART_BDH, field LBKDIE[7] (RW)
 *
 * Enables the LIN break detect flag, LBKDIF, to generate interrupt requests
 * based on the state of LBKDDMAS. or DMA transfer requests,
 *
 * Values:
 * - 0 - LBKDIF interrupt and DMA transfer requests disabled.
 * - 1 - LBKDIF interrupt or DMA transfer requests enabled.
 */
/*@{*/
#define BP_UART_BDH_LBKDIE   (7U)          /*!< Bit position for UART_BDH_LBKDIE. */
#define BM_UART_BDH_LBKDIE   (0x80U)       /*!< Bit mask for UART_BDH_LBKDIE. */
#define BS_UART_BDH_LBKDIE   (1U)          /*!< Bit field size in bits for UART_BDH_LBKDIE. */

/*! @brief Read current value of the UART_BDH_LBKDIE field. */
#define BR_UART_BDH_LBKDIE(x) (BITBAND_ACCESS8(HW_UART_BDH_ADDR(x), BP_UART_BDH_LBKDIE))

/*! @brief Format value for bitfield UART_BDH_LBKDIE. */
#define BF_UART_BDH_LBKDIE(v) ((uint8_t)((uint8_t)(v) << BP_UART_BDH_LBKDIE) & BM_UART_BDH_LBKDIE)

/*! @brief Set the LBKDIE field to a new value. */
#define BW_UART_BDH_LBKDIE(x, v) (BITBAND_ACCESS8(HW_UART_BDH_ADDR(x), BP_UART_BDH_LBKDIE) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_BDL - UART Baud Rate Registers: Low
 ******************************************************************************/

/*!
 * @brief HW_UART_BDL - UART Baud Rate Registers: Low (RW)
 *
 * Reset value: 0x04U
 *
 * This register, along with the BDH register, controls the prescale divisor for
 * UART baud rate generation. To update the 13-bit baud rate setting, SBR[12:0],
 * first write to BDH to buffer the high half of the new value and then write to
 * BDL. The working value in BDH does not change until BDL is written. BDL is
 * reset to a nonzero value, but after reset, the baud rate generator remains
 * disabled until the first time the receiver or transmitter is enabled, that is, when
 * C2[RE] or C2[TE] is set.
 */
typedef union _hw_uart_bdl
{
    uint8_t U;
    struct _hw_uart_bdl_bitfields
    {
        uint8_t SBR : 8;               /*!< [7:0] UART Baud Rate Bits */
    } B;
} hw_uart_bdl_t;

/*!
 * @name Constants and macros for entire UART_BDL register
 */
/*@{*/
#define HW_UART_BDL_ADDR(x)      ((x) + 0x1U)

#define HW_UART_BDL(x)           (*(__IO hw_uart_bdl_t *) HW_UART_BDL_ADDR(x))
#define HW_UART_BDL_RD(x)        (HW_UART_BDL(x).U)
#define HW_UART_BDL_WR(x, v)     (HW_UART_BDL(x).U = (v))
#define HW_UART_BDL_SET(x, v)    (HW_UART_BDL_WR(x, HW_UART_BDL_RD(x) |  (v)))
#define HW_UART_BDL_CLR(x, v)    (HW_UART_BDL_WR(x, HW_UART_BDL_RD(x) & ~(v)))
#define HW_UART_BDL_TOG(x, v)    (HW_UART_BDL_WR(x, HW_UART_BDL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_BDL bitfields
 */

/*!
 * @name Register UART_BDL, field SBR[7:0] (RW)
 *
 * The baud rate for the UART is determined by the 13 SBR fields. See Baud rate
 * generation for details. The baud rate generator is disabled until C2[TE] or
 * C2[RE] is set for the first time after reset.The baud rate generator is disabled
 * when SBR = 0. Writing to BDH has no effect without writing to BDL, because
 * writing to BDH puts the data in a temporary location until BDL is written. When
 * the 1/32 narrow pulse width is selected for infrared (IrDA), the baud rate
 * fields must be even, the least significant bit is 0. See MODEM register for more
 * details.
 */
/*@{*/
#define BP_UART_BDL_SBR      (0U)          /*!< Bit position for UART_BDL_SBR. */
#define BM_UART_BDL_SBR      (0xFFU)       /*!< Bit mask for UART_BDL_SBR. */
#define BS_UART_BDL_SBR      (8U)          /*!< Bit field size in bits for UART_BDL_SBR. */

/*! @brief Read current value of the UART_BDL_SBR field. */
#define BR_UART_BDL_SBR(x)   (HW_UART_BDL(x).U)

/*! @brief Format value for bitfield UART_BDL_SBR. */
#define BF_UART_BDL_SBR(v)   ((uint8_t)((uint8_t)(v) << BP_UART_BDL_SBR) & BM_UART_BDL_SBR)

/*! @brief Set the SBR field to a new value. */
#define BW_UART_BDL_SBR(x, v) (HW_UART_BDL_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_UART_C1 - UART Control Register 1
 ******************************************************************************/

/*!
 * @brief HW_UART_C1 - UART Control Register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * This read/write register controls various optional features of the UART
 * system.
 */
typedef union _hw_uart_c1
{
    uint8_t U;
    struct _hw_uart_c1_bitfields
    {
        uint8_t PT : 1;                /*!< [0] Parity Type */
        uint8_t PE : 1;                /*!< [1] Parity Enable */
        uint8_t ILT : 1;               /*!< [2] Idle Line Type Select */
        uint8_t WAKE : 1;              /*!< [3] Receiver Wakeup Method Select */
        uint8_t M : 1;                 /*!< [4] 9-bit or 8-bit Mode Select */
        uint8_t RSRC : 1;              /*!< [5] Receiver Source Select */
        uint8_t UARTSWAI : 1;          /*!< [6] UART Stops in Wait Mode */
        uint8_t LOOPS : 1;             /*!< [7] Loop Mode Select */
    } B;
} hw_uart_c1_t;

/*!
 * @name Constants and macros for entire UART_C1 register
 */
/*@{*/
#define HW_UART_C1_ADDR(x)       ((x) + 0x2U)

#define HW_UART_C1(x)            (*(__IO hw_uart_c1_t *) HW_UART_C1_ADDR(x))
#define HW_UART_C1_RD(x)         (HW_UART_C1(x).U)
#define HW_UART_C1_WR(x, v)      (HW_UART_C1(x).U = (v))
#define HW_UART_C1_SET(x, v)     (HW_UART_C1_WR(x, HW_UART_C1_RD(x) |  (v)))
#define HW_UART_C1_CLR(x, v)     (HW_UART_C1_WR(x, HW_UART_C1_RD(x) & ~(v)))
#define HW_UART_C1_TOG(x, v)     (HW_UART_C1_WR(x, HW_UART_C1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_C1 bitfields
 */

/*!
 * @name Register UART_C1, field PT[0] (RW)
 *
 * Determines whether the UART generates and checks for even parity or odd
 * parity. With even parity, an even number of 1s clears the parity bit and an odd
 * number of 1s sets the parity bit. With odd parity, an odd number of 1s clears the
 * parity bit and an even number of 1s sets the parity bit. This field must be
 * cleared when C7816[ISO_7816E] is set/enabled.
 *
 * Values:
 * - 0 - Even parity.
 * - 1 - Odd parity.
 */
/*@{*/
#define BP_UART_C1_PT        (0U)          /*!< Bit position for UART_C1_PT. */
#define BM_UART_C1_PT        (0x01U)       /*!< Bit mask for UART_C1_PT. */
#define BS_UART_C1_PT        (1U)          /*!< Bit field size in bits for UART_C1_PT. */

/*! @brief Read current value of the UART_C1_PT field. */
#define BR_UART_C1_PT(x)     (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_PT))

/*! @brief Format value for bitfield UART_C1_PT. */
#define BF_UART_C1_PT(v)     ((uint8_t)((uint8_t)(v) << BP_UART_C1_PT) & BM_UART_C1_PT)

/*! @brief Set the PT field to a new value. */
#define BW_UART_C1_PT(x, v)  (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_PT) = (v))
/*@}*/

/*!
 * @name Register UART_C1, field PE[1] (RW)
 *
 * Enables the parity function. When parity is enabled, parity function inserts
 * a parity bit in the bit position immediately preceding the stop bit. This
 * field must be set when C7816[ISO_7816E] is set/enabled.
 *
 * Values:
 * - 0 - Parity function disabled.
 * - 1 - Parity function enabled.
 */
/*@{*/
#define BP_UART_C1_PE        (1U)          /*!< Bit position for UART_C1_PE. */
#define BM_UART_C1_PE        (0x02U)       /*!< Bit mask for UART_C1_PE. */
#define BS_UART_C1_PE        (1U)          /*!< Bit field size in bits for UART_C1_PE. */

/*! @brief Read current value of the UART_C1_PE field. */
#define BR_UART_C1_PE(x)     (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_PE))

/*! @brief Format value for bitfield UART_C1_PE. */
#define BF_UART_C1_PE(v)     ((uint8_t)((uint8_t)(v) << BP_UART_C1_PE) & BM_UART_C1_PE)

/*! @brief Set the PE field to a new value. */
#define BW_UART_C1_PE(x, v)  (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_PE) = (v))
/*@}*/

/*!
 * @name Register UART_C1, field ILT[2] (RW)
 *
 * Determines when the receiver starts counting logic 1s as idle character bits.
 * The count begins either after a valid start bit or after the stop bit. If the
 * count begins after the start bit, then a string of logic 1s preceding the
 * stop bit can cause false recognition of an idle character. Beginning the count
 * after the stop bit avoids false idle character recognition, but requires
 * properly synchronized transmissions. In case the UART is programmed with ILT = 1, a
 * logic of 1'b0 is automatically shifted after a received stop bit, therefore
 * resetting the idle count. In case the UART is programmed for IDLE line wakeup
 * (RWU = 1 and WAKE = 0), ILT has no effect on when the receiver starts counting
 * logic 1s as idle character bits. In idle line wakeup, an idle character is
 * recognized at anytime the receiver sees 10, 11, or 12 1s depending on the M, PE,
 * and C4[M10] fields.
 *
 * Values:
 * - 0 - Idle character bit count starts after start bit.
 * - 1 - Idle character bit count starts after stop bit.
 */
/*@{*/
#define BP_UART_C1_ILT       (2U)          /*!< Bit position for UART_C1_ILT. */
#define BM_UART_C1_ILT       (0x04U)       /*!< Bit mask for UART_C1_ILT. */
#define BS_UART_C1_ILT       (1U)          /*!< Bit field size in bits for UART_C1_ILT. */

/*! @brief Read current value of the UART_C1_ILT field. */
#define BR_UART_C1_ILT(x)    (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_ILT))

/*! @brief Format value for bitfield UART_C1_ILT. */
#define BF_UART_C1_ILT(v)    ((uint8_t)((uint8_t)(v) << BP_UART_C1_ILT) & BM_UART_C1_ILT)

/*! @brief Set the ILT field to a new value. */
#define BW_UART_C1_ILT(x, v) (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_ILT) = (v))
/*@}*/

/*!
 * @name Register UART_C1, field WAKE[3] (RW)
 *
 * Determines which condition wakes the UART: Address mark in the most
 * significant bit position of a received data character, or An idle condition on the
 * receive pin input signal.
 *
 * Values:
 * - 0 - Idle line wakeup.
 * - 1 - Address mark wakeup.
 */
/*@{*/
#define BP_UART_C1_WAKE      (3U)          /*!< Bit position for UART_C1_WAKE. */
#define BM_UART_C1_WAKE      (0x08U)       /*!< Bit mask for UART_C1_WAKE. */
#define BS_UART_C1_WAKE      (1U)          /*!< Bit field size in bits for UART_C1_WAKE. */

/*! @brief Read current value of the UART_C1_WAKE field. */
#define BR_UART_C1_WAKE(x)   (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_WAKE))

/*! @brief Format value for bitfield UART_C1_WAKE. */
#define BF_UART_C1_WAKE(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C1_WAKE) & BM_UART_C1_WAKE)

/*! @brief Set the WAKE field to a new value. */
#define BW_UART_C1_WAKE(x, v) (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_WAKE) = (v))
/*@}*/

/*!
 * @name Register UART_C1, field M[4] (RW)
 *
 * This field must be set when C7816[ISO_7816E] is set/enabled.
 *
 * Values:
 * - 0 - Normal-start + 8 data bits (MSB/LSB first as determined by MSBF) + stop.
 * - 1 - Use-start + 9 data bits (MSB/LSB first as determined by MSBF) + stop.
 */
/*@{*/
#define BP_UART_C1_M         (4U)          /*!< Bit position for UART_C1_M. */
#define BM_UART_C1_M         (0x10U)       /*!< Bit mask for UART_C1_M. */
#define BS_UART_C1_M         (1U)          /*!< Bit field size in bits for UART_C1_M. */

/*! @brief Read current value of the UART_C1_M field. */
#define BR_UART_C1_M(x)      (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_M))

/*! @brief Format value for bitfield UART_C1_M. */
#define BF_UART_C1_M(v)      ((uint8_t)((uint8_t)(v) << BP_UART_C1_M) & BM_UART_C1_M)

/*! @brief Set the M field to a new value. */
#define BW_UART_C1_M(x, v)   (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_M) = (v))
/*@}*/

/*!
 * @name Register UART_C1, field RSRC[5] (RW)
 *
 * This field has no meaning or effect unless the LOOPS field is set. When LOOPS
 * is set, the RSRC field determines the source for the receiver shift register
 * input.
 *
 * Values:
 * - 0 - Selects internal loop back mode. The receiver input is internally
 *     connected to transmitter output.
 * - 1 - Single wire UART mode where the receiver input is connected to the
 *     transmit pin input signal.
 */
/*@{*/
#define BP_UART_C1_RSRC      (5U)          /*!< Bit position for UART_C1_RSRC. */
#define BM_UART_C1_RSRC      (0x20U)       /*!< Bit mask for UART_C1_RSRC. */
#define BS_UART_C1_RSRC      (1U)          /*!< Bit field size in bits for UART_C1_RSRC. */

/*! @brief Read current value of the UART_C1_RSRC field. */
#define BR_UART_C1_RSRC(x)   (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_RSRC))

/*! @brief Format value for bitfield UART_C1_RSRC. */
#define BF_UART_C1_RSRC(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C1_RSRC) & BM_UART_C1_RSRC)

/*! @brief Set the RSRC field to a new value. */
#define BW_UART_C1_RSRC(x, v) (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_RSRC) = (v))
/*@}*/

/*!
 * @name Register UART_C1, field UARTSWAI[6] (RW)
 *
 * Values:
 * - 0 - UART clock continues to run in Wait mode.
 * - 1 - UART clock freezes while CPU is in Wait mode.
 */
/*@{*/
#define BP_UART_C1_UARTSWAI  (6U)          /*!< Bit position for UART_C1_UARTSWAI. */
#define BM_UART_C1_UARTSWAI  (0x40U)       /*!< Bit mask for UART_C1_UARTSWAI. */
#define BS_UART_C1_UARTSWAI  (1U)          /*!< Bit field size in bits for UART_C1_UARTSWAI. */

/*! @brief Read current value of the UART_C1_UARTSWAI field. */
#define BR_UART_C1_UARTSWAI(x) (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_UARTSWAI))

/*! @brief Format value for bitfield UART_C1_UARTSWAI. */
#define BF_UART_C1_UARTSWAI(v) ((uint8_t)((uint8_t)(v) << BP_UART_C1_UARTSWAI) & BM_UART_C1_UARTSWAI)

/*! @brief Set the UARTSWAI field to a new value. */
#define BW_UART_C1_UARTSWAI(x, v) (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_UARTSWAI) = (v))
/*@}*/

/*!
 * @name Register UART_C1, field LOOPS[7] (RW)
 *
 * When LOOPS is set, the RxD pin is disconnected from the UART and the
 * transmitter output is internally connected to the receiver input. The transmitter and
 * the receiver must be enabled to use the loop function.
 *
 * Values:
 * - 0 - Normal operation.
 * - 1 - Loop mode where transmitter output is internally connected to receiver
 *     input. The receiver input is determined by RSRC.
 */
/*@{*/
#define BP_UART_C1_LOOPS     (7U)          /*!< Bit position for UART_C1_LOOPS. */
#define BM_UART_C1_LOOPS     (0x80U)       /*!< Bit mask for UART_C1_LOOPS. */
#define BS_UART_C1_LOOPS     (1U)          /*!< Bit field size in bits for UART_C1_LOOPS. */

/*! @brief Read current value of the UART_C1_LOOPS field. */
#define BR_UART_C1_LOOPS(x)  (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_LOOPS))

/*! @brief Format value for bitfield UART_C1_LOOPS. */
#define BF_UART_C1_LOOPS(v)  ((uint8_t)((uint8_t)(v) << BP_UART_C1_LOOPS) & BM_UART_C1_LOOPS)

/*! @brief Set the LOOPS field to a new value. */
#define BW_UART_C1_LOOPS(x, v) (BITBAND_ACCESS8(HW_UART_C1_ADDR(x), BP_UART_C1_LOOPS) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_C2 - UART Control Register 2
 ******************************************************************************/

/*!
 * @brief HW_UART_C2 - UART Control Register 2 (RW)
 *
 * Reset value: 0x00U
 *
 * This register can be read or written at any time.
 */
typedef union _hw_uart_c2
{
    uint8_t U;
    struct _hw_uart_c2_bitfields
    {
        uint8_t SBK : 1;               /*!< [0] Send Break */
        uint8_t RWU : 1;               /*!< [1] Receiver Wakeup Control */
        uint8_t RE : 1;                /*!< [2] Receiver Enable */
        uint8_t TE : 1;                /*!< [3] Transmitter Enable */
        uint8_t ILIE : 1;              /*!< [4] Idle Line Interrupt DMA Transfer Enable */
        uint8_t RIE : 1;               /*!< [5] Receiver Full Interrupt or DMA Transfer
                                        * Enable */
        uint8_t TCIE : 1;              /*!< [6] Transmission Complete Interrupt or DMA
                                        * Transfer Enable */
        uint8_t TIE : 1;               /*!< [7] Transmitter Interrupt or DMA Transfer
                                        * Enable. */
    } B;
} hw_uart_c2_t;

/*!
 * @name Constants and macros for entire UART_C2 register
 */
/*@{*/
#define HW_UART_C2_ADDR(x)       ((x) + 0x3U)

#define HW_UART_C2(x)            (*(__IO hw_uart_c2_t *) HW_UART_C2_ADDR(x))
#define HW_UART_C2_RD(x)         (HW_UART_C2(x).U)
#define HW_UART_C2_WR(x, v)      (HW_UART_C2(x).U = (v))
#define HW_UART_C2_SET(x, v)     (HW_UART_C2_WR(x, HW_UART_C2_RD(x) |  (v)))
#define HW_UART_C2_CLR(x, v)     (HW_UART_C2_WR(x, HW_UART_C2_RD(x) & ~(v)))
#define HW_UART_C2_TOG(x, v)     (HW_UART_C2_WR(x, HW_UART_C2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_C2 bitfields
 */

/*!
 * @name Register UART_C2, field SBK[0] (RW)
 *
 * Toggling SBK sends one break character from the following: See Transmitting
 * break characters for the number of logic 0s for the different configurations.
 * Toggling implies clearing the SBK field before the break character has finished
 * transmitting. As long as SBK is set, the transmitter continues to send
 * complete break characters (10, 11, or 12 bits, or 13 or 14 bits, or 15 or 16 bits).
 * Ensure that C2[TE] is asserted atleast 1 clock before assertion of this bit.
 * 10, 11, or 12 logic 0s if S2[BRK13] is cleared 13 or 14 logic 0s if S2[BRK13]
 * is set. 15 or 16 logic 0s if BDH[SBNS] is set. This field must be cleared when
 * C7816[ISO_7816E] is set.
 *
 * Values:
 * - 0 - Normal transmitter operation.
 * - 1 - Queue break characters to be sent.
 */
/*@{*/
#define BP_UART_C2_SBK       (0U)          /*!< Bit position for UART_C2_SBK. */
#define BM_UART_C2_SBK       (0x01U)       /*!< Bit mask for UART_C2_SBK. */
#define BS_UART_C2_SBK       (1U)          /*!< Bit field size in bits for UART_C2_SBK. */

/*! @brief Read current value of the UART_C2_SBK field. */
#define BR_UART_C2_SBK(x)    (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_SBK))

/*! @brief Format value for bitfield UART_C2_SBK. */
#define BF_UART_C2_SBK(v)    ((uint8_t)((uint8_t)(v) << BP_UART_C2_SBK) & BM_UART_C2_SBK)

/*! @brief Set the SBK field to a new value. */
#define BW_UART_C2_SBK(x, v) (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_SBK) = (v))
/*@}*/

/*!
 * @name Register UART_C2, field RWU[1] (RW)
 *
 * This field can be set to place the UART receiver in a standby state. RWU
 * automatically clears when an RWU event occurs, that is, an IDLE event when
 * C1[WAKE] is clear or an address match when C1[WAKE] is set. This field must be
 * cleared when C7816[ISO_7816E] is set. RWU must be set only with C1[WAKE] = 0 (wakeup
 * on idle) if the channel is currently not idle. This can be determined by
 * S2[RAF]. If the flag is set to wake up an IDLE event and the channel is already
 * idle, it is possible that the UART will discard data. This is because the data
 * must be received or a LIN break detected after an IDLE is detected before IDLE
 * is allowed to reasserted.
 *
 * Values:
 * - 0 - Normal operation.
 * - 1 - RWU enables the wakeup function and inhibits further receiver interrupt
 *     requests. Normally, hardware wakes the receiver by automatically clearing
 *     RWU.
 */
/*@{*/
#define BP_UART_C2_RWU       (1U)          /*!< Bit position for UART_C2_RWU. */
#define BM_UART_C2_RWU       (0x02U)       /*!< Bit mask for UART_C2_RWU. */
#define BS_UART_C2_RWU       (1U)          /*!< Bit field size in bits for UART_C2_RWU. */

/*! @brief Read current value of the UART_C2_RWU field. */
#define BR_UART_C2_RWU(x)    (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_RWU))

/*! @brief Format value for bitfield UART_C2_RWU. */
#define BF_UART_C2_RWU(v)    ((uint8_t)((uint8_t)(v) << BP_UART_C2_RWU) & BM_UART_C2_RWU)

/*! @brief Set the RWU field to a new value. */
#define BW_UART_C2_RWU(x, v) (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_RWU) = (v))
/*@}*/

/*!
 * @name Register UART_C2, field RE[2] (RW)
 *
 * Enables the UART receiver.
 *
 * Values:
 * - 0 - Receiver off.
 * - 1 - Receiver on.
 */
/*@{*/
#define BP_UART_C2_RE        (2U)          /*!< Bit position for UART_C2_RE. */
#define BM_UART_C2_RE        (0x04U)       /*!< Bit mask for UART_C2_RE. */
#define BS_UART_C2_RE        (1U)          /*!< Bit field size in bits for UART_C2_RE. */

/*! @brief Read current value of the UART_C2_RE field. */
#define BR_UART_C2_RE(x)     (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_RE))

/*! @brief Format value for bitfield UART_C2_RE. */
#define BF_UART_C2_RE(v)     ((uint8_t)((uint8_t)(v) << BP_UART_C2_RE) & BM_UART_C2_RE)

/*! @brief Set the RE field to a new value. */
#define BW_UART_C2_RE(x, v)  (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_RE) = (v))
/*@}*/

/*!
 * @name Register UART_C2, field TE[3] (RW)
 *
 * Enables the UART transmitter. TE can be used to queue an idle preamble by
 * clearing and then setting TE. When C7816[ISO_7816E] is set/enabled and
 * C7816[TTYPE] = 1, this field is automatically cleared after the requested block has been
 * transmitted. This condition is detected when TL7816[TLEN] = 0 and four
 * additional characters are transmitted.
 *
 * Values:
 * - 0 - Transmitter off.
 * - 1 - Transmitter on.
 */
/*@{*/
#define BP_UART_C2_TE        (3U)          /*!< Bit position for UART_C2_TE. */
#define BM_UART_C2_TE        (0x08U)       /*!< Bit mask for UART_C2_TE. */
#define BS_UART_C2_TE        (1U)          /*!< Bit field size in bits for UART_C2_TE. */

/*! @brief Read current value of the UART_C2_TE field. */
#define BR_UART_C2_TE(x)     (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_TE))

/*! @brief Format value for bitfield UART_C2_TE. */
#define BF_UART_C2_TE(v)     ((uint8_t)((uint8_t)(v) << BP_UART_C2_TE) & BM_UART_C2_TE)

/*! @brief Set the TE field to a new value. */
#define BW_UART_C2_TE(x, v)  (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_TE) = (v))
/*@}*/

/*!
 * @name Register UART_C2, field ILIE[4] (RW)
 *
 * Enables the idle line flag, S1[IDLE], to generate interrupt requestsor DMA
 * transfer requests based on the state of C5[ILDMAS].
 *
 * Values:
 * - 0 - IDLE interrupt requests disabled. and DMA transfer
 * - 1 - IDLE interrupt requests enabled. or DMA transfer
 */
/*@{*/
#define BP_UART_C2_ILIE      (4U)          /*!< Bit position for UART_C2_ILIE. */
#define BM_UART_C2_ILIE      (0x10U)       /*!< Bit mask for UART_C2_ILIE. */
#define BS_UART_C2_ILIE      (1U)          /*!< Bit field size in bits for UART_C2_ILIE. */

/*! @brief Read current value of the UART_C2_ILIE field. */
#define BR_UART_C2_ILIE(x)   (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_ILIE))

/*! @brief Format value for bitfield UART_C2_ILIE. */
#define BF_UART_C2_ILIE(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C2_ILIE) & BM_UART_C2_ILIE)

/*! @brief Set the ILIE field to a new value. */
#define BW_UART_C2_ILIE(x, v) (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_ILIE) = (v))
/*@}*/

/*!
 * @name Register UART_C2, field RIE[5] (RW)
 *
 * Enables S1[RDRF] to generate interrupt requests or DMA transfer requests,
 * based on the state of C5[RDMAS].
 *
 * Values:
 * - 0 - RDRF interrupt and DMA transfer requests disabled.
 * - 1 - RDRF interrupt or DMA transfer requests enabled.
 */
/*@{*/
#define BP_UART_C2_RIE       (5U)          /*!< Bit position for UART_C2_RIE. */
#define BM_UART_C2_RIE       (0x20U)       /*!< Bit mask for UART_C2_RIE. */
#define BS_UART_C2_RIE       (1U)          /*!< Bit field size in bits for UART_C2_RIE. */

/*! @brief Read current value of the UART_C2_RIE field. */
#define BR_UART_C2_RIE(x)    (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_RIE))

/*! @brief Format value for bitfield UART_C2_RIE. */
#define BF_UART_C2_RIE(v)    ((uint8_t)((uint8_t)(v) << BP_UART_C2_RIE) & BM_UART_C2_RIE)

/*! @brief Set the RIE field to a new value. */
#define BW_UART_C2_RIE(x, v) (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_RIE) = (v))
/*@}*/

/*!
 * @name Register UART_C2, field TCIE[6] (RW)
 *
 * Enables the transmission complete flag, S1[TC], to generate interrupt
 * requests . or DMA transfer requests based on the state of C5[TCDMAS] If C2[TCIE] and
 * C5[TCDMAS] are both set, then TIE must be cleared, and D[D] must not be
 * written unless servicing a DMA request.
 *
 * Values:
 * - 0 - TC interrupt and DMA transfer requests disabled.
 * - 1 - TC interrupt or DMA transfer requests enabled.
 */
/*@{*/
#define BP_UART_C2_TCIE      (6U)          /*!< Bit position for UART_C2_TCIE. */
#define BM_UART_C2_TCIE      (0x40U)       /*!< Bit mask for UART_C2_TCIE. */
#define BS_UART_C2_TCIE      (1U)          /*!< Bit field size in bits for UART_C2_TCIE. */

/*! @brief Read current value of the UART_C2_TCIE field. */
#define BR_UART_C2_TCIE(x)   (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_TCIE))

/*! @brief Format value for bitfield UART_C2_TCIE. */
#define BF_UART_C2_TCIE(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C2_TCIE) & BM_UART_C2_TCIE)

/*! @brief Set the TCIE field to a new value. */
#define BW_UART_C2_TCIE(x, v) (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_TCIE) = (v))
/*@}*/

/*!
 * @name Register UART_C2, field TIE[7] (RW)
 *
 * Enables S1[TDRE] to generate interrupt requests or DMA transfer requests,
 * based on the state of C5[TDMAS]. If C2[TIE] and C5[TDMAS] are both set, then TCIE
 * must be cleared, and D[D] must not be written unless servicing a DMA request.
 *
 * Values:
 * - 0 - TDRE interrupt and DMA transfer requests disabled.
 * - 1 - TDRE interrupt or DMA transfer requests enabled.
 */
/*@{*/
#define BP_UART_C2_TIE       (7U)          /*!< Bit position for UART_C2_TIE. */
#define BM_UART_C2_TIE       (0x80U)       /*!< Bit mask for UART_C2_TIE. */
#define BS_UART_C2_TIE       (1U)          /*!< Bit field size in bits for UART_C2_TIE. */

/*! @brief Read current value of the UART_C2_TIE field. */
#define BR_UART_C2_TIE(x)    (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_TIE))

/*! @brief Format value for bitfield UART_C2_TIE. */
#define BF_UART_C2_TIE(v)    ((uint8_t)((uint8_t)(v) << BP_UART_C2_TIE) & BM_UART_C2_TIE)

/*! @brief Set the TIE field to a new value. */
#define BW_UART_C2_TIE(x, v) (BITBAND_ACCESS8(HW_UART_C2_ADDR(x), BP_UART_C2_TIE) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_S1 - UART Status Register 1
 ******************************************************************************/

/*!
 * @brief HW_UART_S1 - UART Status Register 1 (RO)
 *
 * Reset value: 0xC0U
 *
 * The S1 register provides inputs to the MCU for generation of UART interrupts
 * or DMA requests. This register can also be polled by the MCU to check the
 * status of its fields. To clear a flag, the status register should be read followed
 * by a read or write to D register, depending on the interrupt flag type. Other
 * instructions can be executed between the two steps as long the handling of
 * I/O is not compromised, but the order of operations is important for flag
 * clearing. When a flag is configured to trigger a DMA request, assertion of the
 * associated DMA done signal from the DMA controller clears the flag. If the
 * condition that results in the assertion of the flag, interrupt, or DMA request is not
 * resolved prior to clearing the flag, the flag, and interrupt/DMA request,
 * reasserts. For example, if the DMA or interrupt service routine fails to write
 * sufficient data to the transmit buffer to raise it above the watermark level, the
 * flag reasserts and generates another interrupt or DMA request. Reading an
 * empty data register to clear one of the flags of the S1 register causes the FIFO
 * pointers to become misaligned. A receive FIFO flush reinitializes the
 * pointers. A better way to prevent this situation is to always leave one byte in FIFO
 * and this byte will be read eventually in clearing the flag bit.
 */
typedef union _hw_uart_s1
{
    uint8_t U;
    struct _hw_uart_s1_bitfields
    {
        uint8_t PF : 1;                /*!< [0] Parity Error Flag */
        uint8_t FE : 1;                /*!< [1] Framing Error Flag */
        uint8_t NF : 1;                /*!< [2] Noise Flag */
        uint8_t OR : 1;                /*!< [3] Receiver Overrun Flag */
        uint8_t IDLE : 1;              /*!< [4] Idle Line Flag */
        uint8_t RDRF : 1;              /*!< [5] Receive Data Register Full Flag */
        uint8_t TC : 1;                /*!< [6] Transmit Complete Flag */
        uint8_t TDRE : 1;              /*!< [7] Transmit Data Register Empty Flag */
    } B;
} hw_uart_s1_t;

/*!
 * @name Constants and macros for entire UART_S1 register
 */
/*@{*/
#define HW_UART_S1_ADDR(x)       ((x) + 0x4U)

#define HW_UART_S1(x)            (*(__I hw_uart_s1_t *) HW_UART_S1_ADDR(x))
#define HW_UART_S1_RD(x)         (HW_UART_S1(x).U)
/*@}*/

/*
 * Constants & macros for individual UART_S1 bitfields
 */

/*!
 * @name Register UART_S1, field PF[0] (RO)
 *
 * PF is set when PE is set and the parity of the received data does not match
 * its parity bit. The PF is not set in the case of an overrun condition. When PF
 * is set, it indicates only that a dataword was received with parity error since
 * the last time it was cleared. There is no guarantee that the first dataword
 * read from the receive buffer has a parity error or that there is only one
 * dataword in the buffer that was received with a parity error, unless the receive
 * buffer has a depth of one. To clear PF, read S1 and then read D., S2[LBKDE] is
 * disabled, Within the receive buffer structure the received dataword is tagged
 * if it is received with a parity error. This information is available by reading
 * the ED register prior to reading the D register.
 *
 * Values:
 * - 0 - No parity error detected since the last time this flag was cleared. If
 *     the receive buffer has a depth greater than 1, then there may be data in
 *     the receive buffer what was received with a parity error.
 * - 1 - At least one dataword was received with a parity error since the last
 *     time this flag was cleared.
 */
/*@{*/
#define BP_UART_S1_PF        (0U)          /*!< Bit position for UART_S1_PF. */
#define BM_UART_S1_PF        (0x01U)       /*!< Bit mask for UART_S1_PF. */
#define BS_UART_S1_PF        (1U)          /*!< Bit field size in bits for UART_S1_PF. */

/*! @brief Read current value of the UART_S1_PF field. */
#define BR_UART_S1_PF(x)     (BITBAND_ACCESS8(HW_UART_S1_ADDR(x), BP_UART_S1_PF))
/*@}*/

/*!
 * @name Register UART_S1, field FE[1] (RO)
 *
 * FE is set when a logic 0 is accepted as the stop bit. When BDH[SBNS] is set,
 * then FE will set when a logic 0 is accepted for either of the two stop bits.
 * FE does not set in the case of an overrun or while the LIN break detect feature
 * is enabled (S2[LBKDE] = 1). FE inhibits further data reception until it is
 * cleared. To clear FE, read S1 with FE set and then read D. The last data in the
 * receive buffer represents the data that was received with the frame error
 * enabled. Framing errors are not supported when 7816E is set/enabled. However, if
 * this flag is set, data is still not received in 7816 mode.
 *
 * Values:
 * - 0 - No framing error detected.
 * - 1 - Framing error.
 */
/*@{*/
#define BP_UART_S1_FE        (1U)          /*!< Bit position for UART_S1_FE. */
#define BM_UART_S1_FE        (0x02U)       /*!< Bit mask for UART_S1_FE. */
#define BS_UART_S1_FE        (1U)          /*!< Bit field size in bits for UART_S1_FE. */

/*! @brief Read current value of the UART_S1_FE field. */
#define BR_UART_S1_FE(x)     (BITBAND_ACCESS8(HW_UART_S1_ADDR(x), BP_UART_S1_FE))
/*@}*/

/*!
 * @name Register UART_S1, field NF[2] (RO)
 *
 * NF is set when the UART detects noise on the receiver input. NF does not
 * become set in the case of an overrun or while the LIN break detect feature is
 * enabled (S2[LBKDE] = 1). When NF is set, it indicates only that a dataword has
 * been received with noise since the last time it was cleared. There is no
 * guarantee that the first dataword read from the receive buffer has noise or that there
 * is only one dataword in the buffer that was received with noise unless the
 * receive buffer has a depth of one. To clear NF, read S1 and then read D.
 *
 * Values:
 * - 0 - No noise detected since the last time this flag was cleared. If the
 *     receive buffer has a depth greater than 1 then there may be data in the
 *     receiver buffer that was received with noise.
 * - 1 - At least one dataword was received with noise detected since the last
 *     time the flag was cleared.
 */
/*@{*/
#define BP_UART_S1_NF        (2U)          /*!< Bit position for UART_S1_NF. */
#define BM_UART_S1_NF        (0x04U)       /*!< Bit mask for UART_S1_NF. */
#define BS_UART_S1_NF        (1U)          /*!< Bit field size in bits for UART_S1_NF. */

/*! @brief Read current value of the UART_S1_NF field. */
#define BR_UART_S1_NF(x)     (BITBAND_ACCESS8(HW_UART_S1_ADDR(x), BP_UART_S1_NF))
/*@}*/

/*!
 * @name Register UART_S1, field OR[3] (RO)
 *
 * OR is set when software fails to prevent the receive data register from
 * overflowing with data. The OR bit is set immediately after the stop bit has been
 * completely received for the dataword that overflows the buffer and all the other
 * error flags (FE, NF, and PF) are prevented from setting. The data in the
 * shift register is lost, but the data already in the UART data registers is not
 * affected. If the OR flag is set, no data is stored in the data buffer even if
 * sufficient room exists. Additionally, while the OR flag is set, the RDRF and IDLE
 * flags are blocked from asserting, that is, transition from an inactive to an
 * active state. To clear OR, read S1 when OR is set and then read D. See
 * functional description for more details regarding the operation of the OR bit.If
 * LBKDE is enabled and a LIN Break is detected, the OR field asserts if S2[LBKDIF]
 * is not cleared before the next data character is received. In 7816 mode, it is
 * possible to configure a NACK to be returned by programing C7816[ONACK].
 *
 * Values:
 * - 0 - No overrun has occurred since the last time the flag was cleared.
 * - 1 - Overrun has occurred or the overrun flag has not been cleared since the
 *     last overrun occured.
 */
/*@{*/
#define BP_UART_S1_OR        (3U)          /*!< Bit position for UART_S1_OR. */
#define BM_UART_S1_OR        (0x08U)       /*!< Bit mask for UART_S1_OR. */
#define BS_UART_S1_OR        (1U)          /*!< Bit field size in bits for UART_S1_OR. */

/*! @brief Read current value of the UART_S1_OR field. */
#define BR_UART_S1_OR(x)     (BITBAND_ACCESS8(HW_UART_S1_ADDR(x), BP_UART_S1_OR))
/*@}*/

/*!
 * @name Register UART_S1, field IDLE[4] (RO)
 *
 * After the IDLE flag is cleared, a frame must be received (although not
 * necessarily stored in the data buffer, for example if C2[RWU] is set), or a LIN
 * break character must set the S2[LBKDIF] flag before an idle condition can set the
 * IDLE flag. To clear IDLE, read UART status S1 with IDLE set and then read D.
 * IDLE is set when either of the following appear on the receiver input: 10
 * consecutive logic 1s if C1[M] = 0 11 consecutive logic 1s if C1[M] = 1 and C4[M10]
 * = 0 12 consecutive logic 1s if C1[M] = 1, C4[M10] = 1, and C1[PE] = 1 Idle
 * detection is not supported when 7816E is set/enabled and hence this flag is
 * ignored. When RWU is set and WAKE is cleared, an idle line condition sets the IDLE
 * flag if RWUID is set, else the IDLE flag does not become set.
 *
 * Values:
 * - 0 - Receiver input is either active now or has never become active since
 *     the IDLE flag was last cleared.
 * - 1 - Receiver input has become idle or the flag has not been cleared since
 *     it last asserted.
 */
/*@{*/
#define BP_UART_S1_IDLE      (4U)          /*!< Bit position for UART_S1_IDLE. */
#define BM_UART_S1_IDLE      (0x10U)       /*!< Bit mask for UART_S1_IDLE. */
#define BS_UART_S1_IDLE      (1U)          /*!< Bit field size in bits for UART_S1_IDLE. */

/*! @brief Read current value of the UART_S1_IDLE field. */
#define BR_UART_S1_IDLE(x)   (BITBAND_ACCESS8(HW_UART_S1_ADDR(x), BP_UART_S1_IDLE))
/*@}*/

/*!
 * @name Register UART_S1, field RDRF[5] (RO)
 *
 * RDRF is set when the number of datawords in the receive buffer is equal to or
 * more than the number indicated by RWFIFO[RXWATER]. A dataword that is in the
 * process of being received is not included in the count. To clear RDRF, read S1
 * when RDRF is set and then read D. For more efficient interrupt and DMA
 * operation, read all data except the final value from the buffer, using D/C3[T8]/ED.
 * Then read S1 and the final data value, resulting in the clearing of the RDRF
 * flag. Even if RDRF is set, data will continue to be received until an overrun
 * condition occurs.RDRF is prevented from setting while S2[LBKDE] is set.
 * Additionally, when S2[LBKDE] is set, the received datawords are stored in the receive
 * buffer but over-write each other.
 *
 * Values:
 * - 0 - The number of datawords in the receive buffer is less than the number
 *     indicated by RXWATER.
 * - 1 - The number of datawords in the receive buffer is equal to or greater
 *     than the number indicated by RXWATER at some point in time since this flag
 *     was last cleared.
 */
/*@{*/
#define BP_UART_S1_RDRF      (5U)          /*!< Bit position for UART_S1_RDRF. */
#define BM_UART_S1_RDRF      (0x20U)       /*!< Bit mask for UART_S1_RDRF. */
#define BS_UART_S1_RDRF      (1U)          /*!< Bit field size in bits for UART_S1_RDRF. */

/*! @brief Read current value of the UART_S1_RDRF field. */
#define BR_UART_S1_RDRF(x)   (BITBAND_ACCESS8(HW_UART_S1_ADDR(x), BP_UART_S1_RDRF))
/*@}*/

/*!
 * @name Register UART_S1, field TC[6] (RO)
 *
 * TC is set when the transmit buffer is empty and no data, preamble, or break
 * character is being transmitted. When TC is set, the transmit data output signal
 * becomes idle (logic 1). TC is cleared by reading S1 with TC set and then
 * doing one of the following: When C7816[ISO_7816E] is set/enabled, this field is
 * set after any NACK signal has been received, but prior to any corresponding
 * guard times expiring. Writing to D to transmit new data. Queuing a preamble by
 * clearing and then setting C2[TE]. Queuing a break character by writing 1 to SBK
 * in C2.
 *
 * Values:
 * - 0 - Transmitter active (sending data, a preamble, or a break).
 * - 1 - Transmitter idle (transmission activity complete).
 */
/*@{*/
#define BP_UART_S1_TC        (6U)          /*!< Bit position for UART_S1_TC. */
#define BM_UART_S1_TC        (0x40U)       /*!< Bit mask for UART_S1_TC. */
#define BS_UART_S1_TC        (1U)          /*!< Bit field size in bits for UART_S1_TC. */

/*! @brief Read current value of the UART_S1_TC field. */
#define BR_UART_S1_TC(x)     (BITBAND_ACCESS8(HW_UART_S1_ADDR(x), BP_UART_S1_TC))
/*@}*/

/*!
 * @name Register UART_S1, field TDRE[7] (RO)
 *
 * TDRE will set when the number of datawords in the transmit buffer (D and
 * C3[T8])is equal to or less than the number indicated by TWFIFO[TXWATER]. A
 * character that is in the process of being transmitted is not included in the count.
 * To clear TDRE, read S1 when TDRE is set and then write to the UART data
 * register (D). For more efficient interrupt servicing, all data except the final value
 * to be written to the buffer must be written to D/C3[T8]. Then S1 can be read
 * before writing the final data value, resulting in the clearing of the TRDE
 * flag. This is more efficient because the TDRE reasserts until the watermark has
 * been exceeded. So, attempting to clear the TDRE with every write will be
 * ineffective until sufficient data has been written.
 *
 * Values:
 * - 0 - The amount of data in the transmit buffer is greater than the value
 *     indicated by TWFIFO[TXWATER].
 * - 1 - The amount of data in the transmit buffer is less than or equal to the
 *     value indicated by TWFIFO[TXWATER] at some point in time since the flag
 *     has been cleared.
 */
/*@{*/
#define BP_UART_S1_TDRE      (7U)          /*!< Bit position for UART_S1_TDRE. */
#define BM_UART_S1_TDRE      (0x80U)       /*!< Bit mask for UART_S1_TDRE. */
#define BS_UART_S1_TDRE      (1U)          /*!< Bit field size in bits for UART_S1_TDRE. */

/*! @brief Read current value of the UART_S1_TDRE field. */
#define BR_UART_S1_TDRE(x)   (BITBAND_ACCESS8(HW_UART_S1_ADDR(x), BP_UART_S1_TDRE))
/*@}*/

/*******************************************************************************
 * HW_UART_S2 - UART Status Register 2
 ******************************************************************************/

/*!
 * @brief HW_UART_S2 - UART Status Register 2 (RW)
 *
 * Reset value: 0x00U
 *
 * The S2 register provides inputs to the MCU for generation of UART interrupts
 * or DMA requests. Also, this register can be polled by the MCU to check the
 * status of these bits. This register can be read or written at any time, with the
 * exception of the MSBF and RXINV bits, which should be changed by the user only
 * between transmit and receive packets.
 */
typedef union _hw_uart_s2
{
    uint8_t U;
    struct _hw_uart_s2_bitfields
    {
        uint8_t RAF : 1;               /*!< [0] Receiver Active Flag */
        uint8_t LBKDE : 1;             /*!< [1] LIN Break Detection Enable */
        uint8_t BRK13 : 1;             /*!< [2] Break Transmit Character Length */
        uint8_t RWUID : 1;             /*!< [3] Receive Wakeup Idle Detect */
        uint8_t RXINV : 1;             /*!< [4] Receive Data Inversion */
        uint8_t MSBF : 1;              /*!< [5] Most Significant Bit First */
        uint8_t RXEDGIF : 1;           /*!< [6] RxD Pin Active Edge Interrupt Flag */
        uint8_t LBKDIF : 1;            /*!< [7] LIN Break Detect Interrupt Flag */
    } B;
} hw_uart_s2_t;

/*!
 * @name Constants and macros for entire UART_S2 register
 */
/*@{*/
#define HW_UART_S2_ADDR(x)       ((x) + 0x5U)

#define HW_UART_S2(x)            (*(__IO hw_uart_s2_t *) HW_UART_S2_ADDR(x))
#define HW_UART_S2_RD(x)         (HW_UART_S2(x).U)
#define HW_UART_S2_WR(x, v)      (HW_UART_S2(x).U = (v))
#define HW_UART_S2_SET(x, v)     (HW_UART_S2_WR(x, HW_UART_S2_RD(x) |  (v)))
#define HW_UART_S2_CLR(x, v)     (HW_UART_S2_WR(x, HW_UART_S2_RD(x) & ~(v)))
#define HW_UART_S2_TOG(x, v)     (HW_UART_S2_WR(x, HW_UART_S2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_S2 bitfields
 */

/*!
 * @name Register UART_S2, field RAF[0] (RO)
 *
 * RAF is set when the UART receiver detects a logic 0 during the RT1 time
 * period of the start bit search. RAF is cleared when the receiver detects an idle
 * character when C7816[ISO7816E] is cleared/disabled. When C7816[ISO7816E] is
 * enabled, the RAF is cleared if the C7816[TTYPE] = 0 expires or the C7816[TTYPE] =
 * 1 expires.In case C7816[ISO7816E] is set and C7816[TTYPE] = 0, it is possible
 * to configure the guard time to 12. However, if a NACK is required to be
 * transmitted, the data transfer actually takes 13 ETU with the 13th ETU slot being a
 * inactive buffer. Therefore, in this situation, the RAF may deassert one ETU
 * prior to actually being inactive.
 *
 * Values:
 * - 0 - UART receiver idle/inactive waiting for a start bit.
 * - 1 - UART receiver active, RxD input not idle.
 */
/*@{*/
#define BP_UART_S2_RAF       (0U)          /*!< Bit position for UART_S2_RAF. */
#define BM_UART_S2_RAF       (0x01U)       /*!< Bit mask for UART_S2_RAF. */
#define BS_UART_S2_RAF       (1U)          /*!< Bit field size in bits for UART_S2_RAF. */

/*! @brief Read current value of the UART_S2_RAF field. */
#define BR_UART_S2_RAF(x)    (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_RAF))
/*@}*/

/*!
 * @name Register UART_S2, field LBKDE[1] (RW)
 *
 * Enables the LIN Break detection feature. While LBKDE is set, S1[RDRF],
 * S1[NF], S1[FE], and S1[PF] are prevented from setting. When LBKDE is set, see .
 * Overrun operation LBKDE must be cleared when C7816[ISO7816E] is set.
 *
 * Values:
 * - 0 - Break character detection is disabled.
 * - 1 - Break character is detected at length of 11 bit times if C1[M] = 0 or
 *     12 bits time if C1[M] = 1.
 */
/*@{*/
#define BP_UART_S2_LBKDE     (1U)          /*!< Bit position for UART_S2_LBKDE. */
#define BM_UART_S2_LBKDE     (0x02U)       /*!< Bit mask for UART_S2_LBKDE. */
#define BS_UART_S2_LBKDE     (1U)          /*!< Bit field size in bits for UART_S2_LBKDE. */

/*! @brief Read current value of the UART_S2_LBKDE field. */
#define BR_UART_S2_LBKDE(x)  (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_LBKDE))

/*! @brief Format value for bitfield UART_S2_LBKDE. */
#define BF_UART_S2_LBKDE(v)  ((uint8_t)((uint8_t)(v) << BP_UART_S2_LBKDE) & BM_UART_S2_LBKDE)

/*! @brief Set the LBKDE field to a new value. */
#define BW_UART_S2_LBKDE(x, v) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_LBKDE) = (v))
/*@}*/

/*!
 * @name Register UART_S2, field BRK13[2] (RW)
 *
 * Determines whether the transmit break character is 10, 11, or 12 bits long,
 * or 13 or 14 bits long. See for the length of the break character for the
 * different configurations. The detection of a framing error is not affected by this
 * field. Transmitting break characters
 *
 * Values:
 * - 0 - Break character is 10, 11, or 12 bits long.
 * - 1 - Break character is 13 or 14 bits long.
 */
/*@{*/
#define BP_UART_S2_BRK13     (2U)          /*!< Bit position for UART_S2_BRK13. */
#define BM_UART_S2_BRK13     (0x04U)       /*!< Bit mask for UART_S2_BRK13. */
#define BS_UART_S2_BRK13     (1U)          /*!< Bit field size in bits for UART_S2_BRK13. */

/*! @brief Read current value of the UART_S2_BRK13 field. */
#define BR_UART_S2_BRK13(x)  (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_BRK13))

/*! @brief Format value for bitfield UART_S2_BRK13. */
#define BF_UART_S2_BRK13(v)  ((uint8_t)((uint8_t)(v) << BP_UART_S2_BRK13) & BM_UART_S2_BRK13)

/*! @brief Set the BRK13 field to a new value. */
#define BW_UART_S2_BRK13(x, v) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_BRK13) = (v))
/*@}*/

/*!
 * @name Register UART_S2, field RWUID[3] (RW)
 *
 * When RWU is set and WAKE is cleared, this field controls whether the idle
 * character that wakes the receiver sets S1[IDLE]. This field must be cleared when
 * C7816[ISO7816E] is set/enabled.
 *
 * Values:
 * - 0 - S1[IDLE] is not set upon detection of an idle character.
 * - 1 - S1[IDLE] is set upon detection of an idle character.
 */
/*@{*/
#define BP_UART_S2_RWUID     (3U)          /*!< Bit position for UART_S2_RWUID. */
#define BM_UART_S2_RWUID     (0x08U)       /*!< Bit mask for UART_S2_RWUID. */
#define BS_UART_S2_RWUID     (1U)          /*!< Bit field size in bits for UART_S2_RWUID. */

/*! @brief Read current value of the UART_S2_RWUID field. */
#define BR_UART_S2_RWUID(x)  (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_RWUID))

/*! @brief Format value for bitfield UART_S2_RWUID. */
#define BF_UART_S2_RWUID(v)  ((uint8_t)((uint8_t)(v) << BP_UART_S2_RWUID) & BM_UART_S2_RWUID)

/*! @brief Set the RWUID field to a new value. */
#define BW_UART_S2_RWUID(x, v) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_RWUID) = (v))
/*@}*/

/*!
 * @name Register UART_S2, field RXINV[4] (RW)
 *
 * Setting this field reverses the polarity of the received data input. In NRZ
 * format, a one is represented by a mark and a zero is represented by a space for
 * normal polarity, and the opposite for inverted polarity. In IrDA format, a
 * zero is represented by short high pulse in the middle of a bit time remaining
 * idle low for a one for normal polarity. A zero is represented by a short low
 * pulse in the middle of a bit time remaining idle high for a one for inverted
 * polarity. This field is automatically set when C7816[INIT] and C7816[ISO7816E] are
 * enabled and an initial character is detected in T = 0 protocol mode. Setting
 * RXINV inverts the RxD input for data bits, start and stop bits, break, and
 * idle. When C7816[ISO7816E] is set/enabled, only the data bits and the parity bit
 * are inverted.
 *
 * Values:
 * - 0 - Receive data is not inverted.
 * - 1 - Receive data is inverted.
 */
/*@{*/
#define BP_UART_S2_RXINV     (4U)          /*!< Bit position for UART_S2_RXINV. */
#define BM_UART_S2_RXINV     (0x10U)       /*!< Bit mask for UART_S2_RXINV. */
#define BS_UART_S2_RXINV     (1U)          /*!< Bit field size in bits for UART_S2_RXINV. */

/*! @brief Read current value of the UART_S2_RXINV field. */
#define BR_UART_S2_RXINV(x)  (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_RXINV))

/*! @brief Format value for bitfield UART_S2_RXINV. */
#define BF_UART_S2_RXINV(v)  ((uint8_t)((uint8_t)(v) << BP_UART_S2_RXINV) & BM_UART_S2_RXINV)

/*! @brief Set the RXINV field to a new value. */
#define BW_UART_S2_RXINV(x, v) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_RXINV) = (v))
/*@}*/

/*!
 * @name Register UART_S2, field MSBF[5] (RW)
 *
 * Setting this field reverses the order of the bits that are transmitted and
 * received on the wire. This field does not affect the polarity of the bits, the
 * location of the parity bit, or the location of the start or stop bits. This
 * field is automatically set when C7816[INIT] and C7816[ISO7816E] are enabled and
 * an initial character is detected in T = 0 protocol mode.
 *
 * Values:
 * - 0 - LSB (bit0) is the first bit that is transmitted following the start
 *     bit. Further, the first bit received after the start bit is identified as
 *     bit0.
 * - 1 - MSB (bit8, bit7 or bit6) is the first bit that is transmitted following
 *     the start bit, depending on the setting of C1[M] and C1[PE]. Further, the
 *     first bit received after the start bit is identified as bit8, bit7, or
 *     bit6, depending on the setting of C1[M] and C1[PE].
 */
/*@{*/
#define BP_UART_S2_MSBF      (5U)          /*!< Bit position for UART_S2_MSBF. */
#define BM_UART_S2_MSBF      (0x20U)       /*!< Bit mask for UART_S2_MSBF. */
#define BS_UART_S2_MSBF      (1U)          /*!< Bit field size in bits for UART_S2_MSBF. */

/*! @brief Read current value of the UART_S2_MSBF field. */
#define BR_UART_S2_MSBF(x)   (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_MSBF))

/*! @brief Format value for bitfield UART_S2_MSBF. */
#define BF_UART_S2_MSBF(v)   ((uint8_t)((uint8_t)(v) << BP_UART_S2_MSBF) & BM_UART_S2_MSBF)

/*! @brief Set the MSBF field to a new value. */
#define BW_UART_S2_MSBF(x, v) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_MSBF) = (v))
/*@}*/

/*!
 * @name Register UART_S2, field RXEDGIF[6] (W1C)
 *
 * RXEDGIF is set when an active edge occurs on the RxD pin. The active edge is
 * falling if RXINV = 0, and rising if RXINV=1. RXEDGIF is cleared by writing a 1
 * to it. See for additional details. RXEDGIF description The active edge is
 * detected only in two wire mode and on receiving data coming from the RxD pin.
 *
 * Values:
 * - 0 - No active edge on the receive pin has occurred.
 * - 1 - An active edge on the receive pin has occurred.
 */
/*@{*/
#define BP_UART_S2_RXEDGIF   (6U)          /*!< Bit position for UART_S2_RXEDGIF. */
#define BM_UART_S2_RXEDGIF   (0x40U)       /*!< Bit mask for UART_S2_RXEDGIF. */
#define BS_UART_S2_RXEDGIF   (1U)          /*!< Bit field size in bits for UART_S2_RXEDGIF. */

/*! @brief Read current value of the UART_S2_RXEDGIF field. */
#define BR_UART_S2_RXEDGIF(x) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_RXEDGIF))

/*! @brief Format value for bitfield UART_S2_RXEDGIF. */
#define BF_UART_S2_RXEDGIF(v) ((uint8_t)((uint8_t)(v) << BP_UART_S2_RXEDGIF) & BM_UART_S2_RXEDGIF)

/*! @brief Set the RXEDGIF field to a new value. */
#define BW_UART_S2_RXEDGIF(x, v) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_RXEDGIF) = (v))
/*@}*/

/*!
 * @name Register UART_S2, field LBKDIF[7] (W1C)
 *
 * LBKDIF is set when LBKDE is set and a LIN break character is detected on the
 * receiver input. The LIN break characters are 11 consecutive logic 0s if C1[M]
 * = 0 or 12 consecutive logic 0s if C1[M] = 1. LBKDIF is set after receiving the
 * last LIN break character. LBKDIF is cleared by writing a 1 to it.
 *
 * Values:
 * - 0 - No LIN break character detected.
 * - 1 - LIN break character detected.
 */
/*@{*/
#define BP_UART_S2_LBKDIF    (7U)          /*!< Bit position for UART_S2_LBKDIF. */
#define BM_UART_S2_LBKDIF    (0x80U)       /*!< Bit mask for UART_S2_LBKDIF. */
#define BS_UART_S2_LBKDIF    (1U)          /*!< Bit field size in bits for UART_S2_LBKDIF. */

/*! @brief Read current value of the UART_S2_LBKDIF field. */
#define BR_UART_S2_LBKDIF(x) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_LBKDIF))

/*! @brief Format value for bitfield UART_S2_LBKDIF. */
#define BF_UART_S2_LBKDIF(v) ((uint8_t)((uint8_t)(v) << BP_UART_S2_LBKDIF) & BM_UART_S2_LBKDIF)

/*! @brief Set the LBKDIF field to a new value. */
#define BW_UART_S2_LBKDIF(x, v) (BITBAND_ACCESS8(HW_UART_S2_ADDR(x), BP_UART_S2_LBKDIF) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_C3 - UART Control Register 3
 ******************************************************************************/

/*!
 * @brief HW_UART_C3 - UART Control Register 3 (RW)
 *
 * Reset value: 0x00U
 *
 * Writing R8 does not have any effect. TXDIR and TXINV can be changed only
 * between transmit and receive packets.
 */
typedef union _hw_uart_c3
{
    uint8_t U;
    struct _hw_uart_c3_bitfields
    {
        uint8_t PEIE : 1;              /*!< [0] Parity Error Interrupt Enable */
        uint8_t FEIE : 1;              /*!< [1] Framing Error Interrupt Enable */
        uint8_t NEIE : 1;              /*!< [2] Noise Error Interrupt Enable */
        uint8_t ORIE : 1;              /*!< [3] Overrun Error Interrupt Enable */
        uint8_t TXINV : 1;             /*!< [4] Transmit Data Inversion. */
        uint8_t TXDIR : 1;             /*!< [5] Transmitter Pin Data Direction in
                                        * Single-Wire mode */
        uint8_t T8 : 1;                /*!< [6] Transmit Bit 8 */
        uint8_t R8 : 1;                /*!< [7] Received Bit 8 */
    } B;
} hw_uart_c3_t;

/*!
 * @name Constants and macros for entire UART_C3 register
 */
/*@{*/
#define HW_UART_C3_ADDR(x)       ((x) + 0x6U)

#define HW_UART_C3(x)            (*(__IO hw_uart_c3_t *) HW_UART_C3_ADDR(x))
#define HW_UART_C3_RD(x)         (HW_UART_C3(x).U)
#define HW_UART_C3_WR(x, v)      (HW_UART_C3(x).U = (v))
#define HW_UART_C3_SET(x, v)     (HW_UART_C3_WR(x, HW_UART_C3_RD(x) |  (v)))
#define HW_UART_C3_CLR(x, v)     (HW_UART_C3_WR(x, HW_UART_C3_RD(x) & ~(v)))
#define HW_UART_C3_TOG(x, v)     (HW_UART_C3_WR(x, HW_UART_C3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_C3 bitfields
 */

/*!
 * @name Register UART_C3, field PEIE[0] (RW)
 *
 * Enables the parity error flag, S1[PF], to generate interrupt requests.
 *
 * Values:
 * - 0 - PF interrupt requests are disabled.
 * - 1 - PF interrupt requests are enabled.
 */
/*@{*/
#define BP_UART_C3_PEIE      (0U)          /*!< Bit position for UART_C3_PEIE. */
#define BM_UART_C3_PEIE      (0x01U)       /*!< Bit mask for UART_C3_PEIE. */
#define BS_UART_C3_PEIE      (1U)          /*!< Bit field size in bits for UART_C3_PEIE. */

/*! @brief Read current value of the UART_C3_PEIE field. */
#define BR_UART_C3_PEIE(x)   (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_PEIE))

/*! @brief Format value for bitfield UART_C3_PEIE. */
#define BF_UART_C3_PEIE(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C3_PEIE) & BM_UART_C3_PEIE)

/*! @brief Set the PEIE field to a new value. */
#define BW_UART_C3_PEIE(x, v) (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_PEIE) = (v))
/*@}*/

/*!
 * @name Register UART_C3, field FEIE[1] (RW)
 *
 * Enables the framing error flag, S1[FE], to generate interrupt requests.
 *
 * Values:
 * - 0 - FE interrupt requests are disabled.
 * - 1 - FE interrupt requests are enabled.
 */
/*@{*/
#define BP_UART_C3_FEIE      (1U)          /*!< Bit position for UART_C3_FEIE. */
#define BM_UART_C3_FEIE      (0x02U)       /*!< Bit mask for UART_C3_FEIE. */
#define BS_UART_C3_FEIE      (1U)          /*!< Bit field size in bits for UART_C3_FEIE. */

/*! @brief Read current value of the UART_C3_FEIE field. */
#define BR_UART_C3_FEIE(x)   (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_FEIE))

/*! @brief Format value for bitfield UART_C3_FEIE. */
#define BF_UART_C3_FEIE(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C3_FEIE) & BM_UART_C3_FEIE)

/*! @brief Set the FEIE field to a new value. */
#define BW_UART_C3_FEIE(x, v) (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_FEIE) = (v))
/*@}*/

/*!
 * @name Register UART_C3, field NEIE[2] (RW)
 *
 * Enables the noise flag, S1[NF], to generate interrupt requests.
 *
 * Values:
 * - 0 - NF interrupt requests are disabled.
 * - 1 - NF interrupt requests are enabled.
 */
/*@{*/
#define BP_UART_C3_NEIE      (2U)          /*!< Bit position for UART_C3_NEIE. */
#define BM_UART_C3_NEIE      (0x04U)       /*!< Bit mask for UART_C3_NEIE. */
#define BS_UART_C3_NEIE      (1U)          /*!< Bit field size in bits for UART_C3_NEIE. */

/*! @brief Read current value of the UART_C3_NEIE field. */
#define BR_UART_C3_NEIE(x)   (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_NEIE))

/*! @brief Format value for bitfield UART_C3_NEIE. */
#define BF_UART_C3_NEIE(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C3_NEIE) & BM_UART_C3_NEIE)

/*! @brief Set the NEIE field to a new value. */
#define BW_UART_C3_NEIE(x, v) (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_NEIE) = (v))
/*@}*/

/*!
 * @name Register UART_C3, field ORIE[3] (RW)
 *
 * Enables the overrun error flag, S1[OR], to generate interrupt requests.
 *
 * Values:
 * - 0 - OR interrupts are disabled.
 * - 1 - OR interrupt requests are enabled.
 */
/*@{*/
#define BP_UART_C3_ORIE      (3U)          /*!< Bit position for UART_C3_ORIE. */
#define BM_UART_C3_ORIE      (0x08U)       /*!< Bit mask for UART_C3_ORIE. */
#define BS_UART_C3_ORIE      (1U)          /*!< Bit field size in bits for UART_C3_ORIE. */

/*! @brief Read current value of the UART_C3_ORIE field. */
#define BR_UART_C3_ORIE(x)   (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_ORIE))

/*! @brief Format value for bitfield UART_C3_ORIE. */
#define BF_UART_C3_ORIE(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C3_ORIE) & BM_UART_C3_ORIE)

/*! @brief Set the ORIE field to a new value. */
#define BW_UART_C3_ORIE(x, v) (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_ORIE) = (v))
/*@}*/

/*!
 * @name Register UART_C3, field TXINV[4] (RW)
 *
 * Setting this field reverses the polarity of the transmitted data output. In
 * NRZ format, a one is represented by a mark and a zero is represented by a space
 * for normal polarity, and the opposite for inverted polarity. In IrDA format,
 * a zero is represented by short high pulse in the middle of a bit time
 * remaining idle low for a one for normal polarity, and a zero is represented by short
 * low pulse in the middle of a bit time remaining idle high for a one for
 * inverted polarity. This field is automatically set when C7816[INIT] and
 * C7816[ISO7816E] are enabled and an initial character is detected in T = 0 protocol mode.
 * Setting TXINV inverts all transmitted values, including idle, break, start, and
 * stop bits. In loop mode, if TXINV is set, the receiver gets the transmit
 * inversion bit when RXINV is disabled. When C7816[ISO7816E] is set/enabled then only
 * the transmitted data bits and parity bit are inverted.
 *
 * Values:
 * - 0 - Transmit data is not inverted.
 * - 1 - Transmit data is inverted.
 */
/*@{*/
#define BP_UART_C3_TXINV     (4U)          /*!< Bit position for UART_C3_TXINV. */
#define BM_UART_C3_TXINV     (0x10U)       /*!< Bit mask for UART_C3_TXINV. */
#define BS_UART_C3_TXINV     (1U)          /*!< Bit field size in bits for UART_C3_TXINV. */

/*! @brief Read current value of the UART_C3_TXINV field. */
#define BR_UART_C3_TXINV(x)  (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_TXINV))

/*! @brief Format value for bitfield UART_C3_TXINV. */
#define BF_UART_C3_TXINV(v)  ((uint8_t)((uint8_t)(v) << BP_UART_C3_TXINV) & BM_UART_C3_TXINV)

/*! @brief Set the TXINV field to a new value. */
#define BW_UART_C3_TXINV(x, v) (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_TXINV) = (v))
/*@}*/

/*!
 * @name Register UART_C3, field TXDIR[5] (RW)
 *
 * Determines whether the TXD pin is used as an input or output in the
 * single-wire mode of operation. This field is relevant only to the single wire mode.
 * When C7816[ISO7816E] is set/enabled and C7816[TTYPE] = 1, this field is
 * automatically cleared after the requested block is transmitted. This condition is
 * detected when TL7816[TLEN] = 0 and 4 additional characters are transmitted.
 * Additionally, if C7816[ISO7816E] is set/enabled and C7816[TTYPE] = 0 and a NACK is
 * being transmitted, the hardware automatically overrides this field as needed. In
 * this situation, TXDIR does not reflect the temporary state associated with
 * the NACK.
 *
 * Values:
 * - 0 - TXD pin is an input in single wire mode.
 * - 1 - TXD pin is an output in single wire mode.
 */
/*@{*/
#define BP_UART_C3_TXDIR     (5U)          /*!< Bit position for UART_C3_TXDIR. */
#define BM_UART_C3_TXDIR     (0x20U)       /*!< Bit mask for UART_C3_TXDIR. */
#define BS_UART_C3_TXDIR     (1U)          /*!< Bit field size in bits for UART_C3_TXDIR. */

/*! @brief Read current value of the UART_C3_TXDIR field. */
#define BR_UART_C3_TXDIR(x)  (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_TXDIR))

/*! @brief Format value for bitfield UART_C3_TXDIR. */
#define BF_UART_C3_TXDIR(v)  ((uint8_t)((uint8_t)(v) << BP_UART_C3_TXDIR) & BM_UART_C3_TXDIR)

/*! @brief Set the TXDIR field to a new value. */
#define BW_UART_C3_TXDIR(x, v) (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_TXDIR) = (v))
/*@}*/

/*!
 * @name Register UART_C3, field T8[6] (RW)
 *
 * T8 is the ninth data bit transmitted when the UART is configured for 9-bit
 * data format, that is, if C1[M] = 1 or C4[M10] = 1. If the value of T8 is the
 * same as in the previous transmission, T8 does not have to be rewritten. The same
 * value is transmitted until T8 is rewritten. To correctly transmit the 9th bit,
 * write UARTx_C3[T8] to the desired value, then write the UARTx_D register with
 * the remaining data.
 */
/*@{*/
#define BP_UART_C3_T8        (6U)          /*!< Bit position for UART_C3_T8. */
#define BM_UART_C3_T8        (0x40U)       /*!< Bit mask for UART_C3_T8. */
#define BS_UART_C3_T8        (1U)          /*!< Bit field size in bits for UART_C3_T8. */

/*! @brief Read current value of the UART_C3_T8 field. */
#define BR_UART_C3_T8(x)     (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_T8))

/*! @brief Format value for bitfield UART_C3_T8. */
#define BF_UART_C3_T8(v)     ((uint8_t)((uint8_t)(v) << BP_UART_C3_T8) & BM_UART_C3_T8)

/*! @brief Set the T8 field to a new value. */
#define BW_UART_C3_T8(x, v)  (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_T8) = (v))
/*@}*/

/*!
 * @name Register UART_C3, field R8[7] (RO)
 *
 * R8 is the ninth data bit received when the UART is configured for 9-bit data
 * format, that is, if C1[M] = 1 or C4[M10] = 1. The R8 value corresponds to the
 * current data value in the UARTx_D register. To read the 9th bit, read the
 * value of UARTx_C3[R8], then read the UARTx_D register.
 */
/*@{*/
#define BP_UART_C3_R8        (7U)          /*!< Bit position for UART_C3_R8. */
#define BM_UART_C3_R8        (0x80U)       /*!< Bit mask for UART_C3_R8. */
#define BS_UART_C3_R8        (1U)          /*!< Bit field size in bits for UART_C3_R8. */

/*! @brief Read current value of the UART_C3_R8 field. */
#define BR_UART_C3_R8(x)     (BITBAND_ACCESS8(HW_UART_C3_ADDR(x), BP_UART_C3_R8))
/*@}*/

/*******************************************************************************
 * HW_UART_D - UART Data Register
 ******************************************************************************/

/*!
 * @brief HW_UART_D - UART Data Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register is actually two separate registers. Reads return the contents
 * of the read-only receive data register and writes go to the write-only transmit
 * data register. In 8-bit or 9-bit data format, only UART data register (D)
 * needs to be accessed to clear the S1[RDRF] bit (assuming receiver buffer level is
 * less than RWFIFO[RXWATER]). The C3 register needs to be read, prior to the D
 * register, only if the ninth bit of data needs to be captured. Similarly, the
 * ED register needs to be read, prior to the D register, only if the additional
 * flag data for the dataword needs to be captured. In the normal 8-bit mode (M
 * bit cleared) if the parity is enabled, you get seven data bits and one parity
 * bit. That one parity bit is loaded into the D register. So, for the data bits,
 * mask off the parity bit from the value you read out of this register. When
 * transmitting in 9-bit data format and using 8-bit write instructions, write first
 * to transmit bit 8 in UART control register 3 (C3[T8]), then D. A write to
 * C3[T8] stores the data in a temporary register. If D register is written first,
 * and then the new data on data bus is stored in D, the temporary value written by
 * the last write to C3[T8] gets stored in the C3[T8] register.
 */
typedef union _hw_uart_d
{
    uint8_t U;
    struct _hw_uart_d_bitfields
    {
        uint8_t RT : 8;                /*!< [7:0]  */
    } B;
} hw_uart_d_t;

/*!
 * @name Constants and macros for entire UART_D register
 */
/*@{*/
#define HW_UART_D_ADDR(x)        ((x) + 0x7U)

#define HW_UART_D(x)             (*(__IO hw_uart_d_t *) HW_UART_D_ADDR(x))
#define HW_UART_D_RD(x)          (HW_UART_D(x).U)
#define HW_UART_D_WR(x, v)       (HW_UART_D(x).U = (v))
#define HW_UART_D_SET(x, v)      (HW_UART_D_WR(x, HW_UART_D_RD(x) |  (v)))
#define HW_UART_D_CLR(x, v)      (HW_UART_D_WR(x, HW_UART_D_RD(x) & ~(v)))
#define HW_UART_D_TOG(x, v)      (HW_UART_D_WR(x, HW_UART_D_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_D bitfields
 */

/*!
 * @name Register UART_D, field RT[7:0] (RW)
 *
 * Reads return the contents of the read-only receive data register and writes
 * go to the write-only transmit data register.
 */
/*@{*/
#define BP_UART_D_RT         (0U)          /*!< Bit position for UART_D_RT. */
#define BM_UART_D_RT         (0xFFU)       /*!< Bit mask for UART_D_RT. */
#define BS_UART_D_RT         (8U)          /*!< Bit field size in bits for UART_D_RT. */

/*! @brief Read current value of the UART_D_RT field. */
#define BR_UART_D_RT(x)      (HW_UART_D(x).U)

/*! @brief Format value for bitfield UART_D_RT. */
#define BF_UART_D_RT(v)      ((uint8_t)((uint8_t)(v) << BP_UART_D_RT) & BM_UART_D_RT)

/*! @brief Set the RT field to a new value. */
#define BW_UART_D_RT(x, v)   (HW_UART_D_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_UART_MA1 - UART Match Address Registers 1
 ******************************************************************************/

/*!
 * @brief HW_UART_MA1 - UART Match Address Registers 1 (RW)
 *
 * Reset value: 0x00U
 *
 * The MA1 and MA2 registers are compared to input data addresses when the most
 * significant bit is set and the associated C4[MAEN] field is set. If a match
 * occurs, the following data is transferred to the data register. If a match
 * fails, the following data is discarded. These registers can be read and written at
 * anytime.
 */
typedef union _hw_uart_ma1
{
    uint8_t U;
    struct _hw_uart_ma1_bitfields
    {
        uint8_t MA : 8;                /*!< [7:0] Match Address */
    } B;
} hw_uart_ma1_t;

/*!
 * @name Constants and macros for entire UART_MA1 register
 */
/*@{*/
#define HW_UART_MA1_ADDR(x)      ((x) + 0x8U)

#define HW_UART_MA1(x)           (*(__IO hw_uart_ma1_t *) HW_UART_MA1_ADDR(x))
#define HW_UART_MA1_RD(x)        (HW_UART_MA1(x).U)
#define HW_UART_MA1_WR(x, v)     (HW_UART_MA1(x).U = (v))
#define HW_UART_MA1_SET(x, v)    (HW_UART_MA1_WR(x, HW_UART_MA1_RD(x) |  (v)))
#define HW_UART_MA1_CLR(x, v)    (HW_UART_MA1_WR(x, HW_UART_MA1_RD(x) & ~(v)))
#define HW_UART_MA1_TOG(x, v)    (HW_UART_MA1_WR(x, HW_UART_MA1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_MA1 bitfields
 */

/*!
 * @name Register UART_MA1, field MA[7:0] (RW)
 */
/*@{*/
#define BP_UART_MA1_MA       (0U)          /*!< Bit position for UART_MA1_MA. */
#define BM_UART_MA1_MA       (0xFFU)       /*!< Bit mask for UART_MA1_MA. */
#define BS_UART_MA1_MA       (8U)          /*!< Bit field size in bits for UART_MA1_MA. */

/*! @brief Read current value of the UART_MA1_MA field. */
#define BR_UART_MA1_MA(x)    (HW_UART_MA1(x).U)

/*! @brief Format value for bitfield UART_MA1_MA. */
#define BF_UART_MA1_MA(v)    ((uint8_t)((uint8_t)(v) << BP_UART_MA1_MA) & BM_UART_MA1_MA)

/*! @brief Set the MA field to a new value. */
#define BW_UART_MA1_MA(x, v) (HW_UART_MA1_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_UART_MA2 - UART Match Address Registers 2
 ******************************************************************************/

/*!
 * @brief HW_UART_MA2 - UART Match Address Registers 2 (RW)
 *
 * Reset value: 0x00U
 *
 * These registers can be read and written at anytime. The MA1 and MA2 registers
 * are compared to input data addresses when the most significant bit is set and
 * the associated C4[MAEN] field is set. If a match occurs, the following data
 * is transferred to the data register. If a match fails, the following data is
 * discarded.
 */
typedef union _hw_uart_ma2
{
    uint8_t U;
    struct _hw_uart_ma2_bitfields
    {
        uint8_t MA : 8;                /*!< [7:0] Match Address */
    } B;
} hw_uart_ma2_t;

/*!
 * @name Constants and macros for entire UART_MA2 register
 */
/*@{*/
#define HW_UART_MA2_ADDR(x)      ((x) + 0x9U)

#define HW_UART_MA2(x)           (*(__IO hw_uart_ma2_t *) HW_UART_MA2_ADDR(x))
#define HW_UART_MA2_RD(x)        (HW_UART_MA2(x).U)
#define HW_UART_MA2_WR(x, v)     (HW_UART_MA2(x).U = (v))
#define HW_UART_MA2_SET(x, v)    (HW_UART_MA2_WR(x, HW_UART_MA2_RD(x) |  (v)))
#define HW_UART_MA2_CLR(x, v)    (HW_UART_MA2_WR(x, HW_UART_MA2_RD(x) & ~(v)))
#define HW_UART_MA2_TOG(x, v)    (HW_UART_MA2_WR(x, HW_UART_MA2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_MA2 bitfields
 */

/*!
 * @name Register UART_MA2, field MA[7:0] (RW)
 */
/*@{*/
#define BP_UART_MA2_MA       (0U)          /*!< Bit position for UART_MA2_MA. */
#define BM_UART_MA2_MA       (0xFFU)       /*!< Bit mask for UART_MA2_MA. */
#define BS_UART_MA2_MA       (8U)          /*!< Bit field size in bits for UART_MA2_MA. */

/*! @brief Read current value of the UART_MA2_MA field. */
#define BR_UART_MA2_MA(x)    (HW_UART_MA2(x).U)

/*! @brief Format value for bitfield UART_MA2_MA. */
#define BF_UART_MA2_MA(v)    ((uint8_t)((uint8_t)(v) << BP_UART_MA2_MA) & BM_UART_MA2_MA)

/*! @brief Set the MA field to a new value. */
#define BW_UART_MA2_MA(x, v) (HW_UART_MA2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_UART_C4 - UART Control Register 4
 ******************************************************************************/

/*!
 * @brief HW_UART_C4 - UART Control Register 4 (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_uart_c4
{
    uint8_t U;
    struct _hw_uart_c4_bitfields
    {
        uint8_t BRFA : 5;              /*!< [4:0] Baud Rate Fine Adjust */
        uint8_t M10 : 1;               /*!< [5] 10-bit Mode select */
        uint8_t MAEN2 : 1;             /*!< [6] Match Address Mode Enable 2 */
        uint8_t MAEN1 : 1;             /*!< [7] Match Address Mode Enable 1 */
    } B;
} hw_uart_c4_t;

/*!
 * @name Constants and macros for entire UART_C4 register
 */
/*@{*/
#define HW_UART_C4_ADDR(x)       ((x) + 0xAU)

#define HW_UART_C4(x)            (*(__IO hw_uart_c4_t *) HW_UART_C4_ADDR(x))
#define HW_UART_C4_RD(x)         (HW_UART_C4(x).U)
#define HW_UART_C4_WR(x, v)      (HW_UART_C4(x).U = (v))
#define HW_UART_C4_SET(x, v)     (HW_UART_C4_WR(x, HW_UART_C4_RD(x) |  (v)))
#define HW_UART_C4_CLR(x, v)     (HW_UART_C4_WR(x, HW_UART_C4_RD(x) & ~(v)))
#define HW_UART_C4_TOG(x, v)     (HW_UART_C4_WR(x, HW_UART_C4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_C4 bitfields
 */

/*!
 * @name Register UART_C4, field BRFA[4:0] (RW)
 *
 * This bit field is used to add more timing resolution to the average baud
 * frequency, in increments of 1/32. See Baud rate generation for more information.
 */
/*@{*/
#define BP_UART_C4_BRFA      (0U)          /*!< Bit position for UART_C4_BRFA. */
#define BM_UART_C4_BRFA      (0x1FU)       /*!< Bit mask for UART_C4_BRFA. */
#define BS_UART_C4_BRFA      (5U)          /*!< Bit field size in bits for UART_C4_BRFA. */

/*! @brief Read current value of the UART_C4_BRFA field. */
#define BR_UART_C4_BRFA(x)   (HW_UART_C4(x).B.BRFA)

/*! @brief Format value for bitfield UART_C4_BRFA. */
#define BF_UART_C4_BRFA(v)   ((uint8_t)((uint8_t)(v) << BP_UART_C4_BRFA) & BM_UART_C4_BRFA)

/*! @brief Set the BRFA field to a new value. */
#define BW_UART_C4_BRFA(x, v) (HW_UART_C4_WR(x, (HW_UART_C4_RD(x) & ~BM_UART_C4_BRFA) | BF_UART_C4_BRFA(v)))
/*@}*/

/*!
 * @name Register UART_C4, field M10[5] (RW)
 *
 * Causes a tenth, non-memory mapped bit to be part of the serial transmission.
 * This tenth bit is generated and interpreted as a parity bit. The M10 field
 * does not affect the LIN send or detect break behavior. If M10 is set, then both
 * C1[M] and C1[PE] must also be set. This field must be cleared when
 * C7816[ISO7816E] is set/enabled. See Data format (non ISO-7816) for more information.
 *
 * Values:
 * - 0 - The parity bit is the ninth bit in the serial transmission.
 * - 1 - The parity bit is the tenth bit in the serial transmission.
 */
/*@{*/
#define BP_UART_C4_M10       (5U)          /*!< Bit position for UART_C4_M10. */
#define BM_UART_C4_M10       (0x20U)       /*!< Bit mask for UART_C4_M10. */
#define BS_UART_C4_M10       (1U)          /*!< Bit field size in bits for UART_C4_M10. */

/*! @brief Read current value of the UART_C4_M10 field. */
#define BR_UART_C4_M10(x)    (BITBAND_ACCESS8(HW_UART_C4_ADDR(x), BP_UART_C4_M10))

/*! @brief Format value for bitfield UART_C4_M10. */
#define BF_UART_C4_M10(v)    ((uint8_t)((uint8_t)(v) << BP_UART_C4_M10) & BM_UART_C4_M10)

/*! @brief Set the M10 field to a new value. */
#define BW_UART_C4_M10(x, v) (BITBAND_ACCESS8(HW_UART_C4_ADDR(x), BP_UART_C4_M10) = (v))
/*@}*/

/*!
 * @name Register UART_C4, field MAEN2[6] (RW)
 *
 * See Match address operation for more information.
 *
 * Values:
 * - 0 - All data received is transferred to the data buffer if MAEN1 is cleared.
 * - 1 - All data received with the most significant bit cleared, is discarded.
 *     All data received with the most significant bit set, is compared with
 *     contents of MA2 register. If no match occurs, the data is discarded. If a
 *     match occurs, data is transferred to the data buffer. This field must be
 *     cleared when C7816[ISO7816E] is set/enabled.
 */
/*@{*/
#define BP_UART_C4_MAEN2     (6U)          /*!< Bit position for UART_C4_MAEN2. */
#define BM_UART_C4_MAEN2     (0x40U)       /*!< Bit mask for UART_C4_MAEN2. */
#define BS_UART_C4_MAEN2     (1U)          /*!< Bit field size in bits for UART_C4_MAEN2. */

/*! @brief Read current value of the UART_C4_MAEN2 field. */
#define BR_UART_C4_MAEN2(x)  (BITBAND_ACCESS8(HW_UART_C4_ADDR(x), BP_UART_C4_MAEN2))

/*! @brief Format value for bitfield UART_C4_MAEN2. */
#define BF_UART_C4_MAEN2(v)  ((uint8_t)((uint8_t)(v) << BP_UART_C4_MAEN2) & BM_UART_C4_MAEN2)

/*! @brief Set the MAEN2 field to a new value. */
#define BW_UART_C4_MAEN2(x, v) (BITBAND_ACCESS8(HW_UART_C4_ADDR(x), BP_UART_C4_MAEN2) = (v))
/*@}*/

/*!
 * @name Register UART_C4, field MAEN1[7] (RW)
 *
 * See Match address operation for more information.
 *
 * Values:
 * - 0 - All data received is transferred to the data buffer if MAEN2 is cleared.
 * - 1 - All data received with the most significant bit cleared, is discarded.
 *     All data received with the most significant bit set, is compared with
 *     contents of MA1 register. If no match occurs, the data is discarded. If match
 *     occurs, data is transferred to the data buffer. This field must be cleared
 *     when C7816[ISO7816E] is set/enabled.
 */
/*@{*/
#define BP_UART_C4_MAEN1     (7U)          /*!< Bit position for UART_C4_MAEN1. */
#define BM_UART_C4_MAEN1     (0x80U)       /*!< Bit mask for UART_C4_MAEN1. */
#define BS_UART_C4_MAEN1     (1U)          /*!< Bit field size in bits for UART_C4_MAEN1. */

/*! @brief Read current value of the UART_C4_MAEN1 field. */
#define BR_UART_C4_MAEN1(x)  (BITBAND_ACCESS8(HW_UART_C4_ADDR(x), BP_UART_C4_MAEN1))

/*! @brief Format value for bitfield UART_C4_MAEN1. */
#define BF_UART_C4_MAEN1(v)  ((uint8_t)((uint8_t)(v) << BP_UART_C4_MAEN1) & BM_UART_C4_MAEN1)

/*! @brief Set the MAEN1 field to a new value. */
#define BW_UART_C4_MAEN1(x, v) (BITBAND_ACCESS8(HW_UART_C4_ADDR(x), BP_UART_C4_MAEN1) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_C5 - UART Control Register 5
 ******************************************************************************/

/*!
 * @brief HW_UART_C5 - UART Control Register 5 (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_uart_c5
{
    uint8_t U;
    struct _hw_uart_c5_bitfields
    {
        uint8_t RESERVED0 : 3;         /*!< [2:0]  */
        uint8_t LBKDDMAS : 1;          /*!< [3] LIN Break Detect DMA Select Bit */
        uint8_t ILDMAS : 1;            /*!< [4] Idle Line DMA Select */
        uint8_t RDMAS : 1;             /*!< [5] Receiver Full DMA Select */
        uint8_t TCDMAS : 1;            /*!< [6] Transmission Complete DMA Select */
        uint8_t TDMAS : 1;             /*!< [7] Transmitter DMA Select */
    } B;
} hw_uart_c5_t;

/*!
 * @name Constants and macros for entire UART_C5 register
 */
/*@{*/
#define HW_UART_C5_ADDR(x)       ((x) + 0xBU)

#define HW_UART_C5(x)            (*(__IO hw_uart_c5_t *) HW_UART_C5_ADDR(x))
#define HW_UART_C5_RD(x)         (HW_UART_C5(x).U)
#define HW_UART_C5_WR(x, v)      (HW_UART_C5(x).U = (v))
#define HW_UART_C5_SET(x, v)     (HW_UART_C5_WR(x, HW_UART_C5_RD(x) |  (v)))
#define HW_UART_C5_CLR(x, v)     (HW_UART_C5_WR(x, HW_UART_C5_RD(x) & ~(v)))
#define HW_UART_C5_TOG(x, v)     (HW_UART_C5_WR(x, HW_UART_C5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_C5 bitfields
 */

/*!
 * @name Register UART_C5, field LBKDDMAS[3] (RW)
 *
 * Configures the LIN break detect flag, S2[LBKDIF], to generate interrupt or
 * DMA requests if BDH[LBKDIE] is set. If BDH[LBKDIE] is cleared, and S2[LBKDIF] is
 * set, the LBKDIF DMA and LBKDIF interrupt signals are not asserted, regardless
 * of the state of LBKDDMAS.
 *
 * Values:
 * - 0 - If BDH[LBKDIE] and S2[LBKDIF] are set, the LBKDIF interrupt signal is
 *     asserted to request an interrupt service.
 * - 1 - If BDH[LBKDIE] and S2[LBKDIF] are set, the LBKDIF DMA request signal is
 *     asserted to request a DMA transfer.
 */
/*@{*/
#define BP_UART_C5_LBKDDMAS  (3U)          /*!< Bit position for UART_C5_LBKDDMAS. */
#define BM_UART_C5_LBKDDMAS  (0x08U)       /*!< Bit mask for UART_C5_LBKDDMAS. */
#define BS_UART_C5_LBKDDMAS  (1U)          /*!< Bit field size in bits for UART_C5_LBKDDMAS. */

/*! @brief Read current value of the UART_C5_LBKDDMAS field. */
#define BR_UART_C5_LBKDDMAS(x) (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_LBKDDMAS))

/*! @brief Format value for bitfield UART_C5_LBKDDMAS. */
#define BF_UART_C5_LBKDDMAS(v) ((uint8_t)((uint8_t)(v) << BP_UART_C5_LBKDDMAS) & BM_UART_C5_LBKDDMAS)

/*! @brief Set the LBKDDMAS field to a new value. */
#define BW_UART_C5_LBKDDMAS(x, v) (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_LBKDDMAS) = (v))
/*@}*/

/*!
 * @name Register UART_C5, field ILDMAS[4] (RW)
 *
 * Configures the idle line flag, S1[IDLE], to generate interrupt or DMA
 * requests if C2[ILIE] is set. If C2[ILIE] is cleared, and S1[IDLE] is set, the IDLE
 * DMA and IDLE interrupt request signals are not asserted, regardless of the state
 * of ILDMAS.
 *
 * Values:
 * - 0 - If C2[ILIE] and S1[IDLE] are set, the IDLE interrupt request signal is
 *     asserted to request an interrupt service.
 * - 1 - If C2[ILIE] and S1[IDLE] are set, the IDLE DMA request signal is
 *     asserted to request a DMA transfer.
 */
/*@{*/
#define BP_UART_C5_ILDMAS    (4U)          /*!< Bit position for UART_C5_ILDMAS. */
#define BM_UART_C5_ILDMAS    (0x10U)       /*!< Bit mask for UART_C5_ILDMAS. */
#define BS_UART_C5_ILDMAS    (1U)          /*!< Bit field size in bits for UART_C5_ILDMAS. */

/*! @brief Read current value of the UART_C5_ILDMAS field. */
#define BR_UART_C5_ILDMAS(x) (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_ILDMAS))

/*! @brief Format value for bitfield UART_C5_ILDMAS. */
#define BF_UART_C5_ILDMAS(v) ((uint8_t)((uint8_t)(v) << BP_UART_C5_ILDMAS) & BM_UART_C5_ILDMAS)

/*! @brief Set the ILDMAS field to a new value. */
#define BW_UART_C5_ILDMAS(x, v) (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_ILDMAS) = (v))
/*@}*/

/*!
 * @name Register UART_C5, field RDMAS[5] (RW)
 *
 * Configures the receiver data register full flag, S1[RDRF], to generate
 * interrupt or DMA requests if C2[RIE] is set. If C2[RIE] is cleared, and S1[RDRF] is
 * set, the RDRF DMA and RDFR interrupt request signals are not asserted,
 * regardless of the state of RDMAS.
 *
 * Values:
 * - 0 - If C2[RIE] and S1[RDRF] are set, the RDFR interrupt request signal is
 *     asserted to request an interrupt service.
 * - 1 - If C2[RIE] and S1[RDRF] are set, the RDRF DMA request signal is
 *     asserted to request a DMA transfer.
 */
/*@{*/
#define BP_UART_C5_RDMAS     (5U)          /*!< Bit position for UART_C5_RDMAS. */
#define BM_UART_C5_RDMAS     (0x20U)       /*!< Bit mask for UART_C5_RDMAS. */
#define BS_UART_C5_RDMAS     (1U)          /*!< Bit field size in bits for UART_C5_RDMAS. */

/*! @brief Read current value of the UART_C5_RDMAS field. */
#define BR_UART_C5_RDMAS(x)  (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_RDMAS))

/*! @brief Format value for bitfield UART_C5_RDMAS. */
#define BF_UART_C5_RDMAS(v)  ((uint8_t)((uint8_t)(v) << BP_UART_C5_RDMAS) & BM_UART_C5_RDMAS)

/*! @brief Set the RDMAS field to a new value. */
#define BW_UART_C5_RDMAS(x, v) (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_RDMAS) = (v))
/*@}*/

/*!
 * @name Register UART_C5, field TCDMAS[6] (RW)
 *
 * Configures the transmission complete flag, S1[TC], to generate interrupt or
 * DMA requests if C2[TCIE] is set. If C2[TCIE] is cleared, the TC DMA and TC
 * interrupt request signals are not asserted when the S1[TC] flag is set, regardless
 * of the state of TCDMAS. If C2[TCIE] and TCDMAS are both set, then C2[TIE]
 * must be cleared, and D must not be written unless a DMA request is being serviced.
 *
 * Values:
 * - 0 - If C2[TCIE] is set and the S1[TC] flag is set, the TC interrupt request
 *     signal is asserted to request an interrupt service.
 * - 1 - If C2[TCIE] is set and the S1[TC] flag is set, the TC DMA request
 *     signal is asserted to request a DMA transfer.
 */
/*@{*/
#define BP_UART_C5_TCDMAS    (6U)          /*!< Bit position for UART_C5_TCDMAS. */
#define BM_UART_C5_TCDMAS    (0x40U)       /*!< Bit mask for UART_C5_TCDMAS. */
#define BS_UART_C5_TCDMAS    (1U)          /*!< Bit field size in bits for UART_C5_TCDMAS. */

/*! @brief Read current value of the UART_C5_TCDMAS field. */
#define BR_UART_C5_TCDMAS(x) (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_TCDMAS))

/*! @brief Format value for bitfield UART_C5_TCDMAS. */
#define BF_UART_C5_TCDMAS(v) ((uint8_t)((uint8_t)(v) << BP_UART_C5_TCDMAS) & BM_UART_C5_TCDMAS)

/*! @brief Set the TCDMAS field to a new value. */
#define BW_UART_C5_TCDMAS(x, v) (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_TCDMAS) = (v))
/*@}*/

/*!
 * @name Register UART_C5, field TDMAS[7] (RW)
 *
 * Configures the transmit data register empty flag, S1[TDRE], to generate
 * interrupt or DMA requests if C2[TIE] is set. If C2[TIE] is cleared, TDRE DMA and
 * TDRE interrupt request signals are not asserted when the TDRE flag is set,
 * regardless of the state of TDMAS. If C2[TIE] and TDMAS are both set, then C2[TCIE]
 * must be cleared, and D must not be written unless a DMA request is being
 * serviced.
 *
 * Values:
 * - 0 - If C2[TIE] is set and the S1[TDRE] flag is set, the TDRE interrupt
 *     request signal is asserted to request interrupt service.
 * - 1 - If C2[TIE] is set and the S1[TDRE] flag is set, the TDRE DMA request
 *     signal is asserted to request a DMA transfer.
 */
/*@{*/
#define BP_UART_C5_TDMAS     (7U)          /*!< Bit position for UART_C5_TDMAS. */
#define BM_UART_C5_TDMAS     (0x80U)       /*!< Bit mask for UART_C5_TDMAS. */
#define BS_UART_C5_TDMAS     (1U)          /*!< Bit field size in bits for UART_C5_TDMAS. */

/*! @brief Read current value of the UART_C5_TDMAS field. */
#define BR_UART_C5_TDMAS(x)  (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_TDMAS))

/*! @brief Format value for bitfield UART_C5_TDMAS. */
#define BF_UART_C5_TDMAS(v)  ((uint8_t)((uint8_t)(v) << BP_UART_C5_TDMAS) & BM_UART_C5_TDMAS)

/*! @brief Set the TDMAS field to a new value. */
#define BW_UART_C5_TDMAS(x, v) (BITBAND_ACCESS8(HW_UART_C5_ADDR(x), BP_UART_C5_TDMAS) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_ED - UART Extended Data Register
 ******************************************************************************/

/*!
 * @brief HW_UART_ED - UART Extended Data Register (RO)
 *
 * Reset value: 0x00U
 *
 * This register contains additional information flags that are stored with a
 * received dataword. This register may be read at any time but contains valid data
 * only if there is a dataword in the receive FIFO. The data contained in this
 * register represents additional information regarding the conditions on which a
 * dataword was received. The importance of this data varies with the
 * application, and in some cases maybe completely optional. These fields automatically
 * update to reflect the conditions of the next dataword whenever D is read. If
 * S1[NF] and S1[PF] have not been set since the last time the receive buffer was
 * empty, the NOISY and PARITYE fields will be zero.
 */
typedef union _hw_uart_ed
{
    uint8_t U;
    struct _hw_uart_ed_bitfields
    {
        uint8_t RESERVED0 : 6;         /*!< [5:0]  */
        uint8_t PARITYE : 1;           /*!< [6]  */
        uint8_t NOISY : 1;             /*!< [7]  */
    } B;
} hw_uart_ed_t;

/*!
 * @name Constants and macros for entire UART_ED register
 */
/*@{*/
#define HW_UART_ED_ADDR(x)       ((x) + 0xCU)

#define HW_UART_ED(x)            (*(__I hw_uart_ed_t *) HW_UART_ED_ADDR(x))
#define HW_UART_ED_RD(x)         (HW_UART_ED(x).U)
/*@}*/

/*
 * Constants & macros for individual UART_ED bitfields
 */

/*!
 * @name Register UART_ED, field PARITYE[6] (RO)
 *
 * The current received dataword contained in D and C3[R8] was received with a
 * parity error.
 *
 * Values:
 * - 0 - The dataword was received without a parity error.
 * - 1 - The dataword was received with a parity error.
 */
/*@{*/
#define BP_UART_ED_PARITYE   (6U)          /*!< Bit position for UART_ED_PARITYE. */
#define BM_UART_ED_PARITYE   (0x40U)       /*!< Bit mask for UART_ED_PARITYE. */
#define BS_UART_ED_PARITYE   (1U)          /*!< Bit field size in bits for UART_ED_PARITYE. */

/*! @brief Read current value of the UART_ED_PARITYE field. */
#define BR_UART_ED_PARITYE(x) (BITBAND_ACCESS8(HW_UART_ED_ADDR(x), BP_UART_ED_PARITYE))
/*@}*/

/*!
 * @name Register UART_ED, field NOISY[7] (RO)
 *
 * The current received dataword contained in D and C3[R8] was received with
 * noise.
 *
 * Values:
 * - 0 - The dataword was received without noise.
 * - 1 - The data was received with noise.
 */
/*@{*/
#define BP_UART_ED_NOISY     (7U)          /*!< Bit position for UART_ED_NOISY. */
#define BM_UART_ED_NOISY     (0x80U)       /*!< Bit mask for UART_ED_NOISY. */
#define BS_UART_ED_NOISY     (1U)          /*!< Bit field size in bits for UART_ED_NOISY. */

/*! @brief Read current value of the UART_ED_NOISY field. */
#define BR_UART_ED_NOISY(x)  (BITBAND_ACCESS8(HW_UART_ED_ADDR(x), BP_UART_ED_NOISY))
/*@}*/

/*******************************************************************************
 * HW_UART_MODEM - UART Modem Register
 ******************************************************************************/

/*!
 * @brief HW_UART_MODEM - UART Modem Register (RW)
 *
 * Reset value: 0x00U
 *
 * The MODEM register controls options for setting the modem configuration.
 * RXRTSE, TXRTSPOL, TXRTSE, and TXCTSE must all be cleared when C7816[ISO7816EN] is
 * enabled. This will cause the RTS to deassert during ISO-7816 wait times. The
 * ISO-7816 protocol does not use the RTS and CTS signals.
 */
typedef union _hw_uart_modem
{
    uint8_t U;
    struct _hw_uart_modem_bitfields
    {
        uint8_t TXCTSE : 1;            /*!< [0] Transmitter clear-to-send enable */
        uint8_t TXRTSE : 1;            /*!< [1] Transmitter request-to-send enable */
        uint8_t TXRTSPOL : 1;          /*!< [2] Transmitter request-to-send polarity */
        uint8_t RXRTSE : 1;            /*!< [3] Receiver request-to-send enable */
        uint8_t RESERVED0 : 4;         /*!< [7:4]  */
    } B;
} hw_uart_modem_t;

/*!
 * @name Constants and macros for entire UART_MODEM register
 */
/*@{*/
#define HW_UART_MODEM_ADDR(x)    ((x) + 0xDU)

#define HW_UART_MODEM(x)         (*(__IO hw_uart_modem_t *) HW_UART_MODEM_ADDR(x))
#define HW_UART_MODEM_RD(x)      (HW_UART_MODEM(x).U)
#define HW_UART_MODEM_WR(x, v)   (HW_UART_MODEM(x).U = (v))
#define HW_UART_MODEM_SET(x, v)  (HW_UART_MODEM_WR(x, HW_UART_MODEM_RD(x) |  (v)))
#define HW_UART_MODEM_CLR(x, v)  (HW_UART_MODEM_WR(x, HW_UART_MODEM_RD(x) & ~(v)))
#define HW_UART_MODEM_TOG(x, v)  (HW_UART_MODEM_WR(x, HW_UART_MODEM_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_MODEM bitfields
 */

/*!
 * @name Register UART_MODEM, field TXCTSE[0] (RW)
 *
 * TXCTSE controls the operation of the transmitter. TXCTSE can be set
 * independently from the state of TXRTSE and RXRTSE.
 *
 * Values:
 * - 0 - CTS has no effect on the transmitter.
 * - 1 - Enables clear-to-send operation. The transmitter checks the state of
 *     CTS each time it is ready to send a character. If CTS is asserted, the
 *     character is sent. If CTS is deasserted, the signal TXD remains in the mark
 *     state and transmission is delayed until CTS is asserted. Changes in CTS as a
 *     character is being sent do not affect its transmission.
 */
/*@{*/
#define BP_UART_MODEM_TXCTSE (0U)          /*!< Bit position for UART_MODEM_TXCTSE. */
#define BM_UART_MODEM_TXCTSE (0x01U)       /*!< Bit mask for UART_MODEM_TXCTSE. */
#define BS_UART_MODEM_TXCTSE (1U)          /*!< Bit field size in bits for UART_MODEM_TXCTSE. */

/*! @brief Read current value of the UART_MODEM_TXCTSE field. */
#define BR_UART_MODEM_TXCTSE(x) (BITBAND_ACCESS8(HW_UART_MODEM_ADDR(x), BP_UART_MODEM_TXCTSE))

/*! @brief Format value for bitfield UART_MODEM_TXCTSE. */
#define BF_UART_MODEM_TXCTSE(v) ((uint8_t)((uint8_t)(v) << BP_UART_MODEM_TXCTSE) & BM_UART_MODEM_TXCTSE)

/*! @brief Set the TXCTSE field to a new value. */
#define BW_UART_MODEM_TXCTSE(x, v) (BITBAND_ACCESS8(HW_UART_MODEM_ADDR(x), BP_UART_MODEM_TXCTSE) = (v))
/*@}*/

/*!
 * @name Register UART_MODEM, field TXRTSE[1] (RW)
 *
 * Controls RTS before and after a transmission.
 *
 * Values:
 * - 0 - The transmitter has no effect on RTS.
 * - 1 - When a character is placed into an empty transmitter data buffer , RTS
 *     asserts one bit time before the start bit is transmitted. RTS deasserts
 *     one bit time after all characters in the transmitter data buffer and shift
 *     register are completely sent, including the last stop bit. (FIFO) (FIFO)
 */
/*@{*/
#define BP_UART_MODEM_TXRTSE (1U)          /*!< Bit position for UART_MODEM_TXRTSE. */
#define BM_UART_MODEM_TXRTSE (0x02U)       /*!< Bit mask for UART_MODEM_TXRTSE. */
#define BS_UART_MODEM_TXRTSE (1U)          /*!< Bit field size in bits for UART_MODEM_TXRTSE. */

/*! @brief Read current value of the UART_MODEM_TXRTSE field. */
#define BR_UART_MODEM_TXRTSE(x) (BITBAND_ACCESS8(HW_UART_MODEM_ADDR(x), BP_UART_MODEM_TXRTSE))

/*! @brief Format value for bitfield UART_MODEM_TXRTSE. */
#define BF_UART_MODEM_TXRTSE(v) ((uint8_t)((uint8_t)(v) << BP_UART_MODEM_TXRTSE) & BM_UART_MODEM_TXRTSE)

/*! @brief Set the TXRTSE field to a new value. */
#define BW_UART_MODEM_TXRTSE(x, v) (BITBAND_ACCESS8(HW_UART_MODEM_ADDR(x), BP_UART_MODEM_TXRTSE) = (v))
/*@}*/

/*!
 * @name Register UART_MODEM, field TXRTSPOL[2] (RW)
 *
 * Controls the polarity of the transmitter RTS. TXRTSPOL does not affect the
 * polarity of the receiver RTS. RTS will remain negated in the active low state
 * unless TXRTSE is set.
 *
 * Values:
 * - 0 - Transmitter RTS is active low.
 * - 1 - Transmitter RTS is active high.
 */
/*@{*/
#define BP_UART_MODEM_TXRTSPOL (2U)        /*!< Bit position for UART_MODEM_TXRTSPOL. */
#define BM_UART_MODEM_TXRTSPOL (0x04U)     /*!< Bit mask for UART_MODEM_TXRTSPOL. */
#define BS_UART_MODEM_TXRTSPOL (1U)        /*!< Bit field size in bits for UART_MODEM_TXRTSPOL. */

/*! @brief Read current value of the UART_MODEM_TXRTSPOL field. */
#define BR_UART_MODEM_TXRTSPOL(x) (BITBAND_ACCESS8(HW_UART_MODEM_ADDR(x), BP_UART_MODEM_TXRTSPOL))

/*! @brief Format value for bitfield UART_MODEM_TXRTSPOL. */
#define BF_UART_MODEM_TXRTSPOL(v) ((uint8_t)((uint8_t)(v) << BP_UART_MODEM_TXRTSPOL) & BM_UART_MODEM_TXRTSPOL)

/*! @brief Set the TXRTSPOL field to a new value. */
#define BW_UART_MODEM_TXRTSPOL(x, v) (BITBAND_ACCESS8(HW_UART_MODEM_ADDR(x), BP_UART_MODEM_TXRTSPOL) = (v))
/*@}*/

/*!
 * @name Register UART_MODEM, field RXRTSE[3] (RW)
 *
 * Allows the RTS output to control the CTS input of the transmitting device to
 * prevent receiver overrun. Do not set both RXRTSE and TXRTSE.
 *
 * Values:
 * - 0 - The receiver has no effect on RTS.
 * - 1 - RTS is deasserted if the number of characters in the receiver data
 *     register (FIFO) is equal to or greater than RWFIFO[RXWATER]. RTS is asserted
 *     when the number of characters in the receiver data register (FIFO) is less
 *     than RWFIFO[RXWATER].
 */
/*@{*/
#define BP_UART_MODEM_RXRTSE (3U)          /*!< Bit position for UART_MODEM_RXRTSE. */
#define BM_UART_MODEM_RXRTSE (0x08U)       /*!< Bit mask for UART_MODEM_RXRTSE. */
#define BS_UART_MODEM_RXRTSE (1U)          /*!< Bit field size in bits for UART_MODEM_RXRTSE. */

/*! @brief Read current value of the UART_MODEM_RXRTSE field. */
#define BR_UART_MODEM_RXRTSE(x) (BITBAND_ACCESS8(HW_UART_MODEM_ADDR(x), BP_UART_MODEM_RXRTSE))

/*! @brief Format value for bitfield UART_MODEM_RXRTSE. */
#define BF_UART_MODEM_RXRTSE(v) ((uint8_t)((uint8_t)(v) << BP_UART_MODEM_RXRTSE) & BM_UART_MODEM_RXRTSE)

/*! @brief Set the RXRTSE field to a new value. */
#define BW_UART_MODEM_RXRTSE(x, v) (BITBAND_ACCESS8(HW_UART_MODEM_ADDR(x), BP_UART_MODEM_RXRTSE) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_IR - UART Infrared Register
 ******************************************************************************/

/*!
 * @brief HW_UART_IR - UART Infrared Register (RW)
 *
 * Reset value: 0x00U
 *
 * The IR register controls options for setting the infrared configuration.
 */
typedef union _hw_uart_ir
{
    uint8_t U;
    struct _hw_uart_ir_bitfields
    {
        uint8_t TNP : 2;               /*!< [1:0] Transmitter narrow pulse */
        uint8_t IREN : 1;              /*!< [2] Infrared enable */
        uint8_t RESERVED0 : 5;         /*!< [7:3]  */
    } B;
} hw_uart_ir_t;

/*!
 * @name Constants and macros for entire UART_IR register
 */
/*@{*/
#define HW_UART_IR_ADDR(x)       ((x) + 0xEU)

#define HW_UART_IR(x)            (*(__IO hw_uart_ir_t *) HW_UART_IR_ADDR(x))
#define HW_UART_IR_RD(x)         (HW_UART_IR(x).U)
#define HW_UART_IR_WR(x, v)      (HW_UART_IR(x).U = (v))
#define HW_UART_IR_SET(x, v)     (HW_UART_IR_WR(x, HW_UART_IR_RD(x) |  (v)))
#define HW_UART_IR_CLR(x, v)     (HW_UART_IR_WR(x, HW_UART_IR_RD(x) & ~(v)))
#define HW_UART_IR_TOG(x, v)     (HW_UART_IR_WR(x, HW_UART_IR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_IR bitfields
 */

/*!
 * @name Register UART_IR, field TNP[1:0] (RW)
 *
 * Enables whether the UART transmits a 1/16, 3/16, 1/32, or 1/4 narrow pulse.
 *
 * Values:
 * - 00 - 3/16.
 * - 01 - 1/16.
 * - 10 - 1/32.
 * - 11 - 1/4.
 */
/*@{*/
#define BP_UART_IR_TNP       (0U)          /*!< Bit position for UART_IR_TNP. */
#define BM_UART_IR_TNP       (0x03U)       /*!< Bit mask for UART_IR_TNP. */
#define BS_UART_IR_TNP       (2U)          /*!< Bit field size in bits for UART_IR_TNP. */

/*! @brief Read current value of the UART_IR_TNP field. */
#define BR_UART_IR_TNP(x)    (HW_UART_IR(x).B.TNP)

/*! @brief Format value for bitfield UART_IR_TNP. */
#define BF_UART_IR_TNP(v)    ((uint8_t)((uint8_t)(v) << BP_UART_IR_TNP) & BM_UART_IR_TNP)

/*! @brief Set the TNP field to a new value. */
#define BW_UART_IR_TNP(x, v) (HW_UART_IR_WR(x, (HW_UART_IR_RD(x) & ~BM_UART_IR_TNP) | BF_UART_IR_TNP(v)))
/*@}*/

/*!
 * @name Register UART_IR, field IREN[2] (RW)
 *
 * Enables/disables the infrared modulation/demodulation.
 *
 * Values:
 * - 0 - IR disabled.
 * - 1 - IR enabled.
 */
/*@{*/
#define BP_UART_IR_IREN      (2U)          /*!< Bit position for UART_IR_IREN. */
#define BM_UART_IR_IREN      (0x04U)       /*!< Bit mask for UART_IR_IREN. */
#define BS_UART_IR_IREN      (1U)          /*!< Bit field size in bits for UART_IR_IREN. */

/*! @brief Read current value of the UART_IR_IREN field. */
#define BR_UART_IR_IREN(x)   (BITBAND_ACCESS8(HW_UART_IR_ADDR(x), BP_UART_IR_IREN))

/*! @brief Format value for bitfield UART_IR_IREN. */
#define BF_UART_IR_IREN(v)   ((uint8_t)((uint8_t)(v) << BP_UART_IR_IREN) & BM_UART_IR_IREN)

/*! @brief Set the IREN field to a new value. */
#define BW_UART_IR_IREN(x, v) (BITBAND_ACCESS8(HW_UART_IR_ADDR(x), BP_UART_IR_IREN) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_PFIFO - UART FIFO Parameters
 ******************************************************************************/

/*!
 * @brief HW_UART_PFIFO - UART FIFO Parameters (RW)
 *
 * Reset value: 0x00U
 *
 * This register provides the ability for the programmer to turn on and off FIFO
 * functionality. It also provides the size of the FIFO that has been
 * implemented. This register may be read at any time. This register must be written only
 * when C2[RE] and C2[TE] are cleared/not set and when the data buffer/FIFO is
 * empty.
 */
typedef union _hw_uart_pfifo
{
    uint8_t U;
    struct _hw_uart_pfifo_bitfields
    {
        uint8_t RXFIFOSIZE : 3;        /*!< [2:0] Receive FIFO. Buffer Depth */
        uint8_t RXFE : 1;              /*!< [3] Receive FIFO Enable */
        uint8_t TXFIFOSIZE : 3;        /*!< [6:4] Transmit FIFO. Buffer Depth */
        uint8_t TXFE : 1;              /*!< [7] Transmit FIFO Enable */
    } B;
} hw_uart_pfifo_t;

/*!
 * @name Constants and macros for entire UART_PFIFO register
 */
/*@{*/
#define HW_UART_PFIFO_ADDR(x)    ((x) + 0x10U)

#define HW_UART_PFIFO(x)         (*(__IO hw_uart_pfifo_t *) HW_UART_PFIFO_ADDR(x))
#define HW_UART_PFIFO_RD(x)      (HW_UART_PFIFO(x).U)
#define HW_UART_PFIFO_WR(x, v)   (HW_UART_PFIFO(x).U = (v))
#define HW_UART_PFIFO_SET(x, v)  (HW_UART_PFIFO_WR(x, HW_UART_PFIFO_RD(x) |  (v)))
#define HW_UART_PFIFO_CLR(x, v)  (HW_UART_PFIFO_WR(x, HW_UART_PFIFO_RD(x) & ~(v)))
#define HW_UART_PFIFO_TOG(x, v)  (HW_UART_PFIFO_WR(x, HW_UART_PFIFO_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_PFIFO bitfields
 */

/*!
 * @name Register UART_PFIFO, field RXFIFOSIZE[2:0] (RO)
 *
 * The maximum number of receive datawords that can be stored in the receive
 * buffer before an overrun occurs. This field is read only.
 *
 * Values:
 * - 000 - Receive FIFO/Buffer depth = 1 dataword.
 * - 001 - Receive FIFO/Buffer depth = 4 datawords.
 * - 010 - Receive FIFO/Buffer depth = 8 datawords.
 * - 011 - Receive FIFO/Buffer depth = 16 datawords.
 * - 100 - Receive FIFO/Buffer depth = 32 datawords.
 * - 101 - Receive FIFO/Buffer depth = 64 datawords.
 * - 110 - Receive FIFO/Buffer depth = 128 datawords.
 * - 111 - Reserved.
 */
/*@{*/
#define BP_UART_PFIFO_RXFIFOSIZE (0U)      /*!< Bit position for UART_PFIFO_RXFIFOSIZE. */
#define BM_UART_PFIFO_RXFIFOSIZE (0x07U)   /*!< Bit mask for UART_PFIFO_RXFIFOSIZE. */
#define BS_UART_PFIFO_RXFIFOSIZE (3U)      /*!< Bit field size in bits for UART_PFIFO_RXFIFOSIZE. */

/*! @brief Read current value of the UART_PFIFO_RXFIFOSIZE field. */
#define BR_UART_PFIFO_RXFIFOSIZE(x) (HW_UART_PFIFO(x).B.RXFIFOSIZE)
/*@}*/

/*!
 * @name Register UART_PFIFO, field RXFE[3] (RW)
 *
 * When this field is set, the built in FIFO structure for the receive buffer is
 * enabled. The size of the FIFO structure is indicated by the RXFIFOSIZE field.
 * If this field is not set, the receive buffer operates as a FIFO of depth one
 * dataword regardless of the value in RXFIFOSIZE. Both C2[TE] and C2[RE] must be
 * cleared prior to changing this field. Additionally, TXFLUSH and RXFLUSH
 * commands must be issued immediately after changing this field.
 *
 * Values:
 * - 0 - Receive FIFO is not enabled. Buffer is depth 1. (Legacy support)
 * - 1 - Receive FIFO is enabled. Buffer is depth indicted by RXFIFOSIZE.
 */
/*@{*/
#define BP_UART_PFIFO_RXFE   (3U)          /*!< Bit position for UART_PFIFO_RXFE. */
#define BM_UART_PFIFO_RXFE   (0x08U)       /*!< Bit mask for UART_PFIFO_RXFE. */
#define BS_UART_PFIFO_RXFE   (1U)          /*!< Bit field size in bits for UART_PFIFO_RXFE. */

/*! @brief Read current value of the UART_PFIFO_RXFE field. */
#define BR_UART_PFIFO_RXFE(x) (BITBAND_ACCESS8(HW_UART_PFIFO_ADDR(x), BP_UART_PFIFO_RXFE))

/*! @brief Format value for bitfield UART_PFIFO_RXFE. */
#define BF_UART_PFIFO_RXFE(v) ((uint8_t)((uint8_t)(v) << BP_UART_PFIFO_RXFE) & BM_UART_PFIFO_RXFE)

/*! @brief Set the RXFE field to a new value. */
#define BW_UART_PFIFO_RXFE(x, v) (BITBAND_ACCESS8(HW_UART_PFIFO_ADDR(x), BP_UART_PFIFO_RXFE) = (v))
/*@}*/

/*!
 * @name Register UART_PFIFO, field TXFIFOSIZE[6:4] (RO)
 *
 * The maximum number of transmit datawords that can be stored in the transmit
 * buffer. This field is read only.
 *
 * Values:
 * - 000 - Transmit FIFO/Buffer depth = 1 dataword.
 * - 001 - Transmit FIFO/Buffer depth = 4 datawords.
 * - 010 - Transmit FIFO/Buffer depth = 8 datawords.
 * - 011 - Transmit FIFO/Buffer depth = 16 datawords.
 * - 100 - Transmit FIFO/Buffer depth = 32 datawords.
 * - 101 - Transmit FIFO/Buffer depth = 64 datawords.
 * - 110 - Transmit FIFO/Buffer depth = 128 datawords.
 * - 111 - Reserved.
 */
/*@{*/
#define BP_UART_PFIFO_TXFIFOSIZE (4U)      /*!< Bit position for UART_PFIFO_TXFIFOSIZE. */
#define BM_UART_PFIFO_TXFIFOSIZE (0x70U)   /*!< Bit mask for UART_PFIFO_TXFIFOSIZE. */
#define BS_UART_PFIFO_TXFIFOSIZE (3U)      /*!< Bit field size in bits for UART_PFIFO_TXFIFOSIZE. */

/*! @brief Read current value of the UART_PFIFO_TXFIFOSIZE field. */
#define BR_UART_PFIFO_TXFIFOSIZE(x) (HW_UART_PFIFO(x).B.TXFIFOSIZE)
/*@}*/

/*!
 * @name Register UART_PFIFO, field TXFE[7] (RW)
 *
 * When this field is set, the built in FIFO structure for the transmit buffer
 * is enabled. The size of the FIFO structure is indicated by TXFIFOSIZE. If this
 * field is not set, the transmit buffer operates as a FIFO of depth one dataword
 * regardless of the value in TXFIFOSIZE. Both C2[TE] and C2[RE] must be cleared
 * prior to changing this field. Additionally, TXFLUSH and RXFLUSH commands must
 * be issued immediately after changing this field.
 *
 * Values:
 * - 0 - Transmit FIFO is not enabled. Buffer is depth 1. (Legacy support).
 * - 1 - Transmit FIFO is enabled. Buffer is depth indicated by TXFIFOSIZE.
 */
/*@{*/
#define BP_UART_PFIFO_TXFE   (7U)          /*!< Bit position for UART_PFIFO_TXFE. */
#define BM_UART_PFIFO_TXFE   (0x80U)       /*!< Bit mask for UART_PFIFO_TXFE. */
#define BS_UART_PFIFO_TXFE   (1U)          /*!< Bit field size in bits for UART_PFIFO_TXFE. */

/*! @brief Read current value of the UART_PFIFO_TXFE field. */
#define BR_UART_PFIFO_TXFE(x) (BITBAND_ACCESS8(HW_UART_PFIFO_ADDR(x), BP_UART_PFIFO_TXFE))

/*! @brief Format value for bitfield UART_PFIFO_TXFE. */
#define BF_UART_PFIFO_TXFE(v) ((uint8_t)((uint8_t)(v) << BP_UART_PFIFO_TXFE) & BM_UART_PFIFO_TXFE)

/*! @brief Set the TXFE field to a new value. */
#define BW_UART_PFIFO_TXFE(x, v) (BITBAND_ACCESS8(HW_UART_PFIFO_ADDR(x), BP_UART_PFIFO_TXFE) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_CFIFO - UART FIFO Control Register
 ******************************************************************************/

/*!
 * @brief HW_UART_CFIFO - UART FIFO Control Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register provides the ability to program various control fields for FIFO
 * operation. This register may be read or written at any time. Note that
 * writing to TXFLUSH and RXFLUSH may result in data loss and requires careful action
 * to prevent unintended/unpredictable behavior. Therefore, it is recommended that
 * TE and RE be cleared prior to flushing the corresponding FIFO.
 */
typedef union _hw_uart_cfifo
{
    uint8_t U;
    struct _hw_uart_cfifo_bitfields
    {
        uint8_t RXUFE : 1;             /*!< [0] Receive FIFO Underflow Interrupt Enable */
        uint8_t TXOFE : 1;             /*!< [1] Transmit FIFO Overflow Interrupt Enable */
        uint8_t RXOFE : 1;             /*!< [2] Receive FIFO Overflow Interrupt Enable */
        uint8_t RESERVED0 : 3;         /*!< [5:3]  */
        uint8_t RXFLUSH : 1;           /*!< [6] Receive FIFO/Buffer Flush */
        uint8_t TXFLUSH : 1;           /*!< [7] Transmit FIFO/Buffer Flush */
    } B;
} hw_uart_cfifo_t;

/*!
 * @name Constants and macros for entire UART_CFIFO register
 */
/*@{*/
#define HW_UART_CFIFO_ADDR(x)    ((x) + 0x11U)

#define HW_UART_CFIFO(x)         (*(__IO hw_uart_cfifo_t *) HW_UART_CFIFO_ADDR(x))
#define HW_UART_CFIFO_RD(x)      (HW_UART_CFIFO(x).U)
#define HW_UART_CFIFO_WR(x, v)   (HW_UART_CFIFO(x).U = (v))
#define HW_UART_CFIFO_SET(x, v)  (HW_UART_CFIFO_WR(x, HW_UART_CFIFO_RD(x) |  (v)))
#define HW_UART_CFIFO_CLR(x, v)  (HW_UART_CFIFO_WR(x, HW_UART_CFIFO_RD(x) & ~(v)))
#define HW_UART_CFIFO_TOG(x, v)  (HW_UART_CFIFO_WR(x, HW_UART_CFIFO_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_CFIFO bitfields
 */

/*!
 * @name Register UART_CFIFO, field RXUFE[0] (RW)
 *
 * When this field is set, the RXUF flag generates an interrupt to the host.
 *
 * Values:
 * - 0 - RXUF flag does not generate an interrupt to the host.
 * - 1 - RXUF flag generates an interrupt to the host.
 */
/*@{*/
#define BP_UART_CFIFO_RXUFE  (0U)          /*!< Bit position for UART_CFIFO_RXUFE. */
#define BM_UART_CFIFO_RXUFE  (0x01U)       /*!< Bit mask for UART_CFIFO_RXUFE. */
#define BS_UART_CFIFO_RXUFE  (1U)          /*!< Bit field size in bits for UART_CFIFO_RXUFE. */

/*! @brief Read current value of the UART_CFIFO_RXUFE field. */
#define BR_UART_CFIFO_RXUFE(x) (BITBAND_ACCESS8(HW_UART_CFIFO_ADDR(x), BP_UART_CFIFO_RXUFE))

/*! @brief Format value for bitfield UART_CFIFO_RXUFE. */
#define BF_UART_CFIFO_RXUFE(v) ((uint8_t)((uint8_t)(v) << BP_UART_CFIFO_RXUFE) & BM_UART_CFIFO_RXUFE)

/*! @brief Set the RXUFE field to a new value. */
#define BW_UART_CFIFO_RXUFE(x, v) (BITBAND_ACCESS8(HW_UART_CFIFO_ADDR(x), BP_UART_CFIFO_RXUFE) = (v))
/*@}*/

/*!
 * @name Register UART_CFIFO, field TXOFE[1] (RW)
 *
 * When this field is set, the TXOF flag generates an interrupt to the host.
 *
 * Values:
 * - 0 - TXOF flag does not generate an interrupt to the host.
 * - 1 - TXOF flag generates an interrupt to the host.
 */
/*@{*/
#define BP_UART_CFIFO_TXOFE  (1U)          /*!< Bit position for UART_CFIFO_TXOFE. */
#define BM_UART_CFIFO_TXOFE  (0x02U)       /*!< Bit mask for UART_CFIFO_TXOFE. */
#define BS_UART_CFIFO_TXOFE  (1U)          /*!< Bit field size in bits for UART_CFIFO_TXOFE. */

/*! @brief Read current value of the UART_CFIFO_TXOFE field. */
#define BR_UART_CFIFO_TXOFE(x) (BITBAND_ACCESS8(HW_UART_CFIFO_ADDR(x), BP_UART_CFIFO_TXOFE))

/*! @brief Format value for bitfield UART_CFIFO_TXOFE. */
#define BF_UART_CFIFO_TXOFE(v) ((uint8_t)((uint8_t)(v) << BP_UART_CFIFO_TXOFE) & BM_UART_CFIFO_TXOFE)

/*! @brief Set the TXOFE field to a new value. */
#define BW_UART_CFIFO_TXOFE(x, v) (BITBAND_ACCESS8(HW_UART_CFIFO_ADDR(x), BP_UART_CFIFO_TXOFE) = (v))
/*@}*/

/*!
 * @name Register UART_CFIFO, field RXOFE[2] (RW)
 *
 * When this field is set, the RXOF flag generates an interrupt to the host.
 *
 * Values:
 * - 0 - RXOF flag does not generate an interrupt to the host.
 * - 1 - RXOF flag generates an interrupt to the host.
 */
/*@{*/
#define BP_UART_CFIFO_RXOFE  (2U)          /*!< Bit position for UART_CFIFO_RXOFE. */
#define BM_UART_CFIFO_RXOFE  (0x04U)       /*!< Bit mask for UART_CFIFO_RXOFE. */
#define BS_UART_CFIFO_RXOFE  (1U)          /*!< Bit field size in bits for UART_CFIFO_RXOFE. */

/*! @brief Read current value of the UART_CFIFO_RXOFE field. */
#define BR_UART_CFIFO_RXOFE(x) (BITBAND_ACCESS8(HW_UART_CFIFO_ADDR(x), BP_UART_CFIFO_RXOFE))

/*! @brief Format value for bitfield UART_CFIFO_RXOFE. */
#define BF_UART_CFIFO_RXOFE(v) ((uint8_t)((uint8_t)(v) << BP_UART_CFIFO_RXOFE) & BM_UART_CFIFO_RXOFE)

/*! @brief Set the RXOFE field to a new value. */
#define BW_UART_CFIFO_RXOFE(x, v) (BITBAND_ACCESS8(HW_UART_CFIFO_ADDR(x), BP_UART_CFIFO_RXOFE) = (v))
/*@}*/

/*!
 * @name Register UART_CFIFO, field RXFLUSH[6] (WORZ)
 *
 * Writing to this field causes all data that is stored in the receive
 * FIFO/buffer to be flushed. This does not affect data that is in the receive shift
 * register.
 *
 * Values:
 * - 0 - No flush operation occurs.
 * - 1 - All data in the receive FIFO/buffer is cleared out.
 */
/*@{*/
#define BP_UART_CFIFO_RXFLUSH (6U)         /*!< Bit position for UART_CFIFO_RXFLUSH. */
#define BM_UART_CFIFO_RXFLUSH (0x40U)      /*!< Bit mask for UART_CFIFO_RXFLUSH. */
#define BS_UART_CFIFO_RXFLUSH (1U)         /*!< Bit field size in bits for UART_CFIFO_RXFLUSH. */

/*! @brief Format value for bitfield UART_CFIFO_RXFLUSH. */
#define BF_UART_CFIFO_RXFLUSH(v) ((uint8_t)((uint8_t)(v) << BP_UART_CFIFO_RXFLUSH) & BM_UART_CFIFO_RXFLUSH)

/*! @brief Set the RXFLUSH field to a new value. */
#define BW_UART_CFIFO_RXFLUSH(x, v) (BITBAND_ACCESS8(HW_UART_CFIFO_ADDR(x), BP_UART_CFIFO_RXFLUSH) = (v))
/*@}*/

/*!
 * @name Register UART_CFIFO, field TXFLUSH[7] (WORZ)
 *
 * Writing to this field causes all data that is stored in the transmit
 * FIFO/buffer to be flushed. This does not affect data that is in the transmit shift
 * register.
 *
 * Values:
 * - 0 - No flush operation occurs.
 * - 1 - All data in the transmit FIFO/Buffer is cleared out.
 */
/*@{*/
#define BP_UART_CFIFO_TXFLUSH (7U)         /*!< Bit position for UART_CFIFO_TXFLUSH. */
#define BM_UART_CFIFO_TXFLUSH (0x80U)      /*!< Bit mask for UART_CFIFO_TXFLUSH. */
#define BS_UART_CFIFO_TXFLUSH (1U)         /*!< Bit field size in bits for UART_CFIFO_TXFLUSH. */

/*! @brief Format value for bitfield UART_CFIFO_TXFLUSH. */
#define BF_UART_CFIFO_TXFLUSH(v) ((uint8_t)((uint8_t)(v) << BP_UART_CFIFO_TXFLUSH) & BM_UART_CFIFO_TXFLUSH)

/*! @brief Set the TXFLUSH field to a new value. */
#define BW_UART_CFIFO_TXFLUSH(x, v) (BITBAND_ACCESS8(HW_UART_CFIFO_ADDR(x), BP_UART_CFIFO_TXFLUSH) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_SFIFO - UART FIFO Status Register
 ******************************************************************************/

/*!
 * @brief HW_UART_SFIFO - UART FIFO Status Register (RW)
 *
 * Reset value: 0xC0U
 *
 * This register provides status information regarding the transmit and receiver
 * buffers/FIFOs, including interrupt information. This register may be written
 * to or read at any time.
 */
typedef union _hw_uart_sfifo
{
    uint8_t U;
    struct _hw_uart_sfifo_bitfields
    {
        uint8_t RXUF : 1;              /*!< [0] Receiver Buffer Underflow Flag */
        uint8_t TXOF : 1;              /*!< [1] Transmitter Buffer Overflow Flag */
        uint8_t RXOF : 1;              /*!< [2] Receiver Buffer Overflow Flag */
        uint8_t RESERVED0 : 3;         /*!< [5:3]  */
        uint8_t RXEMPT : 1;            /*!< [6] Receive Buffer/FIFO Empty */
        uint8_t TXEMPT : 1;            /*!< [7] Transmit Buffer/FIFO Empty */
    } B;
} hw_uart_sfifo_t;

/*!
 * @name Constants and macros for entire UART_SFIFO register
 */
/*@{*/
#define HW_UART_SFIFO_ADDR(x)    ((x) + 0x12U)

#define HW_UART_SFIFO(x)         (*(__IO hw_uart_sfifo_t *) HW_UART_SFIFO_ADDR(x))
#define HW_UART_SFIFO_RD(x)      (HW_UART_SFIFO(x).U)
#define HW_UART_SFIFO_WR(x, v)   (HW_UART_SFIFO(x).U = (v))
#define HW_UART_SFIFO_SET(x, v)  (HW_UART_SFIFO_WR(x, HW_UART_SFIFO_RD(x) |  (v)))
#define HW_UART_SFIFO_CLR(x, v)  (HW_UART_SFIFO_WR(x, HW_UART_SFIFO_RD(x) & ~(v)))
#define HW_UART_SFIFO_TOG(x, v)  (HW_UART_SFIFO_WR(x, HW_UART_SFIFO_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_SFIFO bitfields
 */

/*!
 * @name Register UART_SFIFO, field RXUF[0] (W1C)
 *
 * Indicates that more data has been read from the receive buffer than was
 * present. This field will assert regardless of the value of CFIFO[RXUFE]. However,
 * an interrupt will be issued to the host only if CFIFO[RXUFE] is set. This flag
 * is cleared by writing a 1.
 *
 * Values:
 * - 0 - No receive buffer underflow has occurred since the last time the flag
 *     was cleared.
 * - 1 - At least one receive buffer underflow has occurred since the last time
 *     the flag was cleared.
 */
/*@{*/
#define BP_UART_SFIFO_RXUF   (0U)          /*!< Bit position for UART_SFIFO_RXUF. */
#define BM_UART_SFIFO_RXUF   (0x01U)       /*!< Bit mask for UART_SFIFO_RXUF. */
#define BS_UART_SFIFO_RXUF   (1U)          /*!< Bit field size in bits for UART_SFIFO_RXUF. */

/*! @brief Read current value of the UART_SFIFO_RXUF field. */
#define BR_UART_SFIFO_RXUF(x) (BITBAND_ACCESS8(HW_UART_SFIFO_ADDR(x), BP_UART_SFIFO_RXUF))

/*! @brief Format value for bitfield UART_SFIFO_RXUF. */
#define BF_UART_SFIFO_RXUF(v) ((uint8_t)((uint8_t)(v) << BP_UART_SFIFO_RXUF) & BM_UART_SFIFO_RXUF)

/*! @brief Set the RXUF field to a new value. */
#define BW_UART_SFIFO_RXUF(x, v) (BITBAND_ACCESS8(HW_UART_SFIFO_ADDR(x), BP_UART_SFIFO_RXUF) = (v))
/*@}*/

/*!
 * @name Register UART_SFIFO, field TXOF[1] (W1C)
 *
 * Indicates that more data has been written to the transmit buffer than it can
 * hold. This field will assert regardless of the value of CFIFO[TXOFE]. However,
 * an interrupt will be issued to the host only if CFIFO[TXOFE] is set. This
 * flag is cleared by writing a 1.
 *
 * Values:
 * - 0 - No transmit buffer overflow has occurred since the last time the flag
 *     was cleared.
 * - 1 - At least one transmit buffer overflow has occurred since the last time
 *     the flag was cleared.
 */
/*@{*/
#define BP_UART_SFIFO_TXOF   (1U)          /*!< Bit position for UART_SFIFO_TXOF. */
#define BM_UART_SFIFO_TXOF   (0x02U)       /*!< Bit mask for UART_SFIFO_TXOF. */
#define BS_UART_SFIFO_TXOF   (1U)          /*!< Bit field size in bits for UART_SFIFO_TXOF. */

/*! @brief Read current value of the UART_SFIFO_TXOF field. */
#define BR_UART_SFIFO_TXOF(x) (BITBAND_ACCESS8(HW_UART_SFIFO_ADDR(x), BP_UART_SFIFO_TXOF))

/*! @brief Format value for bitfield UART_SFIFO_TXOF. */
#define BF_UART_SFIFO_TXOF(v) ((uint8_t)((uint8_t)(v) << BP_UART_SFIFO_TXOF) & BM_UART_SFIFO_TXOF)

/*! @brief Set the TXOF field to a new value. */
#define BW_UART_SFIFO_TXOF(x, v) (BITBAND_ACCESS8(HW_UART_SFIFO_ADDR(x), BP_UART_SFIFO_TXOF) = (v))
/*@}*/

/*!
 * @name Register UART_SFIFO, field RXOF[2] (W1C)
 *
 * Indicates that more data has been written to the receive buffer than it can
 * hold. This field will assert regardless of the value of CFIFO[RXOFE]. However,
 * an interrupt will be issued to the host only if CFIFO[RXOFE] is set. This flag
 * is cleared by writing a 1.
 *
 * Values:
 * - 0 - No receive buffer overflow has occurred since the last time the flag
 *     was cleared.
 * - 1 - At least one receive buffer overflow has occurred since the last time
 *     the flag was cleared.
 */
/*@{*/
#define BP_UART_SFIFO_RXOF   (2U)          /*!< Bit position for UART_SFIFO_RXOF. */
#define BM_UART_SFIFO_RXOF   (0x04U)       /*!< Bit mask for UART_SFIFO_RXOF. */
#define BS_UART_SFIFO_RXOF   (1U)          /*!< Bit field size in bits for UART_SFIFO_RXOF. */

/*! @brief Read current value of the UART_SFIFO_RXOF field. */
#define BR_UART_SFIFO_RXOF(x) (BITBAND_ACCESS8(HW_UART_SFIFO_ADDR(x), BP_UART_SFIFO_RXOF))

/*! @brief Format value for bitfield UART_SFIFO_RXOF. */
#define BF_UART_SFIFO_RXOF(v) ((uint8_t)((uint8_t)(v) << BP_UART_SFIFO_RXOF) & BM_UART_SFIFO_RXOF)

/*! @brief Set the RXOF field to a new value. */
#define BW_UART_SFIFO_RXOF(x, v) (BITBAND_ACCESS8(HW_UART_SFIFO_ADDR(x), BP_UART_SFIFO_RXOF) = (v))
/*@}*/

/*!
 * @name Register UART_SFIFO, field RXEMPT[6] (RO)
 *
 * Asserts when there is no data in the receive FIFO/Buffer. This field does not
 * take into account data that is in the receive shift register.
 *
 * Values:
 * - 0 - Receive buffer is not empty.
 * - 1 - Receive buffer is empty.
 */
/*@{*/
#define BP_UART_SFIFO_RXEMPT (6U)          /*!< Bit position for UART_SFIFO_RXEMPT. */
#define BM_UART_SFIFO_RXEMPT (0x40U)       /*!< Bit mask for UART_SFIFO_RXEMPT. */
#define BS_UART_SFIFO_RXEMPT (1U)          /*!< Bit field size in bits for UART_SFIFO_RXEMPT. */

/*! @brief Read current value of the UART_SFIFO_RXEMPT field. */
#define BR_UART_SFIFO_RXEMPT(x) (BITBAND_ACCESS8(HW_UART_SFIFO_ADDR(x), BP_UART_SFIFO_RXEMPT))
/*@}*/

/*!
 * @name Register UART_SFIFO, field TXEMPT[7] (RO)
 *
 * Asserts when there is no data in the Transmit FIFO/buffer. This field does
 * not take into account data that is in the transmit shift register.
 *
 * Values:
 * - 0 - Transmit buffer is not empty.
 * - 1 - Transmit buffer is empty.
 */
/*@{*/
#define BP_UART_SFIFO_TXEMPT (7U)          /*!< Bit position for UART_SFIFO_TXEMPT. */
#define BM_UART_SFIFO_TXEMPT (0x80U)       /*!< Bit mask for UART_SFIFO_TXEMPT. */
#define BS_UART_SFIFO_TXEMPT (1U)          /*!< Bit field size in bits for UART_SFIFO_TXEMPT. */

/*! @brief Read current value of the UART_SFIFO_TXEMPT field. */
#define BR_UART_SFIFO_TXEMPT(x) (BITBAND_ACCESS8(HW_UART_SFIFO_ADDR(x), BP_UART_SFIFO_TXEMPT))
/*@}*/

/*******************************************************************************
 * HW_UART_TWFIFO - UART FIFO Transmit Watermark
 ******************************************************************************/

/*!
 * @brief HW_UART_TWFIFO - UART FIFO Transmit Watermark (RW)
 *
 * Reset value: 0x00U
 *
 * This register provides the ability to set a programmable threshold for
 * notification of needing additional transmit data. This register may be read at any
 * time but must be written only when C2[TE] is not set. Changing the value of the
 * watermark will not clear the S1[TDRE] flag.
 */
typedef union _hw_uart_twfifo
{
    uint8_t U;
    struct _hw_uart_twfifo_bitfields
    {
        uint8_t TXWATER : 8;           /*!< [7:0] Transmit Watermark */
    } B;
} hw_uart_twfifo_t;

/*!
 * @name Constants and macros for entire UART_TWFIFO register
 */
/*@{*/
#define HW_UART_TWFIFO_ADDR(x)   ((x) + 0x13U)

#define HW_UART_TWFIFO(x)        (*(__IO hw_uart_twfifo_t *) HW_UART_TWFIFO_ADDR(x))
#define HW_UART_TWFIFO_RD(x)     (HW_UART_TWFIFO(x).U)
#define HW_UART_TWFIFO_WR(x, v)  (HW_UART_TWFIFO(x).U = (v))
#define HW_UART_TWFIFO_SET(x, v) (HW_UART_TWFIFO_WR(x, HW_UART_TWFIFO_RD(x) |  (v)))
#define HW_UART_TWFIFO_CLR(x, v) (HW_UART_TWFIFO_WR(x, HW_UART_TWFIFO_RD(x) & ~(v)))
#define HW_UART_TWFIFO_TOG(x, v) (HW_UART_TWFIFO_WR(x, HW_UART_TWFIFO_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_TWFIFO bitfields
 */

/*!
 * @name Register UART_TWFIFO, field TXWATER[7:0] (RW)
 *
 * When the number of datawords in the transmit FIFO/buffer is equal to or less
 * than the value in this register field, an interrupt via S1[TDRE] or a DMA
 * request via C5[TDMAS] is generated as determined by C5[TDMAS] and C2[TIE]. For
 * proper operation, the value in TXWATER must be set to be less than the size of
 * the transmit buffer/FIFO size as indicated by PFIFO[TXFIFOSIZE] and PFIFO[TXFE].
 */
/*@{*/
#define BP_UART_TWFIFO_TXWATER (0U)        /*!< Bit position for UART_TWFIFO_TXWATER. */
#define BM_UART_TWFIFO_TXWATER (0xFFU)     /*!< Bit mask for UART_TWFIFO_TXWATER. */
#define BS_UART_TWFIFO_TXWATER (8U)        /*!< Bit field size in bits for UART_TWFIFO_TXWATER. */

/*! @brief Read current value of the UART_TWFIFO_TXWATER field. */
#define BR_UART_TWFIFO_TXWATER(x) (HW_UART_TWFIFO(x).U)

/*! @brief Format value for bitfield UART_TWFIFO_TXWATER. */
#define BF_UART_TWFIFO_TXWATER(v) ((uint8_t)((uint8_t)(v) << BP_UART_TWFIFO_TXWATER) & BM_UART_TWFIFO_TXWATER)

/*! @brief Set the TXWATER field to a new value. */
#define BW_UART_TWFIFO_TXWATER(x, v) (HW_UART_TWFIFO_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_UART_TCFIFO - UART FIFO Transmit Count
 ******************************************************************************/

/*!
 * @brief HW_UART_TCFIFO - UART FIFO Transmit Count (RO)
 *
 * Reset value: 0x00U
 *
 * This is a read only register that indicates how many datawords are currently
 * in the transmit buffer/FIFO. It may be read at any time.
 */
typedef union _hw_uart_tcfifo
{
    uint8_t U;
    struct _hw_uart_tcfifo_bitfields
    {
        uint8_t TXCOUNT : 8;           /*!< [7:0] Transmit Counter */
    } B;
} hw_uart_tcfifo_t;

/*!
 * @name Constants and macros for entire UART_TCFIFO register
 */
/*@{*/
#define HW_UART_TCFIFO_ADDR(x)   ((x) + 0x14U)

#define HW_UART_TCFIFO(x)        (*(__I hw_uart_tcfifo_t *) HW_UART_TCFIFO_ADDR(x))
#define HW_UART_TCFIFO_RD(x)     (HW_UART_TCFIFO(x).U)
/*@}*/

/*
 * Constants & macros for individual UART_TCFIFO bitfields
 */

/*!
 * @name Register UART_TCFIFO, field TXCOUNT[7:0] (RO)
 *
 * The value in this register indicates the number of datawords that are in the
 * transmit FIFO/buffer. If a dataword is being transmitted, that is, in the
 * transmit shift register, it is not included in the count. This value may be used
 * in conjunction with PFIFO[TXFIFOSIZE] to calculate how much room is left in the
 * transmit FIFO/buffer.
 */
/*@{*/
#define BP_UART_TCFIFO_TXCOUNT (0U)        /*!< Bit position for UART_TCFIFO_TXCOUNT. */
#define BM_UART_TCFIFO_TXCOUNT (0xFFU)     /*!< Bit mask for UART_TCFIFO_TXCOUNT. */
#define BS_UART_TCFIFO_TXCOUNT (8U)        /*!< Bit field size in bits for UART_TCFIFO_TXCOUNT. */

/*! @brief Read current value of the UART_TCFIFO_TXCOUNT field. */
#define BR_UART_TCFIFO_TXCOUNT(x) (HW_UART_TCFIFO(x).U)
/*@}*/

/*******************************************************************************
 * HW_UART_RWFIFO - UART FIFO Receive Watermark
 ******************************************************************************/

/*!
 * @brief HW_UART_RWFIFO - UART FIFO Receive Watermark (RW)
 *
 * Reset value: 0x01U
 *
 * This register provides the ability to set a programmable threshold for
 * notification of the need to remove data from the receiver FIFO/buffer. This register
 * may be read at any time but must be written only when C2[RE] is not asserted.
 * Changing the value in this register will not clear S1[RDRF].
 */
typedef union _hw_uart_rwfifo
{
    uint8_t U;
    struct _hw_uart_rwfifo_bitfields
    {
        uint8_t RXWATER : 8;           /*!< [7:0] Receive Watermark */
    } B;
} hw_uart_rwfifo_t;

/*!
 * @name Constants and macros for entire UART_RWFIFO register
 */
/*@{*/
#define HW_UART_RWFIFO_ADDR(x)   ((x) + 0x15U)

#define HW_UART_RWFIFO(x)        (*(__IO hw_uart_rwfifo_t *) HW_UART_RWFIFO_ADDR(x))
#define HW_UART_RWFIFO_RD(x)     (HW_UART_RWFIFO(x).U)
#define HW_UART_RWFIFO_WR(x, v)  (HW_UART_RWFIFO(x).U = (v))
#define HW_UART_RWFIFO_SET(x, v) (HW_UART_RWFIFO_WR(x, HW_UART_RWFIFO_RD(x) |  (v)))
#define HW_UART_RWFIFO_CLR(x, v) (HW_UART_RWFIFO_WR(x, HW_UART_RWFIFO_RD(x) & ~(v)))
#define HW_UART_RWFIFO_TOG(x, v) (HW_UART_RWFIFO_WR(x, HW_UART_RWFIFO_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_RWFIFO bitfields
 */

/*!
 * @name Register UART_RWFIFO, field RXWATER[7:0] (RW)
 *
 * When the number of datawords in the receive FIFO/buffer is equal to or
 * greater than the value in this register field, an interrupt via S1[RDRF] or a DMA
 * request via C5[RDMAS] is generated as determined by C5[RDMAS] and C2[RIE]. For
 * proper operation, the value in RXWATER must be set to be less than the receive
 * FIFO/buffer size as indicated by PFIFO[RXFIFOSIZE] and PFIFO[RXFE] and must be
 * greater than 0.
 */
/*@{*/
#define BP_UART_RWFIFO_RXWATER (0U)        /*!< Bit position for UART_RWFIFO_RXWATER. */
#define BM_UART_RWFIFO_RXWATER (0xFFU)     /*!< Bit mask for UART_RWFIFO_RXWATER. */
#define BS_UART_RWFIFO_RXWATER (8U)        /*!< Bit field size in bits for UART_RWFIFO_RXWATER. */

/*! @brief Read current value of the UART_RWFIFO_RXWATER field. */
#define BR_UART_RWFIFO_RXWATER(x) (HW_UART_RWFIFO(x).U)

/*! @brief Format value for bitfield UART_RWFIFO_RXWATER. */
#define BF_UART_RWFIFO_RXWATER(v) ((uint8_t)((uint8_t)(v) << BP_UART_RWFIFO_RXWATER) & BM_UART_RWFIFO_RXWATER)

/*! @brief Set the RXWATER field to a new value. */
#define BW_UART_RWFIFO_RXWATER(x, v) (HW_UART_RWFIFO_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_UART_RCFIFO - UART FIFO Receive Count
 ******************************************************************************/

/*!
 * @brief HW_UART_RCFIFO - UART FIFO Receive Count (RO)
 *
 * Reset value: 0x00U
 *
 * This is a read only register that indicates how many datawords are currently
 * in the receive FIFO/buffer. It may be read at any time.
 */
typedef union _hw_uart_rcfifo
{
    uint8_t U;
    struct _hw_uart_rcfifo_bitfields
    {
        uint8_t RXCOUNT : 8;           /*!< [7:0] Receive Counter */
    } B;
} hw_uart_rcfifo_t;

/*!
 * @name Constants and macros for entire UART_RCFIFO register
 */
/*@{*/
#define HW_UART_RCFIFO_ADDR(x)   ((x) + 0x16U)

#define HW_UART_RCFIFO(x)        (*(__I hw_uart_rcfifo_t *) HW_UART_RCFIFO_ADDR(x))
#define HW_UART_RCFIFO_RD(x)     (HW_UART_RCFIFO(x).U)
/*@}*/

/*
 * Constants & macros for individual UART_RCFIFO bitfields
 */

/*!
 * @name Register UART_RCFIFO, field RXCOUNT[7:0] (RO)
 *
 * The value in this register indicates the number of datawords that are in the
 * receive FIFO/buffer. If a dataword is being received, that is, in the receive
 * shift register, it is not included in the count. This value may be used in
 * conjunction with PFIFO[RXFIFOSIZE] to calculate how much room is left in the
 * receive FIFO/buffer.
 */
/*@{*/
#define BP_UART_RCFIFO_RXCOUNT (0U)        /*!< Bit position for UART_RCFIFO_RXCOUNT. */
#define BM_UART_RCFIFO_RXCOUNT (0xFFU)     /*!< Bit mask for UART_RCFIFO_RXCOUNT. */
#define BS_UART_RCFIFO_RXCOUNT (8U)        /*!< Bit field size in bits for UART_RCFIFO_RXCOUNT. */

/*! @brief Read current value of the UART_RCFIFO_RXCOUNT field. */
#define BR_UART_RCFIFO_RXCOUNT(x) (HW_UART_RCFIFO(x).U)
/*@}*/

/*******************************************************************************
 * HW_UART_C7816 - UART 7816 Control Register
 ******************************************************************************/

/*!
 * @brief HW_UART_C7816 - UART 7816 Control Register (RW)
 *
 * Reset value: 0x00U
 *
 * The C7816 register is the primary control register for ISO-7816 specific
 * functionality. This register is specific to 7816 functionality and the values in
 * this register have no effect on UART operation and should be ignored if
 * ISO_7816E is not set/enabled. This register may be read at any time but values must
 * be changed only when ISO_7816E is not set.
 */
typedef union _hw_uart_c7816
{
    uint8_t U;
    struct _hw_uart_c7816_bitfields
    {
        uint8_t ISO_7816E : 1;         /*!< [0] ISO-7816 Functionality Enabled */
        uint8_t TTYPE : 1;             /*!< [1] Transfer Type */
        uint8_t INIT : 1;              /*!< [2] Detect Initial Character */
        uint8_t ANACK : 1;             /*!< [3] Generate NACK on Error */
        uint8_t ONACK : 1;             /*!< [4] Generate NACK on Overflow */
        uint8_t RESERVED0 : 3;         /*!< [7:5]  */
    } B;
} hw_uart_c7816_t;

/*!
 * @name Constants and macros for entire UART_C7816 register
 */
/*@{*/
#define HW_UART_C7816_ADDR(x)    ((x) + 0x18U)

#define HW_UART_C7816(x)         (*(__IO hw_uart_c7816_t *) HW_UART_C7816_ADDR(x))
#define HW_UART_C7816_RD(x)      (HW_UART_C7816(x).U)
#define HW_UART_C7816_WR(x, v)   (HW_UART_C7816(x).U = (v))
#define HW_UART_C7816_SET(x, v)  (HW_UART_C7816_WR(x, HW_UART_C7816_RD(x) |  (v)))
#define HW_UART_C7816_CLR(x, v)  (HW_UART_C7816_WR(x, HW_UART_C7816_RD(x) & ~(v)))
#define HW_UART_C7816_TOG(x, v)  (HW_UART_C7816_WR(x, HW_UART_C7816_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_C7816 bitfields
 */

/*!
 * @name Register UART_C7816, field ISO_7816E[0] (RW)
 *
 * Indicates that the UART is operating according to the ISO-7816 protocol. This
 * field must be modified only when no transmit or receive is occurring. If this
 * field is changed during a data transfer, the data being transmitted or
 * received may be transferred incorrectly.
 *
 * Values:
 * - 0 - ISO-7816 functionality is turned off/not enabled.
 * - 1 - ISO-7816 functionality is turned on/enabled.
 */
/*@{*/
#define BP_UART_C7816_ISO_7816E (0U)       /*!< Bit position for UART_C7816_ISO_7816E. */
#define BM_UART_C7816_ISO_7816E (0x01U)    /*!< Bit mask for UART_C7816_ISO_7816E. */
#define BS_UART_C7816_ISO_7816E (1U)       /*!< Bit field size in bits for UART_C7816_ISO_7816E. */

/*! @brief Read current value of the UART_C7816_ISO_7816E field. */
#define BR_UART_C7816_ISO_7816E(x) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_ISO_7816E))

/*! @brief Format value for bitfield UART_C7816_ISO_7816E. */
#define BF_UART_C7816_ISO_7816E(v) ((uint8_t)((uint8_t)(v) << BP_UART_C7816_ISO_7816E) & BM_UART_C7816_ISO_7816E)

/*! @brief Set the ISO_7816E field to a new value. */
#define BW_UART_C7816_ISO_7816E(x, v) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_ISO_7816E) = (v))
/*@}*/

/*!
 * @name Register UART_C7816, field TTYPE[1] (RW)
 *
 * Indicates the transfer protocol being used. See ISO-7816 / smartcard support
 * for more details.
 *
 * Values:
 * - 0 - T = 0 per the ISO-7816 specification.
 * - 1 - T = 1 per the ISO-7816 specification.
 */
/*@{*/
#define BP_UART_C7816_TTYPE  (1U)          /*!< Bit position for UART_C7816_TTYPE. */
#define BM_UART_C7816_TTYPE  (0x02U)       /*!< Bit mask for UART_C7816_TTYPE. */
#define BS_UART_C7816_TTYPE  (1U)          /*!< Bit field size in bits for UART_C7816_TTYPE. */

/*! @brief Read current value of the UART_C7816_TTYPE field. */
#define BR_UART_C7816_TTYPE(x) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_TTYPE))

/*! @brief Format value for bitfield UART_C7816_TTYPE. */
#define BF_UART_C7816_TTYPE(v) ((uint8_t)((uint8_t)(v) << BP_UART_C7816_TTYPE) & BM_UART_C7816_TTYPE)

/*! @brief Set the TTYPE field to a new value. */
#define BW_UART_C7816_TTYPE(x, v) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_TTYPE) = (v))
/*@}*/

/*!
 * @name Register UART_C7816, field INIT[2] (RW)
 *
 * When this field is set, all received characters are searched for a valid
 * initial character. If an invalid initial character is identified, and ANACK is
 * set, a NACK is sent. All received data is discarded and error flags blocked
 * (S1[NF], S1[OR], S1[FE], S1[PF], IS7816[WT], IS7816[CWT], IS7816[BWT], IS7816[GTV])
 * until a valid initial character is detected. Upon detecting a valid initial
 * character, the configuration values S2[MSBF], C3[TXINV], and S2[RXINV] are
 * automatically updated to reflect the initial character that was received. The
 * actual INIT data value is not stored in the receive buffer. Additionally, upon
 * detection of a valid initial character, IS7816[INITD] is set and an interrupt
 * issued as programmed by IE7816[INITDE]. When a valid initial character is
 * detected, INIT is automatically cleared. This Initial Character Detect feature is
 * supported only in T = 0 protocol mode.
 *
 * Values:
 * - 0 - Normal operating mode. Receiver does not seek to identify initial
 *     character.
 * - 1 - Receiver searches for initial character.
 */
/*@{*/
#define BP_UART_C7816_INIT   (2U)          /*!< Bit position for UART_C7816_INIT. */
#define BM_UART_C7816_INIT   (0x04U)       /*!< Bit mask for UART_C7816_INIT. */
#define BS_UART_C7816_INIT   (1U)          /*!< Bit field size in bits for UART_C7816_INIT. */

/*! @brief Read current value of the UART_C7816_INIT field. */
#define BR_UART_C7816_INIT(x) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_INIT))

/*! @brief Format value for bitfield UART_C7816_INIT. */
#define BF_UART_C7816_INIT(v) ((uint8_t)((uint8_t)(v) << BP_UART_C7816_INIT) & BM_UART_C7816_INIT)

/*! @brief Set the INIT field to a new value. */
#define BW_UART_C7816_INIT(x, v) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_INIT) = (v))
/*@}*/

/*!
 * @name Register UART_C7816, field ANACK[3] (RW)
 *
 * When this field is set, the receiver automatically generates a NACK response
 * if a parity error occurs or if INIT is set and an invalid initial character is
 * detected. A NACK is generated only if TTYPE = 0. If ANACK is set, the UART
 * attempts to retransmit the data indefinitely. To stop retransmission attempts,
 * clear C2[TE] or ISO_7816E and do not set until S1[TC] sets C2[TE] again.
 *
 * Values:
 * - 0 - No NACK is automatically generated.
 * - 1 - A NACK is automatically generated if a parity error is detected or if
 *     an invalid initial character is detected.
 */
/*@{*/
#define BP_UART_C7816_ANACK  (3U)          /*!< Bit position for UART_C7816_ANACK. */
#define BM_UART_C7816_ANACK  (0x08U)       /*!< Bit mask for UART_C7816_ANACK. */
#define BS_UART_C7816_ANACK  (1U)          /*!< Bit field size in bits for UART_C7816_ANACK. */

/*! @brief Read current value of the UART_C7816_ANACK field. */
#define BR_UART_C7816_ANACK(x) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_ANACK))

/*! @brief Format value for bitfield UART_C7816_ANACK. */
#define BF_UART_C7816_ANACK(v) ((uint8_t)((uint8_t)(v) << BP_UART_C7816_ANACK) & BM_UART_C7816_ANACK)

/*! @brief Set the ANACK field to a new value. */
#define BW_UART_C7816_ANACK(x, v) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_ANACK) = (v))
/*@}*/

/*!
 * @name Register UART_C7816, field ONACK[4] (RW)
 *
 * When this field is set, the receiver automatically generates a NACK response
 * if a receive buffer overrun occurs, as indicated by S1[OR]. In many systems,
 * this results in the transmitter resending the packet that overflowed until the
 * retransmit threshold for that transmitter is reached. A NACK is generated only
 * if TTYPE=0. This field operates independently of ANACK. See . Overrun NACK
 * considerations
 *
 * Values:
 * - 0 - The received data does not generate a NACK when the receipt of the data
 *     results in an overflow event.
 * - 1 - If the receiver buffer overflows, a NACK is automatically sent on a
 *     received character.
 */
/*@{*/
#define BP_UART_C7816_ONACK  (4U)          /*!< Bit position for UART_C7816_ONACK. */
#define BM_UART_C7816_ONACK  (0x10U)       /*!< Bit mask for UART_C7816_ONACK. */
#define BS_UART_C7816_ONACK  (1U)          /*!< Bit field size in bits for UART_C7816_ONACK. */

/*! @brief Read current value of the UART_C7816_ONACK field. */
#define BR_UART_C7816_ONACK(x) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_ONACK))

/*! @brief Format value for bitfield UART_C7816_ONACK. */
#define BF_UART_C7816_ONACK(v) ((uint8_t)((uint8_t)(v) << BP_UART_C7816_ONACK) & BM_UART_C7816_ONACK)

/*! @brief Set the ONACK field to a new value. */
#define BW_UART_C7816_ONACK(x, v) (BITBAND_ACCESS8(HW_UART_C7816_ADDR(x), BP_UART_C7816_ONACK) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_IE7816 - UART 7816 Interrupt Enable Register
 ******************************************************************************/

/*!
 * @brief HW_UART_IE7816 - UART 7816 Interrupt Enable Register (RW)
 *
 * Reset value: 0x00U
 *
 * The IE7816 register controls which flags result in an interrupt being issued.
 * This register is specific to 7816 functionality, the corresponding flags that
 * drive the interrupts are not asserted when 7816E is not set/enabled. However,
 * these flags may remain set if they are asserted while 7816E was set and not
 * subsequently cleared. This register may be read or written to at any time.
 */
typedef union _hw_uart_ie7816
{
    uint8_t U;
    struct _hw_uart_ie7816_bitfields
    {
        uint8_t RXTE : 1;              /*!< [0] Receive Threshold Exceeded Interrupt
                                        * Enable */
        uint8_t TXTE : 1;              /*!< [1] Transmit Threshold Exceeded Interrupt
                                        * Enable */
        uint8_t GTVE : 1;              /*!< [2] Guard Timer Violated Interrupt Enable */
        uint8_t RESERVED0 : 1;         /*!< [3]  */
        uint8_t INITDE : 1;            /*!< [4] Initial Character Detected Interrupt
                                        * Enable */
        uint8_t BWTE : 1;              /*!< [5] Block Wait Timer Interrupt Enable */
        uint8_t CWTE : 1;              /*!< [6] Character Wait Timer Interrupt Enable */
        uint8_t WTE : 1;               /*!< [7] Wait Timer Interrupt Enable */
    } B;
} hw_uart_ie7816_t;

/*!
 * @name Constants and macros for entire UART_IE7816 register
 */
/*@{*/
#define HW_UART_IE7816_ADDR(x)   ((x) + 0x19U)

#define HW_UART_IE7816(x)        (*(__IO hw_uart_ie7816_t *) HW_UART_IE7816_ADDR(x))
#define HW_UART_IE7816_RD(x)     (HW_UART_IE7816(x).U)
#define HW_UART_IE7816_WR(x, v)  (HW_UART_IE7816(x).U = (v))
#define HW_UART_IE7816_SET(x, v) (HW_UART_IE7816_WR(x, HW_UART_IE7816_RD(x) |  (v)))
#define HW_UART_IE7816_CLR(x, v) (HW_UART_IE7816_WR(x, HW_UART_IE7816_RD(x) & ~(v)))
#define HW_UART_IE7816_TOG(x, v) (HW_UART_IE7816_WR(x, HW_UART_IE7816_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_IE7816 bitfields
 */

/*!
 * @name Register UART_IE7816, field RXTE[0] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[RXT] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[RXT] results in the generation of an interrupt.
 */
/*@{*/
#define BP_UART_IE7816_RXTE  (0U)          /*!< Bit position for UART_IE7816_RXTE. */
#define BM_UART_IE7816_RXTE  (0x01U)       /*!< Bit mask for UART_IE7816_RXTE. */
#define BS_UART_IE7816_RXTE  (1U)          /*!< Bit field size in bits for UART_IE7816_RXTE. */

/*! @brief Read current value of the UART_IE7816_RXTE field. */
#define BR_UART_IE7816_RXTE(x) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_RXTE))

/*! @brief Format value for bitfield UART_IE7816_RXTE. */
#define BF_UART_IE7816_RXTE(v) ((uint8_t)((uint8_t)(v) << BP_UART_IE7816_RXTE) & BM_UART_IE7816_RXTE)

/*! @brief Set the RXTE field to a new value. */
#define BW_UART_IE7816_RXTE(x, v) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_RXTE) = (v))
/*@}*/

/*!
 * @name Register UART_IE7816, field TXTE[1] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[TXT] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[TXT] results in the generation of an interrupt.
 */
/*@{*/
#define BP_UART_IE7816_TXTE  (1U)          /*!< Bit position for UART_IE7816_TXTE. */
#define BM_UART_IE7816_TXTE  (0x02U)       /*!< Bit mask for UART_IE7816_TXTE. */
#define BS_UART_IE7816_TXTE  (1U)          /*!< Bit field size in bits for UART_IE7816_TXTE. */

/*! @brief Read current value of the UART_IE7816_TXTE field. */
#define BR_UART_IE7816_TXTE(x) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_TXTE))

/*! @brief Format value for bitfield UART_IE7816_TXTE. */
#define BF_UART_IE7816_TXTE(v) ((uint8_t)((uint8_t)(v) << BP_UART_IE7816_TXTE) & BM_UART_IE7816_TXTE)

/*! @brief Set the TXTE field to a new value. */
#define BW_UART_IE7816_TXTE(x, v) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_TXTE) = (v))
/*@}*/

/*!
 * @name Register UART_IE7816, field GTVE[2] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[GTV] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[GTV] results in the generation of an interrupt.
 */
/*@{*/
#define BP_UART_IE7816_GTVE  (2U)          /*!< Bit position for UART_IE7816_GTVE. */
#define BM_UART_IE7816_GTVE  (0x04U)       /*!< Bit mask for UART_IE7816_GTVE. */
#define BS_UART_IE7816_GTVE  (1U)          /*!< Bit field size in bits for UART_IE7816_GTVE. */

/*! @brief Read current value of the UART_IE7816_GTVE field. */
#define BR_UART_IE7816_GTVE(x) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_GTVE))

/*! @brief Format value for bitfield UART_IE7816_GTVE. */
#define BF_UART_IE7816_GTVE(v) ((uint8_t)((uint8_t)(v) << BP_UART_IE7816_GTVE) & BM_UART_IE7816_GTVE)

/*! @brief Set the GTVE field to a new value. */
#define BW_UART_IE7816_GTVE(x, v) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_GTVE) = (v))
/*@}*/

/*!
 * @name Register UART_IE7816, field INITDE[4] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[INITD] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[INITD] results in the generation of an
 *     interrupt.
 */
/*@{*/
#define BP_UART_IE7816_INITDE (4U)         /*!< Bit position for UART_IE7816_INITDE. */
#define BM_UART_IE7816_INITDE (0x10U)      /*!< Bit mask for UART_IE7816_INITDE. */
#define BS_UART_IE7816_INITDE (1U)         /*!< Bit field size in bits for UART_IE7816_INITDE. */

/*! @brief Read current value of the UART_IE7816_INITDE field. */
#define BR_UART_IE7816_INITDE(x) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_INITDE))

/*! @brief Format value for bitfield UART_IE7816_INITDE. */
#define BF_UART_IE7816_INITDE(v) ((uint8_t)((uint8_t)(v) << BP_UART_IE7816_INITDE) & BM_UART_IE7816_INITDE)

/*! @brief Set the INITDE field to a new value. */
#define BW_UART_IE7816_INITDE(x, v) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_INITDE) = (v))
/*@}*/

/*!
 * @name Register UART_IE7816, field BWTE[5] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[BWT] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[BWT] results in the generation of an interrupt.
 */
/*@{*/
#define BP_UART_IE7816_BWTE  (5U)          /*!< Bit position for UART_IE7816_BWTE. */
#define BM_UART_IE7816_BWTE  (0x20U)       /*!< Bit mask for UART_IE7816_BWTE. */
#define BS_UART_IE7816_BWTE  (1U)          /*!< Bit field size in bits for UART_IE7816_BWTE. */

/*! @brief Read current value of the UART_IE7816_BWTE field. */
#define BR_UART_IE7816_BWTE(x) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_BWTE))

/*! @brief Format value for bitfield UART_IE7816_BWTE. */
#define BF_UART_IE7816_BWTE(v) ((uint8_t)((uint8_t)(v) << BP_UART_IE7816_BWTE) & BM_UART_IE7816_BWTE)

/*! @brief Set the BWTE field to a new value. */
#define BW_UART_IE7816_BWTE(x, v) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_BWTE) = (v))
/*@}*/

/*!
 * @name Register UART_IE7816, field CWTE[6] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[CWT] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[CWT] results in the generation of an interrupt.
 */
/*@{*/
#define BP_UART_IE7816_CWTE  (6U)          /*!< Bit position for UART_IE7816_CWTE. */
#define BM_UART_IE7816_CWTE  (0x40U)       /*!< Bit mask for UART_IE7816_CWTE. */
#define BS_UART_IE7816_CWTE  (1U)          /*!< Bit field size in bits for UART_IE7816_CWTE. */

/*! @brief Read current value of the UART_IE7816_CWTE field. */
#define BR_UART_IE7816_CWTE(x) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_CWTE))

/*! @brief Format value for bitfield UART_IE7816_CWTE. */
#define BF_UART_IE7816_CWTE(v) ((uint8_t)((uint8_t)(v) << BP_UART_IE7816_CWTE) & BM_UART_IE7816_CWTE)

/*! @brief Set the CWTE field to a new value. */
#define BW_UART_IE7816_CWTE(x, v) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_CWTE) = (v))
/*@}*/

/*!
 * @name Register UART_IE7816, field WTE[7] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[WT] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[WT] results in the generation of an interrupt.
 */
/*@{*/
#define BP_UART_IE7816_WTE   (7U)          /*!< Bit position for UART_IE7816_WTE. */
#define BM_UART_IE7816_WTE   (0x80U)       /*!< Bit mask for UART_IE7816_WTE. */
#define BS_UART_IE7816_WTE   (1U)          /*!< Bit field size in bits for UART_IE7816_WTE. */

/*! @brief Read current value of the UART_IE7816_WTE field. */
#define BR_UART_IE7816_WTE(x) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_WTE))

/*! @brief Format value for bitfield UART_IE7816_WTE. */
#define BF_UART_IE7816_WTE(v) ((uint8_t)((uint8_t)(v) << BP_UART_IE7816_WTE) & BM_UART_IE7816_WTE)

/*! @brief Set the WTE field to a new value. */
#define BW_UART_IE7816_WTE(x, v) (BITBAND_ACCESS8(HW_UART_IE7816_ADDR(x), BP_UART_IE7816_WTE) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_IS7816 - UART 7816 Interrupt Status Register
 ******************************************************************************/

/*!
 * @brief HW_UART_IS7816 - UART 7816 Interrupt Status Register (RW)
 *
 * Reset value: 0x00U
 *
 * The IS7816 register provides a mechanism to read and clear the interrupt
 * flags. All flags/interrupts are cleared by writing a 1 to the field location.
 * Writing a 0 has no effect. All bits are "sticky", meaning they indicate that only
 * the flag condition that occurred since the last time the bit was cleared, not
 * that the condition currently exists. The status flags are set regardless of
 * whether the corresponding field in the IE7816 is set or cleared. The IE7816
 * controls only if an interrupt is issued to the host processor. This register is
 * specific to 7816 functionality and the values in this register have no affect on
 * UART operation and should be ignored if 7816E is not set/enabled. This
 * register may be read or written at anytime.
 */
typedef union _hw_uart_is7816
{
    uint8_t U;
    struct _hw_uart_is7816_bitfields
    {
        uint8_t RXT : 1;               /*!< [0] Receive Threshold Exceeded Interrupt */
        uint8_t TXT : 1;               /*!< [1] Transmit Threshold Exceeded Interrupt */
        uint8_t GTV : 1;               /*!< [2] Guard Timer Violated Interrupt */
        uint8_t RESERVED0 : 1;         /*!< [3]  */
        uint8_t INITD : 1;             /*!< [4] Initial Character Detected Interrupt */
        uint8_t BWT : 1;               /*!< [5] Block Wait Timer Interrupt */
        uint8_t CWT : 1;               /*!< [6] Character Wait Timer Interrupt */
        uint8_t WT : 1;                /*!< [7] Wait Timer Interrupt */
    } B;
} hw_uart_is7816_t;

/*!
 * @name Constants and macros for entire UART_IS7816 register
 */
/*@{*/
#define HW_UART_IS7816_ADDR(x)   ((x) + 0x1AU)

#define HW_UART_IS7816(x)        (*(__IO hw_uart_is7816_t *) HW_UART_IS7816_ADDR(x))
#define HW_UART_IS7816_RD(x)     (HW_UART_IS7816(x).U)
#define HW_UART_IS7816_WR(x, v)  (HW_UART_IS7816(x).U = (v))
#define HW_UART_IS7816_SET(x, v) (HW_UART_IS7816_WR(x, HW_UART_IS7816_RD(x) |  (v)))
#define HW_UART_IS7816_CLR(x, v) (HW_UART_IS7816_WR(x, HW_UART_IS7816_RD(x) & ~(v)))
#define HW_UART_IS7816_TOG(x, v) (HW_UART_IS7816_WR(x, HW_UART_IS7816_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_IS7816 bitfields
 */

/*!
 * @name Register UART_IS7816, field RXT[0] (W1C)
 *
 * Indicates that there are more than ET7816[RXTHRESHOLD] consecutive NACKS
 * generated in response to parity errors on received data. This flag requires ANACK
 * to be set. Additionally, this flag asserts only when C7816[TTYPE] = 0.
 * Clearing this field also resets the counter keeping track of consecutive NACKS. The
 * UART will continue to attempt to receive data regardless of whether this flag
 * is set. If 7816E is cleared/disabled, RE is cleared/disabled, C7816[TTYPE] = 1,
 * or packet is received without needing to issue a NACK, the internal NACK
 * detection counter is cleared and the count restarts from zero on the next
 * transmitted NACK. This interrupt is cleared by writing 1.
 *
 * Values:
 * - 0 - The number of consecutive NACKS generated as a result of parity errors
 *     and buffer overruns is less than or equal to the value in
 *     ET7816[RXTHRESHOLD].
 * - 1 - The number of consecutive NACKS generated as a result of parity errors
 *     and buffer overruns is greater than the value in ET7816[RXTHRESHOLD].
 */
/*@{*/
#define BP_UART_IS7816_RXT   (0U)          /*!< Bit position for UART_IS7816_RXT. */
#define BM_UART_IS7816_RXT   (0x01U)       /*!< Bit mask for UART_IS7816_RXT. */
#define BS_UART_IS7816_RXT   (1U)          /*!< Bit field size in bits for UART_IS7816_RXT. */

/*! @brief Read current value of the UART_IS7816_RXT field. */
#define BR_UART_IS7816_RXT(x) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_RXT))

/*! @brief Format value for bitfield UART_IS7816_RXT. */
#define BF_UART_IS7816_RXT(v) ((uint8_t)((uint8_t)(v) << BP_UART_IS7816_RXT) & BM_UART_IS7816_RXT)

/*! @brief Set the RXT field to a new value. */
#define BW_UART_IS7816_RXT(x, v) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_RXT) = (v))
/*@}*/

/*!
 * @name Register UART_IS7816, field TXT[1] (W1C)
 *
 * Indicates that the transmit NACK threshold has been exceeded as indicated by
 * ET7816[TXTHRESHOLD]. Regardless of whether this flag is set, the UART
 * continues to retransmit indefinitely. This flag asserts only when C7816[TTYPE] = 0. If
 * 7816E is cleared/disabled, ANACK is cleared/disabled, C2[TE] is
 * cleared/disabled, C7816[TTYPE] = 1, or packet is transferred without receiving a NACK, the
 * internal NACK detection counter is cleared and the count restarts from zero on
 * the next received NACK. This interrupt is cleared by writing 1.
 *
 * Values:
 * - 0 - The number of retries and corresponding NACKS does not exceed the value
 *     in ET7816[TXTHRESHOLD].
 * - 1 - The number of retries and corresponding NACKS exceeds the value in
 *     ET7816[TXTHRESHOLD].
 */
/*@{*/
#define BP_UART_IS7816_TXT   (1U)          /*!< Bit position for UART_IS7816_TXT. */
#define BM_UART_IS7816_TXT   (0x02U)       /*!< Bit mask for UART_IS7816_TXT. */
#define BS_UART_IS7816_TXT   (1U)          /*!< Bit field size in bits for UART_IS7816_TXT. */

/*! @brief Read current value of the UART_IS7816_TXT field. */
#define BR_UART_IS7816_TXT(x) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_TXT))

/*! @brief Format value for bitfield UART_IS7816_TXT. */
#define BF_UART_IS7816_TXT(v) ((uint8_t)((uint8_t)(v) << BP_UART_IS7816_TXT) & BM_UART_IS7816_TXT)

/*! @brief Set the TXT field to a new value. */
#define BW_UART_IS7816_TXT(x, v) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_TXT) = (v))
/*@}*/

/*!
 * @name Register UART_IS7816, field GTV[2] (W1C)
 *
 * Indicates that one or more of the character guard time, block guard time, or
 * guard time are violated. This interrupt is cleared by writing 1.
 *
 * Values:
 * - 0 - A guard time (GT, CGT, or BGT) has not been violated.
 * - 1 - A guard time (GT, CGT, or BGT) has been violated.
 */
/*@{*/
#define BP_UART_IS7816_GTV   (2U)          /*!< Bit position for UART_IS7816_GTV. */
#define BM_UART_IS7816_GTV   (0x04U)       /*!< Bit mask for UART_IS7816_GTV. */
#define BS_UART_IS7816_GTV   (1U)          /*!< Bit field size in bits for UART_IS7816_GTV. */

/*! @brief Read current value of the UART_IS7816_GTV field. */
#define BR_UART_IS7816_GTV(x) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_GTV))

/*! @brief Format value for bitfield UART_IS7816_GTV. */
#define BF_UART_IS7816_GTV(v) ((uint8_t)((uint8_t)(v) << BP_UART_IS7816_GTV) & BM_UART_IS7816_GTV)

/*! @brief Set the GTV field to a new value. */
#define BW_UART_IS7816_GTV(x, v) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_GTV) = (v))
/*@}*/

/*!
 * @name Register UART_IS7816, field INITD[4] (W1C)
 *
 * Indicates that a valid initial character is received. This interrupt is
 * cleared by writing 1.
 *
 * Values:
 * - 0 - A valid initial character has not been received.
 * - 1 - A valid initial character has been received.
 */
/*@{*/
#define BP_UART_IS7816_INITD (4U)          /*!< Bit position for UART_IS7816_INITD. */
#define BM_UART_IS7816_INITD (0x10U)       /*!< Bit mask for UART_IS7816_INITD. */
#define BS_UART_IS7816_INITD (1U)          /*!< Bit field size in bits for UART_IS7816_INITD. */

/*! @brief Read current value of the UART_IS7816_INITD field. */
#define BR_UART_IS7816_INITD(x) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_INITD))

/*! @brief Format value for bitfield UART_IS7816_INITD. */
#define BF_UART_IS7816_INITD(v) ((uint8_t)((uint8_t)(v) << BP_UART_IS7816_INITD) & BM_UART_IS7816_INITD)

/*! @brief Set the INITD field to a new value. */
#define BW_UART_IS7816_INITD(x, v) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_INITD) = (v))
/*@}*/

/*!
 * @name Register UART_IS7816, field BWT[5] (W1C)
 *
 * Indicates that the block wait time, the time between the leading edge of
 * first received character of a block and the leading edge of the last character the
 * previously transmitted block, has exceeded the programmed value. This flag
 * asserts only when C7816[TTYPE] = 1.This interrupt is cleared by writing 1.
 *
 * Values:
 * - 0 - Block wait time (BWT) has not been violated.
 * - 1 - Block wait time (BWT) has been violated.
 */
/*@{*/
#define BP_UART_IS7816_BWT   (5U)          /*!< Bit position for UART_IS7816_BWT. */
#define BM_UART_IS7816_BWT   (0x20U)       /*!< Bit mask for UART_IS7816_BWT. */
#define BS_UART_IS7816_BWT   (1U)          /*!< Bit field size in bits for UART_IS7816_BWT. */

/*! @brief Read current value of the UART_IS7816_BWT field. */
#define BR_UART_IS7816_BWT(x) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_BWT))

/*! @brief Format value for bitfield UART_IS7816_BWT. */
#define BF_UART_IS7816_BWT(v) ((uint8_t)((uint8_t)(v) << BP_UART_IS7816_BWT) & BM_UART_IS7816_BWT)

/*! @brief Set the BWT field to a new value. */
#define BW_UART_IS7816_BWT(x, v) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_BWT) = (v))
/*@}*/

/*!
 * @name Register UART_IS7816, field CWT[6] (W1C)
 *
 * Indicates that the character wait time, the time between the leading edges of
 * two consecutive characters in a block, has exceeded the programmed value.
 * This flag asserts only when C7816[TTYPE] = 1. This interrupt is cleared by
 * writing 1.
 *
 * Values:
 * - 0 - Character wait time (CWT) has not been violated.
 * - 1 - Character wait time (CWT) has been violated.
 */
/*@{*/
#define BP_UART_IS7816_CWT   (6U)          /*!< Bit position for UART_IS7816_CWT. */
#define BM_UART_IS7816_CWT   (0x40U)       /*!< Bit mask for UART_IS7816_CWT. */
#define BS_UART_IS7816_CWT   (1U)          /*!< Bit field size in bits for UART_IS7816_CWT. */

/*! @brief Read current value of the UART_IS7816_CWT field. */
#define BR_UART_IS7816_CWT(x) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_CWT))

/*! @brief Format value for bitfield UART_IS7816_CWT. */
#define BF_UART_IS7816_CWT(v) ((uint8_t)((uint8_t)(v) << BP_UART_IS7816_CWT) & BM_UART_IS7816_CWT)

/*! @brief Set the CWT field to a new value. */
#define BW_UART_IS7816_CWT(x, v) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_CWT) = (v))
/*@}*/

/*!
 * @name Register UART_IS7816, field WT[7] (W1C)
 *
 * Indicates that the wait time, the time between the leading edge of a
 * character being transmitted and the leading edge of the next response character, has
 * exceeded the programmed value. This flag asserts only when C7816[TTYPE] = 0.
 * This interrupt is cleared by writing 1.
 *
 * Values:
 * - 0 - Wait time (WT) has not been violated.
 * - 1 - Wait time (WT) has been violated.
 */
/*@{*/
#define BP_UART_IS7816_WT    (7U)          /*!< Bit position for UART_IS7816_WT. */
#define BM_UART_IS7816_WT    (0x80U)       /*!< Bit mask for UART_IS7816_WT. */
#define BS_UART_IS7816_WT    (1U)          /*!< Bit field size in bits for UART_IS7816_WT. */

/*! @brief Read current value of the UART_IS7816_WT field. */
#define BR_UART_IS7816_WT(x) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_WT))

/*! @brief Format value for bitfield UART_IS7816_WT. */
#define BF_UART_IS7816_WT(v) ((uint8_t)((uint8_t)(v) << BP_UART_IS7816_WT) & BM_UART_IS7816_WT)

/*! @brief Set the WT field to a new value. */
#define BW_UART_IS7816_WT(x, v) (BITBAND_ACCESS8(HW_UART_IS7816_ADDR(x), BP_UART_IS7816_WT) = (v))
/*@}*/

/*******************************************************************************
 * HW_UART_WP7816T0 - UART 7816 Wait Parameter Register
 ******************************************************************************/

/*!
 * @brief HW_UART_WP7816T0 - UART 7816 Wait Parameter Register (RW)
 *
 * Reset value: 0x0AU
 *
 * The WP7816 register contains constants used in the generation of various wait
 * timer counters. To save register space, this register is used differently
 * when C7816[TTYPE] = 0 and C7816[TTYPE] = 1. This register may be read at any
 * time. This register must be written to only when C7816[ISO_7816E] is not set.
 */
typedef union _hw_uart_wp7816t0
{
    uint8_t U;
    struct _hw_uart_wp7816t0_bitfields
    {
        uint8_t WI : 8;                /*!< [7:0] Wait Time Integer (C7816[TTYPE] = 0) */
    } B;
} hw_uart_wp7816t0_t;

/*!
 * @name Constants and macros for entire UART_WP7816T0 register
 */
/*@{*/
#define HW_UART_WP7816T0_ADDR(x) ((x) + 0x1BU)

#define HW_UART_WP7816T0(x)      (*(__IO hw_uart_wp7816t0_t *) HW_UART_WP7816T0_ADDR(x))
#define HW_UART_WP7816T0_RD(x)   (HW_UART_WP7816T0(x).U)
#define HW_UART_WP7816T0_WR(x, v) (HW_UART_WP7816T0(x).U = (v))
#define HW_UART_WP7816T0_SET(x, v) (HW_UART_WP7816T0_WR(x, HW_UART_WP7816T0_RD(x) |  (v)))
#define HW_UART_WP7816T0_CLR(x, v) (HW_UART_WP7816T0_WR(x, HW_UART_WP7816T0_RD(x) & ~(v)))
#define HW_UART_WP7816T0_TOG(x, v) (HW_UART_WP7816T0_WR(x, HW_UART_WP7816T0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_WP7816T0 bitfields
 */

/*!
 * @name Register UART_WP7816T0, field WI[7:0] (RW)
 *
 * Used to calculate the value used for the WT counter. It represents a value
 * between 1 and 255. The value of zero is not valid. This value is used only when
 * C7816[TTYPE] = 0. See Wait time and guard time parameters.
 */
/*@{*/
#define BP_UART_WP7816T0_WI  (0U)          /*!< Bit position for UART_WP7816T0_WI. */
#define BM_UART_WP7816T0_WI  (0xFFU)       /*!< Bit mask for UART_WP7816T0_WI. */
#define BS_UART_WP7816T0_WI  (8U)          /*!< Bit field size in bits for UART_WP7816T0_WI. */

/*! @brief Read current value of the UART_WP7816T0_WI field. */
#define BR_UART_WP7816T0_WI(x) (HW_UART_WP7816T0(x).U)

/*! @brief Format value for bitfield UART_WP7816T0_WI. */
#define BF_UART_WP7816T0_WI(v) ((uint8_t)((uint8_t)(v) << BP_UART_WP7816T0_WI) & BM_UART_WP7816T0_WI)

/*! @brief Set the WI field to a new value. */
#define BW_UART_WP7816T0_WI(x, v) (HW_UART_WP7816T0_WR(x, v))
/*@}*/
/*******************************************************************************
 * HW_UART_WP7816T1 - UART 7816 Wait Parameter Register
 ******************************************************************************/

/*!
 * @brief HW_UART_WP7816T1 - UART 7816 Wait Parameter Register (RW)
 *
 * Reset value: 0x0AU
 *
 * The WP7816 register contains constants used in the generation of various wait
 * timer counters. To save register space, this register is used differently
 * when C7816[TTYPE] = 0 and C7816[TTYPE] = 1. This register may be read at any
 * time. This register must be written to only when C7816[ISO_7816E] is not set.
 */
typedef union _hw_uart_wp7816t1
{
    uint8_t U;
    struct _hw_uart_wp7816t1_bitfields
    {
        uint8_t BWI : 4;               /*!< [3:0] Block Wait Time Integer(C7816[TTYPE] = 1)
                                        * */
        uint8_t CWI : 4;               /*!< [7:4] Character Wait Time Integer (C7816[TTYPE]
                                        * = 1) */
    } B;
} hw_uart_wp7816t1_t;

/*!
 * @name Constants and macros for entire UART_WP7816T1 register
 */
/*@{*/
#define HW_UART_WP7816T1_ADDR(x) ((x) + 0x1BU)

#define HW_UART_WP7816T1(x)      (*(__IO hw_uart_wp7816t1_t *) HW_UART_WP7816T1_ADDR(x))
#define HW_UART_WP7816T1_RD(x)   (HW_UART_WP7816T1(x).U)
#define HW_UART_WP7816T1_WR(x, v) (HW_UART_WP7816T1(x).U = (v))
#define HW_UART_WP7816T1_SET(x, v) (HW_UART_WP7816T1_WR(x, HW_UART_WP7816T1_RD(x) |  (v)))
#define HW_UART_WP7816T1_CLR(x, v) (HW_UART_WP7816T1_WR(x, HW_UART_WP7816T1_RD(x) & ~(v)))
#define HW_UART_WP7816T1_TOG(x, v) (HW_UART_WP7816T1_WR(x, HW_UART_WP7816T1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_WP7816T1 bitfields
 */

/*!
 * @name Register UART_WP7816T1, field BWI[3:0] (RW)
 *
 * Used to calculate the value used for the BWT counter. It represent a value
 * between 0 and 15. This value is used only when C7816[TTYPE] = 1. See Wait time
 * and guard time parameters .
 */
/*@{*/
#define BP_UART_WP7816T1_BWI (0U)          /*!< Bit position for UART_WP7816T1_BWI. */
#define BM_UART_WP7816T1_BWI (0x0FU)       /*!< Bit mask for UART_WP7816T1_BWI. */
#define BS_UART_WP7816T1_BWI (4U)          /*!< Bit field size in bits for UART_WP7816T1_BWI. */

/*! @brief Read current value of the UART_WP7816T1_BWI field. */
#define BR_UART_WP7816T1_BWI(x) (HW_UART_WP7816T1(x).B.BWI)

/*! @brief Format value for bitfield UART_WP7816T1_BWI. */
#define BF_UART_WP7816T1_BWI(v) ((uint8_t)((uint8_t)(v) << BP_UART_WP7816T1_BWI) & BM_UART_WP7816T1_BWI)

/*! @brief Set the BWI field to a new value. */
#define BW_UART_WP7816T1_BWI(x, v) (HW_UART_WP7816T1_WR(x, (HW_UART_WP7816T1_RD(x) & ~BM_UART_WP7816T1_BWI) | BF_UART_WP7816T1_BWI(v)))
/*@}*/

/*!
 * @name Register UART_WP7816T1, field CWI[7:4] (RW)
 *
 * Used to calculate the value used for the CWT counter. It represents a value
 * between 0 and 15. This value is used only when C7816[TTYPE] = 1. See Wait time
 * and guard time parameters .
 */
/*@{*/
#define BP_UART_WP7816T1_CWI (4U)          /*!< Bit position for UART_WP7816T1_CWI. */
#define BM_UART_WP7816T1_CWI (0xF0U)       /*!< Bit mask for UART_WP7816T1_CWI. */
#define BS_UART_WP7816T1_CWI (4U)          /*!< Bit field size in bits for UART_WP7816T1_CWI. */

/*! @brief Read current value of the UART_WP7816T1_CWI field. */
#define BR_UART_WP7816T1_CWI(x) (HW_UART_WP7816T1(x).B.CWI)

/*! @brief Format value for bitfield UART_WP7816T1_CWI. */
#define BF_UART_WP7816T1_CWI(v) ((uint8_t)((uint8_t)(v) << BP_UART_WP7816T1_CWI) & BM_UART_WP7816T1_CWI)

/*! @brief Set the CWI field to a new value. */
#define BW_UART_WP7816T1_CWI(x, v) (HW_UART_WP7816T1_WR(x, (HW_UART_WP7816T1_RD(x) & ~BM_UART_WP7816T1_CWI) | BF_UART_WP7816T1_CWI(v)))
/*@}*/

/*******************************************************************************
 * HW_UART_WN7816 - UART 7816 Wait N Register
 ******************************************************************************/

/*!
 * @brief HW_UART_WN7816 - UART 7816 Wait N Register (RW)
 *
 * Reset value: 0x00U
 *
 * The WN7816 register contains a parameter that is used in the calculation of
 * the guard time counter. This register may be read at any time. This register
 * must be written to only when C7816[ISO_7816E] is not set.
 */
typedef union _hw_uart_wn7816
{
    uint8_t U;
    struct _hw_uart_wn7816_bitfields
    {
        uint8_t GTN : 8;               /*!< [7:0] Guard Band N */
    } B;
} hw_uart_wn7816_t;

/*!
 * @name Constants and macros for entire UART_WN7816 register
 */
/*@{*/
#define HW_UART_WN7816_ADDR(x)   ((x) + 0x1CU)

#define HW_UART_WN7816(x)        (*(__IO hw_uart_wn7816_t *) HW_UART_WN7816_ADDR(x))
#define HW_UART_WN7816_RD(x)     (HW_UART_WN7816(x).U)
#define HW_UART_WN7816_WR(x, v)  (HW_UART_WN7816(x).U = (v))
#define HW_UART_WN7816_SET(x, v) (HW_UART_WN7816_WR(x, HW_UART_WN7816_RD(x) |  (v)))
#define HW_UART_WN7816_CLR(x, v) (HW_UART_WN7816_WR(x, HW_UART_WN7816_RD(x) & ~(v)))
#define HW_UART_WN7816_TOG(x, v) (HW_UART_WN7816_WR(x, HW_UART_WN7816_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_WN7816 bitfields
 */

/*!
 * @name Register UART_WN7816, field GTN[7:0] (RW)
 *
 * Defines a parameter used in the calculation of GT, CGT, and BGT counters. The
 * value represents an integer number between 0 and 255. See Wait time and guard
 * time parameters .
 */
/*@{*/
#define BP_UART_WN7816_GTN   (0U)          /*!< Bit position for UART_WN7816_GTN. */
#define BM_UART_WN7816_GTN   (0xFFU)       /*!< Bit mask for UART_WN7816_GTN. */
#define BS_UART_WN7816_GTN   (8U)          /*!< Bit field size in bits for UART_WN7816_GTN. */

/*! @brief Read current value of the UART_WN7816_GTN field. */
#define BR_UART_WN7816_GTN(x) (HW_UART_WN7816(x).U)

/*! @brief Format value for bitfield UART_WN7816_GTN. */
#define BF_UART_WN7816_GTN(v) ((uint8_t)((uint8_t)(v) << BP_UART_WN7816_GTN) & BM_UART_WN7816_GTN)

/*! @brief Set the GTN field to a new value. */
#define BW_UART_WN7816_GTN(x, v) (HW_UART_WN7816_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_UART_WF7816 - UART 7816 Wait FD Register
 ******************************************************************************/

/*!
 * @brief HW_UART_WF7816 - UART 7816 Wait FD Register (RW)
 *
 * Reset value: 0x01U
 *
 * The WF7816 contains parameters that are used in the generation of various
 * counters including GT, CGT, BGT, WT, and BWT. This register may be read at any
 * time. This register must be written to only when C7816[ISO_7816E] is not set.
 */
typedef union _hw_uart_wf7816
{
    uint8_t U;
    struct _hw_uart_wf7816_bitfields
    {
        uint8_t GTFD : 8;              /*!< [7:0] FD Multiplier */
    } B;
} hw_uart_wf7816_t;

/*!
 * @name Constants and macros for entire UART_WF7816 register
 */
/*@{*/
#define HW_UART_WF7816_ADDR(x)   ((x) + 0x1DU)

#define HW_UART_WF7816(x)        (*(__IO hw_uart_wf7816_t *) HW_UART_WF7816_ADDR(x))
#define HW_UART_WF7816_RD(x)     (HW_UART_WF7816(x).U)
#define HW_UART_WF7816_WR(x, v)  (HW_UART_WF7816(x).U = (v))
#define HW_UART_WF7816_SET(x, v) (HW_UART_WF7816_WR(x, HW_UART_WF7816_RD(x) |  (v)))
#define HW_UART_WF7816_CLR(x, v) (HW_UART_WF7816_WR(x, HW_UART_WF7816_RD(x) & ~(v)))
#define HW_UART_WF7816_TOG(x, v) (HW_UART_WF7816_WR(x, HW_UART_WF7816_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_WF7816 bitfields
 */

/*!
 * @name Register UART_WF7816, field GTFD[7:0] (RW)
 *
 * Used as another multiplier in the calculation of WT and BWT. This value
 * represents a number between 1 and 255. The value of 0 is invalid. This value is not
 * used in baud rate generation. See Wait time and guard time parameters and
 * Baud rate generation .
 */
/*@{*/
#define BP_UART_WF7816_GTFD  (0U)          /*!< Bit position for UART_WF7816_GTFD. */
#define BM_UART_WF7816_GTFD  (0xFFU)       /*!< Bit mask for UART_WF7816_GTFD. */
#define BS_UART_WF7816_GTFD  (8U)          /*!< Bit field size in bits for UART_WF7816_GTFD. */

/*! @brief Read current value of the UART_WF7816_GTFD field. */
#define BR_UART_WF7816_GTFD(x) (HW_UART_WF7816(x).U)

/*! @brief Format value for bitfield UART_WF7816_GTFD. */
#define BF_UART_WF7816_GTFD(v) ((uint8_t)((uint8_t)(v) << BP_UART_WF7816_GTFD) & BM_UART_WF7816_GTFD)

/*! @brief Set the GTFD field to a new value. */
#define BW_UART_WF7816_GTFD(x, v) (HW_UART_WF7816_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_UART_ET7816 - UART 7816 Error Threshold Register
 ******************************************************************************/

/*!
 * @brief HW_UART_ET7816 - UART 7816 Error Threshold Register (RW)
 *
 * Reset value: 0x00U
 *
 * The ET7816 register contains fields that determine the number of NACKs that
 * must be received or transmitted before the host processor is notified. This
 * register may be read at anytime. This register must be written to only when
 * C7816[ISO_7816E] is not set.
 */
typedef union _hw_uart_et7816
{
    uint8_t U;
    struct _hw_uart_et7816_bitfields
    {
        uint8_t RXTHRESHOLD : 4;       /*!< [3:0] Receive NACK Threshold */
        uint8_t TXTHRESHOLD : 4;       /*!< [7:4] Transmit NACK Threshold */
    } B;
} hw_uart_et7816_t;

/*!
 * @name Constants and macros for entire UART_ET7816 register
 */
/*@{*/
#define HW_UART_ET7816_ADDR(x)   ((x) + 0x1EU)

#define HW_UART_ET7816(x)        (*(__IO hw_uart_et7816_t *) HW_UART_ET7816_ADDR(x))
#define HW_UART_ET7816_RD(x)     (HW_UART_ET7816(x).U)
#define HW_UART_ET7816_WR(x, v)  (HW_UART_ET7816(x).U = (v))
#define HW_UART_ET7816_SET(x, v) (HW_UART_ET7816_WR(x, HW_UART_ET7816_RD(x) |  (v)))
#define HW_UART_ET7816_CLR(x, v) (HW_UART_ET7816_WR(x, HW_UART_ET7816_RD(x) & ~(v)))
#define HW_UART_ET7816_TOG(x, v) (HW_UART_ET7816_WR(x, HW_UART_ET7816_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_ET7816 bitfields
 */

/*!
 * @name Register UART_ET7816, field RXTHRESHOLD[3:0] (RW)
 *
 * The value written to this field indicates the maximum number of consecutive
 * NACKs generated as a result of a parity error or receiver buffer overruns
 * before the host processor is notified. After the counter exceeds that value in the
 * field, the IS7816[RXT] is asserted. This field is meaningful only when
 * C7816[TTYPE] = 0. The value read from this field represents the number of consecutive
 * NACKs that have been transmitted since the last successful reception. This
 * counter saturates at 4'hF and does not wrap around. Regardless of the number of
 * NACKs sent, the UART continues to receive valid packets indefinitely. For
 * additional information, see IS7816[RXT] field description.
 */
/*@{*/
#define BP_UART_ET7816_RXTHRESHOLD (0U)    /*!< Bit position for UART_ET7816_RXTHRESHOLD. */
#define BM_UART_ET7816_RXTHRESHOLD (0x0FU) /*!< Bit mask for UART_ET7816_RXTHRESHOLD. */
#define BS_UART_ET7816_RXTHRESHOLD (4U)    /*!< Bit field size in bits for UART_ET7816_RXTHRESHOLD. */

/*! @brief Read current value of the UART_ET7816_RXTHRESHOLD field. */
#define BR_UART_ET7816_RXTHRESHOLD(x) (HW_UART_ET7816(x).B.RXTHRESHOLD)

/*! @brief Format value for bitfield UART_ET7816_RXTHRESHOLD. */
#define BF_UART_ET7816_RXTHRESHOLD(v) ((uint8_t)((uint8_t)(v) << BP_UART_ET7816_RXTHRESHOLD) & BM_UART_ET7816_RXTHRESHOLD)

/*! @brief Set the RXTHRESHOLD field to a new value. */
#define BW_UART_ET7816_RXTHRESHOLD(x, v) (HW_UART_ET7816_WR(x, (HW_UART_ET7816_RD(x) & ~BM_UART_ET7816_RXTHRESHOLD) | BF_UART_ET7816_RXTHRESHOLD(v)))
/*@}*/

/*!
 * @name Register UART_ET7816, field TXTHRESHOLD[7:4] (RW)
 *
 * The value written to this field indicates the maximum number of failed
 * attempts (NACKs) a transmitted character can have before the host processor is
 * notified. This field is meaningful only when C7816[TTYPE] = 0 and C7816[ANACK] = 1.
 * The value read from this field represents the number of consecutive NACKs
 * that have been received since the last successful transmission. This counter
 * saturates at 4'hF and does not wrap around. Regardless of how many NACKs that are
 * received, the UART continues to retransmit indefinitely. This flag only
 * asserts when C7816[TTYPE] = 0. For additional information see the IS7816[TXT] field
 * description.
 *
 * Values:
 * - 0 - TXT asserts on the first NACK that is received.
 * - 1 - TXT asserts on the second NACK that is received.
 */
/*@{*/
#define BP_UART_ET7816_TXTHRESHOLD (4U)    /*!< Bit position for UART_ET7816_TXTHRESHOLD. */
#define BM_UART_ET7816_TXTHRESHOLD (0xF0U) /*!< Bit mask for UART_ET7816_TXTHRESHOLD. */
#define BS_UART_ET7816_TXTHRESHOLD (4U)    /*!< Bit field size in bits for UART_ET7816_TXTHRESHOLD. */

/*! @brief Read current value of the UART_ET7816_TXTHRESHOLD field. */
#define BR_UART_ET7816_TXTHRESHOLD(x) (HW_UART_ET7816(x).B.TXTHRESHOLD)

/*! @brief Format value for bitfield UART_ET7816_TXTHRESHOLD. */
#define BF_UART_ET7816_TXTHRESHOLD(v) ((uint8_t)((uint8_t)(v) << BP_UART_ET7816_TXTHRESHOLD) & BM_UART_ET7816_TXTHRESHOLD)

/*! @brief Set the TXTHRESHOLD field to a new value. */
#define BW_UART_ET7816_TXTHRESHOLD(x, v) (HW_UART_ET7816_WR(x, (HW_UART_ET7816_RD(x) & ~BM_UART_ET7816_TXTHRESHOLD) | BF_UART_ET7816_TXTHRESHOLD(v)))
/*@}*/

/*******************************************************************************
 * HW_UART_TL7816 - UART 7816 Transmit Length Register
 ******************************************************************************/

/*!
 * @brief HW_UART_TL7816 - UART 7816 Transmit Length Register (RW)
 *
 * Reset value: 0x00U
 *
 * The TL7816 register is used to indicate the number of characters contained in
 * the block being transmitted. This register is used only when C7816[TTYPE] =
 * 1. This register may be read at anytime. This register must be written only
 * when C2[TE] is not enabled.
 */
typedef union _hw_uart_tl7816
{
    uint8_t U;
    struct _hw_uart_tl7816_bitfields
    {
        uint8_t TLEN : 8;              /*!< [7:0] Transmit Length */
    } B;
} hw_uart_tl7816_t;

/*!
 * @name Constants and macros for entire UART_TL7816 register
 */
/*@{*/
#define HW_UART_TL7816_ADDR(x)   ((x) + 0x1FU)

#define HW_UART_TL7816(x)        (*(__IO hw_uart_tl7816_t *) HW_UART_TL7816_ADDR(x))
#define HW_UART_TL7816_RD(x)     (HW_UART_TL7816(x).U)
#define HW_UART_TL7816_WR(x, v)  (HW_UART_TL7816(x).U = (v))
#define HW_UART_TL7816_SET(x, v) (HW_UART_TL7816_WR(x, HW_UART_TL7816_RD(x) |  (v)))
#define HW_UART_TL7816_CLR(x, v) (HW_UART_TL7816_WR(x, HW_UART_TL7816_RD(x) & ~(v)))
#define HW_UART_TL7816_TOG(x, v) (HW_UART_TL7816_WR(x, HW_UART_TL7816_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual UART_TL7816 bitfields
 */

/*!
 * @name Register UART_TL7816, field TLEN[7:0] (RW)
 *
 * This value plus four indicates the number of characters contained in the
 * block being transmitted. This register is automatically decremented by 1 for each
 * character in the information field portion of the block. Additionally, this
 * register is automatically decremented by 1 for the first character of a CRC in
 * the epilogue field. Therefore, this register must be programmed with the number
 * of bytes in the data packet if an LRC is being transmitted, and the number of
 * bytes + 1 if a CRC is being transmitted. This register is not decremented for
 * characters that are assumed to be part of the Prologue field, that is, the
 * first three characters transmitted in a block, or the LRC or last CRC character
 * in the Epilogue field, that is, the last character transmitted. This field
 * must be programed or adjusted only when C2[TE] is cleared.
 */
/*@{*/
#define BP_UART_TL7816_TLEN  (0U)          /*!< Bit position for UART_TL7816_TLEN. */
#define BM_UART_TL7816_TLEN  (0xFFU)       /*!< Bit mask for UART_TL7816_TLEN. */
#define BS_UART_TL7816_TLEN  (8U)          /*!< Bit field size in bits for UART_TL7816_TLEN. */

/*! @brief Read current value of the UART_TL7816_TLEN field. */
#define BR_UART_TL7816_TLEN(x) (HW_UART_TL7816(x).U)

/*! @brief Format value for bitfield UART_TL7816_TLEN. */
#define BF_UART_TL7816_TLEN(v) ((uint8_t)((uint8_t)(v) << BP_UART_TL7816_TLEN) & BM_UART_TL7816_TLEN)

/*! @brief Set the TLEN field to a new value. */
#define BW_UART_TL7816_TLEN(x, v) (HW_UART_TL7816_WR(x, v))
/*@}*/

/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/*******************************************************************************
 * hw_uart_t - module struct
 ******************************************************************************/
/*!
 * @brief All UART module registers.
 */
#pragma pack(1)
typedef struct _hw_uart
{
    __IO hw_uart_bdh_t BDH;                /*!< [0x0] UART Baud Rate Registers: High */
    __IO hw_uart_bdl_t BDL;                /*!< [0x1] UART Baud Rate Registers: Low */
    __IO hw_uart_c1_t C1;                  /*!< [0x2] UART Control Register 1 */
    __IO hw_uart_c2_t C2;                  /*!< [0x3] UART Control Register 2 */
    __I hw_uart_s1_t S1;                   /*!< [0x4] UART Status Register 1 */
    __IO hw_uart_s2_t S2;                  /*!< [0x5] UART Status Register 2 */
    __IO hw_uart_c3_t C3;                  /*!< [0x6] UART Control Register 3 */
    __IO hw_uart_d_t D;                    /*!< [0x7] UART Data Register */
    __IO hw_uart_ma1_t MA1;                /*!< [0x8] UART Match Address Registers 1 */
    __IO hw_uart_ma2_t MA2;                /*!< [0x9] UART Match Address Registers 2 */
    __IO hw_uart_c4_t C4;                  /*!< [0xA] UART Control Register 4 */
    __IO hw_uart_c5_t C5;                  /*!< [0xB] UART Control Register 5 */
    __I hw_uart_ed_t ED;                   /*!< [0xC] UART Extended Data Register */
    __IO hw_uart_modem_t MODEM;            /*!< [0xD] UART Modem Register */
    __IO hw_uart_ir_t IR;                  /*!< [0xE] UART Infrared Register */
    uint8_t _reserved0[1];
    __IO hw_uart_pfifo_t PFIFO;            /*!< [0x10] UART FIFO Parameters */
    __IO hw_uart_cfifo_t CFIFO;            /*!< [0x11] UART FIFO Control Register */
    __IO hw_uart_sfifo_t SFIFO;            /*!< [0x12] UART FIFO Status Register */
    __IO hw_uart_twfifo_t TWFIFO;          /*!< [0x13] UART FIFO Transmit Watermark */
    __I hw_uart_tcfifo_t TCFIFO;           /*!< [0x14] UART FIFO Transmit Count */
    __IO hw_uart_rwfifo_t RWFIFO;          /*!< [0x15] UART FIFO Receive Watermark */
    __I hw_uart_rcfifo_t RCFIFO;           /*!< [0x16] UART FIFO Receive Count */
    uint8_t _reserved1[1];
    __IO hw_uart_c7816_t C7816;            /*!< [0x18] UART 7816 Control Register */
    __IO hw_uart_ie7816_t IE7816;          /*!< [0x19] UART 7816 Interrupt Enable Register */
    __IO hw_uart_is7816_t IS7816;          /*!< [0x1A] UART 7816 Interrupt Status Register */
    union {
        __IO hw_uart_wp7816t0_t WP7816T0;  /*!< [0x1B] UART 7816 Wait Parameter Register */
        __IO hw_uart_wp7816t1_t WP7816T1;  /*!< [0x1B] UART 7816 Wait Parameter Register */
    };
    __IO hw_uart_wn7816_t WN7816;          /*!< [0x1C] UART 7816 Wait N Register */
    __IO hw_uart_wf7816_t WF7816;          /*!< [0x1D] UART 7816 Wait FD Register */
    __IO hw_uart_et7816_t ET7816;          /*!< [0x1E] UART 7816 Error Threshold Register */
    __IO hw_uart_tl7816_t TL7816;          /*!< [0x1F] UART 7816 Transmit Length Register */
} hw_uart_t;
#pragma pack()

/*! @brief Macro to access all UART registers. */
/*! @param x UART module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_UART(UART0_BASE)</code>. */
#define HW_UART(x)     (*(hw_uart_t *)(x))

/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma pop
#elif defined(__CWCC__)
  #pragma pop
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

#endif /* __HW_UART_REGISTERS_H__ */
/* EOF */
