/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K22P121M120SF7RM, Rev. 1, March 24, 2014
**     Version:             rev. 2.5, 2014-05-06
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-07-23)
**         Initial version.
**     - rev. 1.1 (2013-09-17)
**         RM rev. 0.4 update.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-20)
**         Update according to reference manual rev. 0.6,
**     - rev. 2.3 (2014-01-13)
**         Update according to reference manual rev. 0.61,
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK22F51212.h
**     - rev. 2.5 (2014-05-06)
**         Update according to reference manual rev. 1.0,
**         Update of system and startup files.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_LPUART_REGISTERS_H__
#define __HW_LPUART_REGISTERS_H__

#include "MK22F51212.h"
#include "fsl_bitaccess.h"

/*
 * MK22F51212 LPUART
 *
 * Universal Asynchronous Receiver/Transmitter
 *
 * Registers defined in this header file:
 * - HW_LPUART_BAUD - LPUART Baud Rate Register
 * - HW_LPUART_STAT - LPUART Status Register
 * - HW_LPUART_CTRL - LPUART Control Register
 * - HW_LPUART_DATA - LPUART Data Register
 * - HW_LPUART_MATCH - LPUART Match Address Register
 * - HW_LPUART_MODIR - LPUART Modem IrDA Register
 *
 * - hw_lpuart_t - Struct containing all module registers.
 */

#define HW_LPUART_INSTANCE_COUNT (1U) /*!< Number of instances of the LPUART module. */

/*******************************************************************************
 * HW_LPUART_BAUD - LPUART Baud Rate Register
 ******************************************************************************/

/*!
 * @brief HW_LPUART_BAUD - LPUART Baud Rate Register (RW)
 *
 * Reset value: 0x0F000004U
 */
typedef union _hw_lpuart_baud
{
    uint32_t U;
    struct _hw_lpuart_baud_bitfields
    {
        uint32_t SBR : 13;             /*!< [12:0] Baud Rate Modulo Divisor. */
        uint32_t SBNS : 1;             /*!< [13] Stop Bit Number Select */
        uint32_t RXEDGIE : 1;          /*!< [14] RX Input Active Edge Interrupt Enable
                                        * */
        uint32_t LBKDIE : 1;           /*!< [15] LIN Break Detect Interrupt Enable */
        uint32_t RESYNCDIS : 1;        /*!< [16] Resynchronization Disable */
        uint32_t BOTHEDGE : 1;         /*!< [17] Both Edge Sampling */
        uint32_t MATCFG : 2;           /*!< [19:18] Match Configuration */
        uint32_t RESERVED0 : 1;        /*!< [20]  */
        uint32_t RDMAE : 1;            /*!< [21] Receiver Full DMA Enable */
        uint32_t RESERVED1 : 1;        /*!< [22]  */
        uint32_t TDMAE : 1;            /*!< [23] Transmitter DMA Enable */
        uint32_t OSR : 5;              /*!< [28:24] Over Sampling Ratio */
        uint32_t M10 : 1;              /*!< [29] 10-bit Mode select */
        uint32_t MAEN2 : 1;            /*!< [30] Match Address Mode Enable 2 */
        uint32_t MAEN1 : 1;            /*!< [31] Match Address Mode Enable 1 */
    } B;
} hw_lpuart_baud_t;

/*!
 * @name Constants and macros for entire LPUART_BAUD register
 */
/*@{*/
#define HW_LPUART_BAUD_ADDR(x)   ((x) + 0x0U)

#define HW_LPUART_BAUD(x)        (*(__IO hw_lpuart_baud_t *) HW_LPUART_BAUD_ADDR(x))
#define HW_LPUART_BAUD_RD(x)     (HW_LPUART_BAUD(x).U)
#define HW_LPUART_BAUD_WR(x, v)  (HW_LPUART_BAUD(x).U = (v))
#define HW_LPUART_BAUD_SET(x, v) (HW_LPUART_BAUD_WR(x, HW_LPUART_BAUD_RD(x) |  (v)))
#define HW_LPUART_BAUD_CLR(x, v) (HW_LPUART_BAUD_WR(x, HW_LPUART_BAUD_RD(x) & ~(v)))
#define HW_LPUART_BAUD_TOG(x, v) (HW_LPUART_BAUD_WR(x, HW_LPUART_BAUD_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LPUART_BAUD bitfields
 */

/*!
 * @name Register LPUART_BAUD, field SBR[12:0] (RW)
 *
 * The 13 bits in SBR[12:0] set the modulo divide rate for the baud rate
 * generator. When SBR is 1 - 8191, the baud rate equals "baud clock / ((OSR+1) * SBR)".
 * The 13-bit baud rate setting [SBR12:SBR0] must only be updated when the
 * transmitter and receiver are both disabled (LPUART_CTRL[RE] and LPUART_CTRL[TE] are
 * both 0).
 */
/*@{*/
#define BP_LPUART_BAUD_SBR   (0U)          /*!< Bit position for LPUART_BAUD_SBR. */
#define BM_LPUART_BAUD_SBR   (0x00001FFFU) /*!< Bit mask for LPUART_BAUD_SBR. */
#define BS_LPUART_BAUD_SBR   (13U)         /*!< Bit field size in bits for LPUART_BAUD_SBR. */

/*! @brief Read current value of the LPUART_BAUD_SBR field. */
#define BR_LPUART_BAUD_SBR(x) (HW_LPUART_BAUD(x).B.SBR)

/*! @brief Format value for bitfield LPUART_BAUD_SBR. */
#define BF_LPUART_BAUD_SBR(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_SBR) & BM_LPUART_BAUD_SBR)

/*! @brief Set the SBR field to a new value. */
#define BW_LPUART_BAUD_SBR(x, v) (HW_LPUART_BAUD_WR(x, (HW_LPUART_BAUD_RD(x) & ~BM_LPUART_BAUD_SBR) | BF_LPUART_BAUD_SBR(v)))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field SBNS[13] (RW)
 *
 * SBNS determines whether data characters are one or two stop bits. This bit
 * should only be changed when the transmitter and receiver are both disabled.
 *
 * Values:
 * - 0 - One stop bit.
 * - 1 - Two stop bits.
 */
/*@{*/
#define BP_LPUART_BAUD_SBNS  (13U)         /*!< Bit position for LPUART_BAUD_SBNS. */
#define BM_LPUART_BAUD_SBNS  (0x00002000U) /*!< Bit mask for LPUART_BAUD_SBNS. */
#define BS_LPUART_BAUD_SBNS  (1U)          /*!< Bit field size in bits for LPUART_BAUD_SBNS. */

/*! @brief Read current value of the LPUART_BAUD_SBNS field. */
#define BR_LPUART_BAUD_SBNS(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_SBNS))

/*! @brief Format value for bitfield LPUART_BAUD_SBNS. */
#define BF_LPUART_BAUD_SBNS(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_SBNS) & BM_LPUART_BAUD_SBNS)

/*! @brief Set the SBNS field to a new value. */
#define BW_LPUART_BAUD_SBNS(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_SBNS) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field RXEDGIE[14] (RW)
 *
 * Enables the receive input active edge, RXEDGIF, to generate interrupt
 * requests. Changing CTRL[LOOP] or CTRL[RSRC] when RXEDGIE is set can cause the RXEDGIF
 * to set.
 *
 * Values:
 * - 0 - Hardware interrupts from LPUART_STAT[RXEDGIF] disabled (use polling).
 * - 1 - Hardware interrupt requested when LPUART_STAT[RXEDGIF] flag is 1.
 */
/*@{*/
#define BP_LPUART_BAUD_RXEDGIE (14U)       /*!< Bit position for LPUART_BAUD_RXEDGIE. */
#define BM_LPUART_BAUD_RXEDGIE (0x00004000U) /*!< Bit mask for LPUART_BAUD_RXEDGIE. */
#define BS_LPUART_BAUD_RXEDGIE (1U)        /*!< Bit field size in bits for LPUART_BAUD_RXEDGIE. */

/*! @brief Read current value of the LPUART_BAUD_RXEDGIE field. */
#define BR_LPUART_BAUD_RXEDGIE(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_RXEDGIE))

/*! @brief Format value for bitfield LPUART_BAUD_RXEDGIE. */
#define BF_LPUART_BAUD_RXEDGIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_RXEDGIE) & BM_LPUART_BAUD_RXEDGIE)

/*! @brief Set the RXEDGIE field to a new value. */
#define BW_LPUART_BAUD_RXEDGIE(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_RXEDGIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field LBKDIE[15] (RW)
 *
 * LBKDIE enables the LIN break detect flag, LBKDIF, to generate interrupt
 * requests.
 *
 * Values:
 * - 0 - Hardware interrupts from LPUART_STAT[LBKDIF] disabled (use polling).
 * - 1 - Hardware interrupt requested when LPUART_STAT[LBKDIF] flag is 1.
 */
/*@{*/
#define BP_LPUART_BAUD_LBKDIE (15U)        /*!< Bit position for LPUART_BAUD_LBKDIE. */
#define BM_LPUART_BAUD_LBKDIE (0x00008000U) /*!< Bit mask for LPUART_BAUD_LBKDIE. */
#define BS_LPUART_BAUD_LBKDIE (1U)         /*!< Bit field size in bits for LPUART_BAUD_LBKDIE. */

/*! @brief Read current value of the LPUART_BAUD_LBKDIE field. */
#define BR_LPUART_BAUD_LBKDIE(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_LBKDIE))

/*! @brief Format value for bitfield LPUART_BAUD_LBKDIE. */
#define BF_LPUART_BAUD_LBKDIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_LBKDIE) & BM_LPUART_BAUD_LBKDIE)

/*! @brief Set the LBKDIE field to a new value. */
#define BW_LPUART_BAUD_LBKDIE(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_LBKDIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field RESYNCDIS[16] (RW)
 *
 * When set, disables the resynchronization of the received data word when a
 * data one followed by data zero transition is detected. This bit should only be
 * changed when the receiver is disabled.
 *
 * Values:
 * - 0 - Resynchronization during received data word is supported
 * - 1 - Resynchronization during received data word is disabled
 */
/*@{*/
#define BP_LPUART_BAUD_RESYNCDIS (16U)     /*!< Bit position for LPUART_BAUD_RESYNCDIS. */
#define BM_LPUART_BAUD_RESYNCDIS (0x00010000U) /*!< Bit mask for LPUART_BAUD_RESYNCDIS. */
#define BS_LPUART_BAUD_RESYNCDIS (1U)      /*!< Bit field size in bits for LPUART_BAUD_RESYNCDIS. */

/*! @brief Read current value of the LPUART_BAUD_RESYNCDIS field. */
#define BR_LPUART_BAUD_RESYNCDIS(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_RESYNCDIS))

/*! @brief Format value for bitfield LPUART_BAUD_RESYNCDIS. */
#define BF_LPUART_BAUD_RESYNCDIS(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_RESYNCDIS) & BM_LPUART_BAUD_RESYNCDIS)

/*! @brief Set the RESYNCDIS field to a new value. */
#define BW_LPUART_BAUD_RESYNCDIS(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_RESYNCDIS) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field BOTHEDGE[17] (RW)
 *
 * Enables sampling of the received data on both edges of the baud rate clock,
 * effectively doubling the number of times the receiver samples the input data
 * for a given oversampling ratio. This bit must be set for oversampling ratios
 * between x4 and x7 and is optional for higher oversampling ratios. This bit should
 * only be changed when the receiver is disabled.
 *
 * Values:
 * - 0 - Receiver samples input data using the rising edge of the baud rate
 *     clock.
 * - 1 - Receiver samples input data using the rising and falling edge of the
 *     baud rate clock.
 */
/*@{*/
#define BP_LPUART_BAUD_BOTHEDGE (17U)      /*!< Bit position for LPUART_BAUD_BOTHEDGE. */
#define BM_LPUART_BAUD_BOTHEDGE (0x00020000U) /*!< Bit mask for LPUART_BAUD_BOTHEDGE. */
#define BS_LPUART_BAUD_BOTHEDGE (1U)       /*!< Bit field size in bits for LPUART_BAUD_BOTHEDGE. */

/*! @brief Read current value of the LPUART_BAUD_BOTHEDGE field. */
#define BR_LPUART_BAUD_BOTHEDGE(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_BOTHEDGE))

/*! @brief Format value for bitfield LPUART_BAUD_BOTHEDGE. */
#define BF_LPUART_BAUD_BOTHEDGE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_BOTHEDGE) & BM_LPUART_BAUD_BOTHEDGE)

/*! @brief Set the BOTHEDGE field to a new value. */
#define BW_LPUART_BAUD_BOTHEDGE(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_BOTHEDGE) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field MATCFG[19:18] (RW)
 *
 * Configures the match addressing mode used.
 *
 * Values:
 * - 00 - Address Match Wakeup
 * - 01 - Idle Match Wakeup
 * - 10 - Match On and Match Off
 * - 11 - Enables RWU on Data Match and Match On/Off for transmitter CTS input
 */
/*@{*/
#define BP_LPUART_BAUD_MATCFG (18U)        /*!< Bit position for LPUART_BAUD_MATCFG. */
#define BM_LPUART_BAUD_MATCFG (0x000C0000U) /*!< Bit mask for LPUART_BAUD_MATCFG. */
#define BS_LPUART_BAUD_MATCFG (2U)         /*!< Bit field size in bits for LPUART_BAUD_MATCFG. */

/*! @brief Read current value of the LPUART_BAUD_MATCFG field. */
#define BR_LPUART_BAUD_MATCFG(x) (HW_LPUART_BAUD(x).B.MATCFG)

/*! @brief Format value for bitfield LPUART_BAUD_MATCFG. */
#define BF_LPUART_BAUD_MATCFG(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_MATCFG) & BM_LPUART_BAUD_MATCFG)

/*! @brief Set the MATCFG field to a new value. */
#define BW_LPUART_BAUD_MATCFG(x, v) (HW_LPUART_BAUD_WR(x, (HW_LPUART_BAUD_RD(x) & ~BM_LPUART_BAUD_MATCFG) | BF_LPUART_BAUD_MATCFG(v)))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field RDMAE[21] (RW)
 *
 * RDMAE configures the receiver data register full flag, LPUART_STAT[RDRF], to
 * generate a DMA request.
 *
 * Values:
 * - 0 - DMA request disabled.
 * - 1 - DMA request enabled.
 */
/*@{*/
#define BP_LPUART_BAUD_RDMAE (21U)         /*!< Bit position for LPUART_BAUD_RDMAE. */
#define BM_LPUART_BAUD_RDMAE (0x00200000U) /*!< Bit mask for LPUART_BAUD_RDMAE. */
#define BS_LPUART_BAUD_RDMAE (1U)          /*!< Bit field size in bits for LPUART_BAUD_RDMAE. */

/*! @brief Read current value of the LPUART_BAUD_RDMAE field. */
#define BR_LPUART_BAUD_RDMAE(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_RDMAE))

/*! @brief Format value for bitfield LPUART_BAUD_RDMAE. */
#define BF_LPUART_BAUD_RDMAE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_RDMAE) & BM_LPUART_BAUD_RDMAE)

/*! @brief Set the RDMAE field to a new value. */
#define BW_LPUART_BAUD_RDMAE(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_RDMAE) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field TDMAE[23] (RW)
 *
 * TDMAE configures the transmit data register empty flag, LPUART_STAT[TDRE], to
 * generate a DMA request.
 *
 * Values:
 * - 0 - DMA request disabled.
 * - 1 - DMA request enabled.
 */
/*@{*/
#define BP_LPUART_BAUD_TDMAE (23U)         /*!< Bit position for LPUART_BAUD_TDMAE. */
#define BM_LPUART_BAUD_TDMAE (0x00800000U) /*!< Bit mask for LPUART_BAUD_TDMAE. */
#define BS_LPUART_BAUD_TDMAE (1U)          /*!< Bit field size in bits for LPUART_BAUD_TDMAE. */

/*! @brief Read current value of the LPUART_BAUD_TDMAE field. */
#define BR_LPUART_BAUD_TDMAE(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_TDMAE))

/*! @brief Format value for bitfield LPUART_BAUD_TDMAE. */
#define BF_LPUART_BAUD_TDMAE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_TDMAE) & BM_LPUART_BAUD_TDMAE)

/*! @brief Set the TDMAE field to a new value. */
#define BW_LPUART_BAUD_TDMAE(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_TDMAE) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field OSR[28:24] (RW)
 *
 * This field configures the oversampling ratio for the receiver between 4x
 * (00011) and 32x (11111). Writing an invalid oversampling ratio will default to an
 * oversampling ratio of 16 (01111). This field should only be changed when the
 * transmitter and receiver are both disabled.
 */
/*@{*/
#define BP_LPUART_BAUD_OSR   (24U)         /*!< Bit position for LPUART_BAUD_OSR. */
#define BM_LPUART_BAUD_OSR   (0x1F000000U) /*!< Bit mask for LPUART_BAUD_OSR. */
#define BS_LPUART_BAUD_OSR   (5U)          /*!< Bit field size in bits for LPUART_BAUD_OSR. */

/*! @brief Read current value of the LPUART_BAUD_OSR field. */
#define BR_LPUART_BAUD_OSR(x) (HW_LPUART_BAUD(x).B.OSR)

/*! @brief Format value for bitfield LPUART_BAUD_OSR. */
#define BF_LPUART_BAUD_OSR(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_OSR) & BM_LPUART_BAUD_OSR)

/*! @brief Set the OSR field to a new value. */
#define BW_LPUART_BAUD_OSR(x, v) (HW_LPUART_BAUD_WR(x, (HW_LPUART_BAUD_RD(x) & ~BM_LPUART_BAUD_OSR) | BF_LPUART_BAUD_OSR(v)))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field M10[29] (RW)
 *
 * The M10 bit causes a tenth bit to be part of the serial transmission. This
 * bit should only be changed when the transmitter and receiver are both disabled.
 *
 * Values:
 * - 0 - Receiver and transmitter use 8-bit or 9-bit data characters.
 * - 1 - Receiver and transmitter use 10-bit data characters.
 */
/*@{*/
#define BP_LPUART_BAUD_M10   (29U)         /*!< Bit position for LPUART_BAUD_M10. */
#define BM_LPUART_BAUD_M10   (0x20000000U) /*!< Bit mask for LPUART_BAUD_M10. */
#define BS_LPUART_BAUD_M10   (1U)          /*!< Bit field size in bits for LPUART_BAUD_M10. */

/*! @brief Read current value of the LPUART_BAUD_M10 field. */
#define BR_LPUART_BAUD_M10(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_M10))

/*! @brief Format value for bitfield LPUART_BAUD_M10. */
#define BF_LPUART_BAUD_M10(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_M10) & BM_LPUART_BAUD_M10)

/*! @brief Set the M10 field to a new value. */
#define BW_LPUART_BAUD_M10(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_M10) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field MAEN2[30] (RW)
 *
 * Values:
 * - 0 - Normal operation.
 * - 1 - Enables automatic address matching or data matching mode for MATCH[MA2].
 */
/*@{*/
#define BP_LPUART_BAUD_MAEN2 (30U)         /*!< Bit position for LPUART_BAUD_MAEN2. */
#define BM_LPUART_BAUD_MAEN2 (0x40000000U) /*!< Bit mask for LPUART_BAUD_MAEN2. */
#define BS_LPUART_BAUD_MAEN2 (1U)          /*!< Bit field size in bits for LPUART_BAUD_MAEN2. */

/*! @brief Read current value of the LPUART_BAUD_MAEN2 field. */
#define BR_LPUART_BAUD_MAEN2(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_MAEN2))

/*! @brief Format value for bitfield LPUART_BAUD_MAEN2. */
#define BF_LPUART_BAUD_MAEN2(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_MAEN2) & BM_LPUART_BAUD_MAEN2)

/*! @brief Set the MAEN2 field to a new value. */
#define BW_LPUART_BAUD_MAEN2(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_MAEN2) = (v))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field MAEN1[31] (RW)
 *
 * Values:
 * - 0 - Normal operation.
 * - 1 - Enables automatic address matching or data matching mode for MATCH[MA1].
 */
/*@{*/
#define BP_LPUART_BAUD_MAEN1 (31U)         /*!< Bit position for LPUART_BAUD_MAEN1. */
#define BM_LPUART_BAUD_MAEN1 (0x80000000U) /*!< Bit mask for LPUART_BAUD_MAEN1. */
#define BS_LPUART_BAUD_MAEN1 (1U)          /*!< Bit field size in bits for LPUART_BAUD_MAEN1. */

/*! @brief Read current value of the LPUART_BAUD_MAEN1 field. */
#define BR_LPUART_BAUD_MAEN1(x) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_MAEN1))

/*! @brief Format value for bitfield LPUART_BAUD_MAEN1. */
#define BF_LPUART_BAUD_MAEN1(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_BAUD_MAEN1) & BM_LPUART_BAUD_MAEN1)

/*! @brief Set the MAEN1 field to a new value. */
#define BW_LPUART_BAUD_MAEN1(x, v) (BITBAND_ACCESS32(HW_LPUART_BAUD_ADDR(x), BP_LPUART_BAUD_MAEN1) = (v))
/*@}*/

/*******************************************************************************
 * HW_LPUART_STAT - LPUART Status Register
 ******************************************************************************/

/*!
 * @brief HW_LPUART_STAT - LPUART Status Register (RW)
 *
 * Reset value: 0x00C00000U
 */
typedef union _hw_lpuart_stat
{
    uint32_t U;
    struct _hw_lpuart_stat_bitfields
    {
        uint32_t RESERVED0 : 14;       /*!< [13:0]  */
        uint32_t MA2F : 1;             /*!< [14] Match 2 Flag */
        uint32_t MA1F : 1;             /*!< [15] Match 1 Flag */
        uint32_t PF : 1;               /*!< [16] Parity Error Flag */
        uint32_t FE : 1;               /*!< [17] Framing Error Flag */
        uint32_t NF : 1;               /*!< [18] Noise Flag */
        uint32_t OR : 1;               /*!< [19] Receiver Overrun Flag */
        uint32_t IDLE : 1;             /*!< [20] Idle Line Flag */
        uint32_t RDRF : 1;             /*!< [21] Receive Data Register Full Flag */
        uint32_t TC : 1;               /*!< [22] Transmission Complete Flag */
        uint32_t TDRE : 1;             /*!< [23] Transmit Data Register Empty Flag */
        uint32_t RAF : 1;              /*!< [24] Receiver Active Flag */
        uint32_t LBKDE : 1;            /*!< [25] LIN Break Detection Enable */
        uint32_t BRK13 : 1;            /*!< [26] Break Character Generation Length */
        uint32_t RWUID : 1;            /*!< [27] Receive Wake Up Idle Detect */
        uint32_t RXINV : 1;            /*!< [28] Receive Data Inversion */
        uint32_t MSBF : 1;             /*!< [29] MSB First */
        uint32_t RXEDGIF : 1;          /*!< [30] LPUART_RX Pin Active Edge Interrupt
                                        * Flag */
        uint32_t LBKDIF : 1;           /*!< [31] LIN Break Detect Interrupt Flag */
    } B;
} hw_lpuart_stat_t;

/*!
 * @name Constants and macros for entire LPUART_STAT register
 */
/*@{*/
#define HW_LPUART_STAT_ADDR(x)   ((x) + 0x4U)

#define HW_LPUART_STAT(x)        (*(__IO hw_lpuart_stat_t *) HW_LPUART_STAT_ADDR(x))
#define HW_LPUART_STAT_RD(x)     (HW_LPUART_STAT(x).U)
#define HW_LPUART_STAT_WR(x, v)  (HW_LPUART_STAT(x).U = (v))
#define HW_LPUART_STAT_SET(x, v) (HW_LPUART_STAT_WR(x, HW_LPUART_STAT_RD(x) |  (v)))
#define HW_LPUART_STAT_CLR(x, v) (HW_LPUART_STAT_WR(x, HW_LPUART_STAT_RD(x) & ~(v)))
#define HW_LPUART_STAT_TOG(x, v) (HW_LPUART_STAT_WR(x, HW_LPUART_STAT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LPUART_STAT bitfields
 */

/*!
 * @name Register LPUART_STAT, field MA2F[14] (W1C)
 *
 * MA2F is set whenever the next character to be read from LPUART_DATA matches
 * MA2. To clear MA2F, write a logic one to the MA2F.
 *
 * Values:
 * - 0 - Received data is not equal to MA2
 * - 1 - Received data is equal to MA2
 */
/*@{*/
#define BP_LPUART_STAT_MA2F  (14U)         /*!< Bit position for LPUART_STAT_MA2F. */
#define BM_LPUART_STAT_MA2F  (0x00004000U) /*!< Bit mask for LPUART_STAT_MA2F. */
#define BS_LPUART_STAT_MA2F  (1U)          /*!< Bit field size in bits for LPUART_STAT_MA2F. */

/*! @brief Read current value of the LPUART_STAT_MA2F field. */
#define BR_LPUART_STAT_MA2F(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_MA2F))

/*! @brief Format value for bitfield LPUART_STAT_MA2F. */
#define BF_LPUART_STAT_MA2F(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_MA2F) & BM_LPUART_STAT_MA2F)

/*! @brief Set the MA2F field to a new value. */
#define BW_LPUART_STAT_MA2F(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_MA2F) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field MA1F[15] (W1C)
 *
 * MA1F is set whenever the next character to be read from LPUART_DATA matches
 * MA1. To clear MA1F, write a logic one to the MA1F.
 *
 * Values:
 * - 0 - Received data is not equal to MA1
 * - 1 - Received data is equal to MA1
 */
/*@{*/
#define BP_LPUART_STAT_MA1F  (15U)         /*!< Bit position for LPUART_STAT_MA1F. */
#define BM_LPUART_STAT_MA1F  (0x00008000U) /*!< Bit mask for LPUART_STAT_MA1F. */
#define BS_LPUART_STAT_MA1F  (1U)          /*!< Bit field size in bits for LPUART_STAT_MA1F. */

/*! @brief Read current value of the LPUART_STAT_MA1F field. */
#define BR_LPUART_STAT_MA1F(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_MA1F))

/*! @brief Format value for bitfield LPUART_STAT_MA1F. */
#define BF_LPUART_STAT_MA1F(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_MA1F) & BM_LPUART_STAT_MA1F)

/*! @brief Set the MA1F field to a new value. */
#define BW_LPUART_STAT_MA1F(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_MA1F) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field PF[16] (W1C)
 *
 * PF is set whenever the next character to be read from LPUART_DATA was
 * received when parity is enabled (PE = 1) and the parity bit in the received character
 * does not agree with the expected parity value. To clear PF, write a logic one
 * to the PF.
 *
 * Values:
 * - 0 - No parity error.
 * - 1 - Parity error.
 */
/*@{*/
#define BP_LPUART_STAT_PF    (16U)         /*!< Bit position for LPUART_STAT_PF. */
#define BM_LPUART_STAT_PF    (0x00010000U) /*!< Bit mask for LPUART_STAT_PF. */
#define BS_LPUART_STAT_PF    (1U)          /*!< Bit field size in bits for LPUART_STAT_PF. */

/*! @brief Read current value of the LPUART_STAT_PF field. */
#define BR_LPUART_STAT_PF(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_PF))

/*! @brief Format value for bitfield LPUART_STAT_PF. */
#define BF_LPUART_STAT_PF(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_PF) & BM_LPUART_STAT_PF)

/*! @brief Set the PF field to a new value. */
#define BW_LPUART_STAT_PF(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_PF) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field FE[17] (W1C)
 *
 * FE is set whenever the next character to be read from LPUART_DATA was
 * received with logic 0 detected where a stop bit was expected. To clear NF, write
 * logic one to the NF.
 *
 * Values:
 * - 0 - No framing error detected. This does not guarantee the framing is
 *     correct.
 * - 1 - Framing error.
 */
/*@{*/
#define BP_LPUART_STAT_FE    (17U)         /*!< Bit position for LPUART_STAT_FE. */
#define BM_LPUART_STAT_FE    (0x00020000U) /*!< Bit mask for LPUART_STAT_FE. */
#define BS_LPUART_STAT_FE    (1U)          /*!< Bit field size in bits for LPUART_STAT_FE. */

/*! @brief Read current value of the LPUART_STAT_FE field. */
#define BR_LPUART_STAT_FE(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_FE))

/*! @brief Format value for bitfield LPUART_STAT_FE. */
#define BF_LPUART_STAT_FE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_FE) & BM_LPUART_STAT_FE)

/*! @brief Set the FE field to a new value. */
#define BW_LPUART_STAT_FE(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_FE) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field NF[18] (W1C)
 *
 * The advanced sampling technique used in the receiver takes three samples in
 * each of the received bits. If any of these samples disagrees with the rest of
 * the samples within any bit time in the frame then noise is detected for that
 * character. NF is set whenever the next character to be read from LPUART_DATA was
 * received with noise detected within the character. To clear NF, write logic
 * one to the NF.
 *
 * Values:
 * - 0 - No noise detected.
 * - 1 - Noise detected in the received character in LPUART_DATA.
 */
/*@{*/
#define BP_LPUART_STAT_NF    (18U)         /*!< Bit position for LPUART_STAT_NF. */
#define BM_LPUART_STAT_NF    (0x00040000U) /*!< Bit mask for LPUART_STAT_NF. */
#define BS_LPUART_STAT_NF    (1U)          /*!< Bit field size in bits for LPUART_STAT_NF. */

/*! @brief Read current value of the LPUART_STAT_NF field. */
#define BR_LPUART_STAT_NF(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_NF))

/*! @brief Format value for bitfield LPUART_STAT_NF. */
#define BF_LPUART_STAT_NF(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_NF) & BM_LPUART_STAT_NF)

/*! @brief Set the NF field to a new value. */
#define BW_LPUART_STAT_NF(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_NF) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field OR[19] (W1C)
 *
 * OR is set when software fails to prevent the receive data register from
 * overflowing with data. The OR bit is set immediately after the stop bit has been
 * completely received for the dataword that overflows the buffer and all the other
 * error flags (FE, NF, and PF) are prevented from setting. The data in the
 * shift register is lost, but the data already in the LPUART data registers is not
 * affected. If LBKDE is enabled and a LIN Break is detected, the OR field asserts
 * if LBKDIF is not cleared before the next data character is received. While
 * the OR flag is set, no additional data is stored in the data buffer even if
 * sufficient room exists. To clear OR, write logic 1 to the OR flag.
 *
 * Values:
 * - 0 - No overrun.
 * - 1 - Receive overrun (new LPUART data lost).
 */
/*@{*/
#define BP_LPUART_STAT_OR    (19U)         /*!< Bit position for LPUART_STAT_OR. */
#define BM_LPUART_STAT_OR    (0x00080000U) /*!< Bit mask for LPUART_STAT_OR. */
#define BS_LPUART_STAT_OR    (1U)          /*!< Bit field size in bits for LPUART_STAT_OR. */

/*! @brief Read current value of the LPUART_STAT_OR field. */
#define BR_LPUART_STAT_OR(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_OR))

/*! @brief Format value for bitfield LPUART_STAT_OR. */
#define BF_LPUART_STAT_OR(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_OR) & BM_LPUART_STAT_OR)

/*! @brief Set the OR field to a new value. */
#define BW_LPUART_STAT_OR(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_OR) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field IDLE[20] (W1C)
 *
 * IDLE is set when the LPUART receive line becomes idle for a full character
 * time after a period of activity. When ILT is cleared, the receiver starts
 * counting idle bit times after the start bit. If the receive character is all 1s,
 * these bit times and the stop bits time count toward the full character time of
 * logic high, 10 to 13 bit times, needed for the receiver to detect an idle line.
 * When ILT is set, the receiver doesn't start counting idle bit times until
 * after the stop bits. The stop bits and any logic high bit times at the end of the
 * previous character do not count toward the full character time of logic high
 * needed for the receiver to detect an idle line. To clear IDLE, write logic 1 to
 * the IDLE flag. After IDLE has been cleared, it cannot become set again until
 * after a new character has been stored in the receive buffer or a LIN break
 * character has set the LBKDIF flag . IDLE is set only once even if the receive
 * line remains idle for an extended period.
 *
 * Values:
 * - 0 - No idle line detected.
 * - 1 - Idle line was detected.
 */
/*@{*/
#define BP_LPUART_STAT_IDLE  (20U)         /*!< Bit position for LPUART_STAT_IDLE. */
#define BM_LPUART_STAT_IDLE  (0x00100000U) /*!< Bit mask for LPUART_STAT_IDLE. */
#define BS_LPUART_STAT_IDLE  (1U)          /*!< Bit field size in bits for LPUART_STAT_IDLE. */

/*! @brief Read current value of the LPUART_STAT_IDLE field. */
#define BR_LPUART_STAT_IDLE(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_IDLE))

/*! @brief Format value for bitfield LPUART_STAT_IDLE. */
#define BF_LPUART_STAT_IDLE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_IDLE) & BM_LPUART_STAT_IDLE)

/*! @brief Set the IDLE field to a new value. */
#define BW_LPUART_STAT_IDLE(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_IDLE) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RDRF[21] (RO)
 *
 * RDRF is set when the receive buffer (LPUART_DATA) is full. To clear RDRF,
 * read the LPUART_DATA register. A character that is in the process of being
 * received does not cause a change in RDRF until the entire character is received.
 * Even if RDRF is set, the character will continue to be received until an overrun
 * condition occurs once the entire character is received.
 *
 * Values:
 * - 0 - Receive data buffer empty.
 * - 1 - Receive data buffer full.
 */
/*@{*/
#define BP_LPUART_STAT_RDRF  (21U)         /*!< Bit position for LPUART_STAT_RDRF. */
#define BM_LPUART_STAT_RDRF  (0x00200000U) /*!< Bit mask for LPUART_STAT_RDRF. */
#define BS_LPUART_STAT_RDRF  (1U)          /*!< Bit field size in bits for LPUART_STAT_RDRF. */

/*! @brief Read current value of the LPUART_STAT_RDRF field. */
#define BR_LPUART_STAT_RDRF(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_RDRF))
/*@}*/

/*!
 * @name Register LPUART_STAT, field TC[22] (RO)
 *
 * TC is cleared when there is a transmission in progress or when a preamble or
 * break character is loaded. TC is set when the transmit buffer is empty and no
 * data, preamble, or break character is being transmitted. When TC is set, the
 * transmit data output signal becomes idle (logic 1). TC is cleared by writing to
 * LPUART_DATA to transmit new data, queuing a preamble by clearing and then
 * setting LPUART_CTRL[TE], queuing a break character by writing 1 to
 * LPUART_CTRL[SBK].
 *
 * Values:
 * - 0 - Transmitter active (sending data, a preamble, or a break).
 * - 1 - Transmitter idle (transmission activity complete).
 */
/*@{*/
#define BP_LPUART_STAT_TC    (22U)         /*!< Bit position for LPUART_STAT_TC. */
#define BM_LPUART_STAT_TC    (0x00400000U) /*!< Bit mask for LPUART_STAT_TC. */
#define BS_LPUART_STAT_TC    (1U)          /*!< Bit field size in bits for LPUART_STAT_TC. */

/*! @brief Read current value of the LPUART_STAT_TC field. */
#define BR_LPUART_STAT_TC(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_TC))
/*@}*/

/*!
 * @name Register LPUART_STAT, field TDRE[23] (RO)
 *
 * TDRE will set when the transmit data register (LPUART_DATA) is empty. To
 * clear TDRE, write to the LPUART data register (LPUART_DATA). TDRE is not affected
 * by a character that is in the process of being transmitted, it is updated at
 * the start of each transmitted character.
 *
 * Values:
 * - 0 - Transmit data buffer full.
 * - 1 - Transmit data buffer empty.
 */
/*@{*/
#define BP_LPUART_STAT_TDRE  (23U)         /*!< Bit position for LPUART_STAT_TDRE. */
#define BM_LPUART_STAT_TDRE  (0x00800000U) /*!< Bit mask for LPUART_STAT_TDRE. */
#define BS_LPUART_STAT_TDRE  (1U)          /*!< Bit field size in bits for LPUART_STAT_TDRE. */

/*! @brief Read current value of the LPUART_STAT_TDRE field. */
#define BR_LPUART_STAT_TDRE(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_TDRE))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RAF[24] (RO)
 *
 * RAF is set when the receiver detects the beginning of a valid start bit, and
 * RAF is cleared automatically when the receiver detects an idle line.
 *
 * Values:
 * - 0 - LPUART receiver idle waiting for a start bit.
 * - 1 - LPUART receiver active (LPUART_RX input not idle).
 */
/*@{*/
#define BP_LPUART_STAT_RAF   (24U)         /*!< Bit position for LPUART_STAT_RAF. */
#define BM_LPUART_STAT_RAF   (0x01000000U) /*!< Bit mask for LPUART_STAT_RAF. */
#define BS_LPUART_STAT_RAF   (1U)          /*!< Bit field size in bits for LPUART_STAT_RAF. */

/*! @brief Read current value of the LPUART_STAT_RAF field. */
#define BR_LPUART_STAT_RAF(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_RAF))
/*@}*/

/*!
 * @name Register LPUART_STAT, field LBKDE[25] (RW)
 *
 * LBKDE selects a longer break character detection length. While LBKDE is set,
 * receive data is not stored in the receive data buffer.
 *
 * Values:
 * - 0 - Break character is detected at length 10 bit times (if M = 0, SBNS = 0)
 *     or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1, SBNS = 1
 *     or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
 * - 1 - Break character is detected at length of 11 bit times (if M = 0, SBNS =
 *     0) or 12 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 14 (if M = 1, SBNS =
 *     1 or M10 = 1, SNBS = 0) or 15 (if M10 = 1, SNBS = 1).
 */
/*@{*/
#define BP_LPUART_STAT_LBKDE (25U)         /*!< Bit position for LPUART_STAT_LBKDE. */
#define BM_LPUART_STAT_LBKDE (0x02000000U) /*!< Bit mask for LPUART_STAT_LBKDE. */
#define BS_LPUART_STAT_LBKDE (1U)          /*!< Bit field size in bits for LPUART_STAT_LBKDE. */

/*! @brief Read current value of the LPUART_STAT_LBKDE field. */
#define BR_LPUART_STAT_LBKDE(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_LBKDE))

/*! @brief Format value for bitfield LPUART_STAT_LBKDE. */
#define BF_LPUART_STAT_LBKDE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_LBKDE) & BM_LPUART_STAT_LBKDE)

/*! @brief Set the LBKDE field to a new value. */
#define BW_LPUART_STAT_LBKDE(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_LBKDE) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field BRK13[26] (RW)
 *
 * BRK13 selects a longer transmitted break character length. Detection of a
 * framing error is not affected by the state of this bit. This bit should only be
 * changed when the transmitter is disabled.
 *
 * Values:
 * - 0 - Break character is transmitted with length of 10 bit times (if M = 0,
 *     SBNS = 0) or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1,
 *     SBNS = 1 or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
 * - 1 - Break character is transmitted with length of 13 bit times (if M = 0,
 *     SBNS = 0) or 14 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 15 (if M = 1,
 *     SBNS = 1 or M10 = 1, SNBS = 0) or 16 (if M10 = 1, SNBS = 1).
 */
/*@{*/
#define BP_LPUART_STAT_BRK13 (26U)         /*!< Bit position for LPUART_STAT_BRK13. */
#define BM_LPUART_STAT_BRK13 (0x04000000U) /*!< Bit mask for LPUART_STAT_BRK13. */
#define BS_LPUART_STAT_BRK13 (1U)          /*!< Bit field size in bits for LPUART_STAT_BRK13. */

/*! @brief Read current value of the LPUART_STAT_BRK13 field. */
#define BR_LPUART_STAT_BRK13(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_BRK13))

/*! @brief Format value for bitfield LPUART_STAT_BRK13. */
#define BF_LPUART_STAT_BRK13(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_BRK13) & BM_LPUART_STAT_BRK13)

/*! @brief Set the BRK13 field to a new value. */
#define BW_LPUART_STAT_BRK13(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_BRK13) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RWUID[27] (RW)
 *
 * For RWU on idle character, RWUID controls whether the idle character that
 * wakes up the receiver sets the IDLE bit. For address match wakeup, RWUID controls
 * if the IDLE bit is set when the address does not match. This bit should only
 * be changed when the receiver is disabled.
 *
 * Values:
 * - 0 - During receive standby state (RWU = 1), the IDLE bit does not get set
 *     upon detection of an idle character. During address match wakeup, the IDLE
 *     bit does not get set when an address does not match.
 * - 1 - During receive standby state (RWU = 1), the IDLE bit gets set upon
 *     detection of an idle character. During address match wakeup, the IDLE bit does
 *     get set when an address does not match.
 */
/*@{*/
#define BP_LPUART_STAT_RWUID (27U)         /*!< Bit position for LPUART_STAT_RWUID. */
#define BM_LPUART_STAT_RWUID (0x08000000U) /*!< Bit mask for LPUART_STAT_RWUID. */
#define BS_LPUART_STAT_RWUID (1U)          /*!< Bit field size in bits for LPUART_STAT_RWUID. */

/*! @brief Read current value of the LPUART_STAT_RWUID field. */
#define BR_LPUART_STAT_RWUID(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_RWUID))

/*! @brief Format value for bitfield LPUART_STAT_RWUID. */
#define BF_LPUART_STAT_RWUID(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_RWUID) & BM_LPUART_STAT_RWUID)

/*! @brief Set the RWUID field to a new value. */
#define BW_LPUART_STAT_RWUID(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_RWUID) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RXINV[28] (RW)
 *
 * Setting this bit reverses the polarity of the received data input. Setting
 * RXINV inverts the LPUART_RX input for all cases: data bits, start and stop bits,
 * break, and idle.
 *
 * Values:
 * - 0 - Receive data not inverted.
 * - 1 - Receive data inverted.
 */
/*@{*/
#define BP_LPUART_STAT_RXINV (28U)         /*!< Bit position for LPUART_STAT_RXINV. */
#define BM_LPUART_STAT_RXINV (0x10000000U) /*!< Bit mask for LPUART_STAT_RXINV. */
#define BS_LPUART_STAT_RXINV (1U)          /*!< Bit field size in bits for LPUART_STAT_RXINV. */

/*! @brief Read current value of the LPUART_STAT_RXINV field. */
#define BR_LPUART_STAT_RXINV(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_RXINV))

/*! @brief Format value for bitfield LPUART_STAT_RXINV. */
#define BF_LPUART_STAT_RXINV(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_RXINV) & BM_LPUART_STAT_RXINV)

/*! @brief Set the RXINV field to a new value. */
#define BW_LPUART_STAT_RXINV(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_RXINV) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field MSBF[29] (RW)
 *
 * Setting this bit reverses the order of the bits that are transmitted and
 * received on the wire. This bit does not affect the polarity of the bits, the
 * location of the parity bit or the location of the start or stop bits. This bit
 * should only be changed when the transmitter and receiver are both disabled.
 *
 * Values:
 * - 0 - LSB (bit0) is the first bit that is transmitted following the start
 *     bit. Further, the first bit received after the start bit is identified as
 *     bit0.
 * - 1 - MSB (bit9, bit8, bit7 or bit6) is the first bit that is transmitted
 *     following the start bit depending on the setting of CTRL[M], CTRL[PE] and
 *     BAUD[M10]. Further, the first bit received after the start bit is identified
 *     as bit9, bit8, bit7 or bit6 depending on the setting of CTRL[M] and
 *     CTRL[PE].
 */
/*@{*/
#define BP_LPUART_STAT_MSBF  (29U)         /*!< Bit position for LPUART_STAT_MSBF. */
#define BM_LPUART_STAT_MSBF  (0x20000000U) /*!< Bit mask for LPUART_STAT_MSBF. */
#define BS_LPUART_STAT_MSBF  (1U)          /*!< Bit field size in bits for LPUART_STAT_MSBF. */

/*! @brief Read current value of the LPUART_STAT_MSBF field. */
#define BR_LPUART_STAT_MSBF(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_MSBF))

/*! @brief Format value for bitfield LPUART_STAT_MSBF. */
#define BF_LPUART_STAT_MSBF(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_MSBF) & BM_LPUART_STAT_MSBF)

/*! @brief Set the MSBF field to a new value. */
#define BW_LPUART_STAT_MSBF(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_MSBF) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RXEDGIF[30] (W1C)
 *
 * RXEDGIF is set when an active edge, falling if RXINV = 0, rising if RXINV=1,
 * on the LPUART_RX pin occurs. RXEDGIF is cleared by writing a 1 to it.
 *
 * Values:
 * - 0 - No active edge on the receive pin has occurred.
 * - 1 - An active edge on the receive pin has occurred.
 */
/*@{*/
#define BP_LPUART_STAT_RXEDGIF (30U)       /*!< Bit position for LPUART_STAT_RXEDGIF. */
#define BM_LPUART_STAT_RXEDGIF (0x40000000U) /*!< Bit mask for LPUART_STAT_RXEDGIF. */
#define BS_LPUART_STAT_RXEDGIF (1U)        /*!< Bit field size in bits for LPUART_STAT_RXEDGIF. */

/*! @brief Read current value of the LPUART_STAT_RXEDGIF field. */
#define BR_LPUART_STAT_RXEDGIF(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_RXEDGIF))

/*! @brief Format value for bitfield LPUART_STAT_RXEDGIF. */
#define BF_LPUART_STAT_RXEDGIF(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_RXEDGIF) & BM_LPUART_STAT_RXEDGIF)

/*! @brief Set the RXEDGIF field to a new value. */
#define BW_LPUART_STAT_RXEDGIF(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_RXEDGIF) = (v))
/*@}*/

/*!
 * @name Register LPUART_STAT, field LBKDIF[31] (W1C)
 *
 * LBKDIF is set when the LIN break detect circuitry is enabled and a LIN break
 * character is detected. LBKDIF is cleared by writing a 1 to it.
 *
 * Values:
 * - 0 - No LIN break character has been detected.
 * - 1 - LIN break character has been detected.
 */
/*@{*/
#define BP_LPUART_STAT_LBKDIF (31U)        /*!< Bit position for LPUART_STAT_LBKDIF. */
#define BM_LPUART_STAT_LBKDIF (0x80000000U) /*!< Bit mask for LPUART_STAT_LBKDIF. */
#define BS_LPUART_STAT_LBKDIF (1U)         /*!< Bit field size in bits for LPUART_STAT_LBKDIF. */

/*! @brief Read current value of the LPUART_STAT_LBKDIF field. */
#define BR_LPUART_STAT_LBKDIF(x) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_LBKDIF))

/*! @brief Format value for bitfield LPUART_STAT_LBKDIF. */
#define BF_LPUART_STAT_LBKDIF(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_STAT_LBKDIF) & BM_LPUART_STAT_LBKDIF)

/*! @brief Set the LBKDIF field to a new value. */
#define BW_LPUART_STAT_LBKDIF(x, v) (BITBAND_ACCESS32(HW_LPUART_STAT_ADDR(x), BP_LPUART_STAT_LBKDIF) = (v))
/*@}*/

/*******************************************************************************
 * HW_LPUART_CTRL - LPUART Control Register
 ******************************************************************************/

/*!
 * @brief HW_LPUART_CTRL - LPUART Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This read/write register controls various optional features of the LPUART
 * system. This register should only be altered when the transmitter and receiver
 * are both disabled.
 */
typedef union _hw_lpuart_ctrl
{
    uint32_t U;
    struct _hw_lpuart_ctrl_bitfields
    {
        uint32_t PT : 1;               /*!< [0] Parity Type */
        uint32_t PE : 1;               /*!< [1] Parity Enable */
        uint32_t ILT : 1;              /*!< [2] Idle Line Type Select */
        uint32_t WAKE : 1;             /*!< [3] Receiver Wakeup Method Select */
        uint32_t M : 1;                /*!< [4] 9-Bit or 8-Bit Mode Select */
        uint32_t RSRC : 1;             /*!< [5] Receiver Source Select */
        uint32_t DOZEEN : 1;           /*!< [6] Doze Enable */
        uint32_t LOOPS : 1;            /*!< [7] Loop Mode Select */
        uint32_t IDLECFG : 3;          /*!< [10:8] Idle Configuration */
        uint32_t RESERVED0 : 3;        /*!< [13:11]  */
        uint32_t MA2IE : 1;            /*!< [14] Match 2 Interrupt Enable */
        uint32_t MA1IE : 1;            /*!< [15] Match 1 Interrupt Enable */
        uint32_t SBK : 1;              /*!< [16] Send Break */
        uint32_t RWU : 1;              /*!< [17] Receiver Wakeup Control */
        uint32_t RE : 1;               /*!< [18] Receiver Enable */
        uint32_t TE : 1;               /*!< [19] Transmitter Enable */
        uint32_t ILIE : 1;             /*!< [20] Idle Line Interrupt Enable */
        uint32_t RIE : 1;              /*!< [21] Receiver Interrupt Enable */
        uint32_t TCIE : 1;             /*!< [22] Transmission Complete Interrupt Enable
                                        * for */
        uint32_t TIE : 1;              /*!< [23] Transmit Interrupt Enable */
        uint32_t PEIE : 1;             /*!< [24] Parity Error Interrupt Enable */
        uint32_t FEIE : 1;             /*!< [25] Framing Error Interrupt Enable */
        uint32_t NEIE : 1;             /*!< [26] Noise Error Interrupt Enable */
        uint32_t ORIE : 1;             /*!< [27] Overrun Interrupt Enable */
        uint32_t TXINV : 1;            /*!< [28] Transmit Data Inversion */
        uint32_t TXDIR : 1;            /*!< [29] LPUART_TX Pin Direction in Single-Wire
                                        * Mode */
        uint32_t R9T8 : 1;             /*!< [30] Receive Bit 9 / Transmit Bit 8 */
        uint32_t R8T9 : 1;             /*!< [31] Receive Bit 8 / Transmit Bit 9 */
    } B;
} hw_lpuart_ctrl_t;

/*!
 * @name Constants and macros for entire LPUART_CTRL register
 */
/*@{*/
#define HW_LPUART_CTRL_ADDR(x)   ((x) + 0x8U)

#define HW_LPUART_CTRL(x)        (*(__IO hw_lpuart_ctrl_t *) HW_LPUART_CTRL_ADDR(x))
#define HW_LPUART_CTRL_RD(x)     (HW_LPUART_CTRL(x).U)
#define HW_LPUART_CTRL_WR(x, v)  (HW_LPUART_CTRL(x).U = (v))
#define HW_LPUART_CTRL_SET(x, v) (HW_LPUART_CTRL_WR(x, HW_LPUART_CTRL_RD(x) |  (v)))
#define HW_LPUART_CTRL_CLR(x, v) (HW_LPUART_CTRL_WR(x, HW_LPUART_CTRL_RD(x) & ~(v)))
#define HW_LPUART_CTRL_TOG(x, v) (HW_LPUART_CTRL_WR(x, HW_LPUART_CTRL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LPUART_CTRL bitfields
 */

/*!
 * @name Register LPUART_CTRL, field PT[0] (RW)
 *
 * Provided parity is enabled (PE = 1), this bit selects even or odd parity. Odd
 * parity means the total number of 1s in the data character, including the
 * parity bit, is odd. Even parity means the total number of 1s in the data
 * character, including the parity bit, is even.
 *
 * Values:
 * - 0 - Even parity.
 * - 1 - Odd parity.
 */
/*@{*/
#define BP_LPUART_CTRL_PT    (0U)          /*!< Bit position for LPUART_CTRL_PT. */
#define BM_LPUART_CTRL_PT    (0x00000001U) /*!< Bit mask for LPUART_CTRL_PT. */
#define BS_LPUART_CTRL_PT    (1U)          /*!< Bit field size in bits for LPUART_CTRL_PT. */

/*! @brief Read current value of the LPUART_CTRL_PT field. */
#define BR_LPUART_CTRL_PT(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_PT))

/*! @brief Format value for bitfield LPUART_CTRL_PT. */
#define BF_LPUART_CTRL_PT(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_PT) & BM_LPUART_CTRL_PT)

/*! @brief Set the PT field to a new value. */
#define BW_LPUART_CTRL_PT(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_PT) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field PE[1] (RW)
 *
 * Enables hardware parity generation and checking. When parity is enabled, the
 * bit immediately before the stop bit is treated as the parity bit.
 *
 * Values:
 * - 0 - No hardware parity generation or checking.
 * - 1 - Parity enabled.
 */
/*@{*/
#define BP_LPUART_CTRL_PE    (1U)          /*!< Bit position for LPUART_CTRL_PE. */
#define BM_LPUART_CTRL_PE    (0x00000002U) /*!< Bit mask for LPUART_CTRL_PE. */
#define BS_LPUART_CTRL_PE    (1U)          /*!< Bit field size in bits for LPUART_CTRL_PE. */

/*! @brief Read current value of the LPUART_CTRL_PE field. */
#define BR_LPUART_CTRL_PE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_PE))

/*! @brief Format value for bitfield LPUART_CTRL_PE. */
#define BF_LPUART_CTRL_PE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_PE) & BM_LPUART_CTRL_PE)

/*! @brief Set the PE field to a new value. */
#define BW_LPUART_CTRL_PE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_PE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field ILT[2] (RW)
 *
 * Determines when the receiver starts counting logic 1s as idle character bits.
 * The count begins either after a valid start bit or after the stop bit. If the
 * count begins after the start bit, then a string of logic 1s preceding the
 * stop bit can cause false recognition of an idle character. Beginning the count
 * after the stop bit avoids false idle character recognition, but requires
 * properly synchronized transmissions. In case the LPUART is programmed with ILT = 1, a
 * logic 0 is automatically shifted after a received stop bit, therefore
 * resetting the idle count.
 *
 * Values:
 * - 0 - Idle character bit count starts after start bit.
 * - 1 - Idle character bit count starts after stop bit.
 */
/*@{*/
#define BP_LPUART_CTRL_ILT   (2U)          /*!< Bit position for LPUART_CTRL_ILT. */
#define BM_LPUART_CTRL_ILT   (0x00000004U) /*!< Bit mask for LPUART_CTRL_ILT. */
#define BS_LPUART_CTRL_ILT   (1U)          /*!< Bit field size in bits for LPUART_CTRL_ILT. */

/*! @brief Read current value of the LPUART_CTRL_ILT field. */
#define BR_LPUART_CTRL_ILT(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_ILT))

/*! @brief Format value for bitfield LPUART_CTRL_ILT. */
#define BF_LPUART_CTRL_ILT(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_ILT) & BM_LPUART_CTRL_ILT)

/*! @brief Set the ILT field to a new value. */
#define BW_LPUART_CTRL_ILT(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_ILT) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field WAKE[3] (RW)
 *
 * Determines which condition wakes the LPUART when RWU=1: Address mark in the
 * most significant bit position of a received data character, or An idle
 * condition on the receive pin input signal.
 *
 * Values:
 * - 0 - Configures RWU for idle-line wakeup.
 * - 1 - Configures RWU with address-mark wakeup.
 */
/*@{*/
#define BP_LPUART_CTRL_WAKE  (3U)          /*!< Bit position for LPUART_CTRL_WAKE. */
#define BM_LPUART_CTRL_WAKE  (0x00000008U) /*!< Bit mask for LPUART_CTRL_WAKE. */
#define BS_LPUART_CTRL_WAKE  (1U)          /*!< Bit field size in bits for LPUART_CTRL_WAKE. */

/*! @brief Read current value of the LPUART_CTRL_WAKE field. */
#define BR_LPUART_CTRL_WAKE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_WAKE))

/*! @brief Format value for bitfield LPUART_CTRL_WAKE. */
#define BF_LPUART_CTRL_WAKE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_WAKE) & BM_LPUART_CTRL_WAKE)

/*! @brief Set the WAKE field to a new value. */
#define BW_LPUART_CTRL_WAKE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_WAKE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field M[4] (RW)
 *
 * Values:
 * - 0 - Receiver and transmitter use 8-bit data characters.
 * - 1 - Receiver and transmitter use 9-bit data characters.
 */
/*@{*/
#define BP_LPUART_CTRL_M     (4U)          /*!< Bit position for LPUART_CTRL_M. */
#define BM_LPUART_CTRL_M     (0x00000010U) /*!< Bit mask for LPUART_CTRL_M. */
#define BS_LPUART_CTRL_M     (1U)          /*!< Bit field size in bits for LPUART_CTRL_M. */

/*! @brief Read current value of the LPUART_CTRL_M field. */
#define BR_LPUART_CTRL_M(x)  (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_M))

/*! @brief Format value for bitfield LPUART_CTRL_M. */
#define BF_LPUART_CTRL_M(v)  ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_M) & BM_LPUART_CTRL_M)

/*! @brief Set the M field to a new value. */
#define BW_LPUART_CTRL_M(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_M) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field RSRC[5] (RW)
 *
 * This field has no meaning or effect unless the LOOPS field is set. When LOOPS
 * is set, the RSRC field determines the source for the receiver shift register
 * input.
 *
 * Values:
 * - 0 - Provided LOOPS is set, RSRC is cleared, selects internal loop back mode
 *     and the LPUART does not use the LPUART_RX pin.
 * - 1 - Single-wire LPUART mode where the LPUART_TX pin is connected to the
 *     transmitter output and receiver input.
 */
/*@{*/
#define BP_LPUART_CTRL_RSRC  (5U)          /*!< Bit position for LPUART_CTRL_RSRC. */
#define BM_LPUART_CTRL_RSRC  (0x00000020U) /*!< Bit mask for LPUART_CTRL_RSRC. */
#define BS_LPUART_CTRL_RSRC  (1U)          /*!< Bit field size in bits for LPUART_CTRL_RSRC. */

/*! @brief Read current value of the LPUART_CTRL_RSRC field. */
#define BR_LPUART_CTRL_RSRC(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_RSRC))

/*! @brief Format value for bitfield LPUART_CTRL_RSRC. */
#define BF_LPUART_CTRL_RSRC(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_RSRC) & BM_LPUART_CTRL_RSRC)

/*! @brief Set the RSRC field to a new value. */
#define BW_LPUART_CTRL_RSRC(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_RSRC) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field DOZEEN[6] (RW)
 *
 * Values:
 * - 0 - LPUART is enabled in Doze mode.
 * - 1 - LPUART is disabled in Doze mode.
 */
/*@{*/
#define BP_LPUART_CTRL_DOZEEN (6U)         /*!< Bit position for LPUART_CTRL_DOZEEN. */
#define BM_LPUART_CTRL_DOZEEN (0x00000040U) /*!< Bit mask for LPUART_CTRL_DOZEEN. */
#define BS_LPUART_CTRL_DOZEEN (1U)         /*!< Bit field size in bits for LPUART_CTRL_DOZEEN. */

/*! @brief Read current value of the LPUART_CTRL_DOZEEN field. */
#define BR_LPUART_CTRL_DOZEEN(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_DOZEEN))

/*! @brief Format value for bitfield LPUART_CTRL_DOZEEN. */
#define BF_LPUART_CTRL_DOZEEN(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_DOZEEN) & BM_LPUART_CTRL_DOZEEN)

/*! @brief Set the DOZEEN field to a new value. */
#define BW_LPUART_CTRL_DOZEEN(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_DOZEEN) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field LOOPS[7] (RW)
 *
 * When LOOPS is set, the LPUART_RX pin is disconnected from the LPUART and the
 * transmitter output is internally connected to the receiver input. The
 * transmitter and the receiver must be enabled to use the loop function.
 *
 * Values:
 * - 0 - Normal operation - LPUART_RX and LPUART_TX use separate pins.
 * - 1 - Loop mode or single-wire mode where transmitter outputs are internally
 *     connected to receiver input (see RSRC bit).
 */
/*@{*/
#define BP_LPUART_CTRL_LOOPS (7U)          /*!< Bit position for LPUART_CTRL_LOOPS. */
#define BM_LPUART_CTRL_LOOPS (0x00000080U) /*!< Bit mask for LPUART_CTRL_LOOPS. */
#define BS_LPUART_CTRL_LOOPS (1U)          /*!< Bit field size in bits for LPUART_CTRL_LOOPS. */

/*! @brief Read current value of the LPUART_CTRL_LOOPS field. */
#define BR_LPUART_CTRL_LOOPS(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_LOOPS))

/*! @brief Format value for bitfield LPUART_CTRL_LOOPS. */
#define BF_LPUART_CTRL_LOOPS(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_LOOPS) & BM_LPUART_CTRL_LOOPS)

/*! @brief Set the LOOPS field to a new value. */
#define BW_LPUART_CTRL_LOOPS(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_LOOPS) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field IDLECFG[10:8] (RW)
 *
 * Configures the number of idle characters that must be received before the
 * IDLE flag is set.
 *
 * Values:
 * - 000 - 1 idle character
 * - 001 - 2 idle characters
 * - 010 - 4 idle characters
 * - 011 - 8 idle characters
 * - 100 - 16 idle characters
 * - 101 - 32 idle characters
 * - 110 - 64 idle characters
 * - 111 - 128 idle characters
 */
/*@{*/
#define BP_LPUART_CTRL_IDLECFG (8U)        /*!< Bit position for LPUART_CTRL_IDLECFG. */
#define BM_LPUART_CTRL_IDLECFG (0x00000700U) /*!< Bit mask for LPUART_CTRL_IDLECFG. */
#define BS_LPUART_CTRL_IDLECFG (3U)        /*!< Bit field size in bits for LPUART_CTRL_IDLECFG. */

/*! @brief Read current value of the LPUART_CTRL_IDLECFG field. */
#define BR_LPUART_CTRL_IDLECFG(x) (HW_LPUART_CTRL(x).B.IDLECFG)

/*! @brief Format value for bitfield LPUART_CTRL_IDLECFG. */
#define BF_LPUART_CTRL_IDLECFG(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_IDLECFG) & BM_LPUART_CTRL_IDLECFG)

/*! @brief Set the IDLECFG field to a new value. */
#define BW_LPUART_CTRL_IDLECFG(x, v) (HW_LPUART_CTRL_WR(x, (HW_LPUART_CTRL_RD(x) & ~BM_LPUART_CTRL_IDLECFG) | BF_LPUART_CTRL_IDLECFG(v)))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field MA2IE[14] (RW)
 *
 * Values:
 * - 0 - MA2F interrupt disabled
 * - 1 - MA2F interrupt enabled
 */
/*@{*/
#define BP_LPUART_CTRL_MA2IE (14U)         /*!< Bit position for LPUART_CTRL_MA2IE. */
#define BM_LPUART_CTRL_MA2IE (0x00004000U) /*!< Bit mask for LPUART_CTRL_MA2IE. */
#define BS_LPUART_CTRL_MA2IE (1U)          /*!< Bit field size in bits for LPUART_CTRL_MA2IE. */

/*! @brief Read current value of the LPUART_CTRL_MA2IE field. */
#define BR_LPUART_CTRL_MA2IE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_MA2IE))

/*! @brief Format value for bitfield LPUART_CTRL_MA2IE. */
#define BF_LPUART_CTRL_MA2IE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_MA2IE) & BM_LPUART_CTRL_MA2IE)

/*! @brief Set the MA2IE field to a new value. */
#define BW_LPUART_CTRL_MA2IE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_MA2IE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field MA1IE[15] (RW)
 *
 * Values:
 * - 0 - MA1F interrupt disabled
 * - 1 - MA1F interrupt enabled
 */
/*@{*/
#define BP_LPUART_CTRL_MA1IE (15U)         /*!< Bit position for LPUART_CTRL_MA1IE. */
#define BM_LPUART_CTRL_MA1IE (0x00008000U) /*!< Bit mask for LPUART_CTRL_MA1IE. */
#define BS_LPUART_CTRL_MA1IE (1U)          /*!< Bit field size in bits for LPUART_CTRL_MA1IE. */

/*! @brief Read current value of the LPUART_CTRL_MA1IE field. */
#define BR_LPUART_CTRL_MA1IE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_MA1IE))

/*! @brief Format value for bitfield LPUART_CTRL_MA1IE. */
#define BF_LPUART_CTRL_MA1IE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_MA1IE) & BM_LPUART_CTRL_MA1IE)

/*! @brief Set the MA1IE field to a new value. */
#define BW_LPUART_CTRL_MA1IE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_MA1IE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field SBK[16] (RW)
 *
 * Writing a 1 and then a 0 to SBK queues a break character in the transmit data
 * stream. Additional break characters of 10 to 13, or 13 to 16 if
 * LPUART_STATBRK13] is set, bit times of logic 0 are queued as long as SBK is set. Depending
 * on the timing of the set and clear of SBK relative to the information
 * currently being transmitted, a second break character may be queued before software
 * clears SBK.
 *
 * Values:
 * - 0 - Normal transmitter operation.
 * - 1 - Queue break character(s) to be sent.
 */
/*@{*/
#define BP_LPUART_CTRL_SBK   (16U)         /*!< Bit position for LPUART_CTRL_SBK. */
#define BM_LPUART_CTRL_SBK   (0x00010000U) /*!< Bit mask for LPUART_CTRL_SBK. */
#define BS_LPUART_CTRL_SBK   (1U)          /*!< Bit field size in bits for LPUART_CTRL_SBK. */

/*! @brief Read current value of the LPUART_CTRL_SBK field. */
#define BR_LPUART_CTRL_SBK(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_SBK))

/*! @brief Format value for bitfield LPUART_CTRL_SBK. */
#define BF_LPUART_CTRL_SBK(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_SBK) & BM_LPUART_CTRL_SBK)

/*! @brief Set the SBK field to a new value. */
#define BW_LPUART_CTRL_SBK(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_SBK) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field RWU[17] (RW)
 *
 * This field can be set to place the LPUART receiver in a standby state. RWU
 * automatically clears when an RWU event occurs, that is, an IDLE event when
 * CTRL[WAKE] is clear or an address match when CTRL[WAKE] is set with STAT[RWUID] is
 * clear. RWU must be set only with CTRL[WAKE] = 0 (wakeup on idle) if the
 * channel is currently not idle. This can be determined by STAT[RAF]. If the flag is
 * set to wake up an IDLE event and the channel is already idle, it is possible
 * that the LPUART will discard data. This is because the data must be received or
 * a LIN break detected after an IDLE is detected before IDLE is allowed to
 * reasserted.
 *
 * Values:
 * - 0 - Normal receiver operation.
 * - 1 - LPUART receiver in standby waiting for wakeup condition.
 */
/*@{*/
#define BP_LPUART_CTRL_RWU   (17U)         /*!< Bit position for LPUART_CTRL_RWU. */
#define BM_LPUART_CTRL_RWU   (0x00020000U) /*!< Bit mask for LPUART_CTRL_RWU. */
#define BS_LPUART_CTRL_RWU   (1U)          /*!< Bit field size in bits for LPUART_CTRL_RWU. */

/*! @brief Read current value of the LPUART_CTRL_RWU field. */
#define BR_LPUART_CTRL_RWU(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_RWU))

/*! @brief Format value for bitfield LPUART_CTRL_RWU. */
#define BF_LPUART_CTRL_RWU(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_RWU) & BM_LPUART_CTRL_RWU)

/*! @brief Set the RWU field to a new value. */
#define BW_LPUART_CTRL_RWU(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_RWU) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field RE[18] (RW)
 *
 * Enables the LPUART receiver. When RE is written to 0, this register bit will
 * read as 1 until the receiver finishes receiving the current character (if any).
 *
 * Values:
 * - 0 - Receiver disabled.
 * - 1 - Receiver enabled.
 */
/*@{*/
#define BP_LPUART_CTRL_RE    (18U)         /*!< Bit position for LPUART_CTRL_RE. */
#define BM_LPUART_CTRL_RE    (0x00040000U) /*!< Bit mask for LPUART_CTRL_RE. */
#define BS_LPUART_CTRL_RE    (1U)          /*!< Bit field size in bits for LPUART_CTRL_RE. */

/*! @brief Read current value of the LPUART_CTRL_RE field. */
#define BR_LPUART_CTRL_RE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_RE))

/*! @brief Format value for bitfield LPUART_CTRL_RE. */
#define BF_LPUART_CTRL_RE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_RE) & BM_LPUART_CTRL_RE)

/*! @brief Set the RE field to a new value. */
#define BW_LPUART_CTRL_RE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_RE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TE[19] (RW)
 *
 * Enables the LPUART transmitter. TE can also be used to queue an idle preamble
 * by clearing and then setting TE. When TE is cleared, this register bit will
 * read as 1 until the transmitter has completed the current character and the
 * LPUART_TX pin is tristated.
 *
 * Values:
 * - 0 - Transmitter disabled.
 * - 1 - Transmitter enabled.
 */
/*@{*/
#define BP_LPUART_CTRL_TE    (19U)         /*!< Bit position for LPUART_CTRL_TE. */
#define BM_LPUART_CTRL_TE    (0x00080000U) /*!< Bit mask for LPUART_CTRL_TE. */
#define BS_LPUART_CTRL_TE    (1U)          /*!< Bit field size in bits for LPUART_CTRL_TE. */

/*! @brief Read current value of the LPUART_CTRL_TE field. */
#define BR_LPUART_CTRL_TE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TE))

/*! @brief Format value for bitfield LPUART_CTRL_TE. */
#define BF_LPUART_CTRL_TE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_TE) & BM_LPUART_CTRL_TE)

/*! @brief Set the TE field to a new value. */
#define BW_LPUART_CTRL_TE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field ILIE[20] (RW)
 *
 * ILIE enables the idle line flag, STAT[IDLE], to generate interrupt requests.
 *
 * Values:
 * - 0 - Hardware interrupts from IDLE disabled; use polling.
 * - 1 - Hardware interrupt requested when IDLE flag is 1.
 */
/*@{*/
#define BP_LPUART_CTRL_ILIE  (20U)         /*!< Bit position for LPUART_CTRL_ILIE. */
#define BM_LPUART_CTRL_ILIE  (0x00100000U) /*!< Bit mask for LPUART_CTRL_ILIE. */
#define BS_LPUART_CTRL_ILIE  (1U)          /*!< Bit field size in bits for LPUART_CTRL_ILIE. */

/*! @brief Read current value of the LPUART_CTRL_ILIE field. */
#define BR_LPUART_CTRL_ILIE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_ILIE))

/*! @brief Format value for bitfield LPUART_CTRL_ILIE. */
#define BF_LPUART_CTRL_ILIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_ILIE) & BM_LPUART_CTRL_ILIE)

/*! @brief Set the ILIE field to a new value. */
#define BW_LPUART_CTRL_ILIE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_ILIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field RIE[21] (RW)
 *
 * Enables STAT[RDRF] to generate interrupt requests.
 *
 * Values:
 * - 0 - Hardware interrupts from RDRF disabled; use polling.
 * - 1 - Hardware interrupt requested when RDRF flag is 1.
 */
/*@{*/
#define BP_LPUART_CTRL_RIE   (21U)         /*!< Bit position for LPUART_CTRL_RIE. */
#define BM_LPUART_CTRL_RIE   (0x00200000U) /*!< Bit mask for LPUART_CTRL_RIE. */
#define BS_LPUART_CTRL_RIE   (1U)          /*!< Bit field size in bits for LPUART_CTRL_RIE. */

/*! @brief Read current value of the LPUART_CTRL_RIE field. */
#define BR_LPUART_CTRL_RIE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_RIE))

/*! @brief Format value for bitfield LPUART_CTRL_RIE. */
#define BF_LPUART_CTRL_RIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_RIE) & BM_LPUART_CTRL_RIE)

/*! @brief Set the RIE field to a new value. */
#define BW_LPUART_CTRL_RIE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_RIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TCIE[22] (RW)
 *
 * TCIE enables the transmission complete flag, TC, to generate interrupt
 * requests.
 *
 * Values:
 * - 0 - Hardware interrupts from TC disabled; use polling.
 * - 1 - Hardware interrupt requested when TC flag is 1.
 */
/*@{*/
#define BP_LPUART_CTRL_TCIE  (22U)         /*!< Bit position for LPUART_CTRL_TCIE. */
#define BM_LPUART_CTRL_TCIE  (0x00400000U) /*!< Bit mask for LPUART_CTRL_TCIE. */
#define BS_LPUART_CTRL_TCIE  (1U)          /*!< Bit field size in bits for LPUART_CTRL_TCIE. */

/*! @brief Read current value of the LPUART_CTRL_TCIE field. */
#define BR_LPUART_CTRL_TCIE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TCIE))

/*! @brief Format value for bitfield LPUART_CTRL_TCIE. */
#define BF_LPUART_CTRL_TCIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_TCIE) & BM_LPUART_CTRL_TCIE)

/*! @brief Set the TCIE field to a new value. */
#define BW_LPUART_CTRL_TCIE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TCIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TIE[23] (RW)
 *
 * Enables STAT[TDRE] to generate interrupt requests.
 *
 * Values:
 * - 0 - Hardware interrupts from TDRE disabled; use polling.
 * - 1 - Hardware interrupt requested when TDRE flag is 1.
 */
/*@{*/
#define BP_LPUART_CTRL_TIE   (23U)         /*!< Bit position for LPUART_CTRL_TIE. */
#define BM_LPUART_CTRL_TIE   (0x00800000U) /*!< Bit mask for LPUART_CTRL_TIE. */
#define BS_LPUART_CTRL_TIE   (1U)          /*!< Bit field size in bits for LPUART_CTRL_TIE. */

/*! @brief Read current value of the LPUART_CTRL_TIE field. */
#define BR_LPUART_CTRL_TIE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TIE))

/*! @brief Format value for bitfield LPUART_CTRL_TIE. */
#define BF_LPUART_CTRL_TIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_TIE) & BM_LPUART_CTRL_TIE)

/*! @brief Set the TIE field to a new value. */
#define BW_LPUART_CTRL_TIE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field PEIE[24] (RW)
 *
 * This bit enables the parity error flag (PF) to generate hardware interrupt
 * requests.
 *
 * Values:
 * - 0 - PF interrupts disabled; use polling).
 * - 1 - Hardware interrupt requested when PF is set.
 */
/*@{*/
#define BP_LPUART_CTRL_PEIE  (24U)         /*!< Bit position for LPUART_CTRL_PEIE. */
#define BM_LPUART_CTRL_PEIE  (0x01000000U) /*!< Bit mask for LPUART_CTRL_PEIE. */
#define BS_LPUART_CTRL_PEIE  (1U)          /*!< Bit field size in bits for LPUART_CTRL_PEIE. */

/*! @brief Read current value of the LPUART_CTRL_PEIE field. */
#define BR_LPUART_CTRL_PEIE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_PEIE))

/*! @brief Format value for bitfield LPUART_CTRL_PEIE. */
#define BF_LPUART_CTRL_PEIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_PEIE) & BM_LPUART_CTRL_PEIE)

/*! @brief Set the PEIE field to a new value. */
#define BW_LPUART_CTRL_PEIE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_PEIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field FEIE[25] (RW)
 *
 * This bit enables the framing error flag (FE) to generate hardware interrupt
 * requests.
 *
 * Values:
 * - 0 - FE interrupts disabled; use polling.
 * - 1 - Hardware interrupt requested when FE is set.
 */
/*@{*/
#define BP_LPUART_CTRL_FEIE  (25U)         /*!< Bit position for LPUART_CTRL_FEIE. */
#define BM_LPUART_CTRL_FEIE  (0x02000000U) /*!< Bit mask for LPUART_CTRL_FEIE. */
#define BS_LPUART_CTRL_FEIE  (1U)          /*!< Bit field size in bits for LPUART_CTRL_FEIE. */

/*! @brief Read current value of the LPUART_CTRL_FEIE field. */
#define BR_LPUART_CTRL_FEIE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_FEIE))

/*! @brief Format value for bitfield LPUART_CTRL_FEIE. */
#define BF_LPUART_CTRL_FEIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_FEIE) & BM_LPUART_CTRL_FEIE)

/*! @brief Set the FEIE field to a new value. */
#define BW_LPUART_CTRL_FEIE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_FEIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field NEIE[26] (RW)
 *
 * This bit enables the noise flag (NF) to generate hardware interrupt requests.
 *
 * Values:
 * - 0 - NF interrupts disabled; use polling.
 * - 1 - Hardware interrupt requested when NF is set.
 */
/*@{*/
#define BP_LPUART_CTRL_NEIE  (26U)         /*!< Bit position for LPUART_CTRL_NEIE. */
#define BM_LPUART_CTRL_NEIE  (0x04000000U) /*!< Bit mask for LPUART_CTRL_NEIE. */
#define BS_LPUART_CTRL_NEIE  (1U)          /*!< Bit field size in bits for LPUART_CTRL_NEIE. */

/*! @brief Read current value of the LPUART_CTRL_NEIE field. */
#define BR_LPUART_CTRL_NEIE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_NEIE))

/*! @brief Format value for bitfield LPUART_CTRL_NEIE. */
#define BF_LPUART_CTRL_NEIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_NEIE) & BM_LPUART_CTRL_NEIE)

/*! @brief Set the NEIE field to a new value. */
#define BW_LPUART_CTRL_NEIE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_NEIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field ORIE[27] (RW)
 *
 * This bit enables the overrun flag (OR) to generate hardware interrupt
 * requests.
 *
 * Values:
 * - 0 - OR interrupts disabled; use polling.
 * - 1 - Hardware interrupt requested when OR is set.
 */
/*@{*/
#define BP_LPUART_CTRL_ORIE  (27U)         /*!< Bit position for LPUART_CTRL_ORIE. */
#define BM_LPUART_CTRL_ORIE  (0x08000000U) /*!< Bit mask for LPUART_CTRL_ORIE. */
#define BS_LPUART_CTRL_ORIE  (1U)          /*!< Bit field size in bits for LPUART_CTRL_ORIE. */

/*! @brief Read current value of the LPUART_CTRL_ORIE field. */
#define BR_LPUART_CTRL_ORIE(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_ORIE))

/*! @brief Format value for bitfield LPUART_CTRL_ORIE. */
#define BF_LPUART_CTRL_ORIE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_ORIE) & BM_LPUART_CTRL_ORIE)

/*! @brief Set the ORIE field to a new value. */
#define BW_LPUART_CTRL_ORIE(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_ORIE) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TXINV[28] (RW)
 *
 * Setting this bit reverses the polarity of the transmitted data output.
 * Setting TXINV inverts the LPUART_TX output for all cases: data bits, start and stop
 * bits, break, and idle.
 *
 * Values:
 * - 0 - Transmit data not inverted.
 * - 1 - Transmit data inverted.
 */
/*@{*/
#define BP_LPUART_CTRL_TXINV (28U)         /*!< Bit position for LPUART_CTRL_TXINV. */
#define BM_LPUART_CTRL_TXINV (0x10000000U) /*!< Bit mask for LPUART_CTRL_TXINV. */
#define BS_LPUART_CTRL_TXINV (1U)          /*!< Bit field size in bits for LPUART_CTRL_TXINV. */

/*! @brief Read current value of the LPUART_CTRL_TXINV field. */
#define BR_LPUART_CTRL_TXINV(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TXINV))

/*! @brief Format value for bitfield LPUART_CTRL_TXINV. */
#define BF_LPUART_CTRL_TXINV(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_TXINV) & BM_LPUART_CTRL_TXINV)

/*! @brief Set the TXINV field to a new value. */
#define BW_LPUART_CTRL_TXINV(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TXINV) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TXDIR[29] (RW)
 *
 * When the LPUART is configured for single-wire half-duplex operation (LOOPS =
 * RSRC = 1), this bit determines the direction of data at the LPUART_TX pin.
 * When clearing TXDIR, the transmitter will finish receiving the current character
 * (if any) before the receiver starts receiving data from the LPUART_TX pin.
 *
 * Values:
 * - 0 - LPUART_TX pin is an input in single-wire mode.
 * - 1 - LPUART_TX pin is an output in single-wire mode.
 */
/*@{*/
#define BP_LPUART_CTRL_TXDIR (29U)         /*!< Bit position for LPUART_CTRL_TXDIR. */
#define BM_LPUART_CTRL_TXDIR (0x20000000U) /*!< Bit mask for LPUART_CTRL_TXDIR. */
#define BS_LPUART_CTRL_TXDIR (1U)          /*!< Bit field size in bits for LPUART_CTRL_TXDIR. */

/*! @brief Read current value of the LPUART_CTRL_TXDIR field. */
#define BR_LPUART_CTRL_TXDIR(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TXDIR))

/*! @brief Format value for bitfield LPUART_CTRL_TXDIR. */
#define BF_LPUART_CTRL_TXDIR(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_TXDIR) & BM_LPUART_CTRL_TXDIR)

/*! @brief Set the TXDIR field to a new value. */
#define BW_LPUART_CTRL_TXDIR(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_TXDIR) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field R9T8[30] (RW)
 *
 * R9 is the tenth data bit received when the LPUART is configured for 10-bit
 * data formats. When reading 10-bit data, read R9 before reading LPUART_DATA T8 is
 * the ninth data bit received when the LPUART is configured for 9-bit or 10-bit
 * data formats. When writing 9-bit or 10-bit data, write T8 before writing
 * LPUART_DATA. If T8 does not need to change from its previous value, such as when
 * it is used to generate address mark or parity, they it need not be written each
 * time LPUART_DATA is written.
 */
/*@{*/
#define BP_LPUART_CTRL_R9T8  (30U)         /*!< Bit position for LPUART_CTRL_R9T8. */
#define BM_LPUART_CTRL_R9T8  (0x40000000U) /*!< Bit mask for LPUART_CTRL_R9T8. */
#define BS_LPUART_CTRL_R9T8  (1U)          /*!< Bit field size in bits for LPUART_CTRL_R9T8. */

/*! @brief Read current value of the LPUART_CTRL_R9T8 field. */
#define BR_LPUART_CTRL_R9T8(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_R9T8))

/*! @brief Format value for bitfield LPUART_CTRL_R9T8. */
#define BF_LPUART_CTRL_R9T8(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_R9T8) & BM_LPUART_CTRL_R9T8)

/*! @brief Set the R9T8 field to a new value. */
#define BW_LPUART_CTRL_R9T8(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_R9T8) = (v))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field R8T9[31] (RW)
 *
 * R8 is the ninth data bit received when the LPUART is configured for 9-bit or
 * 10-bit data formats. When reading 9-bit or 10-bit data, read R8 before reading
 * LPUART_DATA. T9 is the tenth data bit received when the LPUART is configured
 * for 10-bit data formats. When writing 10-bit data, write T9 before writing
 * LPUART_DATA. If T9 does not need to change from its previous value, such as when
 * it is used to generate address mark or parity, they it need not be written
 * each time LPUART_DATA is written.
 */
/*@{*/
#define BP_LPUART_CTRL_R8T9  (31U)         /*!< Bit position for LPUART_CTRL_R8T9. */
#define BM_LPUART_CTRL_R8T9  (0x80000000U) /*!< Bit mask for LPUART_CTRL_R8T9. */
#define BS_LPUART_CTRL_R8T9  (1U)          /*!< Bit field size in bits for LPUART_CTRL_R8T9. */

/*! @brief Read current value of the LPUART_CTRL_R8T9 field. */
#define BR_LPUART_CTRL_R8T9(x) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_R8T9))

/*! @brief Format value for bitfield LPUART_CTRL_R8T9. */
#define BF_LPUART_CTRL_R8T9(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_CTRL_R8T9) & BM_LPUART_CTRL_R8T9)

/*! @brief Set the R8T9 field to a new value. */
#define BW_LPUART_CTRL_R8T9(x, v) (BITBAND_ACCESS32(HW_LPUART_CTRL_ADDR(x), BP_LPUART_CTRL_R8T9) = (v))
/*@}*/

/*******************************************************************************
 * HW_LPUART_DATA - LPUART Data Register
 ******************************************************************************/

/*!
 * @brief HW_LPUART_DATA - LPUART Data Register (RW)
 *
 * Reset value: 0x00001000U
 *
 * This register is actually two separate registers. Reads return the contents
 * of the read-only receive data buffer and writes go to the write-only transmit
 * data buffer. Reads and writes of this register are also involved in the
 * automatic flag clearing mechanisms for some of the LPUART status flags.
 */
typedef union _hw_lpuart_data
{
    uint32_t U;
    struct _hw_lpuart_data_bitfields
    {
        uint32_t R0T0 : 1;             /*!< [0]  */
        uint32_t R1T1 : 1;             /*!< [1]  */
        uint32_t R2T2 : 1;             /*!< [2]  */
        uint32_t R3T3 : 1;             /*!< [3]  */
        uint32_t R4T4 : 1;             /*!< [4]  */
        uint32_t R5T5 : 1;             /*!< [5]  */
        uint32_t R6T6 : 1;             /*!< [6]  */
        uint32_t R7T7 : 1;             /*!< [7]  */
        uint32_t R8T8 : 1;             /*!< [8]  */
        uint32_t R9T9 : 1;             /*!< [9]  */
        uint32_t RESERVED0 : 1;        /*!< [10]  */
        uint32_t IDLINE : 1;           /*!< [11] Idle Line */
        uint32_t RXEMPT : 1;           /*!< [12] Receive Buffer Empty */
        uint32_t FRETSC : 1;           /*!< [13] Frame Error / Transmit Special
                                        * Character */
        uint32_t PARITYE : 1;          /*!< [14]  */
        uint32_t NOISY : 1;            /*!< [15]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_lpuart_data_t;

/*!
 * @name Constants and macros for entire LPUART_DATA register
 */
/*@{*/
#define HW_LPUART_DATA_ADDR(x)   ((x) + 0xCU)

#define HW_LPUART_DATA(x)        (*(__IO hw_lpuart_data_t *) HW_LPUART_DATA_ADDR(x))
#define HW_LPUART_DATA_RD(x)     (HW_LPUART_DATA(x).U)
#define HW_LPUART_DATA_WR(x, v)  (HW_LPUART_DATA(x).U = (v))
#define HW_LPUART_DATA_SET(x, v) (HW_LPUART_DATA_WR(x, HW_LPUART_DATA_RD(x) |  (v)))
#define HW_LPUART_DATA_CLR(x, v) (HW_LPUART_DATA_WR(x, HW_LPUART_DATA_RD(x) & ~(v)))
#define HW_LPUART_DATA_TOG(x, v) (HW_LPUART_DATA_WR(x, HW_LPUART_DATA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LPUART_DATA bitfields
 */

/*!
 * @name Register LPUART_DATA, field R0T0[0] (RW)
 *
 * Read receive data buffer 0 or write transmit data buffer 0.
 */
/*@{*/
#define BP_LPUART_DATA_R0T0  (0U)          /*!< Bit position for LPUART_DATA_R0T0. */
#define BM_LPUART_DATA_R0T0  (0x00000001U) /*!< Bit mask for LPUART_DATA_R0T0. */
#define BS_LPUART_DATA_R0T0  (1U)          /*!< Bit field size in bits for LPUART_DATA_R0T0. */

/*! @brief Read current value of the LPUART_DATA_R0T0 field. */
#define BR_LPUART_DATA_R0T0(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R0T0))

/*! @brief Format value for bitfield LPUART_DATA_R0T0. */
#define BF_LPUART_DATA_R0T0(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R0T0) & BM_LPUART_DATA_R0T0)

/*! @brief Set the R0T0 field to a new value. */
#define BW_LPUART_DATA_R0T0(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R0T0) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R1T1[1] (RW)
 *
 * Read receive data buffer 1 or write transmit data buffer 1.
 */
/*@{*/
#define BP_LPUART_DATA_R1T1  (1U)          /*!< Bit position for LPUART_DATA_R1T1. */
#define BM_LPUART_DATA_R1T1  (0x00000002U) /*!< Bit mask for LPUART_DATA_R1T1. */
#define BS_LPUART_DATA_R1T1  (1U)          /*!< Bit field size in bits for LPUART_DATA_R1T1. */

/*! @brief Read current value of the LPUART_DATA_R1T1 field. */
#define BR_LPUART_DATA_R1T1(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R1T1))

/*! @brief Format value for bitfield LPUART_DATA_R1T1. */
#define BF_LPUART_DATA_R1T1(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R1T1) & BM_LPUART_DATA_R1T1)

/*! @brief Set the R1T1 field to a new value. */
#define BW_LPUART_DATA_R1T1(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R1T1) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R2T2[2] (RW)
 *
 * Read receive data buffer 2 or write transmit data buffer 2.
 */
/*@{*/
#define BP_LPUART_DATA_R2T2  (2U)          /*!< Bit position for LPUART_DATA_R2T2. */
#define BM_LPUART_DATA_R2T2  (0x00000004U) /*!< Bit mask for LPUART_DATA_R2T2. */
#define BS_LPUART_DATA_R2T2  (1U)          /*!< Bit field size in bits for LPUART_DATA_R2T2. */

/*! @brief Read current value of the LPUART_DATA_R2T2 field. */
#define BR_LPUART_DATA_R2T2(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R2T2))

/*! @brief Format value for bitfield LPUART_DATA_R2T2. */
#define BF_LPUART_DATA_R2T2(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R2T2) & BM_LPUART_DATA_R2T2)

/*! @brief Set the R2T2 field to a new value. */
#define BW_LPUART_DATA_R2T2(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R2T2) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R3T3[3] (RW)
 *
 * Read receive data buffer 3 or write transmit data buffer 3.
 */
/*@{*/
#define BP_LPUART_DATA_R3T3  (3U)          /*!< Bit position for LPUART_DATA_R3T3. */
#define BM_LPUART_DATA_R3T3  (0x00000008U) /*!< Bit mask for LPUART_DATA_R3T3. */
#define BS_LPUART_DATA_R3T3  (1U)          /*!< Bit field size in bits for LPUART_DATA_R3T3. */

/*! @brief Read current value of the LPUART_DATA_R3T3 field. */
#define BR_LPUART_DATA_R3T3(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R3T3))

/*! @brief Format value for bitfield LPUART_DATA_R3T3. */
#define BF_LPUART_DATA_R3T3(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R3T3) & BM_LPUART_DATA_R3T3)

/*! @brief Set the R3T3 field to a new value. */
#define BW_LPUART_DATA_R3T3(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R3T3) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R4T4[4] (RW)
 *
 * Read receive data buffer 4 or write transmit data buffer 4.
 */
/*@{*/
#define BP_LPUART_DATA_R4T4  (4U)          /*!< Bit position for LPUART_DATA_R4T4. */
#define BM_LPUART_DATA_R4T4  (0x00000010U) /*!< Bit mask for LPUART_DATA_R4T4. */
#define BS_LPUART_DATA_R4T4  (1U)          /*!< Bit field size in bits for LPUART_DATA_R4T4. */

/*! @brief Read current value of the LPUART_DATA_R4T4 field. */
#define BR_LPUART_DATA_R4T4(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R4T4))

/*! @brief Format value for bitfield LPUART_DATA_R4T4. */
#define BF_LPUART_DATA_R4T4(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R4T4) & BM_LPUART_DATA_R4T4)

/*! @brief Set the R4T4 field to a new value. */
#define BW_LPUART_DATA_R4T4(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R4T4) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R5T5[5] (RW)
 *
 * Read receive data buffer 5 or write transmit data buffer 5.
 */
/*@{*/
#define BP_LPUART_DATA_R5T5  (5U)          /*!< Bit position for LPUART_DATA_R5T5. */
#define BM_LPUART_DATA_R5T5  (0x00000020U) /*!< Bit mask for LPUART_DATA_R5T5. */
#define BS_LPUART_DATA_R5T5  (1U)          /*!< Bit field size in bits for LPUART_DATA_R5T5. */

/*! @brief Read current value of the LPUART_DATA_R5T5 field. */
#define BR_LPUART_DATA_R5T5(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R5T5))

/*! @brief Format value for bitfield LPUART_DATA_R5T5. */
#define BF_LPUART_DATA_R5T5(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R5T5) & BM_LPUART_DATA_R5T5)

/*! @brief Set the R5T5 field to a new value. */
#define BW_LPUART_DATA_R5T5(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R5T5) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R6T6[6] (RW)
 *
 * Read receive data buffer 6 or write transmit data buffer 6.
 */
/*@{*/
#define BP_LPUART_DATA_R6T6  (6U)          /*!< Bit position for LPUART_DATA_R6T6. */
#define BM_LPUART_DATA_R6T6  (0x00000040U) /*!< Bit mask for LPUART_DATA_R6T6. */
#define BS_LPUART_DATA_R6T6  (1U)          /*!< Bit field size in bits for LPUART_DATA_R6T6. */

/*! @brief Read current value of the LPUART_DATA_R6T6 field. */
#define BR_LPUART_DATA_R6T6(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R6T6))

/*! @brief Format value for bitfield LPUART_DATA_R6T6. */
#define BF_LPUART_DATA_R6T6(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R6T6) & BM_LPUART_DATA_R6T6)

/*! @brief Set the R6T6 field to a new value. */
#define BW_LPUART_DATA_R6T6(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R6T6) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R7T7[7] (RW)
 *
 * Read receive data buffer 7 or write transmit data buffer 7.
 */
/*@{*/
#define BP_LPUART_DATA_R7T7  (7U)          /*!< Bit position for LPUART_DATA_R7T7. */
#define BM_LPUART_DATA_R7T7  (0x00000080U) /*!< Bit mask for LPUART_DATA_R7T7. */
#define BS_LPUART_DATA_R7T7  (1U)          /*!< Bit field size in bits for LPUART_DATA_R7T7. */

/*! @brief Read current value of the LPUART_DATA_R7T7 field. */
#define BR_LPUART_DATA_R7T7(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R7T7))

/*! @brief Format value for bitfield LPUART_DATA_R7T7. */
#define BF_LPUART_DATA_R7T7(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R7T7) & BM_LPUART_DATA_R7T7)

/*! @brief Set the R7T7 field to a new value. */
#define BW_LPUART_DATA_R7T7(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R7T7) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R8T8[8] (RW)
 *
 * Read receive data buffer 8 or write transmit data buffer 8.
 */
/*@{*/
#define BP_LPUART_DATA_R8T8  (8U)          /*!< Bit position for LPUART_DATA_R8T8. */
#define BM_LPUART_DATA_R8T8  (0x00000100U) /*!< Bit mask for LPUART_DATA_R8T8. */
#define BS_LPUART_DATA_R8T8  (1U)          /*!< Bit field size in bits for LPUART_DATA_R8T8. */

/*! @brief Read current value of the LPUART_DATA_R8T8 field. */
#define BR_LPUART_DATA_R8T8(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R8T8))

/*! @brief Format value for bitfield LPUART_DATA_R8T8. */
#define BF_LPUART_DATA_R8T8(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R8T8) & BM_LPUART_DATA_R8T8)

/*! @brief Set the R8T8 field to a new value. */
#define BW_LPUART_DATA_R8T8(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R8T8) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R9T9[9] (RW)
 *
 * Read receive data buffer 9 or write transmit data buffer 9.
 */
/*@{*/
#define BP_LPUART_DATA_R9T9  (9U)          /*!< Bit position for LPUART_DATA_R9T9. */
#define BM_LPUART_DATA_R9T9  (0x00000200U) /*!< Bit mask for LPUART_DATA_R9T9. */
#define BS_LPUART_DATA_R9T9  (1U)          /*!< Bit field size in bits for LPUART_DATA_R9T9. */

/*! @brief Read current value of the LPUART_DATA_R9T9 field. */
#define BR_LPUART_DATA_R9T9(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R9T9))

/*! @brief Format value for bitfield LPUART_DATA_R9T9. */
#define BF_LPUART_DATA_R9T9(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_R9T9) & BM_LPUART_DATA_R9T9)

/*! @brief Set the R9T9 field to a new value. */
#define BW_LPUART_DATA_R9T9(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_R9T9) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field IDLINE[11] (RO)
 *
 * Indicates the receiver line was idle before receiving the character in
 * DATA[9:0]. Unlike the IDLE flag, this bit can set for the first character received
 * when the receiver is first enabled.
 *
 * Values:
 * - 0 - Receiver was not idle before receiving this character.
 * - 1 - Receiver was idle before receiving this character.
 */
/*@{*/
#define BP_LPUART_DATA_IDLINE (11U)        /*!< Bit position for LPUART_DATA_IDLINE. */
#define BM_LPUART_DATA_IDLINE (0x00000800U) /*!< Bit mask for LPUART_DATA_IDLINE. */
#define BS_LPUART_DATA_IDLINE (1U)         /*!< Bit field size in bits for LPUART_DATA_IDLINE. */

/*! @brief Read current value of the LPUART_DATA_IDLINE field. */
#define BR_LPUART_DATA_IDLINE(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_IDLINE))
/*@}*/

/*!
 * @name Register LPUART_DATA, field RXEMPT[12] (RO)
 *
 * Asserts when there is no data in the receive buffer. This field does not take
 * into account data that is in the receive shift register.
 *
 * Values:
 * - 0 - Receive buffer contains valid data.
 * - 1 - Receive buffer is empty, data returned on read is not valid.
 */
/*@{*/
#define BP_LPUART_DATA_RXEMPT (12U)        /*!< Bit position for LPUART_DATA_RXEMPT. */
#define BM_LPUART_DATA_RXEMPT (0x00001000U) /*!< Bit mask for LPUART_DATA_RXEMPT. */
#define BS_LPUART_DATA_RXEMPT (1U)         /*!< Bit field size in bits for LPUART_DATA_RXEMPT. */

/*! @brief Read current value of the LPUART_DATA_RXEMPT field. */
#define BR_LPUART_DATA_RXEMPT(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_RXEMPT))
/*@}*/

/*!
 * @name Register LPUART_DATA, field FRETSC[13] (RW)
 *
 * For reads, indicates the current received dataword contained in DATA[R9:R0]
 * was received with a frame error. For writes, indicates a break or idle
 * character is to be transmitted instead of the contents in DATA[T9:T0]. T9 is used to
 * indicate a break character when 0 and a idle character when 1, he contents of
 * DATA[T8:T0] should be zero.
 *
 * Values:
 * - 0 - The dataword was received without a frame error on read, transmit a
 *     normal character on write.
 * - 1 - The dataword was received with a frame error, transmit an idle or break
 *     character on transmit.
 */
/*@{*/
#define BP_LPUART_DATA_FRETSC (13U)        /*!< Bit position for LPUART_DATA_FRETSC. */
#define BM_LPUART_DATA_FRETSC (0x00002000U) /*!< Bit mask for LPUART_DATA_FRETSC. */
#define BS_LPUART_DATA_FRETSC (1U)         /*!< Bit field size in bits for LPUART_DATA_FRETSC. */

/*! @brief Read current value of the LPUART_DATA_FRETSC field. */
#define BR_LPUART_DATA_FRETSC(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_FRETSC))

/*! @brief Format value for bitfield LPUART_DATA_FRETSC. */
#define BF_LPUART_DATA_FRETSC(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_DATA_FRETSC) & BM_LPUART_DATA_FRETSC)

/*! @brief Set the FRETSC field to a new value. */
#define BW_LPUART_DATA_FRETSC(x, v) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_FRETSC) = (v))
/*@}*/

/*!
 * @name Register LPUART_DATA, field PARITYE[14] (RO)
 *
 * The current received dataword contained in DATA[R9:R0] was received with a
 * parity error.
 *
 * Values:
 * - 0 - The dataword was received without a parity error.
 * - 1 - The dataword was received with a parity error.
 */
/*@{*/
#define BP_LPUART_DATA_PARITYE (14U)       /*!< Bit position for LPUART_DATA_PARITYE. */
#define BM_LPUART_DATA_PARITYE (0x00004000U) /*!< Bit mask for LPUART_DATA_PARITYE. */
#define BS_LPUART_DATA_PARITYE (1U)        /*!< Bit field size in bits for LPUART_DATA_PARITYE. */

/*! @brief Read current value of the LPUART_DATA_PARITYE field. */
#define BR_LPUART_DATA_PARITYE(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_PARITYE))
/*@}*/

/*!
 * @name Register LPUART_DATA, field NOISY[15] (RO)
 *
 * The current received dataword contained in DATA[R9:R0] was received with
 * noise.
 *
 * Values:
 * - 0 - The dataword was received without noise.
 * - 1 - The data was received with noise.
 */
/*@{*/
#define BP_LPUART_DATA_NOISY (15U)         /*!< Bit position for LPUART_DATA_NOISY. */
#define BM_LPUART_DATA_NOISY (0x00008000U) /*!< Bit mask for LPUART_DATA_NOISY. */
#define BS_LPUART_DATA_NOISY (1U)          /*!< Bit field size in bits for LPUART_DATA_NOISY. */

/*! @brief Read current value of the LPUART_DATA_NOISY field. */
#define BR_LPUART_DATA_NOISY(x) (BITBAND_ACCESS32(HW_LPUART_DATA_ADDR(x), BP_LPUART_DATA_NOISY))
/*@}*/

/*******************************************************************************
 * HW_LPUART_MATCH - LPUART Match Address Register
 ******************************************************************************/

/*!
 * @brief HW_LPUART_MATCH - LPUART Match Address Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_lpuart_match
{
    uint32_t U;
    struct _hw_lpuart_match_bitfields
    {
        uint32_t MA1 : 10;             /*!< [9:0] Match Address 1 */
        uint32_t RESERVED0 : 6;        /*!< [15:10]  */
        uint32_t MA2 : 10;             /*!< [25:16] Match Address 2 */
        uint32_t RESERVED1 : 6;        /*!< [31:26]  */
    } B;
} hw_lpuart_match_t;

/*!
 * @name Constants and macros for entire LPUART_MATCH register
 */
/*@{*/
#define HW_LPUART_MATCH_ADDR(x)  ((x) + 0x10U)

#define HW_LPUART_MATCH(x)       (*(__IO hw_lpuart_match_t *) HW_LPUART_MATCH_ADDR(x))
#define HW_LPUART_MATCH_RD(x)    (HW_LPUART_MATCH(x).U)
#define HW_LPUART_MATCH_WR(x, v) (HW_LPUART_MATCH(x).U = (v))
#define HW_LPUART_MATCH_SET(x, v) (HW_LPUART_MATCH_WR(x, HW_LPUART_MATCH_RD(x) |  (v)))
#define HW_LPUART_MATCH_CLR(x, v) (HW_LPUART_MATCH_WR(x, HW_LPUART_MATCH_RD(x) & ~(v)))
#define HW_LPUART_MATCH_TOG(x, v) (HW_LPUART_MATCH_WR(x, HW_LPUART_MATCH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LPUART_MATCH bitfields
 */

/*!
 * @name Register LPUART_MATCH, field MA1[9:0] (RW)
 *
 * The MA1 and MA2 registers are compared to input data addresses when the most
 * significant bit is set and the associated BAUD[MAEN] bit is set. If a match
 * occurs, the following data is transferred to the data register. If a match
 * fails, the following data is discarded. Software should only write a MA register
 * when the associated BAUD[MAEN] bit is clear.
 */
/*@{*/
#define BP_LPUART_MATCH_MA1  (0U)          /*!< Bit position for LPUART_MATCH_MA1. */
#define BM_LPUART_MATCH_MA1  (0x000003FFU) /*!< Bit mask for LPUART_MATCH_MA1. */
#define BS_LPUART_MATCH_MA1  (10U)         /*!< Bit field size in bits for LPUART_MATCH_MA1. */

/*! @brief Read current value of the LPUART_MATCH_MA1 field. */
#define BR_LPUART_MATCH_MA1(x) (HW_LPUART_MATCH(x).B.MA1)

/*! @brief Format value for bitfield LPUART_MATCH_MA1. */
#define BF_LPUART_MATCH_MA1(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MATCH_MA1) & BM_LPUART_MATCH_MA1)

/*! @brief Set the MA1 field to a new value. */
#define BW_LPUART_MATCH_MA1(x, v) (HW_LPUART_MATCH_WR(x, (HW_LPUART_MATCH_RD(x) & ~BM_LPUART_MATCH_MA1) | BF_LPUART_MATCH_MA1(v)))
/*@}*/

/*!
 * @name Register LPUART_MATCH, field MA2[25:16] (RW)
 *
 * The MA1 and MA2 registers are compared to input data addresses when the most
 * significant bit is set and the associated BAUD[MAEN] bit is set. If a match
 * occurs, the following data is transferred to the data register. If a match
 * fails, the following data is discarded. Software should only write a MA register
 * when the associated BAUD[MAEN] bit is clear.
 */
/*@{*/
#define BP_LPUART_MATCH_MA2  (16U)         /*!< Bit position for LPUART_MATCH_MA2. */
#define BM_LPUART_MATCH_MA2  (0x03FF0000U) /*!< Bit mask for LPUART_MATCH_MA2. */
#define BS_LPUART_MATCH_MA2  (10U)         /*!< Bit field size in bits for LPUART_MATCH_MA2. */

/*! @brief Read current value of the LPUART_MATCH_MA2 field. */
#define BR_LPUART_MATCH_MA2(x) (HW_LPUART_MATCH(x).B.MA2)

/*! @brief Format value for bitfield LPUART_MATCH_MA2. */
#define BF_LPUART_MATCH_MA2(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MATCH_MA2) & BM_LPUART_MATCH_MA2)

/*! @brief Set the MA2 field to a new value. */
#define BW_LPUART_MATCH_MA2(x, v) (HW_LPUART_MATCH_WR(x, (HW_LPUART_MATCH_RD(x) & ~BM_LPUART_MATCH_MA2) | BF_LPUART_MATCH_MA2(v)))
/*@}*/

/*******************************************************************************
 * HW_LPUART_MODIR - LPUART Modem IrDA Register
 ******************************************************************************/

/*!
 * @brief HW_LPUART_MODIR - LPUART Modem IrDA Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MODEM register controls options for setting the modem configuration.
 */
typedef union _hw_lpuart_modir
{
    uint32_t U;
    struct _hw_lpuart_modir_bitfields
    {
        uint32_t TXCTSE : 1;           /*!< [0] Transmitter clear-to-send enable */
        uint32_t TXRTSE : 1;           /*!< [1] Transmitter request-to-send enable */
        uint32_t TXRTSPOL : 1;         /*!< [2] Transmitter request-to-send polarity
                                        * */
        uint32_t RXRTSE : 1;           /*!< [3] Receiver request-to-send enable */
        uint32_t TXCTSC : 1;           /*!< [4] Transmit CTS Configuration */
        uint32_t TXCTSSRC : 1;         /*!< [5] Transmit CTS Source */
        uint32_t RESERVED0 : 10;       /*!< [15:6]  */
        uint32_t TNP : 2;              /*!< [17:16] Transmitter narrow pulse */
        uint32_t IREN : 1;             /*!< [18] Infrared enable */
        uint32_t RESERVED1 : 13;       /*!< [31:19]  */
    } B;
} hw_lpuart_modir_t;

/*!
 * @name Constants and macros for entire LPUART_MODIR register
 */
/*@{*/
#define HW_LPUART_MODIR_ADDR(x)  ((x) + 0x14U)

#define HW_LPUART_MODIR(x)       (*(__IO hw_lpuart_modir_t *) HW_LPUART_MODIR_ADDR(x))
#define HW_LPUART_MODIR_RD(x)    (HW_LPUART_MODIR(x).U)
#define HW_LPUART_MODIR_WR(x, v) (HW_LPUART_MODIR(x).U = (v))
#define HW_LPUART_MODIR_SET(x, v) (HW_LPUART_MODIR_WR(x, HW_LPUART_MODIR_RD(x) |  (v)))
#define HW_LPUART_MODIR_CLR(x, v) (HW_LPUART_MODIR_WR(x, HW_LPUART_MODIR_RD(x) & ~(v)))
#define HW_LPUART_MODIR_TOG(x, v) (HW_LPUART_MODIR_WR(x, HW_LPUART_MODIR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual LPUART_MODIR bitfields
 */

/*!
 * @name Register LPUART_MODIR, field TXCTSE[0] (RW)
 *
 * TXCTSE controls the operation of the transmitter. TXCTSE can be set
 * independently from the state of TXRTSE and RXRTSE.
 *
 * Values:
 * - 0 - CTS has no effect on the transmitter.
 * - 1 - Enables clear-to-send operation. The transmitter checks the state of
 *     CTS each time it is ready to send a character. If CTS is asserted, the
 *     character is sent. If CTS is deasserted, the signal TXD remains in the mark
 *     state and transmission is delayed until CTS is asserted. Changes in CTS as a
 *     character is being sent do not affect its transmission.
 */
/*@{*/
#define BP_LPUART_MODIR_TXCTSE (0U)        /*!< Bit position for LPUART_MODIR_TXCTSE. */
#define BM_LPUART_MODIR_TXCTSE (0x00000001U) /*!< Bit mask for LPUART_MODIR_TXCTSE. */
#define BS_LPUART_MODIR_TXCTSE (1U)        /*!< Bit field size in bits for LPUART_MODIR_TXCTSE. */

/*! @brief Read current value of the LPUART_MODIR_TXCTSE field. */
#define BR_LPUART_MODIR_TXCTSE(x) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXCTSE))

/*! @brief Format value for bitfield LPUART_MODIR_TXCTSE. */
#define BF_LPUART_MODIR_TXCTSE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MODIR_TXCTSE) & BM_LPUART_MODIR_TXCTSE)

/*! @brief Set the TXCTSE field to a new value. */
#define BW_LPUART_MODIR_TXCTSE(x, v) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXCTSE) = (v))
/*@}*/

/*!
 * @name Register LPUART_MODIR, field TXRTSE[1] (RW)
 *
 * Controls RTS before and after a transmission.
 *
 * Values:
 * - 0 - The transmitter has no effect on RTS.
 * - 1 - When a character is placed into an empty transmitter data buffer , RTS
 *     asserts one bit time before the start bit is transmitted. RTS deasserts
 *     one bit time after all characters in the transmitter data buffer and shift
 *     register are completely sent, including the last stop bit.
 */
/*@{*/
#define BP_LPUART_MODIR_TXRTSE (1U)        /*!< Bit position for LPUART_MODIR_TXRTSE. */
#define BM_LPUART_MODIR_TXRTSE (0x00000002U) /*!< Bit mask for LPUART_MODIR_TXRTSE. */
#define BS_LPUART_MODIR_TXRTSE (1U)        /*!< Bit field size in bits for LPUART_MODIR_TXRTSE. */

/*! @brief Read current value of the LPUART_MODIR_TXRTSE field. */
#define BR_LPUART_MODIR_TXRTSE(x) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXRTSE))

/*! @brief Format value for bitfield LPUART_MODIR_TXRTSE. */
#define BF_LPUART_MODIR_TXRTSE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MODIR_TXRTSE) & BM_LPUART_MODIR_TXRTSE)

/*! @brief Set the TXRTSE field to a new value. */
#define BW_LPUART_MODIR_TXRTSE(x, v) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXRTSE) = (v))
/*@}*/

/*!
 * @name Register LPUART_MODIR, field TXRTSPOL[2] (RW)
 *
 * Controls the polarity of the transmitter RTS. TXRTSPOL does not affect the
 * polarity of the receiver RTS. RTS will remain negated in the active low state
 * unless TXRTSE is set.
 *
 * Values:
 * - 0 - Transmitter RTS is active low.
 * - 1 - Transmitter RTS is active high.
 */
/*@{*/
#define BP_LPUART_MODIR_TXRTSPOL (2U)      /*!< Bit position for LPUART_MODIR_TXRTSPOL. */
#define BM_LPUART_MODIR_TXRTSPOL (0x00000004U) /*!< Bit mask for LPUART_MODIR_TXRTSPOL. */
#define BS_LPUART_MODIR_TXRTSPOL (1U)      /*!< Bit field size in bits for LPUART_MODIR_TXRTSPOL. */

/*! @brief Read current value of the LPUART_MODIR_TXRTSPOL field. */
#define BR_LPUART_MODIR_TXRTSPOL(x) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXRTSPOL))

/*! @brief Format value for bitfield LPUART_MODIR_TXRTSPOL. */
#define BF_LPUART_MODIR_TXRTSPOL(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MODIR_TXRTSPOL) & BM_LPUART_MODIR_TXRTSPOL)

/*! @brief Set the TXRTSPOL field to a new value. */
#define BW_LPUART_MODIR_TXRTSPOL(x, v) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXRTSPOL) = (v))
/*@}*/

/*!
 * @name Register LPUART_MODIR, field RXRTSE[3] (RW)
 *
 * Allows the RTS output to control the CTS input of the transmitting device to
 * prevent receiver overrun. Do not set both RXRTSE and TXRTSE.
 *
 * Values:
 * - 0 - The receiver has no effect on RTS.
 * - 1 - RTS is deasserted if the receiver data register is full or a start bit
 *     has been detected that would cause the receiver data register to become
 *     full. RTS is asserted if the receiver data register is not full and has not
 *     detected a start bit that would cause the receiver data register to become
 *     full.
 */
/*@{*/
#define BP_LPUART_MODIR_RXRTSE (3U)        /*!< Bit position for LPUART_MODIR_RXRTSE. */
#define BM_LPUART_MODIR_RXRTSE (0x00000008U) /*!< Bit mask for LPUART_MODIR_RXRTSE. */
#define BS_LPUART_MODIR_RXRTSE (1U)        /*!< Bit field size in bits for LPUART_MODIR_RXRTSE. */

/*! @brief Read current value of the LPUART_MODIR_RXRTSE field. */
#define BR_LPUART_MODIR_RXRTSE(x) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_RXRTSE))

/*! @brief Format value for bitfield LPUART_MODIR_RXRTSE. */
#define BF_LPUART_MODIR_RXRTSE(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MODIR_RXRTSE) & BM_LPUART_MODIR_RXRTSE)

/*! @brief Set the RXRTSE field to a new value. */
#define BW_LPUART_MODIR_RXRTSE(x, v) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_RXRTSE) = (v))
/*@}*/

/*!
 * @name Register LPUART_MODIR, field TXCTSC[4] (RW)
 *
 * Configures if the CTS state is checked at the start of each character or only
 * when the transmitter is idle.
 *
 * Values:
 * - 0 - CTS input is sampled at the start of each character.
 * - 1 - CTS input is sampled when the transmitter is idle.
 */
/*@{*/
#define BP_LPUART_MODIR_TXCTSC (4U)        /*!< Bit position for LPUART_MODIR_TXCTSC. */
#define BM_LPUART_MODIR_TXCTSC (0x00000010U) /*!< Bit mask for LPUART_MODIR_TXCTSC. */
#define BS_LPUART_MODIR_TXCTSC (1U)        /*!< Bit field size in bits for LPUART_MODIR_TXCTSC. */

/*! @brief Read current value of the LPUART_MODIR_TXCTSC field. */
#define BR_LPUART_MODIR_TXCTSC(x) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXCTSC))

/*! @brief Format value for bitfield LPUART_MODIR_TXCTSC. */
#define BF_LPUART_MODIR_TXCTSC(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MODIR_TXCTSC) & BM_LPUART_MODIR_TXCTSC)

/*! @brief Set the TXCTSC field to a new value. */
#define BW_LPUART_MODIR_TXCTSC(x, v) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXCTSC) = (v))
/*@}*/

/*!
 * @name Register LPUART_MODIR, field TXCTSSRC[5] (RW)
 *
 * Configures the source of the CTS input.
 *
 * Values:
 * - 0 - CTS input is the LPUART_CTS pin.
 * - 1 - CTS input is the inverted Receiver Match result.
 */
/*@{*/
#define BP_LPUART_MODIR_TXCTSSRC (5U)      /*!< Bit position for LPUART_MODIR_TXCTSSRC. */
#define BM_LPUART_MODIR_TXCTSSRC (0x00000020U) /*!< Bit mask for LPUART_MODIR_TXCTSSRC. */
#define BS_LPUART_MODIR_TXCTSSRC (1U)      /*!< Bit field size in bits for LPUART_MODIR_TXCTSSRC. */

/*! @brief Read current value of the LPUART_MODIR_TXCTSSRC field. */
#define BR_LPUART_MODIR_TXCTSSRC(x) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXCTSSRC))

/*! @brief Format value for bitfield LPUART_MODIR_TXCTSSRC. */
#define BF_LPUART_MODIR_TXCTSSRC(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MODIR_TXCTSSRC) & BM_LPUART_MODIR_TXCTSSRC)

/*! @brief Set the TXCTSSRC field to a new value. */
#define BW_LPUART_MODIR_TXCTSSRC(x, v) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_TXCTSSRC) = (v))
/*@}*/

/*!
 * @name Register LPUART_MODIR, field TNP[17:16] (RW)
 *
 * Enables whether the LPUART transmits a 1/OSR, 2/OSR, 3/OSR or 4/OSR narrow
 * pulse.
 *
 * Values:
 * - 00 - 1/OSR.
 * - 01 - 2/OSR.
 * - 10 - 3/OSR.
 * - 11 - 4/OSR.
 */
/*@{*/
#define BP_LPUART_MODIR_TNP  (16U)         /*!< Bit position for LPUART_MODIR_TNP. */
#define BM_LPUART_MODIR_TNP  (0x00030000U) /*!< Bit mask for LPUART_MODIR_TNP. */
#define BS_LPUART_MODIR_TNP  (2U)          /*!< Bit field size in bits for LPUART_MODIR_TNP. */

/*! @brief Read current value of the LPUART_MODIR_TNP field. */
#define BR_LPUART_MODIR_TNP(x) (HW_LPUART_MODIR(x).B.TNP)

/*! @brief Format value for bitfield LPUART_MODIR_TNP. */
#define BF_LPUART_MODIR_TNP(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MODIR_TNP) & BM_LPUART_MODIR_TNP)

/*! @brief Set the TNP field to a new value. */
#define BW_LPUART_MODIR_TNP(x, v) (HW_LPUART_MODIR_WR(x, (HW_LPUART_MODIR_RD(x) & ~BM_LPUART_MODIR_TNP) | BF_LPUART_MODIR_TNP(v)))
/*@}*/

/*!
 * @name Register LPUART_MODIR, field IREN[18] (RW)
 *
 * Enables/disables the infrared modulation/demodulation.
 *
 * Values:
 * - 0 - IR disabled.
 * - 1 - IR enabled.
 */
/*@{*/
#define BP_LPUART_MODIR_IREN (18U)         /*!< Bit position for LPUART_MODIR_IREN. */
#define BM_LPUART_MODIR_IREN (0x00040000U) /*!< Bit mask for LPUART_MODIR_IREN. */
#define BS_LPUART_MODIR_IREN (1U)          /*!< Bit field size in bits for LPUART_MODIR_IREN. */

/*! @brief Read current value of the LPUART_MODIR_IREN field. */
#define BR_LPUART_MODIR_IREN(x) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_IREN))

/*! @brief Format value for bitfield LPUART_MODIR_IREN. */
#define BF_LPUART_MODIR_IREN(v) ((uint32_t)((uint32_t)(v) << BP_LPUART_MODIR_IREN) & BM_LPUART_MODIR_IREN)

/*! @brief Set the IREN field to a new value. */
#define BW_LPUART_MODIR_IREN(x, v) (BITBAND_ACCESS32(HW_LPUART_MODIR_ADDR(x), BP_LPUART_MODIR_IREN) = (v))
/*@}*/

/*******************************************************************************
 * hw_lpuart_t - module struct
 ******************************************************************************/
/*!
 * @brief All LPUART module registers.
 */
#pragma pack(1)
typedef struct _hw_lpuart
{
    __IO hw_lpuart_baud_t BAUD;            /*!< [0x0] LPUART Baud Rate Register */
    __IO hw_lpuart_stat_t STAT;            /*!< [0x4] LPUART Status Register */
    __IO hw_lpuart_ctrl_t CTRL;            /*!< [0x8] LPUART Control Register */
    __IO hw_lpuart_data_t DATA;            /*!< [0xC] LPUART Data Register */
    __IO hw_lpuart_match_t MATCH;          /*!< [0x10] LPUART Match Address Register */
    __IO hw_lpuart_modir_t MODIR;          /*!< [0x14] LPUART Modem IrDA Register */
} hw_lpuart_t;
#pragma pack()

/*! @brief Macro to access all LPUART registers. */
/*! @param x LPUART module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_LPUART(LPUART0_BASE)</code>. */
#define HW_LPUART(x)   (*(hw_lpuart_t *)(x))

#endif /* __HW_LPUART_REGISTERS_H__ */
/* EOF */
