#include "mbed.h"
#include "USBHostDac.h"
#include "FATFileSystem.h"
#include "USBHostMSD.h"
#include "dec_wav.h"

#if defined(TARGET_RZ_A1H)
#include "usb_host_setting.h"
#else
#define USB_HOST_CH     0
#endif

#if (USB_HOST_CH == 1) //Audio Shield USB1
DigitalOut usb1en(P3_8);
#endif
DigitalIn  button(USER_BUTTON0);

#define AUDIO_WRITE_BUFF_SIZE  (4096)
#define FILE_NAME_LEN          (64)
#define TEXT_SIZE              (64 + 1) //null-terminated
#define FLD_PATH               "/usb/"

static uint8_t audio_write_buff[AUDIO_WRITE_BUFF_SIZE];
//Tag buffer
static uint8_t title_buf[TEXT_SIZE];
static uint8_t artist_buf[TEXT_SIZE];
static uint8_t album_buf[TEXT_SIZE];

int main() {
    FILE * fp = NULL;
    DIR  * d = NULL;
    char file_path[sizeof(FLD_PATH) + FILE_NAME_LEN];
    size_t audio_data_size;
    dec_wav wav_file;

#if (USB_HOST_CH == 1) //Audio Shield USB1
    //Audio Shield USB1 enable
    usb1en = 1;        //Outputs high level
    Thread::wait(5);
    usb1en = 0;        //Outputs low level
#endif

    FATFileSystem fs("usb");
    USBHostMSD msd;
    USBHostDac usbdac;

    while(1) {
        // try to connect a MSD device
        while(!msd.connect()) {
            Thread::wait(500);
        }
        fs.mount(&msd);

        // in a loop, append a file
        // if the device is disconnected, we try to connect it again
        while(1) {
            // if device disconnected, try to connect again
            if (!msd.connected()) {
                break;
            }
            if (fp == NULL) {
                // file search
                if (d == NULL) {
                    d = opendir(FLD_PATH);
                }
                struct dirent * p;
                while ((p = readdir(d)) != NULL) {
                    size_t len = strlen(p->d_name);
                    if ((len > 4) && (len < FILE_NAME_LEN)
                        && (memcmp(&p->d_name[len - 4], ".wav", 4) == 0)) {
                        strcpy(file_path, FLD_PATH);
                        strcat(file_path, p->d_name);
                        fp = fopen(file_path, "r");
                        if (wav_file.AnalyzeHeder(title_buf, artist_buf, album_buf,
                                                   TEXT_SIZE, fp) == false) {
                            fclose(fp);
                            fp = NULL;
                        } else if ((wav_file.GetChannel() != 2)
                                || (wav_file.GetBlockSize() != 16)
                                || (wav_file.GetSamplingRate() != 48000)) {
                            fclose(fp);
                            fp = NULL;
                        } else {
                            printf("File  :%s\n", p->d_name);
                            printf("Title :%s\n", title_buf);
                            printf("Artist:%s\n", artist_buf);
                            printf("Album :%s\n", album_buf);
                            printf("\n");
                            break;
                        }
                    }
                }
                if (p == NULL) {
                    closedir(d);
                    d = NULL;
                }
            } else {
                // file read
                uint8_t * p_buf = audio_write_buff;

                audio_data_size = wav_file.GetNextData(p_buf, AUDIO_WRITE_BUFF_SIZE);
                if (audio_data_size > 0) {
                    bool flush = false;

                    // try to connect a usbdac device
                    while(!usbdac.connect()) {
                        Thread::wait(500);
                    }
                    if (audio_data_size < AUDIO_WRITE_BUFF_SIZE) {
                        flush = true;
                    }
                    usbdac.send(p_buf, audio_data_size, flush);
                }

                // file close
                if ((audio_data_size < AUDIO_WRITE_BUFF_SIZE) || (button == 0)) {
                    fclose(fp);
                    fp = NULL;
                    Thread::wait(500);
                }
            }
        }

        // close check
        if (fp != NULL) {
            fclose(fp);
            fp = NULL;
        }
        if (d != NULL) {
            closedir(d);
            d = NULL;
        }
    }
}
