/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

#ifndef USBHOSTAUDIO_H
#define USBHOSTAUDIO_H

#include "USBHostConf.h"
#include "USBHost.h"
#include "USBIsochronous.h"

#define USBDAC_DATA_SIZE       (192 * 8)

#define USBDAC_

/**
 * A class to communicate a USB dac (send:only 48kHz,16bit,2ch , receive:only 48kHz,16bit,1ch)
 */
class USBHostDac : public IUSBEnumerator {
public:

    /**
    * Constructor
    */
    USBHostDac();

    /** Destructor
     *
     */
    virtual ~USBHostDac();

    /**
     * Try to connect a audio device
     *
     * @return true if connection was successful
     */
    bool connect();

    /**
    * Check if a audio is connected
    *
    * @returns true if a audio is connected
    */
    bool connected();

    /**
    * Data send : only 48kHz,16bit,2ch. It's sent by the 1536byte unit.
    *
    * @param buf pointer on a buffer which will be written
    * @param len length of the transfer
    * @param flush if true, less than 1536 bytes of data is sent
    *
    * @returns the number of bytes written is returned
    */
    uint32_t send(uint8_t* buf, uint32_t len, bool flush = true);

    /**
    * Data receive : only 48kHz,16bit,1ch
    *
    * @param buf pointer on a buffer which will be read
    * @param len length of the transfer
    *
    * @returns the number of bytes read is returned
    */
    uint32_t receive(uint8_t* buf, uint32_t len);

protected:
    //From IUSBEnumerator
    virtual void setVidPid(uint16_t vid, uint16_t pid);
    virtual bool parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol); //Must return true if the interface should be parsed
    virtual bool useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir); //Must return true if the endpoint will be used

private:
    typedef struct {
        IsochronousEp* m_isoEp;
        uint16_t wMaxPacketSize;
        uint8_t  bEndpointAddress;
        uint8_t  bInterfaceNumber;
        uint8_t  bAlternateSetting;
        uint8_t* p_rest_data;
        uint32_t rest_data_index;
        uint32_t rest_data_size;
    } iso_if_t;

    USBHost * host;
    USBDeviceConnected * dev;

    bool dev_connected;
    bool audio_device_found;
    int audio_intf;
    int audio_intf_cnt;

    iso_if_t iso_send;
    iso_if_t iso_recv;

    void init();
    void onDisconnect();
    bool chkAudioStreaming();
    USB_TYPE setInterface(uint16_t alt, uint16_t index);
    void setSamplingRate(uint8_t endpoint_adder, uint32_t sampling_rate);
};
#endif
