#include "FATFileSystem.h"
#include "USBHostMSD.h"
#include "USBHostC270.h"

#if defined(TARGET_RZ_A1H)
#include "usb_host_setting.h"
#else
#define USB_HOST_CH     0
#endif

#if (USB_HOST_CH == 1) //Audio Camera Shield USB1
DigitalOut usb1en(P3_8);
#endif

Serial pc(USBTX, USBRX);
BusOut leds(LED1, LED2, LED3);

static uint8_t buf[1024*10];

int main() {
    pc.baud(921600);

    
#if (USB_HOST_CH == 1) //Audio Shield USB1
    //Audio Shield USB1 enable
    usb1en = 1;        //Outputs high level
    Thread::wait(5);
    usb1en = 0;        //Outputs low level
#endif

     // USB flash drive
    FATFileSystem fs("usb");
    USBHostMSD msd;
    
    while(!msd.connect()) {
        Thread::wait(500);
    }
    fs.mount(&msd);
    
    USBHostC270* cam = new USBHostC270(C270_MJPEG, C270_160x120, _5FPS); // Logitech C270

    Timer interval_t;
    interval_t.reset();
    interval_t.start();
    int shot = 0;
    while(1) {
        if (interval_t.read() > 10 && cam->connected()) {
            int r = cam->readJPEG(buf, sizeof(buf));
            char path[32];
            snprintf(path, sizeof(path), "/usb/image%02d.jpg", shot % 20);
            printf("%d %s %d bytes\n", shot, path, r);
            if (msd.connected()) {
                FILE* fp = fopen(path, "wb");
                if (fp) {
                    fwrite(buf, r, 1, fp);
                    fclose(fp);
                }
                shot++;
                leds = shot % 8;
            }
            interval_t.reset();
        }
        // If USB flash disk is unplugged, wait until USB is re-plugged
        if (!msd.connected()) {
            while(!msd.connect())
            {
                Thread::wait(500);
            }
            fs.mount(&msd);
        }
        // If Logitech C270 is unplugged, try to re-plug it
        if (!cam->connected()) {
            cam->connect();
            Thread::wait(500);
        } else {
            cam->poll();
        }
    }
}
