/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

/******************************************************************************
Includes   <System Includes> , "Project Includes"
******************************************************************************/
#include <stdio.h>
#include <stdint.h>
#include "mbed.h"
extern "C"{
#include    "iodefine.h"
#include    "devdrv_sdg.h"
}
#include    "score.h"
#include    "piano4int.h"


/******************************************************************************
Typedef definitions
******************************************************************************/


/******************************************************************************
Macro definitions
******************************************************************************/


/******************************************************************************
Imported global variables and functions (from other files)
******************************************************************************/


/******************************************************************************
Exported global variables and functions (to be accessed by other files)
******************************************************************************/
extern "C" {
    void Sample_OSTM0_Interrupt(void);
};

static void sound_LED (uint32_t channel, uint32_t value);


/******************************************************************************
Private global variables and functions
******************************************************************************/
Ticker      LEDTicker;
DigitalOut  LED(LED1);
DigitalOut  SoundLED(LED2);

static const int8_t score1[] = {
    SCORE1
};

static const int8_t score3[] = {
    SCORE3
};


/******************************************************************************
* Function Name: main
* Description  : Displays the sample program information on the terminal
*              : connected with the CPU board by the UART, and executes initial
*              : setting for the PORT connected with the LEDs on the board.
*              : Executes initial setting for the OSTM channel 0, and sets the
*              : timer counter so that the OSTM0 interrupt occurs every 500ms.
* Arguments    : none
* Return Value : 0
******************************************************************************/
int main(void)
{
    static const int8_t *scores[SDG_CH_TOTAL] = {
        /*DEVDRV_CH_0*/ NULL,
        /*DEVDRV_CH_1*/ score1,
        /*DEVDRV_CH_2*/ NULL,
        /*DEVDRV_CH_3*/ score3
    };
    /* ==== Setup the I/O without buffering ==== */
    printf("\nRZ/A1H CPU Board Sample Program. Ver.1.00\n");
    printf("RZ/A1H Sound Generator Sample Program. Ver.0.01\n");
    printf("Copyright (C) 2015 Renesas Electronics Corporation. All rights reserved.\n");
    printf("\n");

    LED = 0;
    LEDTicker.attach(&Sample_OSTM0_Interrupt, 0.2);

    /* ==== Receive command, activate sample software ==== */
    while (true) {
        /* start playing scores */
        piano4int_start (scores, sound_LED);

        while (piano4int_status()) {
            /* wait 10ms */
            wait_us(10.0 * 1000.0);
        }
        /* stop playing scores */
        piano4int_stop(false);
        /* wait 5 seconds */
        wait(5.0);
    }
    return 0;
}

/******************************************************************************
* Function Name: Sample_OSTM0_Interrupt
* Description  : This function is executed when the OSTM0 interrupt is received.
*              : In this sample code, the processing to blink the LEDs on the
*              : CPU board every 500ms is executed.
* Arguments    : none
* Return Value : none
******************************************************************************/
void Sample_OSTM0_Interrupt(void)
{
    /* ==== LED blink ==== */
    LED = LED ^ 1;
}

/******************************************************************************
* End of Function Sample_OSTM0_Interrupt
******************************************************************************/

/******************************************************************************
* Function Name: sound_LED
* Description  : This function is used for callback function.
* Arguments    : uint32_t channel : SDG channel (0, 1, 2 or 3)
*              : uint32_t value   : Syncronization Marker ID
* Return Value : none
******************************************************************************/
static void sound_LED (uint32_t channel, uint32_t value)
{
    /* ==== LED blink ==== */
    SoundLED = SoundLED ^ 1;
}

/* End of File */
