/******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2015 Renesas Electronics Corporation. All
* rights reserved.
******************************************************************************/

#ifndef __PIANO4INT_H
#define __PIANO4INT_H

/******************************************************************************
Includes   <System Includes> , "Project Includes"
******************************************************************************/


/******************************************************************************
Macro definitions
******************************************************************************/
#define     OCTAVE0_CHAR        ('-')
#define     OCTAVE1_CHAR        (' ')
#define     OCTAVE2_CHAR        ('+')
#define     OCTAVE3_CHAR        ('*')

#define     NOTE_DO_CHAR        ('C')
#define     NOTE_RE_CHAR        ('D')
#define     NOTE_MI_CHAR        ('E')
#define     NOTE_FA_CHAR        ('F')
#define     NOTE_SO_CHAR        ('G')
#define     NOTE_RA_CHAR        ('A')
#define     NOTE_SI_CHAR        ('B')
#define     NOTE_REST_CHAR      ('R')

#define     NOTE_SHARP          ('#')

#define     NOTE_TIE            ('_')

#define     NOTE_DOT            ('.')

#define     NOTE_MARKER         ('@')

/* base time  */
#define     BASESPEED           (60 * 1000 * 4)

#define     MAXOCTAVE           (4)
#define     MAXNOTE             (13)

#define     DEFLOUDNESS         (4)

/* octave level value */
#define     OCTAVE_LEVEL_0      (0)
#define     OCTAVE_LEVEL_1      (1)
#define     OCTAVE_LEVEL_2      (2)
#define     OCTAVE_LEVEL_3      (3)

/* key value */
#define     KEY_C               (3)
#define     KEY_D               (5)
#define     KEY_E               (7)
#define     KEY_F               (8)
#define     KEY_G               (10)
#define     KEY_A               (0)
#define     KEY_B               (2)
#define     KEY_R               (12)

/* dotted note value */
#define     DOTTED_NOTE         (1)
#define     NOT_DOTTED_NONE     (0)

/* tied note value */
#define     TIED_NOTE           (0)
#define     NOT_TIED_NONE       (4)

/******************************************************************************
Typedef definitions
******************************************************************************/
typedef void (*PIANO4INT_CB)(uint32_t channel, uint32_t value);

/******************************************************************************
Imported global variables and functions (from other files)
******************************************************************************/


/******************************************************************************
Exported global variables and functions (to be accessed by other files)
******************************************************************************/
extern void piano4int_start(const int8_t *scores[SDG_CH_TOTAL], PIANO4INT_CB callback);
extern void piano4int_stop(bool force);
extern bool piano4int_status(void);


#endif  /*__PIANO4INT_H*/

/* End of File */
