/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

#ifndef SDG_IOBITMASK_H
#define SDG_IOBITMASK_H


/* ==== Mask values for IO registers ==== */
/* ---- SDGn ---- */
#define     SDGn_SGCR1_SGST_SHIFT       (7u)
#define     SDGn_SGCR1_STPM_SHIFT       (6u)
#define     SDGn_SGCR1_SGCK_SHIFT       (3u)
#define     SDGn_SGCR1_DPF_SHIFT        (0u)

#define     SDGn_SGCSR_SGIE_SHIFT       (7u)
#define     SDGn_SGCSR_SGDEF_SHIFT      (6u)

#define     SDGn_SGCR2_SGEND_SHIFT      (7u)
#define     SDGn_SGCR2_TCHG_SHIFT       (6u)

#define     SDGn_SGLR_LD_SHIFT          (0u)

#define     SDGn_SGTFR_TONE_SHIFT       (0u)

#define     SDGn_SGSFR_SFS_SHIFT        (0u)


#define     SDGn_SGCR1_SGST             (1u << SDGn_SGCR1_SGST_SHIFT)
#define     SDGn_SGCR1_STPM             (1u << SDGn_SGCR1_STPM_SHIFT)
#define     SDGn_SGCR1_SGCK             (0x3u << SDGn_SGCR1_SGCK_SHIFT)
#define     SDGn_SGCR1_DPF              (0x7u << SDGn_SGCR1_DPF_SHIFT)

#define     SDGn_SGCSR_SGIE             (1u << SDGn_SGCSR_SGIE_SHIFT)
#define     SDGn_SGCSR_SGDEF            (1u << SDGn_SGCSR_SGDEF_SHIFT)

#define     SDGn_SGCR2_SGEND            (1u << SDGn_SGCR2_SGEND_SHIFT)
#define     SDGn_SGCR2_TCHG             (1u << SDGn_SGCR2_TCHG_SHIFT)

#define     SDGn_SGLR_LD                (0xFFu << SDGn_SGLR_LD_SHIFT)

#define     SDGn_SGTFR_TONE             (0x7Fu << SDGn_SGTFR_TONE_SHIFT)

#define     SDGn_SGSFR_SFS              (0xFFu << SDGn_SGSFR_SFS_SHIFT )



#endif /* SDG_IOBITMASK_H */

/* End of File */
