/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

/******************************************************************************
Includes   <System Includes> , "Project Includes"
******************************************************************************/
#include "r_typedefs.h"
#include "dev_drv.h"                /* Device Driver common header */
#include "devdrv_sdg.h"             /* SDG Driver header */
#include "iodefine.h"
#include "sdg_iobitmask.h"
#include "rza_io_regrw.h"

/******************************************************************************
Typedef definitions
******************************************************************************/


/******************************************************************************
Macro definitions
******************************************************************************/
#define REGW16(CH, REG, BIT, VAL) RZA_IO_RegWrite_16(&CH.REG, VAL, CH##_##REG##_##BIT##_SHIFT, CH##_##REG##_##BIT)

/******************************************************************************
Imported global variables and functions (from other files)
******************************************************************************/


/******************************************************************************
Exported global variables and functions (to be accessed by other files)
******************************************************************************/


/******************************************************************************
Private global variables and functions
******************************************************************************/


/******************************************************************************
* Function Name: Userdef_SDG0_Open
* Description  : This function is a user-defined function.
* Arguments    : none
* Return Value : DEVDRV_SUCCESS   : Success to initialize SDG0
*              : DEVDRV_ERROR     : Failure to initialize SDG0
******************************************************************************/
int32_t Userdef_SDG0_Open(void)
{
    return DEVDRV_ERROR;
}

/******************************************************************************
* Function Name: Userdef_SDG1_Open
* Description  : This function is a user-defined function.
* Arguments    : none
* Return Value : DEVDRV_SUCCESS   : Success to initialize SDG1
*              : DEVDRV_ERROR     : Failure to initialize SDG1
******************************************************************************/
int32_t Userdef_SDG1_Open(void)
{
    /* input the clock to SDG1  */
    RZA_IO_RegWrite_8(&CPG.STBCR5, 0, CPG_STBCR5_MSTP54_SHIFT, CPG_STBCR5_MSTP54);

    /* check the mode of SDG1 */
    if (0 != RZA_IO_RegRead_8(&SDG1.SGCR1, SDGn_SGCR1_SGST_SHIFT, SDGn_SGCR1_SGST)) {
        return DEVDRV_ERROR;
    }

    /* ---- P8_11 : SDOUT_1 ---- */
    /* Port initialize */
    REGW16(GPIO, PIBC8, PIBC811, 0);
    REGW16(GPIO, PBDC8, PBDC811, 0);
    REGW16(GPIO, PM8,   PM811,   1);
    REGW16(GPIO, PMC8,  PMC811,  0);
    REGW16(GPIO, PIPC8, PIPC811, 0);
    /* Port mode : Multiplex mode                     */
    /* Port function setting : 7th multiplex function */
    /* I/O control mode : Peripheral function         */
    /* Bidirectional mode : Disable                   */
    REGW16(GPIO, PBDC8, PBDC811, 0);
    REGW16(GPIO, PFC8,  PFC811,  0);
    REGW16(GPIO, PFCE8, PFCE811, 1);
    REGW16(GPIO, PFCAE8,PFCAE811,1);
    REGW16(GPIO, PIPC8, PIPC811, 1);
    REGW16(GPIO, PMC8,  PMC811,  1);

    return DEVDRV_SUCCESS;
}

/******************************************************************************
* Function Name: Userdef_SDG2_Open
* Description  : This function is a user-defined function.
* Arguments    : none
* Return Value : DEVDRV_SUCCESS   : Success to initialize SDG2
*              : DEVDRV_ERROR     : Failure to initialize SDG2
******************************************************************************/
int32_t Userdef_SDG2_Open(void)
{
    return DEVDRV_ERROR;
}

/******************************************************************************
* Function Name: Userdef_SDG3_Open
* Description  : This function is a user-defined function.
* Arguments    : none
* Return Value : DEVDRV_SUCCESS   : Success to initialize SDG3
*              : DEVDRV_ERROR     : Failure to initialize SDG3
******************************************************************************/
int32_t Userdef_SDG3_Open(void)
{
    /* input the clock to SDG3  */
    RZA_IO_RegWrite_8(&CPG.STBCR5, 0, CPG_STBCR5_MSTP52_SHIFT, CPG_STBCR5_MSTP52);

    /* check the mode of SDG3 */
    if (0 != RZA_IO_RegRead_8(&SDG3.SGCR1, SDGn_SGCR1_SGST_SHIFT, SDGn_SGCR1_SGST)) {
        return DEVDRV_ERROR;
    }

    /* ---- P8_13 : SDOUT_3 ---- */
    /* Port initialize */
    REGW16(GPIO, PIBC8, PIBC813,  0);
    REGW16(GPIO, PBDC8, PBDC813,  0);
    REGW16(GPIO, PM8,   PM813,    1);
    REGW16(GPIO, PMC8,  PMC813,   0);
    REGW16(GPIO, PIPC8, PIPC813,  0);
    /* Port mode : Multiplex mode                     */
    /* Port function setting : 7th multiplex function */
    /* I/O control mode : Peripheral function         */
    /* Bidirectional mode : Disable                   */
    REGW16(GPIO, PBDC8, PBDC813,  0);
    REGW16(GPIO, PFC8,  PFC813,   0);
    REGW16(GPIO, PFCE8, PFCE813,  1);
    REGW16(GPIO, PFCAE8,PFCAE813, 1);
    REGW16(GPIO, PIPC8, PIPC813,  1);
    REGW16(GPIO, PMC8,  PMC813,   1);

    return DEVDRV_SUCCESS;
}

/******************************************************************************
* Function Name: Userdef_SDG0_Close
* Description  : This function is a user-defined function.
* Arguments    : none
* Return Value : DEVDRV_SUCCESS   : Success to initialize SDG0
*              : DEVDRV_ERROR     : Failure to initialize SDG0
******************************************************************************/
int32_t Userdef_SDG0_Close(void)
{
    return DEVDRV_ERROR;
}


/******************************************************************************
* Function Name: Userdef_SDG1_Close
* Description  : This function is a user-defined function.
* Arguments    : none
* Return Value : DEVDRV_SUCCESS   : Success to initialize SDG1
*              : DEVDRV_ERROR     : Failure to initialize SDG1
******************************************************************************/
int32_t Userdef_SDG1_Close(void)
{
    /* Stop the SDG1 */
    RZA_IO_RegWrite_8(&SDG1.SGCR1, 0, SDGn_SGCR1_STPM_SHIFT, SDGn_SGCR1_STPM);
    RZA_IO_RegWrite_8(&SDG1.SGCR1, 0, SDGn_SGCR1_SGST_SHIFT, SDGn_SGCR1_SGST);
    /* Stop input the clock to SDG1  */
    RZA_IO_RegWrite_8(&CPG.STBCR5, 1, CPG_STBCR5_MSTP54_SHIFT, CPG_STBCR5_MSTP54);

    return DEVDRV_SUCCESS;
}

/******************************************************************************
* Function Name: Userdef_SDG2_Close
* Description  : This function is a user-defined function.
* Arguments    : none
* Return Value : DEVDRV_SUCCESS   : Success to initialize SDG2
*              : DEVDRV_ERROR     : Failure to initialize SDG2
******************************************************************************/
int32_t Userdef_SDG2_Close(void)
{
    return DEVDRV_ERROR;
}

/******************************************************************************
* Function Name: Userdef_SDG3_Close
* Description  : This function is a user-defined function.
* Arguments    : none
* Return Value : DEVDRV_SUCCESS   : Success to initialize SDG3
*              : DEVDRV_ERROR     : Failure to initialize SDG3
******************************************************************************/
int32_t Userdef_SDG3_Close(void)
{
    /* Stop the SDG3 */
    RZA_IO_RegWrite_8(&SDG3.SGCR1, 0, SDGn_SGCR1_STPM_SHIFT, SDGn_SGCR1_STPM);
    RZA_IO_RegWrite_8(&SDG3.SGCR1, 0, SDGn_SGCR1_SGST_SHIFT, SDGn_SGCR1_SGST);
    /* Stop input the clock to SDG3  */
    RZA_IO_RegWrite_8(&CPG.STBCR5, 1, CPG_STBCR5_MSTP52_SHIFT, CPG_STBCR5_MSTP52);

    return DEVDRV_SUCCESS;
}

/* End of File */
