/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

#ifndef DEVDRV_SDG_H
#define DEVDRV_SDG_H

/******************************************************************************
Includes   <System Includes> , "Project Includes"
******************************************************************************/


/******************************************************************************
Typedef definitions
******************************************************************************/
/* selects SGCLK */
typedef enum
{
    R_SDG_CLOCK_2   = 0,
    R_SDG_CLOCK_4   = 1,
    R_SDG_CLOCK_8   = 2,
    R_SDG_CLOCK_16  = 3,
} R_SDG_CLOCK;


/* Attenuation */
typedef enum
{
    R_SDG_ATT_OFF   = 0,
    R_SDG_ATT_1     = 1,
    R_SDG_ATT_2     = 2,
    R_SDG_ATT_4     = 3,
    R_SDG_ATT_8     = 4,
    R_SDG_ATT_16    = 5,
    R_SDG_ATT_32    = 6,
} R_SDG_ATTENUATION;


/* callback: now, no implement */
typedef     void(*callback)(uint32_t channel);

/* a note */
typedef struct {
    uint8_t tone;           /* tone value (0 < tone <= 127 ) */
    uint8_t sfs;            /* SFS value (0 < SFS <= 255 )*/
    uint8_t loud;           /* LD value (0 <= LD <= 255 ) */
    uint8_t attenuation;    /* Attenuation value */
} NOTE;


/******************************************************************************
Macro definitions
******************************************************************************/
#define     SDG_CH_TOTAL    (SDG_COUNT)     /* units of sound generator */
#define     SDG_TONE_MAX    (127)           /* maximum value of tone */

/******************************************************************************
Variable Externs
******************************************************************************/


/******************************************************************************
Functions Prototypes
******************************************************************************/
/* ==== API functions ==== */
int32_t R_SDG_Open(uint32_t channel, R_SDG_CLOCK clock);
int32_t R_SDG_Close(uint32_t channel);
int32_t R_SDG_Tone(uint32_t channel, NOTE *note);

/* ==== User-defined functions ==== */
int32_t Userdef_SDG0_Open(void);
int32_t Userdef_SDG1_Open(void);
int32_t Userdef_SDG2_Open(void);
int32_t Userdef_SDG3_Open(void);

int32_t Userdef_SDG0_Close(void);
int32_t Userdef_SDG1_Close(void);
int32_t Userdef_SDG2_Close(void);
int32_t Userdef_SDG3_Close(void);


#endif  /* DEVDRV_SDG_H */

/* End of File */
