/*
 * IHttpDataIn.h
 *
 *  Created on: Aug 15, 2016
 *      Author: Faheem Inayat
 * Created for: Renesas Electronics America HQ, Santa Clara, CA, USA
 * 
 * Copyright (c) 2016 Renesas Electronics America (REA) and Faheem Inayat
 */
/*
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef IHTTPDATAIN_H_
    #define IHTTPDATAIN_H_

#include "stddef.h"

///This is a simple interface for HTTP data storage (impl examples are Key/Value Pairs, File, etc...)
class IHttpDataIn
{
    public:
        IHttpDataIn ();
        virtual ~IHttpDataIn ();

        /** Reset stream to its beginning
         * Called by the HTTPClient on each new request
         */
        virtual void writeReset() = 0;

        /** Write a piece of data transmitted by the server
         * @param buf Pointer to the buffer from which to copy the data
         * @param len Length of the buffer
         */
        virtual int write(const char* buf, size_t len) = 0;

        /** Set MIME type
         * @param type Internet media type from Content-Type header
         */
        virtual void setDataType(const char* type) = 0;

        /** Determine whether the data is chunked
         *  Recovered from Transfer-Encoding header
         */
        virtual void setIsChunked(bool chunked) = 0;

        /** If the data is not chunked, set its size
         * From Content-Length header
         */
        virtual void setDataLen(size_t len) = 0;
};

#endif /* IHTTPDATAIN_H_ */

