/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef USBHOSTMOUSE_H
#define USBHOSTMOUSE_H

#include "USBHostConf.h"

#if USBHOST_MOUSE

#include "USBHost.h"

/** 
 * A class to communicate a USB mouse
 */
class USBHostMouse : public IUSBEnumerator {
public:

    /**
    * Constructor
    */
    USBHostMouse();

    /**
     * Try to connect a mouse device
     *
     * @return true if connection was successful
     */
    bool connect();

    /**
    * Check if a mouse is connected
    *
    * @returns true if a mouse is connected
    */
    bool connected();

    /**
     * Attach a callback called when a mouse event is received
     *
     * @param ptr function pointer
     */
    inline void attach(void (*ptr)(uint8_t buttons, int8_t x, int8_t y, int8_t z)) {
        if (ptr != NULL) {
            onUpdate = ptr;
        }
    }

protected:
    //From IUSBEnumerator
    virtual void setVidPid(uint16_t vid, uint16_t pid);
    virtual bool parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol); //Must return true if the interface should be parsed
    virtual bool useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir); //Must return true if the endpoint will be used

private:
    USBHost * host;
    USBDeviceConnected * dev;
    USBEndpoint * int_in;
    uint8_t report[4];
    
    bool dev_connected;
    bool mouse_device_found;
    int mouse_intf;

    void rxHandler();
    void (*onUpdate)(uint8_t buttons, int8_t x, int8_t y, int8_t z);
    int report_id;
    void init();
};

#endif

#endif

