/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "USBHostMouse.h"

#if USBHOST_MOUSE

USBHostMouse::USBHostMouse() {
    host = USBHost::getHostInst();
    init();
}

void USBHostMouse::init() {
    dev = NULL;
    int_in = NULL;
    onUpdate = NULL;
    report_id = 0;
    dev_connected = false;
    mouse_device_found = false;
    mouse_intf = -1;
}

bool USBHostMouse::connected() {
    return dev_connected;
}

bool USBHostMouse::connect() {
    
    U8 i;
    
    if (dev_connected) {
        return true;
    }
    
    for (i = 0; i < MAX_DEVICE_CONNECTED; i++) {
        if ((dev = host->getDevice(i)) != NULL) {

            if(host->enumerate(dev, this))
                break;
            
            if (mouse_device_found) {
                
                int_in = dev->getEndpoint(mouse_intf, INTERRUPT_ENDPOINT, IN);
                if (!int_in)
                    break;
                
                USB_INFO("New Mouse device: VID:%04x PID:%04x [dev: %p]", dev->getVid(), dev->getPid(), dev);
                dev->setName("Mouse");
                host->registerDriver(dev, mouse_intf, this, &USBHostMouse::init);
                
                int_in->attach(this, &USBHostMouse::rxHandler);
                host->interruptRead(dev, int_in, report, int_in->getSize(), false);
                
                dev_connected = true;
                return true;
            }
        }
    }
    init();
    return false;
}

void USBHostMouse::rxHandler() {
    int len_listen = int_in->getSize();
    int len = int_in->getLengthTransferred();
    if (onUpdate) {
        (*onUpdate)(report[0] & 0x07, report[1], report[2], report[3]);
    }
    if (dev != NULL)
        host->interruptRead(dev, int_in, report, len_listen, false);
}

/*virtual*/ void USBHostMouse::setVidPid(uint16_t vid, uint16_t pid)
{
    // we don't check VID/PID for mouse driver
}

/*virtual*/ bool USBHostMouse::parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol) //Must return true if the interface should be parsed
{
    if ((mouse_intf == -1) &&
        (intf_class == HID_CLASS) &&
        (intf_subclass == 0x01) &&
        (intf_protocol == 0x02)) {
        mouse_intf = intf_nb;
        return true;
    }
    return false;
}

/*virtual*/ bool USBHostMouse::useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir) //Must return true if the endpoint will be used
{
    if (intf_nb == mouse_intf) {
        if (type == INTERRUPT_ENDPOINT && dir == IN) {
            mouse_device_found = true;
            return true;
        }
    }
    return false;
}

#endif

