#ifndef USBHOST_CONF_H
#define USBHOST_CONF_H

/*
* Maximum number of devices that can be connected
* to the usb host
*/
#define MAX_DEVICE_CONNECTED        10

/*
* Maximum of Hub connected to the usb host
*/
#define MAX_HUB_NB                  5

/*
* Maximum number of ports on a USB hub
*/
#define MAX_HUB_PORT                4

/*
* Enable USBHostMSD
*/
#define USBHOST_MSD                 1

/*
* Enable USBHostKeyboard
*/
#define USBHOST_KEYBOARD            1

/*
* Enable USBHostMouse
*/
#define USBHOST_MOUSE               1

/*
* Enable USBHostSerial
*/
#define USBHOST_SERIAL              1

/*
* Maximum number of interfaces of a usb device
*/
#define MAX_INTF                    2

/*
* Maximum number of endpoints on each interface
*/
#define MAX_ENDPOINT_PER_INTERFACE  3

/*
* Maximum number of endpoint descriptors that can be allocated
*/
#define MAX_ENDPOINT                (MAX_DEVICE_CONNECTED * MAX_INTF * MAX_ENDPOINT_PER_INTERFACE)

/*
* Maximum number of transfer descriptors that can be allocated
*/
#define MAX_TD                      (MAX_ENDPOINT*2)

/*
* usb_thread stack size
*/
#define USB_THREAD_STACK            (128*4 + MAX_HUB_NB*128*4)

#endif

