#include "mbed.h"
#include "JPEG_Converter.h"
#include "USBHostMSD.h"
#if defined(TARGET_RZ_A1H)
#include "usb_host_setting.h"
#else
#define USB_HOST_CH     0
#endif

#define SAMPLE_WIDTH        (320)
#define SAMPLE_HEIGHT       (240)
#define SAMPLE_BUFF_SIZE    (SAMPLE_WIDTH * SAMPLE_HEIGHT * 4)

#define MAX_FILE_NAME_LENGTH    (64)
#define FOLD_COUNT              (5)

#if (USB_HOST_CH == 1) //Audio Camera Shield USB1
DigitalOut usb1en(P3_8);
#endif
DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);

static uint8_t JCUBuffer_INPUT[SAMPLE_BUFF_SIZE]__attribute((section("NC_BSS"),aligned(8)));  //8 bytes aligned!;
static uint8_t JCUBuffer_OUTPUT[SAMPLE_BUFF_SIZE]__attribute((section("NC_BSS"),aligned(8)));  //8 bytes aligned!;

bool get_file_name(char * p_buf, int size) {
    bool ret;
    char ch;
    int i = 0;

    while (1) {
        ch = (char)pc.getc();
        if (ch == '\r'){
            p_buf[i] = '\0';
            pc.putc('\n');
            ret = true;
            break;
        } else if (ch == '\n') {
            // Do Nothing
        } else if (ch == '\b') {
            if (i > 0) {
                pc.puts("\b \b");
                i--;
                p_buf[i] = '\0';
            }
        } else if (i < size) {
            p_buf[i] = ch;
            i++;
            pc.putc(ch);
        } else {
            ret = false;
            break;
        }
    }

    return ret;
}

int main() {
    char file_name[MAX_FILE_NAME_LENGTH + FOLD_COUNT];
    JPEG_Converter  decoder;
    JPEG_Converter::bitmap_buff_info_t  aBitmapData;
    FILE * rd_fp = NULL;
    FILE * wr_fp = NULL;
    int filesize;
    size_t EncodeSize;

    file_name[0] = '/';
    file_name[1] = 'u';
    file_name[2] = 's';
    file_name[3] = 'b';
    file_name[4] = '/';

#if (USB_HOST_CH == 1) //Audio Shield USB1
    //Audio Shield USB1 enable
    usb1en = 1;        //Outputs high level
    Thread::wait(5);
    usb1en = 0;        //Outputs low level
#endif
    USBHostMSD msd("usb");

    //try to connect a MSD device
    while(!msd.connect()) {
        Thread::wait(500);
    }

    pc.printf("%dpix x %dpix\n", SAMPLE_WIDTH, SAMPLE_HEIGHT);

    while (1) {
        pc.printf("\nInput file name (.jpg or .bin)>");
        if (get_file_name(&file_name[FOLD_COUNT], MAX_FILE_NAME_LENGTH) == false) {
            pc.printf("Error:Max file name length is %d\n", MAX_FILE_NAME_LENGTH);
        } else {
            size_t len = strlen(file_name);
            if ((len > 4) && (file_name[len - 4] == (char)'.')
                && ((file_name[len - 3] | 0x20u) == (char)'j')
                && ((file_name[len - 2] | 0x20u) == (char)'p')
                && ((file_name[len - 1] | 0x20u) == (char)'g')) {
                // input ".jpg"
                // decode JPG file to bitmap file
                rd_fp = fopen(file_name, "r");
                if (rd_fp == NULL) {
                    pc.printf("Error:File is not exist \n");
                } else {
                    fseek(rd_fp, 0, SEEK_END);
                    filesize = ftell(rd_fp);
                    if (filesize > SAMPLE_BUFF_SIZE) {
                        pc.printf("Error:File size over \n");
                    } else {
                        led1 = 1;
                        fseek(rd_fp, 0, SEEK_SET);
                        fread(&JCUBuffer_INPUT[0], sizeof(char), filesize, rd_fp);
                        pc.printf("[Decode Mode]\n");
                        pc.printf("\nOutput file name (.bin)>");
                        if (get_file_name(&file_name[FOLD_COUNT], MAX_FILE_NAME_LENGTH) == false) {
                            pc.printf("Error:Max file name length is %d\n", MAX_FILE_NAME_LENGTH);
                        } else {
                            //YCbCr setting
                            aBitmapData.width           = SAMPLE_WIDTH;
                            aBitmapData.height          = SAMPLE_HEIGHT;
                            aBitmapData.format          = JPEG_Converter::WR_RD_YCbCr422;   //YCbCr[0] & ARGB8888[1] is 4byte, not RGB565[2] is 2byte
                            aBitmapData.buffer_address  = (void *)JCUBuffer_OUTPUT;
                            pc.printf("File decode start\n");
                            // JPEG_Converter
                            if (decoder.decode((void *)JCUBuffer_INPUT, &aBitmapData) == JPEG_Converter::JPEG_CONV_OK) {
                                pc.printf("File decode done %dbyte\n", (SAMPLE_WIDTH * SAMPLE_HEIGHT * 4));
                                pc.printf("File write start\n");
                                wr_fp = fopen(file_name, "w");
                                fwrite(JCUBuffer_OUTPUT, sizeof(char), (SAMPLE_WIDTH * SAMPLE_HEIGHT * 4), wr_fp);

                                fclose(wr_fp);
                                pc.printf("File write done\n");
                                led1 = 0;
                            } else {
                                pc.printf("Error:JCU decode error\n");
                                led1 = 0;
                            }
                        }
                    }
                    fclose(rd_fp);
                }
            } else if ((file_name[len - 4] == (char)'.')
                && ((file_name[len - 3] | 0x20u) == (char)'b')
                && ((file_name[len - 2] | 0x20u) == (char)'i')
                && ((file_name[len - 1] | 0x20u) == (char)'n')) {
                // input ".bin"
                // encode bitmap file to JPEG file
                rd_fp = fopen(file_name, "r");
                if (rd_fp == NULL) {
                    pc.printf("Error:File is not exist\n");
                } else {
                    fseek(rd_fp, 0, SEEK_END);
                    filesize = ftell(rd_fp);
                    if (filesize > SAMPLE_BUFF_SIZE) {
                        fclose(wr_fp);
                        pc.printf("Error:File size over\n");
                    } else {
                        led1 = 1;
                        fseek(rd_fp, 0, SEEK_SET);
                        fread(&JCUBuffer_INPUT[0], sizeof(char), filesize, rd_fp);
                        pc.printf("[Encode Mode]\n");
                        pc.printf("\nOutput file name (.jpg)>");
                        if (get_file_name(&file_name[FOLD_COUNT], MAX_FILE_NAME_LENGTH) == false) {
                            pc.printf("Error:Max file name length is %d\n", MAX_FILE_NAME_LENGTH);
                            fclose(rd_fp);
                        } else {
                            //YCbCr setting
                            aBitmapData.width           = SAMPLE_WIDTH;
                            aBitmapData.height          = SAMPLE_HEIGHT;
                            aBitmapData.format          = JPEG_Converter::WR_RD_YCbCr422;   //YCbCr[0] & ARGB8888[1] is 4byte, not RGB565[2] is 2byte
                            aBitmapData.buffer_address  = (void *)JCUBuffer_INPUT;
                            pc.printf("File encode start\n");
                            // JPEG_Converter
                            if (decoder.encode(&aBitmapData, JCUBuffer_OUTPUT, &EncodeSize) == JPEG_Converter::JPEG_CONV_OK) {
                                pc.printf("File encode done %dbyte\n", EncodeSize);
                                pc.printf("File write start\n");
                                wr_fp = fopen(file_name, "w");
                                fwrite(JCUBuffer_OUTPUT, sizeof(char), EncodeSize, wr_fp);

                                fclose(wr_fp);
                                pc.printf("File write done\n");
                                led1 = 0;
                            } else {
                                pc.printf("Error:JCU encode error\n");
                                led1 = 0;
                            }
                        }
                    }
                    fclose(rd_fp);
                }
            } else {
                pc.printf("Error:Not supported extension (.jpg or .bin)\n");
            }
        }
    }
}
