#ifndef RECOGNITION_PROCESSING_H
#define RECOGNITION_PROCESSING_H

#include "DisplayBace.h"
#include "HVCApi.h"
#include "HVCDef.h"
#include "HVCExtraUartFunc.h"

#define BODY_THRESHOLD_DEFAULT             500            /* Threshold for Human Body Detection */
#define FACE_THRESHOLD_DEFAULT             500            /* Threshold for Face Detection */
#define HAND_THRESHOLD_DEFAULT             500            /* Threshold for Hand Detection */
#define REC_THRESHOLD_DEFAULT              500            /* Threshold for Face Recognition */

#define BODY_SIZE_RANGE_MIN_DEFAULT        180            /* Human Body Detection minimum detection size */
#define BODY_SIZE_RANGE_MAX_DEFAULT       1000            /* Human Body Detection maximum detection size */
#define HAND_SIZE_RANGE_MIN_DEFAULT        100            /* Hand Detection minimum detection size */
#define HAND_SIZE_RANGE_MAX_DEFAULT       1000            /* Hand Detection maximum detection size */
#define FACE_SIZE_RANGE_MIN_DEFAULT        100            /* Face Detection minimum detection size */
#define FACE_SIZE_RANGE_MAX_DEFAULT       1000            /* Face Detection maximum detection size */

#define FACE_POSE_DEFAULT                    0            /* Face Detection facial pose (frontal face)*/
#define FACE_ANGLE_DEFAULT                   0            /* Face Detection roll angle (±15°)*/

typedef struct {
    INT32         execFlag;
    HVC_THRESHOLD threshold;
    HVC_SIZERANGE sizeRange;
    INT32         pose;
    INT32         angle;
} recognition_setting_t;

extern void recognition_task(DisplayBase * p_display);

extern recognition_setting_t * GetRecognitionSettingPointer(void);
extern void SetRegistrationrReq(void);
extern void SetSettingReq(void);

#endif

