#ifndef IOT_READY_PROCESSING_H
#define IOT_READY_PROCESSING_H

#include "HVCApi.h"
#include "HVCDef.h"
#include "clib_drivers.h"

#define DETECT_MAX 35
#define WAIT_TIME 5000

#define USE_SENSOR_SHIELD
#define USE_HVC_P2

typedef struct {
    INT32 score_neutral;
    INT32 score_anger;
    INT32 score_happiness;
    INT32 score_surprise;
    INT32 score_sadness;
} IotReadyExpression_t;

typedef struct {
    int x;
    int y;
    int z;
} Accelerometer_t;

typedef struct {
    int red;
    int green;
    int blue;
    int alpha;
} Color_t;

/* Face data detected by HVC-P2 to send to IOT Platform */
typedef struct {
    AGE_RESULT				age;			/* Age Estimation result */
    GENDER_RESULT			gender;			/* Gender Estimation result */
    IntBoxType		face_rectangle;	/* rectangle of face detection result */
    IotReadyExpression_t	scores; 		/* Score of 5 expression */
} result_hvcp2_fd_t;

/* Body data detected by HVC-P2 to send to IOT Platform */
typedef struct {
    IntBoxType		body_rectangle;	/* rectangle of body detection result */
} result_hvcp2_bd_t;

/* Data detected by SENSORSHIELD-EVK-001 to send to IOT Platform */
typedef struct {
    int	Temperature;
    int	Atmosphere;
    Accelerometer_t Accelerometer;
    Color_t Color;
} result_sensor_shield_t;

#define _DEBUG
#ifdef _DEBUG
extern Serial pc;
#define DEBUG_PRINT(...) pc.printf(__VA_ARGS__)
#else
#define DEBUG_PRINT(...)
#endif

extern result_hvcp2_fd_t result_hvcp2_fd[DETECT_MAX];
extern result_hvcp2_bd_t result_hvcp2_bd[DETECT_MAX];
extern uint32_t result_hvcp2_bd_cnt;
extern uint32_t result_hvcp2_fd_cnt;

extern result_sensor_shield_t result_sensorshield;
extern Semaphore iot_ready_semaphore;
extern int semaphore_wait_ret;

#endif
