#include "mbed.h"
#include "EasyAttach_CameraAndLCD.h"
#include "recognition_proc.h"
#include "touch_proc.h"

static DisplayBase Display;
static Thread      recognitionTask(osPriorityNormal, 1024 * 8);
static Thread      touchTask;

/****** LCD ******/
static void IntCallbackFunc_LoVsync(DisplayBase::int_type_t int_type) {
    /* Interrupt callback function for Vsync interruption */
    touch_lcd_int(int_type);
}

/****** main ******/
int main(void) {
    /* Initialization of LCD */
    EasyAttach_Init(Display);

    /* Interrupt callback function setting (Vsync signal output from scaler 0) */
    Display.Graphics_Irq_Handler_Set(DisplayBase::INT_TYPE_S0_LO_VSYNC, 0, IntCallbackFunc_LoVsync);

    /* Start recognition processing */
    recognitionTask.start(callback(recognition_task, &Display));

    /* Start touch panel processing */
    touchTask.start(callback(touch_task, &Display));

    /* Backlight on */
    ThisThread::sleep_for(200);
    EasyAttach_LcdBacklight(true);

    /* Wait for the threads to finish */
    recognitionTask.join();
    touchTask.join();
}
