#include "mbed.h"
#include "TLV320_RBSP.h"
#include "USBHostMSD.h"
#if defined(TARGET_RZ_A1H)
#include "usb_host_setting.h"
#else
#define USB_HOST_CH     0
#endif

#if (USB_HOST_CH == 1) //Audio Shield USB1
DigitalOut usb1en(P3_8);
#endif
DigitalIn  button(USER_BUTTON0);

#define FILE_READ_BUFF_SIZE    (4096)
#define AUDIO_WRITE_BUFF_SIZE  (FILE_READ_BUFF_SIZE)
#define AUDIO_WRITE_BUFF_NUM   (16)
#define AUDIO_READ_BUFF_NUM    (0)
#define MAIL_QUEUE_SIZE        (AUDIO_WRITE_BUFF_NUM)
#define FILE_NAME_LEN          (64)
#define TEXT_SIZE              (64)
#define FLD_PATH               "/usb/"

typedef struct {
    void *   p_data;
    int32_t  result;
} mail_t;
Mail<mail_t, MAIL_QUEUE_SIZE> mail_box;

static uint8_t audio_write_buff[AUDIO_WRITE_BUFF_NUM][AUDIO_WRITE_BUFF_SIZE] __attribute((section("NC_BSS"),aligned(4)));  //4 bytes aligned! No cache memory
static uint8_t title_buf[TEXT_SIZE + 1];
static uint8_t artist_buf[TEXT_SIZE + 1];
static uint8_t album_buf[TEXT_SIZE + 1];
static uint32_t music_data_size;
static uint32_t music_data_index;

TLV320_RBSP audio(P3_13, P10_13, I2C_SDA, I2C_SCL, P4_4, P4_5, P4_7, P4_6, 0x80, AUDIO_WRITE_BUFF_NUM, AUDIO_READ_BUFF_NUM); // I2S Codec

static void callback_audio_tans_end(void * p_data, int32_t result, void * p_app_data) {
    mail_t *mail = mail_box.alloc();

    if (result < 0) {
        printf("error %d\n", result);
    }
    if (mail == NULL) {
        printf("error mail alloc\n");
    } else {
        mail->p_data    = p_data;
        mail->result    = result;
        mail_box.put(mail);
    }
}

static bool analyze_wav_heder(FILE * fp) {
    bool result = false;
    size_t read_size;
    uint8_t wk_read_buff[36];
    uint8_t *data;
    uint32_t chunk_size;
    uint32_t sub_chunk_size;
    uint32_t list_index_max;
    bool list_ok = false;
    uint32_t read_index = 0;
    uint32_t data_index = 0;
    int16_t wk_len;
    uint16_t ch;
    uint32_t sampling_rate;
    uint16_t block_size;

    music_data_size = 0;
    music_data_index = 0;
    title_buf[0] = '\0';
    artist_buf[0] = '\0';
    album_buf[0] = '\0';

    read_size = fread(&wk_read_buff[0], sizeof(char), 36, fp);
    if (read_size < 36) {
        // do nothing
    } else if (memcmp(&wk_read_buff[0], "RIFF", 4) != 0) {
        // do nothing
    } else if (memcmp(&wk_read_buff[8], "WAVE", 4) != 0) {
        // do nothing
    } else if (memcmp(&wk_read_buff[12], "fmt ", 4) != 0) {
        // do nothing
    } else {
        read_index += 36;
        ch = ((uint32_t)wk_read_buff[22] << 0) + ((uint32_t)wk_read_buff[23] << 8);
        sampling_rate = ((uint32_t)wk_read_buff[24] << 0)
                      + ((uint32_t)wk_read_buff[25] << 8)
                      + ((uint32_t)wk_read_buff[26] << 16)
                      + ((uint32_t)wk_read_buff[27] << 24);
        block_size = ((uint32_t)wk_read_buff[34] << 0) + ((uint32_t)wk_read_buff[35] << 8);
        if ((ch != 2) || (block_size != 16) || (sampling_rate != 44100)) {
            return false;
        }
        while (1) {
            read_size = fread(&wk_read_buff[0], sizeof(char), 8, fp);
            read_index += 8;
            if (read_size < 8) {
                break;
            } else {
                chunk_size = ((uint32_t)wk_read_buff[4] << 0)
                           + ((uint32_t)wk_read_buff[5] << 8)
                           + ((uint32_t)wk_read_buff[6] << 16)
                           + ((uint32_t)wk_read_buff[7] << 24);
                if (memcmp(&wk_read_buff[0], "data", 4) == 0) {
                    result = true;
                    music_data_size = chunk_size;
                    if (list_ok == true) {
                        break;
                    } else {
                        data_index = read_index;
                        fseek(fp, chunk_size, SEEK_CUR);
                        read_index += chunk_size;
                    }
                } else if (memcmp(&wk_read_buff[0], "LIST", 4) == 0) {
                    list_ok = true;
                    list_index_max = read_index + chunk_size;
                    read_size = fread(&wk_read_buff[0], sizeof(char), 4, fp);
                    read_index += 4;
                    while (read_index < list_index_max) {
                        read_size = fread(&wk_read_buff[0], sizeof(char), 8, fp);
                        read_index += 8;
                        if (read_size < 8) {
                            break;
                        } else if (memcmp(&wk_read_buff[0], "INAM", 4) == 0) {
                            data = title_buf;
                        } else if (memcmp(&wk_read_buff[0], "IART", 4) == 0) {
                            data = artist_buf;
                        } else if (memcmp(&wk_read_buff[0], "IPRD", 4) == 0) {
                            data = album_buf;
                        } else {
                            data = NULL;
                        }
                        if (data != NULL) {
                            sub_chunk_size = ((uint32_t)wk_read_buff[4] << 0)
                                           + ((uint32_t)wk_read_buff[5] << 8)
                                           + ((uint32_t)wk_read_buff[6] << 16)
                                           + ((uint32_t)wk_read_buff[7] << 24);
                            if (sub_chunk_size > TEXT_SIZE) {
                                wk_len = TEXT_SIZE;
                            } else {
                                wk_len = sub_chunk_size;
                            }
                            read_size = fread(data, sizeof(char), wk_len, fp);
                            read_index += sub_chunk_size;
                            fseek(fp, read_index, SEEK_SET);
                            data[wk_len] = '\0';
                        }
                    }
                    if (data_index != 0) {
                        break;
                    } else {
                        fseek(fp, list_index_max, SEEK_SET);
                    }
                } else {
                    fseek(fp, chunk_size, SEEK_CUR);
                    read_index += chunk_size;
                }
            }
        }

        if (data_index != 0) {
            fseek(fp, data_index, SEEK_SET);
        }
    }

    return result;
}

static size_t get_audio_data(void *buf, size_t len, FILE * fp) {
    if ((music_data_index + len) > music_data_size) {
        len = music_data_size - music_data_index;
    }
    music_data_index += len;

    return fread(buf, sizeof(char), len, fp);
}

void msd_task(void const *) {
    FILE * fp = NULL;
    DIR  * d = NULL;
    char file_path[sizeof(FLD_PATH) + FILE_NAME_LEN];
    rbsp_data_conf_t audio_write_async_ctl = {&callback_audio_tans_end, NULL};
    int cnt;
    size_t audio_data_size;

#if (USB_HOST_CH == 1) //Audio Shield USB1
    //Audio Shield USB1 enable
    usb1en = 1;        //Outputs high level
    Thread::wait(5);
    usb1en = 0;        //Outputs low level
#endif

    audio.power(0x02); // mic off
    audio.inputVolume(0.7, 0.7);

    for (cnt = 0; cnt < AUDIO_WRITE_BUFF_NUM; cnt++) {
        mail_t *mail = mail_box.alloc();

        if (mail == NULL) {
            printf("error mail alloc\n");
        } else {
            mail->p_data    = audio_write_buff[cnt];
            mail->result    = 0;
            mail_box.put(mail);
        }
    }

    USBHostMSD msd("usb");

    while(1) {
        // try to connect a MSD device
        while(!msd.connect()) {
            Thread::wait(500);
        }

        // in a loop, append a file
        // if the device is disconnected, we try to connect it again
        while(1) {
            // if device disconnected, try to connect again
            if (!msd.connected()) {
                break;
            }
            if (fp == NULL) {
                // file search
                if (d == NULL) {
                    d = opendir(FLD_PATH);
                }
                struct dirent * p;
                while ((p = readdir(d)) != NULL) {
                    size_t len = strlen(p->d_name);
                    if ((len > 4) && (len < FILE_NAME_LEN) && (memcmp(&p->d_name[len - 4], ".wav", 4) == 0)) {
                        strcpy(file_path, FLD_PATH);
                        strcat(file_path, p->d_name);
                        fp = fopen(file_path, "r");
                        if (analyze_wav_heder(fp) == false) {
                            fclose(fp);
                            fp = NULL;
                        } else {
                            printf("File  :%s\n", p->d_name);
                            printf("Title :%s\n", title_buf);
                            printf("Artist:%s\n", artist_buf);
                            printf("Album :%s\n", album_buf);
                            printf("\n");
                            break;
                        }
                    }
                }
                if (p == NULL) {
                    closedir(d);
                    d = NULL;
                }
            } else {
                // file read
                osEvent evt = mail_box.get();
                if (evt.status == osEventMail) {
                    mail_t *mail = (mail_t *)evt.value.p;

                    audio_data_size = get_audio_data(mail->p_data, FILE_READ_BUFF_SIZE, fp);
                    if (audio_data_size > 0) {
                        audio.write(mail->p_data, audio_data_size, &audio_write_async_ctl);
                        mail_box.free(mail);
                    } else {
                        mail_box.put(mail);
                    }
                } else {
                    audio_data_size = 0;
                }

                // file close
                if ((audio_data_size < FILE_READ_BUFF_SIZE) || (button == 0)) {
                    fclose(fp);
                    fp = NULL;
                    Thread::wait(500);
                }
            }
        }

        // close check
        if (fp != NULL) {
            fclose(fp);
            fp = NULL;
        }
        if (d != NULL) {
            closedir(d);
            d = NULL;
        }
    }
}

int main() {
    Thread msdTask(msd_task, NULL, osPriorityNormal, 1024 * 8);

    while(1) {
        Thread::wait(500);
    }
}
