/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer*
* Copyright (C) 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

#ifndef IMG_TBL_H
#define IMG_TBL_H

#include "r_typedefs.h"
#include "disp_graphics.h"

/*--- Macro definition ---*/
/* img_audio.cpp */
#define DSP_IMG_TP_AUDIO (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO (192u)
#define DSP_IMG_HS_AUDIO (45u)
#define DSP_IMG_SZ_AUDIO (34560u)

/* img_audio_bar.cpp */
#define DSP_IMG_TP_AUDIO_BAR (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BAR (540u)
#define DSP_IMG_HS_AUDIO_BAR (14u)
#define DSP_IMG_SZ_AUDIO_BAR (30240u)

/* img_audio_button1.cpp */
#define DSP_IMG_TP_AUDIO_BUTTON1 (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BUTTON1 (136u)
#define DSP_IMG_HS_AUDIO_BUTTON1 (60u)
#define DSP_IMG_SZ_AUDIO_BUTTON1 (32640u)

/* img_audio_button1d.cpp */
#define DSP_IMG_TP_AUDIO_BUTTON1D (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BUTTON1D (136u)
#define DSP_IMG_HS_AUDIO_BUTTON1D (60u)
#define DSP_IMG_SZ_AUDIO_BUTTON1D (32640u)

/* img_audio_button2.cpp */
#define DSP_IMG_TP_AUDIO_BUTTON2 (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BUTTON2 (136u)
#define DSP_IMG_HS_AUDIO_BUTTON2 (60u)
#define DSP_IMG_SZ_AUDIO_BUTTON2 (32640u)

/* img_audio_button2d.cpp */
#define DSP_IMG_TP_AUDIO_BUTTON2D (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BUTTON2D (136u)
#define DSP_IMG_HS_AUDIO_BUTTON2D (60u)
#define DSP_IMG_SZ_AUDIO_BUTTON2D (32640u)

/* img_audio_button3.cpp */
#define DSP_IMG_TP_AUDIO_BUTTON3 (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BUTTON3 (136u)
#define DSP_IMG_HS_AUDIO_BUTTON3 (60u)
#define DSP_IMG_SZ_AUDIO_BUTTON3 (32640u)

/* img_audio_button3d.cpp */
#define DSP_IMG_TP_AUDIO_BUTTON3D (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BUTTON3D (136u)
#define DSP_IMG_HS_AUDIO_BUTTON3D (60u)
#define DSP_IMG_SZ_AUDIO_BUTTON3D (32640u)

/* img_audio_button4.cpp */
#define DSP_IMG_TP_AUDIO_BUTTON4 (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BUTTON4 (136u)
#define DSP_IMG_HS_AUDIO_BUTTON4 (60u)
#define DSP_IMG_SZ_AUDIO_BUTTON4 (32640u)

/* img_audio_button4d.cpp */
#define DSP_IMG_TP_AUDIO_BUTTON4D (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_BUTTON4D (136u)
#define DSP_IMG_HS_AUDIO_BUTTON4D (60u)
#define DSP_IMG_SZ_AUDIO_BUTTON4D (32640u)

/* img_audio_window.cpp */
#define DSP_IMG_TP_AUDIO_WINDOW (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_AUDIO_WINDOW (800u)
#define DSP_IMG_HS_AUDIO_WINDOW (300u)
#define DSP_IMG_SZ_AUDIO_WINDOW (960000u)

/* Because image size is big, the image is divided into 4. */
/* The top image is DSP_IMG_ID_AUDIO_WINDOW1. */
/* The bottom image is DSP_IMG_ID_AUDIO_WINDOW4. */
#define DSP_IMG_PN_AUDIO_WINDOW (4u)

#define DSP_IMG_ST_AUDIO_WINDOW4 (0u)
#define DSP_IMG_WS_AUDIO_WINDOW4 (DSP_IMG_WS_AUDIO_WINDOW)
#define DSP_IMG_HS_AUDIO_WINDOW4 (DSP_IMG_HS_AUDIO_WINDOW/DSP_IMG_PN_AUDIO_WINDOW)

#define DSP_IMG_ST_AUDIO_WINDOW3 (DSP_IMG_ST_AUDIO_WINDOW4+(DSP_IMG_SZ_AUDIO_WINDOW/DSP_IMG_PN_AUDIO_WINDOW))
#define DSP_IMG_WS_AUDIO_WINDOW3 (DSP_IMG_WS_AUDIO_WINDOW)
#define DSP_IMG_HS_AUDIO_WINDOW3 (DSP_IMG_HS_AUDIO_WINDOW/DSP_IMG_PN_AUDIO_WINDOW)

#define DSP_IMG_ST_AUDIO_WINDOW2 (DSP_IMG_ST_AUDIO_WINDOW3+(DSP_IMG_SZ_AUDIO_WINDOW/DSP_IMG_PN_AUDIO_WINDOW))
#define DSP_IMG_WS_AUDIO_WINDOW2 (DSP_IMG_WS_AUDIO_WINDOW)
#define DSP_IMG_HS_AUDIO_WINDOW2 (DSP_IMG_HS_AUDIO_WINDOW/DSP_IMG_PN_AUDIO_WINDOW)

#define DSP_IMG_ST_AUDIO_WINDOW1 (DSP_IMG_ST_AUDIO_WINDOW2+(DSP_IMG_SZ_AUDIO_WINDOW/DSP_IMG_PN_AUDIO_WINDOW))
#define DSP_IMG_WS_AUDIO_WINDOW1 (DSP_IMG_WS_AUDIO_WINDOW)
#define DSP_IMG_HS_AUDIO_WINDOW1 (DSP_IMG_HS_AUDIO_WINDOW/DSP_IMG_PN_AUDIO_WINDOW)

/* img_back.cpp */
#define DSP_IMG_TP_BACK (DSP_IMG_FORM_RGB888)
#define DSP_IMG_WS_BACK (800u)
#define DSP_IMG_HS_BACK (480u)
#define DSP_IMG_SZ_BACK (1152000u)

/* Because image size is big, the image is divided into 6. */
/* The top image is DSP_IMG_ID_BACK1. */
/* The bottom image is DSP_IMG_ID_BACK6. */
#define DSP_IMG_PN_BACK (6u)

#define DSP_IMG_ST_BACK6 (0u)
#define DSP_IMG_WS_BACK6 (DSP_IMG_WS_BACK)
#define DSP_IMG_HS_BACK6 (DSP_IMG_HS_BACK / DSP_IMG_PN_BACK)

#define DSP_IMG_ST_BACK5 (DSP_IMG_ST_BACK6 + (DSP_IMG_SZ_BACK / DSP_IMG_PN_BACK))
#define DSP_IMG_WS_BACK5 (DSP_IMG_WS_BACK)
#define DSP_IMG_HS_BACK5 (DSP_IMG_HS_BACK / DSP_IMG_PN_BACK)

#define DSP_IMG_ST_BACK4 (DSP_IMG_ST_BACK5 + (DSP_IMG_SZ_BACK / DSP_IMG_PN_BACK))
#define DSP_IMG_WS_BACK4 (DSP_IMG_WS_BACK)
#define DSP_IMG_HS_BACK4 (DSP_IMG_HS_BACK / DSP_IMG_PN_BACK)

#define DSP_IMG_ST_BACK3 (DSP_IMG_ST_BACK4 + (DSP_IMG_SZ_BACK / DSP_IMG_PN_BACK))
#define DSP_IMG_WS_BACK3 (DSP_IMG_WS_BACK)
#define DSP_IMG_HS_BACK3 (DSP_IMG_HS_BACK / DSP_IMG_PN_BACK)

#define DSP_IMG_ST_BACK2 (DSP_IMG_ST_BACK3 + (DSP_IMG_SZ_BACK / DSP_IMG_PN_BACK))
#define DSP_IMG_WS_BACK2 (DSP_IMG_WS_BACK)
#define DSP_IMG_HS_BACK2 (DSP_IMG_HS_BACK / DSP_IMG_PN_BACK)

#define DSP_IMG_ST_BACK1 (DSP_IMG_ST_BACK2 + (DSP_IMG_SZ_BACK / DSP_IMG_PN_BACK))
#define DSP_IMG_WS_BACK1 (DSP_IMG_WS_BACK)
#define DSP_IMG_HS_BACK1 (DSP_IMG_HS_BACK / DSP_IMG_PN_BACK)

/* img_bar_left.cpp */
#define DSP_IMG_TP_BAR_LEFT (DSP_IMG_FORM_RGB888)
#define DSP_IMG_WS_BAR_LEFT (4u)
#define DSP_IMG_HS_BAR_LEFT (10u)
#define DSP_IMG_SZ_BAR_LEFT (120u)

/* img_bar_mid.cpp */
#define DSP_IMG_TP_BAR_MID (DSP_IMG_FORM_RGB888)
#define DSP_IMG_WS_BAR_MID (12u)
#define DSP_IMG_HS_BAR_MID (10u)
#define DSP_IMG_SZ_BAR_MID (360u)

/* img_bar_right.cpp */
#define DSP_IMG_TP_BAR_RIGHT (DSP_IMG_FORM_RGB888)
#define DSP_IMG_WS_BAR_RIGHT (12u)
#define DSP_IMG_HS_BAR_RIGHT (10u)
#define DSP_IMG_SZ_BAR_RIGHT (360u)

/* img_mode.cpp */
#define DSP_IMG_TP_MODE (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_MODE (148u)
#define DSP_IMG_HS_MODE (92u)
#define DSP_IMG_SZ_MODE (54464u)

/* img_renesas.cpp */
#define DSP_IMG_TP_RENESAS (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_RENESAS (280u)
#define DSP_IMG_HS_RENESAS (40u)
#define DSP_IMG_SZ_RENESAS (44800u)

/* img_tv.cpp */
#define DSP_IMG_TP_TV (DSP_IMG_FORM_ARGB8888)
#define DSP_IMG_WS_TV (88u)
#define DSP_IMG_HS_TV (64u)
#define DSP_IMG_SZ_TV (22528u)

/* img_font.cpp */
#define DSP_IMG_FONT_FG_VAL (1u)          /* The value of foreground in the font data. */
#define DSP_IMG_FONT_BG_VAL (0u)          /* The value of background in the font data.*/

#define DSP_IMG_FONT_FG_COL (0xFFF0F0F0u) /* The drawing color of foreground in the font data. */

#define DSP_IMG_TBL_NUM_FONT30X34 (2)
#define DSP_IMG_WS_FONT30X34      (30u)
#define DSP_IMG_HS_FONT30X34      (34u)

#define DSP_IMG_TBL_NUM_FONT15X17 (1)
#define DSP_IMG_WS_FONT15X17      (15u)
#define DSP_IMG_HS_FONT15X17      (17u)

#define DSP_IMG_ID_AUDIO          (0)
#define DSP_IMG_ID_AUDIO_BAR      (1)
#define DSP_IMG_ID_AUDIO_BUTTON1  (2)
#define DSP_IMG_ID_AUDIO_BUTTON1D (3)
#define DSP_IMG_ID_AUDIO_BUTTON2  (4)
#define DSP_IMG_ID_AUDIO_BUTTON2D (5)
#define DSP_IMG_ID_AUDIO_BUTTON3  (6)
#define DSP_IMG_ID_AUDIO_BUTTON3D (7)
#define DSP_IMG_ID_AUDIO_BUTTON4  (8)
#define DSP_IMG_ID_AUDIO_BUTTON4D (9)
#define DSP_IMG_ID_AUDIO_WINDOW1  (10)
#define DSP_IMG_ID_AUDIO_WINDOW2  (11)
#define DSP_IMG_ID_AUDIO_WINDOW3  (12)
#define DSP_IMG_ID_AUDIO_WINDOW4  (13)
#define DSP_IMG_ID_BACK1          (14)
#define DSP_IMG_ID_BACK2          (15)
#define DSP_IMG_ID_BACK3          (16)
#define DSP_IMG_ID_BACK4          (17)
#define DSP_IMG_ID_BACK5          (18)
#define DSP_IMG_ID_BACK6          (19)
#define DSP_IMG_ID_BAR_LEFT       (20)
#define DSP_IMG_ID_BAR_MID        (21)
#define DSP_IMG_ID_BAR_RIGHT      (22)
#define DSP_IMG_ID_MODE           (23)
#define DSP_IMG_ID_RENESAS        (24)
#define DSP_IMG_ID_TV             (25)
#define DSP_IMG_TBL_SIZE          (26)

/*--- User defined types ---*/
typedef struct {
    int32_t         image_type;     /* Format of a bitmap. */
    const uint8_t   *p_image;       /* Pointer to top address of a bitmap. */
    uint32_t        size_x;         /* The width of a bitmap. */
    uint32_t        size_y;         /* The height of a bitmap. */
} dsp_bmpinf_t;

typedef struct {
    const uint32_t  *p_font;        /* Pointer to top address of the font table. */
    uint32_t        start_char;     /* The first character in this font table. */
    uint32_t        end_char;       /* The last character in this font table. */
} dsp_fntinf_t;

extern const uint8_t dsp_img_audio[DSP_IMG_SZ_AUDIO];
extern const uint8_t dsp_img_audio_bar[DSP_IMG_SZ_AUDIO_BAR];
extern const uint8_t dsp_img_audio_button1[DSP_IMG_SZ_AUDIO_BUTTON1];
extern const uint8_t dsp_img_audio_button1d[DSP_IMG_SZ_AUDIO_BUTTON1D];
extern const uint8_t dsp_img_audio_button2[DSP_IMG_SZ_AUDIO_BUTTON2];
extern const uint8_t dsp_img_audio_button2d[DSP_IMG_SZ_AUDIO_BUTTON2D];
extern const uint8_t dsp_img_audio_button3[DSP_IMG_SZ_AUDIO_BUTTON3];
extern const uint8_t dsp_img_audio_button3d[DSP_IMG_SZ_AUDIO_BUTTON3D];
extern const uint8_t dsp_img_audio_button4[DSP_IMG_SZ_AUDIO_BUTTON4];
extern const uint8_t dsp_img_audio_button4d[DSP_IMG_SZ_AUDIO_BUTTON4D];
extern const uint8_t dsp_img_audio_window[DSP_IMG_SZ_AUDIO_WINDOW];
extern const uint8_t dsp_img_back[DSP_IMG_SZ_BACK];
extern const uint8_t dsp_img_bar_left[DSP_IMG_SZ_BAR_LEFT];
extern const uint8_t dsp_img_bar_mid[DSP_IMG_SZ_BAR_MID];
extern const uint8_t dsp_img_bar_right[DSP_IMG_SZ_BAR_RIGHT];
extern const uint8_t dsp_img_mode[DSP_IMG_SZ_MODE];
extern const uint8_t dsp_img_renesas[DSP_IMG_SZ_RENESAS];
extern const uint8_t dsp_img_tv[DSP_IMG_SZ_TV];
extern const dsp_bmpinf_t dsp_bitmap_tbl[DSP_IMG_TBL_SIZE];
extern const dsp_fntinf_t dsp_img_fonttbl30x34[DSP_IMG_TBL_NUM_FONT30X34];
extern const dsp_fntinf_t dsp_img_fonttbl15x17[DSP_IMG_TBL_NUM_FONT15X17];

#endif /* IMG_TBL_H */
