/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer*
* Copyright (C) 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

#ifndef DISP_TFT_SCRN_H
#define DISP_TFT_SCRN_H

#include "r_typedefs.h"
#include "display.h"

/** This function initializes for creating the display image of playback screen.
 *
 *  @param p_tft Pointer to management data of TFT module.
 */
void dsp_init_tft_scrn(dsp_tft_ctrl_t * const p_tft);

/** This function creates the display image of playback screen.
 *
 *  @param p_com Pointer to common data in all module.
 *  @param p_tft Pointer to management data of TFT module.
 *
 *  @returns 
 *    Returns the number of the display layer to update.
 */
uint32_t dsp_make_tft_scrn(const dsp_com_ctrl_t * const p_com, dsp_tft_ctrl_t * const p_tft);

/** This function converts the touch position of playback screen into the key code.
 *
 *  @param pos_x Touch X position.
 *  @param pos_y Touch Y position.
 *
 *  @returns 
 *    If touch position is on the picture of key, this function returns key code. 
 *    Otherwise this function returns "SYS_KEYCODE_NON".
 */
SYS_KeyCode dsp_convert_key_tft_scrn(const uint32_t pos_x, const uint32_t pos_y);

#endif  /* DISP_TFT_SCRN_H */
