/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer*
* Copyright (C) 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

#include "misratypes.h"
#include "img_tbl.h"

/*--- Macro definition ---*/
#define TBL30X34_0_CHR_START    (0x01)      /* 0xE299AA : EIGHTH NOTE */
#define TBL30X34_0_CHR_END      (0x01)      /* 0xE299AA : EIGHTH NOTE */

#define FONTTBL30X34_0_TBL_SIZE (TBL30X34_0_CHR_END - TBL30X34_0_CHR_START + 1)

#define TBL30X34_1_CHR_START    (' ')       /* 0x20 : SPACE */
#define TBL30X34_1_CHR_END      ('~')       /* 0x7E : TILDE */

#define FONTTBL30X34_1_TBL_SIZE (TBL30X34_1_CHR_END - TBL30X34_1_CHR_START + 1)

#define TBL15X17_0_CHR_START    ('0')       /* 0x30 : DIGIT ZERO */
#define TBL15X17_0_CHR_END      (':')       /* 0x3A : COLON */

#define FONTTBL15X17_0_TBL_SIZE (TBL15X17_0_CHR_END - TBL15X17_0_CHR_START + 1)

static const uint32_t fnttbl_30x34_0_0x1[FONTTBL30X34_0_TBL_SIZE][DSP_IMG_HS_FONT30X34] = {
    {   /* 0x266A[ EIGHTH NOTE ] */
        0x00003800u, 
        0x00007800u, 
        0x0000F800u, 
        0x0001F800u, 
        0x0003F800u, 
        0x0007F800u, 
        0x000FF800u, 
        0x001F9800u, 
        0x003F1800u, 
        0x007C1800u, 
        0x00781800u, 
        0x00F01800u, 
        0x00E01800u, 
        0x00E01800u, 
        0x00E01800u, 
        0x00E01800u, 
        0x00E01800u, 
        0x00601800u, 
        0x00601800u, 
        0x00381800u, 
        0x003C1800u, 
        0x001C1800u, 
        0x00001800u, 
        0x00001800u, 
        0x00001F80u, 
        0x00001FF0u, 
        0x00001FF8u, 
        0x00001FFCu, 
        0x00001FFCu, 
        0x00001FFCu, 
        0x00000FFCu, 
        0x000007F8u, 
        0x000001E0u, 
        0x00000000u  
    }
};

static const uint32_t fnttbl_30x34_1_0x20to0x7e[FONTTBL30X34_1_TBL_SIZE][DSP_IMG_HS_FONT30X34] = {
    {   /* 0x20[   ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x21[ ! ] */
        0x00000000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x22[ " ] */
        0x00000000u, 
        0x00000000u, 
        0x000F8780u, 
        0x000F8780u, 
        0x00078780u, 
        0x00078780u, 
        0x00078780u, 
        0x00078780u, 
        0x00078780u, 
        0x00078780u, 
        0x00078780u, 
        0x00078780u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x23[ # ] */
        0x00000000u, 
        0x00F07800u, 
        0x00703800u, 
        0x00783C00u, 
        0x00783C00u, 
        0x00783C00u, 
        0x00781E00u, 
        0x00781E00u, 
        0x07FFFFF0u, 
        0x07FFFFF0u, 
        0x07FFFFF0u, 
        0x007C1E00u, 
        0x003C1E00u, 
        0x003E0F00u, 
        0x003E0F00u, 
        0x003E0F00u, 
        0x003E0F00u, 
        0x001E0F00u, 
        0x001E0780u, 
        0x001E0780u, 
        0x001E0780u, 
        0x01FFFFFCu, 
        0x01FFFFFCu, 
        0x01FFFFFCu, 
        0x000F0780u, 
        0x000F0380u, 
        0x000783C0u, 
        0x000783C0u, 
        0x000783C0u, 
        0x000781C0u, 
        0x000781E0u, 
        0x000781E0u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x24[ $ ] */
        0x00003800u, 
        0x00003800u, 
        0x0003FF00u, 
        0x001FFFC0u, 
        0x001FFFF0u, 
        0x001FFFF8u, 
        0x001C39FCu, 
        0x000038FCu, 
        0x0000387Cu, 
        0x0000387Cu, 
        0x0000387Cu, 
        0x000038FCu, 
        0x000039F8u, 
        0x00003FF8u, 
        0x00003FF0u, 
        0x00003FC0u, 
        0x0001FF00u, 
        0x0007F800u, 
        0x001FF800u, 
        0x003FF800u, 
        0x003F3800u, 
        0x003E3800u, 
        0x007C3800u, 
        0x007C3800u, 
        0x007E3800u, 
        0x003F3808u, 
        0x003FB878u, 
        0x003FFFF8u, 
        0x001FFFF8u, 
        0x000FFFE0u, 
        0x0000FE00u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u  
    },
    {   /* 0x25[ % ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00F001C0u, 
        0x00780FF0u, 
        0x00781FFCu, 
        0x003C1E3Cu, 
        0x003C3C1Eu, 
        0x001E3C1Eu, 
        0x001F3C1Eu, 
        0x000F3C1Eu, 
        0x000FBC1Eu, 
        0x0007BE3Eu, 
        0x0003DFFEu, 
        0x0003DFFCu, 
        0x0001EFF8u, 
        0x01F9E080u, 
        0x07FEF000u, 
        0x0F9EF000u, 
        0x0F0F7800u, 
        0x1E0F7C00u, 
        0x1E0F3C00u, 
        0x1E0F3E00u, 
        0x1E0F1E00u, 
        0x1E0F0F00u, 
        0x1F0F0F00u, 
        0x0FFE0780u, 
        0x07FE0780u, 
        0x03FC03C0u, 
        0x00F00000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x26[ & ] */
        0x00000000u, 
        0x00000000u, 
        0x001FFF80u, 
        0x003FFFC0u, 
        0x003FC7E0u, 
        0x003E07E0u, 
        0x007C03E0u, 
        0x007C01E0u, 
        0x003C01E0u, 
        0x003E03E0u, 
        0x001E03C0u, 
        0x001F87C0u, 
        0x000FCF80u, 
        0x0007FF80u, 
        0x0003FF00u, 
        0x0001FE00u, 
        0x1F00FF00u, 
        0x0F81FF80u, 
        0x0F83F7C0u, 
        0x0F87E3E0u, 
        0x0FC7C1F0u, 
        0x07CF80F8u, 
        0x07DF007Cu, 
        0x03FE007Cu, 
        0x01FC007Cu, 
        0x01F8007Cu, 
        0x03F8007Cu, 
        0x07FC00F8u, 
        0x0FFF03F8u, 
        0x0FBFFFF0u, 
        0x1F1FFFF0u, 
        0x3F0FFFC0u, 
        0x0003FF00u, 
        0x00000000u  
    },
    {   /* 0x27[ ' ] */
        0x00000000u, 
        0x00000000u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x00007800u, 
        0x00007800u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x28[ ( ] */
        0x000F0000u, 
        0x00070000u, 
        0x00078000u, 
        0x0003C000u, 
        0x0001C000u, 
        0x0001E000u, 
        0x0000F000u, 
        0x0000F000u, 
        0x00007000u, 
        0x00007800u, 
        0x00007800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003C00u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00007800u, 
        0x00007800u, 
        0x00007000u, 
        0x0000F000u, 
        0x0000F000u, 
        0x0000E000u, 
        0x0001E000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x00078000u, 
        0x000F0000u, 
        0x001E0000u, 
        0x00000000u  
    },
    {   /* 0x29[ ) ] */
        0x00003C00u, 
        0x00007800u, 
        0x00007000u, 
        0x0000E000u, 
        0x0001E000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x00078000u, 
        0x00078000u, 
        0x000F8000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x00070000u, 
        0x00078000u, 
        0x00078000u, 
        0x00078000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0001E000u, 
        0x0000F000u, 
        0x00007000u, 
        0x00003800u, 
        0x00001C00u, 
        0x00000000u  
    },
    {   /* 0x2A[ * ] */
        0x00000000u, 
        0x00000000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0061E180u, 
        0x0071E380u, 
        0x00FDEFC0u, 
        0x003FFF00u, 
        0x001FFE00u, 
        0x0007F800u, 
        0x0003F000u, 
        0x000FFC00u, 
        0x003FFF00u, 
        0x00F9E7C0u, 
        0x0071E380u, 
        0x0041E180u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x2B[ + ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0FFFFFF8u, 
        0x0FFFFFF8u, 
        0x0FFFFFF8u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x0001C000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x2C[ , ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0007E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0000F000u, 
        0x0000F000u, 
        0x0000F800u, 
        0x00007800u, 
        0x00007800u, 
        0x00000000u  
    },
    {   /* 0x2D[ - ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x001FFF80u, 
        0x001FFF80u, 
        0x001FFF80u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x2E[ . ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x2F[ / ] */
        0x01F00000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x007C0000u, 
        0x007C0000u, 
        0x003E0000u, 
        0x003E0000u, 
        0x003E0000u, 
        0x001F0000u, 
        0x001F0000u, 
        0x000F8000u, 
        0x000F8000u, 
        0x0007C000u, 
        0x0007C000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0000F800u, 
        0x0000F800u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00003E00u, 
        0x00003E00u, 
        0x00001F00u, 
        0x00001F00u, 
        0x00000F80u, 
        0x00000F80u, 
        0x00000F80u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000003E0u, 
        0x00000000u  
    },
    {   /* 0x30[ 0 ] */
        0x00000000u, 
        0x001FFC00u, 
        0x007FFF00u, 
        0x00FF7F80u, 
        0x00F80FC0u, 
        0x01F007C0u, 
        0x01E003E0u, 
        0x03E003E0u, 
        0x03E001E0u, 
        0x03E001E0u, 
        0x03E001F0u, 
        0x03C001F0u, 
        0x03C001F0u, 
        0x07C001F0u, 
        0x07C001F0u, 
        0x07C001F0u, 
        0x07C001F0u, 
        0x07C001F0u, 
        0x07C001F0u, 
        0x03C001F0u, 
        0x03C001F0u, 
        0x03E001F0u, 
        0x03E001F0u, 
        0x03E003E0u, 
        0x01E003E0u, 
        0x01F003E0u, 
        0x01F007C0u, 
        0x00FC1FC0u, 
        0x007FFF80u, 
        0x003FFF00u, 
        0x001FFC00u, 
        0x0007F000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x31[ 1 ] */
        0x00000000u, 
        0x0003E000u, 
        0x0003F000u, 
        0x0003FC00u, 
        0x0003FE00u, 
        0x0003FF00u, 
        0x0003FF80u, 
        0x0003EFC0u, 
        0x0003E3E0u, 
        0x0003E1E0u, 
        0x0003E0E0u, 
        0x0003E060u, 
        0x0003E020u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x32[ 2 ] */
        0x00000000u, 
        0x00001000u, 
        0x0003FFC0u, 
        0x001FFFF0u, 
        0x003FEFF0u, 
        0x003E00F0u, 
        0x007C0030u, 
        0x007C0000u, 
        0x00780000u, 
        0x00780000u, 
        0x00780000u, 
        0x007C0000u, 
        0x003E0000u, 
        0x003E0000u, 
        0x003F0000u, 
        0x003F0000u, 
        0x001F8000u, 
        0x001FC000u, 
        0x000FE000u, 
        0x0007F000u, 
        0x0003F800u, 
        0x0001FC00u, 
        0x0000FE00u, 
        0x00007F00u, 
        0x00003F80u, 
        0x00001FC0u, 
        0x00000FE0u, 
        0x000007F0u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x33[ 3 ] */
        0x00000000u, 
        0x00001000u, 
        0x001FFFC0u, 
        0x003FFFF0u, 
        0x007FEFF0u, 
        0x007F8070u, 
        0x007E0010u, 
        0x007C0000u, 
        0x00780000u, 
        0x00780000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003F0000u, 
        0x001FFF00u, 
        0x0007FF00u, 
        0x0003FF00u, 
        0x000FFF00u, 
        0x003FF800u, 
        0x003FC000u, 
        0x007E0000u, 
        0x007C0000u, 
        0x00FC0000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x007C0000u, 
        0x007C0000u, 
        0x007C0008u, 
        0x003F0078u, 
        0x001FFFF8u, 
        0x000FFFF8u, 
        0x0007FFF0u, 
        0x0001FF00u, 
        0x00000000u  
    },
    {   /* 0x34[ 4 ] */
        0x00000000u, 
        0x00078000u, 
        0x0007C000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007F000u, 
        0x0007F800u, 
        0x0007F800u, 
        0x0007BC00u, 
        0x00079E00u, 
        0x00079F00u, 
        0x00078F00u, 
        0x00078780u, 
        0x000783C0u, 
        0x000783C0u, 
        0x000781E0u, 
        0x000780F0u, 
        0x000780F0u, 
        0x00078078u, 
        0x0007803Cu, 
        0x0007801Eu, 
        0x01FFFFFEu, 
        0x01FFFFFEu, 
        0x01FFFFFEu, 
        0x01FFFFFEu, 
        0x00078000u, 
        0x00078000u, 
        0x00078000u, 
        0x00078000u, 
        0x00078000u, 
        0x00078000u, 
        0x00078000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x35[ 5 ] */
        0x00000000u, 
        0x007FFFE0u, 
        0x007FFFE0u, 
        0x007FFFE0u, 
        0x007FFFE0u, 
        0x000001E0u, 
        0x000001E0u, 
        0x000001E0u, 
        0x000001F0u, 
        0x000001F0u, 
        0x000001F0u, 
        0x000001F0u, 
        0x0000F1F0u, 
        0x0007FFF0u, 
        0x001FFFF0u, 
        0x003FC7F0u, 
        0x003E00F0u, 
        0x007C0000u, 
        0x007C0000u, 
        0x00780000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x007C0000u, 
        0x007C0000u, 
        0x007C0000u, 
        0x007E0000u, 
        0x003E0010u, 
        0x003F80F0u, 
        0x001FFFF0u, 
        0x000FFFF0u, 
        0x0007FFE0u, 
        0x0000FF00u, 
        0x00000000u  
    },
    {   /* 0x36[ 6 ] */
        0x00000000u, 
        0x001FF800u, 
        0x001FFE00u, 
        0x001FFF80u, 
        0x001FBFC0u, 
        0x00000FC0u, 
        0x000007E0u, 
        0x000003E0u, 
        0x000001F0u, 
        0x000000F0u, 
        0x000000F0u, 
        0x0001FC70u, 
        0x000FFF78u, 
        0x001FFFF8u, 
        0x003FFFF8u, 
        0x007F8FF8u, 
        0x00FE03F8u, 
        0x00F800F8u, 
        0x00F80078u, 
        0x00F00078u, 
        0x01F00078u, 
        0x01F00078u, 
        0x01F00078u, 
        0x00F00078u, 
        0x00F00078u, 
        0x00F000F0u, 
        0x007800F0u, 
        0x007C01F0u, 
        0x003F03E0u, 
        0x001FFFE0u, 
        0x000FFFC0u, 
        0x0001FF80u, 
        0x00003F00u, 
        0x00000000u  
    },
    {   /* 0x37[ 7 ] */
        0x00000000u, 
        0x00FFFFF8u, 
        0x00FFFFF8u, 
        0x00FFFFF8u, 
        0x00FFFFF8u, 
        0x00F80000u, 
        0x007C0000u, 
        0x003E0000u, 
        0x003E0000u, 
        0x001F0000u, 
        0x001F0000u, 
        0x000F8000u, 
        0x00078000u, 
        0x0007C000u, 
        0x0003C000u, 
        0x0003E000u, 
        0x0001E000u, 
        0x0001F000u, 
        0x0000F000u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007E00u, 
        0x00007E00u, 
        0x00003E00u, 
        0x00003F00u, 
        0x00001F00u, 
        0x00001F00u, 
        0x00000F80u, 
        0x00000F80u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x38[ 8 ] */
        0x00000000u, 
        0x00000000u, 
        0x0007FF00u, 
        0x001FFFC0u, 
        0x003FEFE0u, 
        0x007E01F0u, 
        0x007C00F8u, 
        0x00FC00F8u, 
        0x00F80078u, 
        0x00780078u, 
        0x00780078u, 
        0x003E00F8u, 
        0x003F83F0u, 
        0x001FFFF0u, 
        0x000FFFC0u, 
        0x0007FF80u, 
        0x003FFFC0u, 
        0x007FCFE0u, 
        0x00FE03F0u, 
        0x00FC00F8u, 
        0x01F8007Cu, 
        0x01F8003Cu, 
        0x01F0003Cu, 
        0x01F0007Cu, 
        0x01F0007Cu, 
        0x00F8007Cu, 
        0x00F80078u, 
        0x00FC01F8u, 
        0x007F9FF0u, 
        0x003FFFF0u, 
        0x001FFFE0u, 
        0x000FFFC0u, 
        0x0001FE00u, 
        0x00000000u  
    },
    {   /* 0x39[ 9 ] */
        0x00000000u, 
        0x00001F00u, 
        0x0003FFC0u, 
        0x000FFFE0u, 
        0x001FFFF0u, 
        0x003E03F0u, 
        0x003C01F8u, 
        0x007800F8u, 
        0x00780078u, 
        0x00F8007Cu, 
        0x00F0007Cu, 
        0x00F0007Cu, 
        0x00F0007Cu, 
        0x01F0007Cu, 
        0x01F8007Cu, 
        0x01F800F8u, 
        0x01F801F8u, 
        0x00FE03F0u, 
        0x00FFFFF0u, 
        0x00FBFFE0u, 
        0x00F9FFC0u, 
        0x00F87F00u, 
        0x00FC0000u, 
        0x007C0000u, 
        0x007C0000u, 
        0x003E0000u, 
        0x003F0000u, 
        0x001F8060u, 
        0x000FE3E0u, 
        0x000FFFE0u, 
        0x0007FFE0u, 
        0x0001FFC0u, 
        0x00007F00u, 
        0x00000000u  
    },
    {   /* 0x3A[ : ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x0007E000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x3B[ ; ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x000FC000u, 
        0x000FC000u, 
        0x000FC000u, 
        0x000FC000u, 
        0x000FC000u, 
        0x000FC000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x000FC000u, 
        0x0007C000u, 
        0x0007E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0003E000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0000F000u, 
        0x0000F000u, 
        0x0000F800u, 
        0x00007800u, 
        0x00000000u  
    },
    {   /* 0x3C[ < ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x01000000u, 
        0x01C00000u, 
        0x01F80000u, 
        0x01FE0000u, 
        0x00FF8000u, 
        0x001FF000u, 
        0x0003FC00u, 
        0x0000FF80u, 
        0x00001FE0u, 
        0x000003F8u, 
        0x00000078u, 
        0x00000018u, 
        0x00000038u, 
        0x000001F8u, 
        0x00000FF0u, 
        0x00003FC0u, 
        0x0001FE00u, 
        0x000FF800u, 
        0x007FC000u, 
        0x01FF0000u, 
        0x01FC0000u, 
        0x01E00000u, 
        0x01800000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x3D[ = ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x03FFFFFEu, 
        0x03FFFFFEu, 
        0x03FFFFFEu, 
        0x03FFFFFEu, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x03FFFFFEu, 
        0x03FFFFFEu, 
        0x03FFFFFEu, 
        0x03FFFFFEu, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x3E[ > ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000070u, 
        0x000001F0u, 
        0x00000FF0u, 
        0x00003FF0u, 
        0x0000FF80u, 
        0x0007FC00u, 
        0x001FE000u, 
        0x00FF8000u, 
        0x03FC0000u, 
        0x03E00000u, 
        0x03800000u, 
        0x03C00000u, 
        0x03F80000u, 
        0x01FF0000u, 
        0x003FC000u, 
        0x000FF800u, 
        0x0001FF00u, 
        0x00007FE0u, 
        0x00001FF0u, 
        0x000003F0u, 
        0x000000F0u, 
        0x00000010u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x3F[ ? ] */
        0x00000000u, 
        0x00002000u, 
        0x0007FFF8u, 
        0x001FFFF8u, 
        0x003FEFF8u, 
        0x003E00F8u, 
        0x007C0000u, 
        0x00780000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00780000u, 
        0x007C0000u, 
        0x007F0000u, 
        0x001F8000u, 
        0x000FC000u, 
        0x0003E000u, 
        0x0001F000u, 
        0x0001F800u, 
        0x0000FC00u, 
        0x00007C00u, 
        0x00007E00u, 
        0x00007E00u, 
        0x00003E00u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00003E00u, 
        0x00003E00u, 
        0x00003E00u, 
        0x00003E00u, 
        0x00003E00u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x40[ @ ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x000FFC00u, 
        0x003FFF00u, 
        0x007F0FC0u, 
        0x00F801E0u, 
        0x01E000F0u, 
        0x03C06078u, 
        0x039EFC7Cu, 
        0x071FFE3Cu, 
        0x071FFE1Cu, 
        0x071F9E1Eu, 
        0x061F0F1Eu, 
        0x060F070Eu, 
        0x060F070Eu, 
        0x060F878Eu, 
        0x060F838Eu, 
        0x0307C78Eu, 
        0x0307FF1Eu, 
        0x038FFF1Cu, 
        0x01FEFE1Cu, 
        0x001E7C3Cu, 
        0x00000078u, 
        0x001001F0u, 
        0x003C0FE0u, 
        0x003FFFC0u, 
        0x001FFF80u, 
        0x0007FC00u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x41[ A ] */
        0x00000000u, 
        0x0001F000u, 
        0x0001F800u, 
        0x0001F800u, 
        0x0003F800u, 
        0x0003BC00u, 
        0x00039C00u, 
        0x00079C00u, 
        0x00071E00u, 
        0x00070E00u, 
        0x000F0E00u, 
        0x000F0F00u, 
        0x000E0700u, 
        0x001E0700u, 
        0x001E0780u, 
        0x001E0380u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C01C0u, 
        0x007801E0u, 
        0x007FFFE0u, 
        0x007FFFE0u, 
        0x00FFFFF0u, 
        0x00FFFFF0u, 
        0x00F001F0u, 
        0x00F000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E0007Cu, 
        0x03C0007Cu, 
        0x03C0003Eu, 
        0x03C0003Eu, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x42[ B ] */
        0x00000000u, 
        0x000007F8u, 
        0x0003FFF8u, 
        0x000FFFF8u, 
        0x000FFFF8u, 
        0x001F00F8u, 
        0x003E00F8u, 
        0x003C00F8u, 
        0x007C00F8u, 
        0x007800F8u, 
        0x003800F8u, 
        0x003C00F8u, 
        0x001C00F8u, 
        0x001FFFF8u, 
        0x000FFFF8u, 
        0x0003FFF8u, 
        0x001FFFF8u, 
        0x003FF8F8u, 
        0x007FC0F8u, 
        0x00FE00F8u, 
        0x00F800F8u, 
        0x01F800F8u, 
        0x01F000F8u, 
        0x01F000F8u, 
        0x00F800F8u, 
        0x00F800F8u, 
        0x00FC00F8u, 
        0x007F00F8u, 
        0x003FFFF8u, 
        0x001FFFF8u, 
        0x000FFFF8u, 
        0x0001FFF8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x43[ C ] */
        0x00000000u, 
        0x007F0000u, 
        0x007FF800u, 
        0x007FFF00u, 
        0x007F1FC0u, 
        0x000007E0u, 
        0x000003F0u, 
        0x000001F8u, 
        0x000000F8u, 
        0x000000FCu, 
        0x0000007Cu, 
        0x0000007Cu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Eu, 
        0x0000007Cu, 
        0x000000FCu, 
        0x000000FCu, 
        0x000001F8u, 
        0x000003F0u, 
        0x004007F0u, 
        0x00780FE0u, 
        0x007FFFC0u, 
        0x007FFF80u, 
        0x0007FE00u, 
        0x0000F000u, 
        0x00000000u  
    },
    {   /* 0x44[ D ] */
        0x00000000u, 
        0x000007F8u, 
        0x0003FFF8u, 
        0x000FFFF8u, 
        0x003FFFF8u, 
        0x007FF0F8u, 
        0x00FE00F8u, 
        0x00F800F8u, 
        0x01F000F8u, 
        0x01E000F8u, 
        0x03E000F8u, 
        0x03C000F8u, 
        0x03C000F8u, 
        0x03C000F8u, 
        0x078000F8u, 
        0x078000F8u, 
        0x078000F8u, 
        0x078000F8u, 
        0x038000F8u, 
        0x038000F8u, 
        0x03C000F8u, 
        0x03C000F8u, 
        0x03C000F8u, 
        0x01E000F8u, 
        0x01F000F8u, 
        0x01FC00F8u, 
        0x00FE00F8u, 
        0x007F80F8u, 
        0x003FFFF8u, 
        0x001FFFF8u, 
        0x0007FFF8u, 
        0x0000FFF8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x45[ E ] */
        0x00000000u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x001FFFF8u, 
        0x001FFFF8u, 
        0x001FFFF8u, 
        0x001FFFF8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x46[ F ] */
        0x00000000u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x003FFFF8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x001FFFF8u, 
        0x001FFFF8u, 
        0x001FFFF8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x47[ G ] */
        0x00000000u, 
        0x01FE0000u, 
        0x01FFFC00u, 
        0x01FFFF00u, 
        0x01FC3F80u, 
        0x000007E0u, 
        0x000003F0u, 
        0x000001F0u, 
        0x000000F8u, 
        0x0000007Cu, 
        0x0000007Cu, 
        0x0000007Cu, 
        0x0000007Eu, 
        0x07FFE07Eu, 
        0x07FFE07Eu, 
        0x07FFE07Eu, 
        0x07FFE07Eu, 
        0x07C0007Eu, 
        0x07C0007Eu, 
        0x07C0007Eu, 
        0x07C0007Cu, 
        0x07C0007Cu, 
        0x07C0007Cu, 
        0x07C000F8u, 
        0x07C000F8u, 
        0x07C001F0u, 
        0x07C007E0u, 
        0x07C01FE0u, 
        0x07E0FFC0u, 
        0x07FFFF80u, 
        0x07FFFE00u, 
        0x01FFFC00u, 
        0x003FE000u, 
        0x00000000u  
    },
    {   /* 0x48[ H ] */
        0x00000000u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03FFFFF8u, 
        0x03FFFFF8u, 
        0x03FFFFF8u, 
        0x03FFFFF8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x49[ I ] */
        0x00000000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x4A[ J ] */
        0x00000000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00F80000u, 
        0x00FC0000u, 
        0x00FC0000u, 
        0x00FC0000u, 
        0x007E0000u, 
        0x007E0000u, 
        0x007E0020u, 
        0x003F81E0u, 
        0x003FFFE0u, 
        0x001FFFE0u, 
        0x000FFFC0u, 
        0x0001FE00u, 
        0x00000000u  
    },
    {   /* 0x4B[ K ] */
        0x00000000u, 
        0x01F000F8u, 
        0x00F800F8u, 
        0x007C00F8u, 
        0x003E00F8u, 
        0x001F00F8u, 
        0x001F80F8u, 
        0x000F80F8u, 
        0x0007C0F8u, 
        0x0003E0F8u, 
        0x0001F0F8u, 
        0x0001F8F8u, 
        0x0000FCF8u, 
        0x00007EF8u, 
        0x00003EF8u, 
        0x00001FF8u, 
        0x00001FF8u, 
        0x00003FF8u, 
        0x00003EF8u, 
        0x00007CF8u, 
        0x0000FCF8u, 
        0x0001F8F8u, 
        0x0001F0F8u, 
        0x0003E0F8u, 
        0x0007C0F8u, 
        0x000FC0F8u, 
        0x000F80F8u, 
        0x001F00F8u, 
        0x003E00F8u, 
        0x007C00F8u, 
        0x007C00F8u, 
        0x00F800F8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x4C[ L ] */
        0x00000000u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x000001F8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x4D[ M ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00F801F0u, 
        0x00F801F0u, 
        0x00F803F0u, 
        0x00FC03F0u, 
        0x01FC03F0u, 
        0x01FC03F0u, 
        0x01EC0770u, 
        0x01EE0778u, 
        0x01EE0778u, 
        0x01EE0778u, 
        0x01E60678u, 
        0x01E70E78u, 
        0x03C70E78u, 
        0x03C70E78u, 
        0x03C70C78u, 
        0x03C31C78u, 
        0x03C39C78u, 
        0x03C39C3Cu, 
        0x03C3983Cu, 
        0x03C1B83Cu, 
        0x0781F83Cu, 
        0x0781F83Cu, 
        0x0781F03Cu, 
        0x0780F03Cu, 
        0x0780F03Cu, 
        0x0780F03Cu, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x4E[ N ] */
        0x00000000u, 
        0x03E000F8u, 
        0x03E000F8u, 
        0x03E001F8u, 
        0x03E003F8u, 
        0x03E003F8u, 
        0x03E007F8u, 
        0x03E007F8u, 
        0x03E00FF8u, 
        0x03E00FF8u, 
        0x03E01EF8u, 
        0x03E03EF8u, 
        0x03E03CF8u, 
        0x03E07CF8u, 
        0x03E078F8u, 
        0x03E0F8F8u, 
        0x03E0F0F8u, 
        0x03E1F0F8u, 
        0x03E1E0F8u, 
        0x03E3C0F8u, 
        0x03E7C0F8u, 
        0x03E780F8u, 
        0x03EF80F8u, 
        0x03EF00F8u, 
        0x03FF00F8u, 
        0x03FE00F8u, 
        0x03FC00F8u, 
        0x03FC00F8u, 
        0x03F800F8u, 
        0x03F800F8u, 
        0x03F000F8u, 
        0x03F000F8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x4F[ O ] */
        0x00000000u, 
        0x001FFE00u, 
        0x007FFF80u, 
        0x00FFBFC0u, 
        0x01F807E0u, 
        0x01E003F0u, 
        0x03C001F8u, 
        0x078000F8u, 
        0x0780007Cu, 
        0x0700007Cu, 
        0x0F00007Cu, 
        0x0F00003Eu, 
        0x0F00003Eu, 
        0x0F00003Eu, 
        0x0E00003Eu, 
        0x1E00003Eu, 
        0x1E00003Eu, 
        0x1E00003Eu, 
        0x0F00003Eu, 
        0x0F00003Eu, 
        0x0F00007Eu, 
        0x0F00007Cu, 
        0x0F8000FCu, 
        0x07C000FCu, 
        0x07E001F8u, 
        0x03F003F0u, 
        0x01F807F0u, 
        0x00FE1FE0u, 
        0x007FFFC0u, 
        0x003FFF80u, 
        0x000FFF00u, 
        0x0001F800u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x50[ P ] */
        0x00000000u, 
        0x00000FF8u, 
        0x000FFFF8u, 
        0x003FFFF8u, 
        0x007FFFF8u, 
        0x007FE0F8u, 
        0x00FE00F8u, 
        0x00FC00F8u, 
        0x00F800F8u, 
        0x01F800F8u, 
        0x01F800F8u, 
        0x01F000F8u, 
        0x00F000F8u, 
        0x00F800F8u, 
        0x00F800F8u, 
        0x007C00F8u, 
        0x007F00F8u, 
        0x003FFFF8u, 
        0x001FFFF8u, 
        0x0003FFF8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x000000F8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x51[ Q ] */
        0x00000000u, 
        0x00007800u, 
        0x0003FF00u, 
        0x000FFFC0u, 
        0x001F01F0u, 
        0x001E00F8u, 
        0x003C0078u, 
        0x0038007Cu, 
        0x0070003Cu, 
        0x0070003Cu, 
        0x00F0001Eu, 
        0x00F0001Eu, 
        0x00E0001Eu, 
        0x00E0001Eu, 
        0x00E0001Eu, 
        0x00E0001Eu, 
        0x00E0001Eu, 
        0x00F0001Eu, 
        0x00F0003Eu, 
        0x0070003Cu, 
        0x0078007Cu, 
        0x003C00FCu, 
        0x003E01F8u, 
        0x001F07F0u, 
        0x000FFFE0u, 
        0x0007FFC0u, 
        0x000FFF80u, 
        0x003FFE00u, 
        0x00F80000u, 
        0x01F00000u, 
        0x03E00000u, 
        0x03E00000u, 
        0x07C00000u, 
        0x00000000u  
    },
    {   /* 0x52[ R ] */
        0x00000000u, 
        0x000007F8u, 
        0x0007FFF8u, 
        0x001FFFF8u, 
        0x003FFFF8u, 
        0x007FF0F8u, 
        0x007C00F8u, 
        0x00F800F8u, 
        0x00F800F8u, 
        0x01F000F8u, 
        0x01F800F8u, 
        0x00F800F8u, 
        0x00FC00F8u, 
        0x00FE00F8u, 
        0x007F00F8u, 
        0x003FFFF8u, 
        0x000FFFF8u, 
        0x0003FFF8u, 
        0x0003FFF8u, 
        0x000FE0F8u, 
        0x000F80F8u, 
        0x001F00F8u, 
        0x001F00F8u, 
        0x001E00F8u, 
        0x001E00F8u, 
        0x003C00F8u, 
        0x003C00F8u, 
        0x007800F8u, 
        0x007800F8u, 
        0x007000F8u, 
        0x00F000F8u, 
        0x00F000F8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x53[ S ] */
        0x00000000u, 
        0x00000800u, 
        0x000FFF80u, 
        0x000FFFE0u, 
        0x000FEFF0u, 
        0x000E01F0u, 
        0x000800F8u, 
        0x00000078u, 
        0x00000078u, 
        0x00000078u, 
        0x00000078u, 
        0x00000078u, 
        0x000000F0u, 
        0x000007F0u, 
        0x00001FE0u, 
        0x00007FC0u, 
        0x0001FF80u, 
        0x0003FE00u, 
        0x0007F000u, 
        0x000FC000u, 
        0x000F8000u, 
        0x000F0000u, 
        0x001E0000u, 
        0x001E0000u, 
        0x001E0000u, 
        0x001E0000u, 
        0x000F0000u, 
        0x000F0018u, 
        0x000F8078u, 
        0x0007FFF8u, 
        0x0003FFF8u, 
        0x0000FFF0u, 
        0x00001FC0u, 
        0x00000000u  
    },
    {   /* 0x54[ T ] */
        0x00000000u, 
        0x01FFFFF8u, 
        0x01FFFFF8u, 
        0x01FFFFF8u, 
        0x01FFFFF8u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x55[ U ] */
        0x00000000u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x01F000F8u, 
        0x00F000F8u, 
        0x00F000F8u, 
        0x00F800F8u, 
        0x00F801F0u, 
        0x00FC01F0u, 
        0x007E03E0u, 
        0x003FFFE0u, 
        0x001FFFC0u, 
        0x000FFF80u, 
        0x0003FC00u, 
        0x00000000u  
    },
    {   /* 0x56[ V ] */
        0x00000000u, 
        0x0780003Eu, 
        0x03C0003Eu, 
        0x03C0007Cu, 
        0x03C0007Cu, 
        0x01E0007Cu, 
        0x01E000F8u, 
        0x01E000F8u, 
        0x00F000F8u, 
        0x00F001F0u, 
        0x00F001F0u, 
        0x007001E0u, 
        0x007803E0u, 
        0x007803E0u, 
        0x003803C0u, 
        0x003C07C0u, 
        0x003C07C0u, 
        0x001C0780u, 
        0x001E0F80u, 
        0x001E0F80u, 
        0x000E0F00u, 
        0x000F1F00u, 
        0x000F1F00u, 
        0x00073E00u, 
        0x00073E00u, 
        0x0007BC00u, 
        0x0007FC00u, 
        0x0003FC00u, 
        0x0003F800u, 
        0x0003F800u, 
        0x0001F800u, 
        0x0001F000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x57[ W ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x9E01F01Eu, 
        0x9F01F01Eu, 
        0x8F03F01Eu, 
        0x8F03F01Eu, 
        0x8F03F81Cu, 
        0x8F03F83Cu, 
        0x8703B83Cu, 
        0x8707B83Cu, 
        0x8787B838u, 
        0x87873C38u, 
        0x87873C38u, 
        0x83871C78u, 
        0x838F1C78u, 
        0x838F1C70u, 
        0x83CF1C70u, 
        0x81CF1E70u, 
        0x81CE0E70u, 
        0x81DE0E60u, 
        0x81DE0EE0u, 
        0x81DE0EE0u, 
        0x80DE0FE0u, 
        0x80FE07E0u, 
        0x80FC07C0u, 
        0x80FC07C0u, 
        0x807C07C0u, 
        0x807C07C0u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x58[ X ] */
        0x00000000u, 
        0x03E000F8u, 
        0x01F000F8u, 
        0x00F801F0u, 
        0x00F801E0u, 
        0x007C03E0u, 
        0x007C03C0u, 
        0x003E07C0u, 
        0x001E0780u, 
        0x001F0F80u, 
        0x000F8F00u, 
        0x000F9F00u, 
        0x0007DE00u, 
        0x0003FE00u, 
        0x0003FC00u, 
        0x0001FC00u, 
        0x0001F800u, 
        0x0001FC00u, 
        0x0003FC00u, 
        0x0007FE00u, 
        0x0007DF00u, 
        0x000F9F00u, 
        0x000F0F80u, 
        0x001F0780u, 
        0x001E07C0u, 
        0x003E03C0u, 
        0x007C03E0u, 
        0x007C01F0u, 
        0x00F801F0u, 
        0x00F800F8u, 
        0x01F000F8u, 
        0x01F0007Cu, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x59[ Y ] */
        0x00000000u, 
        0x07C0007Eu, 
        0x03E0007Cu, 
        0x01F000FCu, 
        0x01F000F8u, 
        0x00F801F8u, 
        0x00F801F0u, 
        0x007C03E0u, 
        0x007C03E0u, 
        0x003E07C0u, 
        0x003F07C0u, 
        0x001F0F80u, 
        0x000F8F00u, 
        0x000F9F00u, 
        0x0007DE00u, 
        0x0007FC00u, 
        0x0003FC00u, 
        0x0003F800u, 
        0x0001F800u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x5A[ Z ] */
        0x00000000u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007C0000u, 
        0x003E0000u, 
        0x001F0000u, 
        0x001F0000u, 
        0x000F8000u, 
        0x000FC000u, 
        0x0007C000u, 
        0x0003E000u, 
        0x0003F000u, 
        0x0001F000u, 
        0x0001F800u, 
        0x0000FC00u, 
        0x00007C00u, 
        0x00007E00u, 
        0x00003E00u, 
        0x00001F00u, 
        0x00001F80u, 
        0x00000F80u, 
        0x00000FC0u, 
        0x000007E0u, 
        0x000003E0u, 
        0x000003F0u, 
        0x000001F8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x007FFFF8u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x5B[ [ ] */
        0x0003FF00u, 
        0x0003FF00u, 
        0x0003FF00u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x00000700u, 
        0x0003FF00u, 
        0x0003FF00u, 
        0x0003FF00u, 
        0x0003FF00u, 
        0x00000000u  
    },
    {   /* 0x5C[ \ ] */
        0x000007C0u, 
        0x000007C0u, 
        0x00000F80u, 
        0x00000F80u, 
        0x00001F00u, 
        0x00001F00u, 
        0x00001E00u, 
        0x00003E00u, 
        0x00003C00u, 
        0x00007C00u, 
        0x00007800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F000u, 
        0x0001F000u, 
        0x0001E000u, 
        0x0003E000u, 
        0x0003C000u, 
        0x0007C000u, 
        0x00078000u, 
        0x00078000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x001F0000u, 
        0x001E0000u, 
        0x001E0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x00780000u, 
        0x00780000u, 
        0x00F00000u, 
        0x00F00000u, 
        0x00E00000u, 
        0x00000000u  
    },
    {   /* 0x5D[ ] ] */
        0x0001FFC0u, 
        0x0001FFC0u, 
        0x0001FFC0u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001FFC0u, 
        0x0001FFC0u, 
        0x0001FFC0u, 
        0x0001FFC0u, 
        0x00000000u  
    },
    {   /* 0x5E[ ^ ] */
        0x00000000u, 
        0x0001F800u, 
        0x0001FC00u, 
        0x0003FC00u, 
        0x0003FE00u, 
        0x0007DE00u, 
        0x00079F00u, 
        0x000F8F00u, 
        0x000F0F80u, 
        0x001F0F80u, 
        0x001F07C0u, 
        0x003E07C0u, 
        0x007E03E0u, 
        0x007C03F0u, 
        0x00FC01F0u, 
        0x00F801F8u, 
        0x01F801F8u, 
        0x01F800FCu, 
        0x03F000FCu, 
        0x03F0007Eu, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x5F[ _ ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x01FFFFF0u, 
        0x01FFFFF0u, 
        0x01FFFFF0u, 
        0x01FFFFF0u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x60[ ` ] */
        0x00000000u, 
        0x00003E00u, 
        0x00003C00u, 
        0x00007C00u, 
        0x00007800u, 
        0x00007800u, 
        0x0000F000u, 
        0x0000F000u, 
        0x0000E000u, 
        0x0001E000u, 
        0x0001C000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x61[ a ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0000FC00u, 
        0x0007FF80u, 
        0x000FFFC0u, 
        0x000FCFC0u, 
        0x000E00C0u, 
        0x000E0000u, 
        0x001E0000u, 
        0x001FC000u, 
        0x001FFE00u, 
        0x001FFF80u, 
        0x001E07C0u, 
        0x001E01C0u, 
        0x001E01C0u, 
        0x001E03C0u, 
        0x001F01C0u, 
        0x001F83C0u, 
        0x001FF7C0u, 
        0x001EFF80u, 
        0x001E7F00u, 
        0x00001C00u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x62[ b ] */
        0x00000000u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x0007C7C0u, 
        0x000FF7C0u, 
        0x001FFFC0u, 
        0x003F1FC0u, 
        0x003C07C0u, 
        0x003807C0u, 
        0x007807C0u, 
        0x007007C0u, 
        0x007007C0u, 
        0x007007C0u, 
        0x007007C0u, 
        0x007807C0u, 
        0x007807C0u, 
        0x007807C0u, 
        0x007C07C0u, 
        0x003C0FC0u, 
        0x001FFFC0u, 
        0x000FFBC0u, 
        0x0007F3C0u, 
        0x0000C000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x63[ c ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0007F000u, 
        0x0007FC00u, 
        0x0007FF00u, 
        0x00041F80u, 
        0x000007C0u, 
        0x000003C0u, 
        0x000003E0u, 
        0x000001E0u, 
        0x000001E0u, 
        0x000001E0u, 
        0x000001E0u, 
        0x000001E0u, 
        0x000001E0u, 
        0x000001E0u, 
        0x000003C0u, 
        0x000007C0u, 
        0x00078F80u, 
        0x0007FF00u, 
        0x0003FE00u, 
        0x00003800u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x64[ d ] */
        0x00000000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003CF800u, 
        0x003DFC00u, 
        0x003FFF00u, 
        0x003E1F80u, 
        0x003E0780u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C01C0u, 
        0x003C01C0u, 
        0x003C01C0u, 
        0x003C01C0u, 
        0x003C01E0u, 
        0x003C01E0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003E07C0u, 
        0x003FCF80u, 
        0x003DFF00u, 
        0x003DFE00u, 
        0x00007800u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x65[ e ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0001FC00u, 
        0x0007FF00u, 
        0x000FFF80u, 
        0x000F8FC0u, 
        0x001E03C0u, 
        0x001C03E0u, 
        0x001C01E0u, 
        0x001C01E0u, 
        0x001FFFE0u, 
        0x001FFFE0u, 
        0x001FFFE0u, 
        0x000001E0u, 
        0x000001C0u, 
        0x000003C0u, 
        0x00000380u, 
        0x00000780u, 
        0x000FFF00u, 
        0x000FFE00u, 
        0x0007FC00u, 
        0x0000F000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x66[ f ] */
        0x00000000u, 
        0x00000000u, 
        0x000FC000u, 
        0x000FF800u, 
        0x000FF800u, 
        0x00007C00u, 
        0x00003C00u, 
        0x00003C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x000FFFC0u, 
        0x000FFFC0u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x67[ g ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00007C00u, 
        0x007BFF80u, 
        0x007FFF80u, 
        0x007FFFC0u, 
        0x007E07C0u, 
        0x007C03C0u, 
        0x007C01E0u, 
        0x007C01E0u, 
        0x007C01E0u, 
        0x007C01E0u, 
        0x007C03E0u, 
        0x003E07C0u, 
        0x001F9FC0u, 
        0x000FFFC0u, 
        0x00007FC0u, 
        0x000001E0u, 
        0x000003E0u, 
        0x0000FFE0u, 
        0x003FFFC0u, 
        0x007FFF80u, 
        0x007F8000u, 
        0x00FC0000u, 
        0x00F80000u, 
        0x00780000u, 
        0x00780000u, 
        0x007C0020u, 
        0x003F00E0u, 
        0x001FFFE0u, 
        0x000FFFE0u, 
        0x0001FF00u, 
        0x00000000u  
    },
    {   /* 0x68[ h ] */
        0x00000000u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000387C0u, 
        0x000FE7C0u, 
        0x001FFFC0u, 
        0x001F3FC0u, 
        0x003C0FC0u, 
        0x003C07C0u, 
        0x003803C0u, 
        0x003803C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x003807C0u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x69[ i ] */
        0x00000000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x6A[ j ] */
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003C000u, 
        0x0003FF00u, 
        0x0001FF00u, 
        0x0000FF00u, 
        0x00001E00u, 
        0x00000000u  
    },
    {   /* 0x6B[ k ] */
        0x00000000u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x000007C0u, 
        0x003E07C0u, 
        0x001F07C0u, 
        0x000F87C0u, 
        0x0007C7C0u, 
        0x0003E7C0u, 
        0x0001F7C0u, 
        0x0000FFC0u, 
        0x00007FC0u, 
        0x00003FC0u, 
        0x00007FC0u, 
        0x0000F7C0u, 
        0x0001E7C0u, 
        0x0003C7C0u, 
        0x0007C7C0u, 
        0x000F87C0u, 
        0x001F07C0u, 
        0x003E07C0u, 
        0x007C07C0u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x6C[ l ] */
        0x00000000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00007000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x6D[ m ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x001C1C00u, 
        0x00FE3F3Cu, 
        0x00FFBFBCu, 
        0x01F3F8FCu, 
        0x01C1F07Cu, 
        0x01C0E03Cu, 
        0x01C0E03Cu, 
        0x03C0E03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x03C0F03Cu, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x6E[ n ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0007C000u, 
        0x000FF3C0u, 
        0x001FFBC0u, 
        0x003E3FC0u, 
        0x003C0FC0u, 
        0x003C07C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x6F[ o ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0003FC00u, 
        0x0007FE00u, 
        0x000FFF00u, 
        0x001F9F80u, 
        0x003E07C0u, 
        0x003C03C0u, 
        0x007C01E0u, 
        0x007801E0u, 
        0x007801E0u, 
        0x007801E0u, 
        0x007801E0u, 
        0x007801E0u, 
        0x007801E0u, 
        0x003C01E0u, 
        0x003C03C0u, 
        0x001E07C0u, 
        0x001FFF80u, 
        0x0007FF00u, 
        0x0001FE00u, 
        0x00007800u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x70[ p ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0003C000u, 
        0x000FFBC0u, 
        0x001FFFC0u, 
        0x003F1FC0u, 
        0x003C07C0u, 
        0x003807C0u, 
        0x007803C0u, 
        0x007003C0u, 
        0x007003C0u, 
        0x007003C0u, 
        0x007003C0u, 
        0x007803C0u, 
        0x007803C0u, 
        0x007803C0u, 
        0x007C03C0u, 
        0x003C0FC0u, 
        0x001FFFC0u, 
        0x000FFBC0u, 
        0x0007F3C0u, 
        0x0001C3C0u, 
        0x000003C0u, 
        0x000003C0u, 
        0x000003C0u, 
        0x000003C0u, 
        0x000003C0u, 
        0x000003C0u, 
        0x00000000u  
    },
    {   /* 0x71[ q ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0000F000u, 
        0x003DFC00u, 
        0x003FFF00u, 
        0x003E1F80u, 
        0x003E0780u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003C01C0u, 
        0x003C01C0u, 
        0x003C01C0u, 
        0x003C01C0u, 
        0x003C01E0u, 
        0x003C01C0u, 
        0x003C03C0u, 
        0x003C03C0u, 
        0x003E0780u, 
        0x003FCF80u, 
        0x003DFF00u, 
        0x003CFC00u, 
        0x003C3800u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x003C0000u, 
        0x00000000u  
    },
    {   /* 0x72[ r ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x003E3C00u, 
        0x003F3C00u, 
        0x000FFC00u, 
        0x0001FC00u, 
        0x0000FC00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00007C00u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x73[ s ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x0000FC00u, 
        0x0007FF00u, 
        0x0007FF80u, 
        0x00070F80u, 
        0x00000380u, 
        0x000003C0u, 
        0x000003C0u, 
        0x00000FC0u, 
        0x00003F80u, 
        0x0001FE00u, 
        0x0007F800u, 
        0x0007E000u, 
        0x000F8000u, 
        0x000F0000u, 
        0x000F0000u, 
        0x000F00C0u, 
        0x0007FFC0u, 
        0x0007FFC0u, 
        0x0001FF80u, 
        0x00003800u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x74[ t ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x000FFFC0u, 
        0x000FFFC0u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00001C00u, 
        0x00003C00u, 
        0x0000FC00u, 
        0x0007FC00u, 
        0x0007F800u, 
        0x0003E000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x75[ u ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C03C0u, 
        0x001C0380u, 
        0x001E0380u, 
        0x001F0380u, 
        0x001FFF80u, 
        0x001DFF00u, 
        0x001C7F00u, 
        0x00001C00u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x76[ v ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x003C01E0u, 
        0x003C03E0u, 
        0x001E03C0u, 
        0x001E03C0u, 
        0x001E0380u, 
        0x000E0780u, 
        0x000F0780u, 
        0x000F0700u, 
        0x00070F00u, 
        0x00070F00u, 
        0x00078E00u, 
        0x00039E00u, 
        0x00039E00u, 
        0x0003DC00u, 
        0x0003FC00u, 
        0x0001F800u, 
        0x0001F800u, 
        0x0001F800u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x77[ w ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x03C1F83Cu, 
        0x03C1F83Cu, 
        0x03C1F83Cu, 
        0x03C1F878u, 
        0x01C1F878u, 
        0x01E3B878u, 
        0x01E39C78u, 
        0x01E39CF8u, 
        0x01E39CF0u, 
        0x00E31CF0u, 
        0x00E30CF0u, 
        0x00F70CF0u, 
        0x00F70FE0u, 
        0x00770FE0u, 
        0x00760FE0u, 
        0x007E07E0u, 
        0x007E07E0u, 
        0x003E07C0u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x78[ x ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x001C03C0u, 
        0x000E0780u, 
        0x000F0F80u, 
        0x00070F00u, 
        0x00079E00u, 
        0x0003DE00u, 
        0x0003FC00u, 
        0x0001F800u, 
        0x0001F800u, 
        0x0001F800u, 
        0x0001FC00u, 
        0x0003DC00u, 
        0x00039E00u, 
        0x00070F00u, 
        0x00070F00u, 
        0x000E0780u, 
        0x001E0780u, 
        0x001C03C0u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x79[ y ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x007803E0u, 
        0x003C03C0u, 
        0x003C07C0u, 
        0x003C0780u, 
        0x001C0780u, 
        0x001E0F80u, 
        0x001E0F00u, 
        0x000E1F00u, 
        0x000F1E00u, 
        0x000F1E00u, 
        0x00073C00u, 
        0x0007BC00u, 
        0x0003B800u, 
        0x0003F800u, 
        0x0003F000u, 
        0x0001F000u, 
        0x0001F000u, 
        0x0001E000u, 
        0x0000E000u, 
        0x0000F000u, 
        0x00007000u, 
        0x00007800u, 
        0x00003E00u, 
        0x00003F80u, 
        0x00000FC0u, 
        0x000007C0u, 
        0x00000000u  
    },
    {   /* 0x7A[ z ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x001FFFC0u, 
        0x001FFFC0u, 
        0x000F0000u, 
        0x000F8000u, 
        0x00078000u, 
        0x0003C000u, 
        0x0003E000u, 
        0x0001F000u, 
        0x0000F000u, 
        0x0000F800u, 
        0x00007C00u, 
        0x00003E00u, 
        0x00003E00u, 
        0x00001F00u, 
        0x00000F80u, 
        0x000007C0u, 
        0x001FFFC0u, 
        0x001FFFC0u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    },
    {   /* 0x7B[ { ] */
        0x000FF000u, 
        0x000FF800u, 
        0x000FF800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003C00u, 
        0x00003C00u, 
        0x00003E00u, 
        0x00001F00u, 
        0x00000FC0u, 
        0x000007C0u, 
        0x00001FC0u, 
        0x00001E00u, 
        0x00003C00u, 
        0x00003C00u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x00003800u, 
        0x000FF800u, 
        0x000FF800u, 
        0x000FF000u, 
        0x000FE000u, 
        0x00000000u  
    },
    {   /* 0x7C[ | ] */
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x0000F800u, 
        0x00000000u  
    },
    {   /* 0x7D[ } ] */
        0x00007F80u, 
        0x0000FF80u, 
        0x0000FF80u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0001E000u, 
        0x0003C000u, 
        0x001F8000u, 
        0x001FC000u, 
        0x001FE000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0001E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000E000u, 
        0x0000F000u, 
        0x0000FF80u, 
        0x00007F80u, 
        0x00003F80u, 
        0x00000F80u, 
        0x00000000u  
    },
    {   /* 0x7E[ ~ ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x000007C0u, 
        0x00000FF0u, 
        0x00301FF8u, 
        0x00787E3Cu, 
        0x003FF81Cu, 
        0x001FE000u, 
        0x00070000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u  
    }
};

static const uint32_t fnttbl_15x17_0_0x30to0x3a[FONTTBL15X17_0_TBL_SIZE][DSP_IMG_HS_FONT15X17] = {
    {   /* 0x30[ 0 ] */
        0x00000000u, 
        0x000003E0u, 
        0x000007F0u, 
        0x00000E38u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000E38u, 
        0x000007F0u, 
        0x000003E0u, 
        0x00000000u  
    },
    {   /* 0x31[ 1 ] */
        0x00000000u, 
        0x00000000u, 
        0x000001C0u, 
        0x000001E0u, 
        0x000001B0u, 
        0x00000198u, 
        0x00000188u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000000u  
    },
    {   /* 0x32[ 2 ] */
        0x00000000u, 
        0x000007F0u, 
        0x00000FF8u, 
        0x00000C18u, 
        0x00000C08u, 
        0x00000C00u, 
        0x00000C00u, 
        0x00000600u, 
        0x00000300u, 
        0x00000180u, 
        0x000000C0u, 
        0x00000060u, 
        0x00000030u, 
        0x00000018u, 
        0x00000FF8u, 
        0x00000FF8u, 
        0x00000000u  
    },
    {   /* 0x33[ 3 ] */
        0x00000000u, 
        0x000007F0u, 
        0x00000FF8u, 
        0x00000C18u, 
        0x00000C08u, 
        0x00000C00u, 
        0x00000C00u, 
        0x000007E0u, 
        0x000007E0u, 
        0x00000E00u, 
        0x00000C00u, 
        0x00000C00u, 
        0x00000C00u, 
        0x00000C08u, 
        0x00000FF8u, 
        0x000007F0u, 
        0x00000000u  
    },
    {   /* 0x34[ 4 ] */
        0x00000000u, 
        0x00000000u, 
        0x00000700u, 
        0x00000780u, 
        0x000006C0u, 
        0x000006C0u, 
        0x00000660u, 
        0x00000660u, 
        0x00000630u, 
        0x00000630u, 
        0x00000618u, 
        0x00001FF8u, 
        0x00001FF8u, 
        0x00000600u, 
        0x00000600u, 
        0x00000600u, 
        0x00000000u  
    },
    {   /* 0x35[ 5 ] */
        0x00000000u, 
        0x000007F8u, 
        0x000007F8u, 
        0x00000018u, 
        0x00000018u, 
        0x00000018u, 
        0x00000018u, 
        0x000007F8u, 
        0x00000FF8u, 
        0x00000C18u, 
        0x00000C00u, 
        0x00000C00u, 
        0x00000C00u, 
        0x00000C08u, 
        0x00000FF8u, 
        0x000007F0u, 
        0x00000000u  
    },
    {   /* 0x36[ 6 ] */
        0x00000000u, 
        0x000007C0u, 
        0x000007E0u, 
        0x000000F0u, 
        0x00000030u, 
        0x00000018u, 
        0x00000018u, 
        0x000007F8u, 
        0x00000FF8u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000E18u, 
        0x000007F8u, 
        0x000003F0u, 
        0x00000000u  
    },
    {   /* 0x37[ 7 ] */
        0x00000000u, 
        0x00000FF8u, 
        0x00000FF8u, 
        0x00000C00u, 
        0x00000E00u, 
        0x00000600u, 
        0x00000300u, 
        0x00000300u, 
        0x00000180u, 
        0x00000180u, 
        0x000000C0u, 
        0x000000C0u, 
        0x00000060u, 
        0x00000060u, 
        0x00000030u, 
        0x00000030u, 
        0x00000000u  
    },
    {   /* 0x38[ 8 ] */
        0x00000000u, 
        0x000003E0u, 
        0x000007F0u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x000007F0u, 
        0x00000FF8u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000FF8u, 
        0x000007F0u, 
        0x00000000u  
    },
    {   /* 0x39[ 9 ] */
        0x00000000u, 
        0x000003F0u, 
        0x000007F0u, 
        0x00000E38u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000C18u, 
        0x00000FF0u, 
        0x00000FE0u, 
        0x00000C00u, 
        0x00000C00u, 
        0x00000600u, 
        0x00000780u, 
        0x000003F0u, 
        0x000001F0u, 
        0x00000000u  
    },
    {   /* 0x3A[ : ] */
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000000u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000180u, 
        0x00000000u, 
        0x00000000u  
    }
};

const dsp_fntinf_t dsp_img_fonttbl30x34[DSP_IMG_TBL_NUM_FONT30X34] = {
    {   /* Special character 0x01( EIGHTH NOTE ) */
        &fnttbl_30x34_0_0x1[0][0],          /* p_font */
        TBL30X34_0_CHR_START,               /* start_char */
        TBL30X34_0_CHR_END                  /* end_char */
    },
    {   /* ASCII 0x20(' ') - 0x7E('~') */
        &fnttbl_30x34_1_0x20to0x7e[0][0],   /* p_font */
        TBL30X34_1_CHR_START,               /* start_char */
        TBL30X34_1_CHR_END                  /* end_char */
    }
};

const dsp_fntinf_t dsp_img_fonttbl15x17[DSP_IMG_TBL_NUM_FONT15X17] = {
    {   /* ASCII 0x30('0') - 0x3A(':') */
        &fnttbl_15x17_0_0x30to0x3a[0][0],   /* p_font */
        TBL15X17_0_CHR_START,               /* start_char */
        TBL15X17_0_CHR_END                  /* end_char */
    }
};
