/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer*
* Copyright (C) 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/

#ifndef DISP_GRAPHICS_H
#define DISP_GRAPHICS_H

#include "r_typedefs.h"

/*--- Macro definition ---*/
#define DSP_IMG_FORM_AUTOSEL            (0)
#define DSP_IMG_FORM_RGB888             (1)
#define DSP_IMG_FORM_ARGB8888           (2)
#define DSP_IMG_FORM_ARGB8888_NO_BLEND  (3)

/*--- User defined types ---*/
typedef struct {
    uint32_t        *p_disp_buf;    /* Pointer to a buffer of TFT display.  */
                                    /* Refers VDC5 driver to this buffer.  */
    uint32_t        *p_back_buf;    /* Pointer to a buffer of TFT display. */
                                    /* Uses this buffer for making data of the display image. */
    uint32_t        width;          /* The width of TFT display. */
    uint32_t        height;         /* The height of TFT display. */
    uint32_t        stride;         /* Buffer stride of TFT display. */
} dsp_tftlayer_t;

/** Fills all area of VRAM with color of black.
 *
 *  @param p_info Pointer to VRAM structure
 */
void dsp_clear_all(const dsp_tftlayer_t * const p_info);

/** Fills the specified area of VRAM with color of black.
 *
 *  @param p_info Pointer to VRAM structure
 *  @param start_x Display position X
 *  @param start_y Display position Y
 *  @param size_x The width
 *  @param size_y The height
 */
void dsp_clear_area(const dsp_tftlayer_t * const p_info, const int32_t start_x, 
                 const int32_t start_y, const int32_t size_x, const int32_t size_y);

/** Draws the specified picture to VRAM.
 *
 *  @param p_info Pointer to VRAM structure
 *  @param start_x Display position X of the picture
 *  @param start_y Display position Y of the picture
 *  @param pict_id Picture ID
 *  @param pict_type Picture type
 */
void dsp_draw_picture(const dsp_tftlayer_t * const p_info, const int32_t start_x, 
                const int32_t start_y, const int32_t pict_id, const int32_t pict_type);

/** Draws the filled rectangle.
 *
 *  @param p_info Pointer to VRAM structure
 *  @param start_x Display position X of rectangle
 *  @param start_y Display position Y of rectangle
 *  @param size_x The width of rectangle
 *  @param size_y The height of rectangle
 *  @param fg_col The foreground color of ARGB8888 format
 */
void dsp_fill_rect(const dsp_tftlayer_t * const p_info, const int32_t start_x, 
    const int32_t start_y, const int32_t size_x, const int32_t size_y, const uint32_t fg_col);

/** Draws the text string.
 *
 *  @param p_info Pointer to VRAM structure
 *  @param start_x Display position X of the text string
 *  @param start_y Display position Y of the text string
 *  @param p_str Pointer to the text string
 */
void dsp_draw_text30x34(const dsp_tftlayer_t * const p_info, const int32_t start_x, 
                                    const int32_t start_y, const char_t * const p_str);

/** Draws the text string.
 *
 *  @param p_info Pointer to VRAM structure
 *  @param start_x Display position X of the text string
 *  @param start_y Display position Y of the text string
 *  @param p_str Pointer to the text string
 */
void dsp_draw_text15x17(const dsp_tftlayer_t * const p_info, const int32_t start_x, 
                                    const int32_t start_y, const char_t * const p_str);

#endif  /* DISP_GRAPHICS_H */
