#include "mbed.h"

AnalogIn Sensor_L(PA_0);
AnalogIn Sensor_F(PA_1);
AnalogIn Sensor_R(PA_4);

float readSensorValue(int);

bool readSensor(int Position)
{
    float dist1, dist2;
    while(true) {
        dist1 = readSensorValue(Position);
        //wait(0.3);
        dist2 = readSensorValue(Position);
        if(abs(dist1-dist2) < 3.0f) {
            if(((dist1+dist2)/2) >= 13.0f) {
                return false;
            } else {
                return true;
            }
        }
    }
}

float readSensorValue(int Position)
{

    float distance;
    float voltage;
    float distancetot = 0;
    int i = 0;

    while(true) {
        for(i = 0; i < 2; i++) {
            switch(Position) {
                case 1:
                    voltage = Sensor_L.read();
                    //distance = -4122.2*pow(voltage,5)+9496.2*pow(voltage,4)-8519.4*pow(voltage,3)+3743.5*pow(voltage,2)-822.5*voltage+77.9;
                    distance = 306.4*pow(voltage,5)-405.41*pow(voltage,4)+36.17*pow(voltage,3)+177.5*pow(voltage,2)-106.65*voltage+23.08;
                    if(distance > 15.0)
                    {
                        distance = 15.0;
                    }
                    if(distance < 2)
                    {
                        distance = 2.0;
                    } 
                    break;

                case 2:
                    voltage = Sensor_F.read();
                    
                    //distance = -4122*pow(voltage,5)+9496*pow(voltage,4)-8519*pow(voltage,3)+3743*pow(voltage,2)-822*voltage;
                    distance = -137.67*pow(voltage,5)+129.58*pow(voltage,4)-55.36*pow(voltage,3)+72.25*pow(voltage,2)-59.54*voltage+18.0;
                                        if(distance > 15.0)
                    {
                        distance = 15.0;
                    }
                    if(distance < 2)
                    {
                        distance = 2.0;
                    } 
                    break;

                case 3:
                    voltage = Sensor_R.read();
                    //printf("Spannung, %f\n",voltage);
                    distance = 3407.9*pow(voltage,5)-5715*pow(voltage,4)+3435.4*pow(voltage,3)-828.2*pow(voltage,2)+29.5*voltage+16.1;
                    if(distance > 15.0)
                    {
                        distance = 15.0;
                    }
                    if(distance < 2)
                    {
                        distance = 2.0;
                    } 
                    break;

                default:
                    return true;
                    break;
            }
            distancetot = distancetot + distance;
        }
        //ticker_sens.detach();
        distancetot = distancetot / (i);
        //printf("%f\n",distancetot);
        return distancetot;
        //filter.in(distance);
        //filteredDistance = filter.out();


    }
}