 #include "mbed.h" 
 #include "VS1002.h"
  
 using namespace mbed;
   
/*For Change Task*/

 #define MUSIC_PLAYER 's'
 #define LED 'l'
 #define MOTOR 'm'
volatile char task=MUSIC_PLAYER;
/*Serial COM port*/
Serial pc1(USBTX, USBRX);
Serial taskport(p28,p27); 

/*For Music Control*/  
VS1002 mp3(p5, p6, p7, p8,"sd",p11, p12 ,p13, p14, p18, p19, p20, p15);  
char *song_name[6]={"Escape","Summer of 69","Monster", "Leave out all the rest","Kings","Interstellar Docking"}; //Array of song names entered manually
int new_song_number=1;  //Variable to store the Song Number
int volume_set=-5;     //Variable to store the Volume
int previous_volume;    //Variable to store the volume when muted
bool pause=false;       //Variable to store the status of Pause button 
bool mute=false;        //Variable to store the status of mute button
 #define NEXT 7
 #define PREVIOUS 8
 #define PP 9
 #define V_DOWN 10
 #define V_UP 11
 #define MUTE_UNMUTE 12

/*For LED Control*/
PwmOut red(p24);
PwmOut green(p23);
PwmOut blue(p22);
/*For Motor Control*/
PwmOut fanSwitch(p21);
/*For Debugging*/
 DigitalOut led1(LED1);
 DigitalOut led2(LED2);

/*For Change Task*/
  void changeTask()
  {
      if(taskport.readable()){
          char c=taskport.getc();
          pc1.putc(c);
          task=c;
          }
      }
/*For Do Different Function*/
  void changeAction(){
  if(pc1.readable()){
  const char arg0=pc1.getc();
  if(task==LED){
     switch(arg0)
    {
        case '1':
                    {
                        red = 1.0;
                        green = 1.0;
                        blue = 1.0;
                    }
                    break;
        case '2':
                    {
                        red = 0.75;
                        green = 0.75;
                        blue = 0.75;
                    }
                    break;    
        case '3':
                    {
                        red = 0.5;
                        green = 0.5;
                        blue = 0.5;
                    }
                    break; 
        case '4':
                    {
                        red = 0.25;
                        green = 0.25;
                        blue = 0.25;
                    }
                    break;  

        default :
                    break;                                                
    }
    led1=!led1;
  }else if(task==MOTOR){
     switch(arg0)
    {
        case '1':
                    {
                        fanSwitch = 1.0; //Full Speed
                    }
                    break;
        case '2':
                    {
                        fanSwitch = 0.3; // Medium Speed
                    }
                    break;    
        case '3':
                    {
                        fanSwitch = 0; // Low Speed
                    }
                    break; 
        
          
        default :
                    break;                                                
    }
    led2=!led2;
  }else if(task==MUSIC_PLAYER)
  {
  int key_code=0;
    switch(arg0){
    case '1': key_code=V_UP; break;
    case '2': key_code=V_DOWN; break;
    case '3': key_code=PP; break;
    case '4': key_code=NEXT; break;
    case '5': key_code=PREVIOUS; break;
    case '6': key_code=MUTE_UNMUTE; break;   
    default : key_code=0; break; 
    }
    

 switch(key_code)  // Different cases depending on key press
 { 
  case NEXT:
            pc1.printf("next\r\n");
            new_song_number+=1;  // Next song
          if(new_song_number==7)
           new_song_number=1;
          break;
  case PREVIOUS: 
            pc1.printf("previous\r\n");
            new_song_number-=1;  // Previous Song
          if(new_song_number==0)
           new_song_number=6;
          break;
  case PP: 
            pc1.printf("pp\r\n");
            pause=!pause; // Pause/Play button
          break;
  case V_UP: 
            pc1.printf("v_up\r\n");
            volume_set+=10; // Volume Up
           if(volume_set>=0)
            volume_set=0;
           break;
  case V_DOWN: 
            pc1.printf("v_down\r\n");
            volume_set-=10;  //Volume Down
           if(volume_set<-55)
            volume_set=-55;
            break;
  case MUTE_UNMUTE: 
            pc1.printf("mute_unmute\r\n");
            mute=!mute;  //Mute/Unmute
           if(mute)
           {
            previous_volume=volume_set; // Attenuation of -55 db is small enough to not hear anything
            volume_set=-55;
           }
           else
           {
           volume_set=previous_volume;
           }
           break;
  default: ;//pc.cls();
           pc1.printf("error");  // exit on error
           exit(1);
        }
 
 /* Print to LCD the status of Song */
  //pc.cls();
  if(pause)
    pc1.printf("Paused ");
  if(mute)
   pc1.printf("Muted");
  if(!mute && !pause)
   pc1.printf("Playing"); 
  pc1.printf("\r\n %d %s",new_song_number,song_name[new_song_number-1]);   
  }
  }
}
 int main () 
 { 
    led1=1;
    led2=1;
    pc1.printf("hello\r\n");      
    
     mp3._RST = 1; 
     mp3.cs_high();                                  //chip disabled 
     mp3.sci_initialise();                           //initialise MBED 
     mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF)); 
     mp3.sci_write(0x03, 0x9800); 
     mp3.sdi_initialise();    
      
    pc1.attach(&changeAction, Serial::RxIrq);//Serial interrupt for function code
    taskport.attach(&changeTask, Serial::RxIrq);// Serial interrupt for Task code
         while(1)
         {
         mp3.play_song(new_song_number);
         }       
 
 } 
 
          
