#include "mbed.h"
#include "uLCD_4DGL.h"
#include "LSM9DS1.h"

AnalogIn flex(p17);
PwmOut red(p24);
PwmOut green(p23);
PwmOut blue(p22);
PwmOut motorSwitch(p21);

uLCD_4DGL uLCD (p28,p27,p30); // serial tx, serial rx, reset pin;
Serial pc(USBTX, USBRX);

float flexScaled;

int main()
{
    uLCD.baudrate(300000);
    red.period(0.00001); 
    green.period(0.00001);
    blue.period(0.000010);
    motorSwitch.period(0.01);

    flexScaled=flex*1000;
   
    uLCD.cls();
    uLCD.background_color(DGREY);
    uLCD.set_font(FONT_7X8);
    uLCD.text_bold(ON);
    uLCD.text_italic(ON);
    
    while(1)
    {  
        flexScaled=flex*10000;
        red = 0;
        green = 0;
        blue = 0;
      
        if(flexScaled<1000) 
        {
            green=1;
        }
        if(flexScaled>1050 && flexScaled<2800)
        {
            blue=1;
        }    
        if(flexScaled>2800)
        {
            red=1;
        }
        
        float motorVal;
        motorVal=float(flexScaled/3500);
        motorSwitch.write(motorVal);
     
        uLCD.printf(" %f",motorSwitch.read());
        uLCD.locate(0,0);
        wait(0.01);

    }
}