/********************************************************************************
Titre : TCS34725.h
Auteur : Jeanne Baumier, Anaïs Auberval et Thomas Broussard
Date : 28/11/17
--------------------------------
Description : 
Librairie de fonctions dédiées au capteur RGB TCS34725
********************************************************************************/

#ifndef __TCS34725_H__
#define __TCS34725_H__

#include "mbed.h"

#define TCS34725_ADDR (41 << 1)


class TCS34725
{
public:
    /** Configure data pin (with other devices on I2C line)
      * @param I2C previous definition
      */
    TCS34725(I2C& p_i2c);

    /** Get approximates the human eye response
      *  in the commonly used Illuminance unit of Lux
      * @param none
      * @return Lux
      */
    void init_RGB(void);

    /** Set timing register
      * @param timing parameter
      * @return timing read data
      */
    void GET_RGB(int *clear_value, int* red_value, int*blue_value, int *green_value);

protected:
    I2C *_i2c_p;
    I2C &_i2c;

};   

#endif


 