/********************************************************************************
Titre : TCS34725.h
Auteur : Jeanne Baumier, Anaïs Auberval et Thomas Broussard
Date : 28/11/17
--------------------------------
Description : 
Librairie de fonctions dédiées au capteur RGB TCS34725
********************************************************************************/
#include "TCS34725.h"

TCS34725::TCS34725 (I2C& p_i2c)
 : _i2c(p_i2c)
{

}

void TCS34725::init_RGB()
{
    char id_regval[1] = {146};
    char data[1] = {0};
    
    _i2c.write(TCS34725_ADDR,id_regval,1, true);
    _i2c.read(TCS34725_ADDR,data,1,false);
    
    // Initialisation du capteur
    // Configuration du registre Timing (choix de la période d'intégration du résultat ?)
    char timing_register[2] = {129,0};
    _i2c.write(TCS34725_ADDR,timing_register,2,false);
    
    // Configuration du registre Control
    char control_register[2] = {143,0};
    _i2c.write(TCS34725_ADDR,control_register,2,false);
    
    // Activation du capteur
    char enable_register[2] = {128,3};
    _i2c.write(TCS34725_ADDR,enable_register,2,false);
};


void TCS34725::GET_RGB(int *clear_value, int* red_value, int*blue_value, int *green_value)
{
  char clear_reg[1] = {148};    char red_reg[1] = {150};    char green_reg[1] = {152};  char blue_reg[1] = {154};
  char clear_data[2] = {0,0};   char red_data[2] = {0,0};   char green_data[2] = {0,0}; char blue_data[2] = {0,0};
  
  // Clear
    _i2c.write(TCS34725_ADDR,clear_reg,1, true);// On pointe sur l'adresse clear_reg
    _i2c.read(TCS34725_ADDR,clear_data,2, false);// Lecture du résultat (2 octets)
        
    *clear_value = ((int)clear_data[1] << 8) | clear_data[0]; // Conversion binaire -> décimal du résultat
  
  // Red
    _i2c.write(TCS34725_ADDR,red_reg,1, true);// On pointe sur l'adresse red_reg 
    _i2c.read(TCS34725_ADDR,red_data,2, false);// Lecture du résultat (2 octets)
    
    *red_value = ((int)red_data[1] << 8) | red_data[0]; // Conversion binaire -> décimal du résultat
        
    // Green
    _i2c.write(TCS34725_ADDR,green_reg,1, true);// On pointe sur l'adresse green_reg 
    _i2c.read(TCS34725_ADDR,green_data,2, false);// Lecture du résultat (2 octets)
    
    *green_value = ((int)green_data[1] << 8) | green_data[0]; // Conversion binaire -> décimal du résultat
        
    // Blue
    _i2c.write(TCS34725_ADDR,blue_reg,1, true); // On pointe sur l'adresse blue_reg 
    _i2c.read(TCS34725_ADDR,blue_data,2, false);// Lecture du résultat (2 octets)
    
    *blue_value = ((int)blue_data[1] << 8) | blue_data[0]; // Conversion binaire -> décimal du résultat
}