/*
 *  Copyright (c) 2012 Neal Horman - http://www.wanlink.com
 *  
 *  License: MIT open source (http://opensource.org/licenses/MIT)
 *      Summary;
 *      Use / modify / distribute / publish it how you want and 
 *      if you use it, or don't, you can't hold me liable for how
 *      it does or doesn't work.
 *      If it doesn't work how you want, don't use it, or change
 *      it so that it does work.
 */
 
#include "mbed.h"
#include "Adafruit_SSD1306.h"
 
// Définition des pattes SPI
#define MOSI        D2
#define MISO        NC
#define CLK         A1
#define DC          D6  
#define CS          D3
#define RST_SPI     D5

// Définition des pattes i2c
#define SDA         D5
#define SCL         D6
#define RST_I2C     A0

// Déclaration des E/S
DigitalOut myled(LED1);


// Fonctions locales 
void Battery_Charge_SPI(int x, int y, int Niveau);

// sub-class SPI : 
// Caractéristiques par défaut de la communication SPI avec le SSD1306
class SPIPreInit : public SPI
{
public:
    SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk)
    {
        format(8,3); 
        frequency(2000000);
    };
};
 

// sub-class I2C : 
// Caractéristiques par défaut de la communication I2C avec le SSD1306
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(400000);// Fréquence d'utilisation(en Hz)
        start(); //Condition de start
    };
};

// Initialisation de l'écran en mode SPI
SPIPreInit gSpi(MOSI,MISO,CLK);
Adafruit_SSD1306_Spi gOled1(gSpi,DC,RST_SPI,CS,64,128);
 
// Initialisation de l'écran en mode I2C
//I2CPreInit gI2C(SDA,SCL);
//Adafruit_SSD1306_I2c gOled2(gI2C,RST_I2C);
 
int main()
{   uint16_t x=100,y=0;

    //gOled1.printf("%ux%u Thomas \r\n", gOled1.width(), gOled1.height());
    //gOled2.printf("%ux%u OLED Display\r\n", gOled2.width(), gOled2.height());
    
    
    
    while(1)
    {
        myled = !myled; 
        // On efface l'écran avant de commencer le programme
        gOled1.fillRect(0,0,128,64,0);
        
        gOled1.setTextCursor(0,0);
        gOled1.printf("Projet ei2i-4");
        gOled1.setTextCursor(0,10);
        gOled1.printf("Jeanne Anais Thomas");
        
        // Ligne horizontale blanche
        gOled1.drawFastHLine(0, 20, 128, WHITE);
        gOled1.drawFastHLine(0, 22, 128, WHITE);
        
        //Affichage X
        gOled1.setTextCursor(0,30);
        gOled1.printf("X = %d",x);
        gOled1.setTextCursor(80,30);
        //gOled1.printf("\tC");
        
        // Affichage Y
        gOled1.setTextCursor(0,40);
        gOled1.printf("Y = %d",y);
        gOled1.setTextCursor(80,40);
        //gOled1.printf("\t/\t");
        
        // Affichage batterie :
        Battery_Charge_SPI(110, 45, x);
         
        gOled1.display();
        
        x-=1;
        y+=2;
        
        if (y > 100)
        {
            y = 0;   
        }
        if (x <= 0)
        {
            x = 100;   
        }
        wait(0.2);
    }
}

void Battery_Charge_SPI(int x, int y, int Niveau)
{
    int color_1 = BLACK , color_2 = BLACK , color_3 = BLACK , color_4 = BLACK;
    
    // 1 - tracé de la batterie
    gOled1.drawRect(x,2 + y ,9,15,WHITE);
    gOled1.drawRect(1 + x ,y ,7,3,WHITE);
    
    // 2 - Nombre de barres
    if (Niveau > 75)
        color_1 = WHITE;
    if (Niveau > 50)
        color_2 = WHITE;
    if (Niveau > 25)
        color_3 = WHITE;
    if (Niveau > 0)
        color_4 = WHITE;
        
    // 3 Affichage barres
    gOled1.fillRect(2 + x ,4 + y ,5,2,color_1);  
    gOled1.fillRect(2 + x ,7 + y ,5,2,color_2); 
    gOled1.fillRect(2 + x ,10 + y ,5,2,color_3); 
    gOled1.fillRect(2 + x ,13 + y ,5,2,color_4); 
} 