/*

Copyright (c) 2017 Radiant RVA

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "mbed.h"
#include "neopixel.h"
#include "ble/BLE.h"
#include "GattCallbackParamTypes.h"
#include "DFUService.h"
#include "pitches.h"
#include <DeviceInformationService.h>
extern "C" {
#include "ble_radio_notification.h"
}
#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

#define TXRX_BUF_LEN                     20

#ifdef VIQ
    #define DIGITAL_OUT_PIN                  P0_17  
    #define BOARD_LED                        P0_19  
    #define DIGITAL_IN_PIN                   P0_9
    #define PWM_PIN                          P0_16  
    #define SERVO_PIN                        P0_14  
    #define ANALOG_IN_PIN                    P0_6   
    #define LED_DIG_OUT_PIN                  P0_28   //RTS
    #define HAPTIC_PIN                       P0_5
    #define PIEZO_PIN                        P0_4
#endif

#define LED_HEADER                       0x01
#define ONOFF_HEADER                     0x11
#define COLOR_HEADER                     0x22
#define PATTERN_HEADER                   0x33
#define HAPTIC_HEADER                    0x44
#define PIEZO_HEADER                     0x55
#define ALARM_HEADER                     0x66

#define NUM_LEDS                         7

#define PATTERN_NONE                     0x00
#define PATTERN_ON                       0x01
#define PATTERN_FAST                     0x02
#define PATTERN_SLOW                     0x03
#define PATTERN_CHASE                    0x04
#define PATTERN_MRB                      0x05
#define PATTERN_RAINBOW                  0x06
#define PATTERN_CANDY                    0x07
#define PATTERN_SNOW                     0x08
#define PATTERN_XMAS                     0x09
#define PATTERN_ICE                      0x0A
#define PATTERN_COL                      0x0B
#define PATTERN_IRON                     0x0C
#define PATTERN_SPRING                   0x0D
#define PATTERN_EASTER                   0x0E
#define PATTERN_MEM                      0x0F

#define LEDS_ON                          0x01
#define LEDS_OFF                         0x02
#define PIEZO_ON                         0x01
#define PIEZO_OFF                        0x02
#define ALARM_ON                         0x01
#define ALARM_OFF                        0x02
#define HAPTIC_ON                        0x01
#define HAPTIC_OFF                       0x02

#define RINGTONE_COL                     0x70
#define RINGTONE_ONE                     0x71
#define RINGTONE_TWO                     0x72
#define RINGTONE_THREE                   0x73
#define RINGTONE_NONE                    0x74

#define HAPTIC_10                        0x10
#define HAPTIC_30                        0x30
#define HAPTIC_60                        0x60
#define BUZZ_LEVEL1                      0x51
#define BUZZ_LEVEL2                      0x52
#define BUZZ_LEVEL3                      0x53

BLE             ble;
#ifdef VIQ
    DigitalOut      LED_SET(BOARD_LED);
    DigitalIn       BUTTON(DIGITAL_IN_PIN);
    DigitalOut      BUZZER(HAPTIC_PIN);
    PwmOut          PIEZO(PIEZO_PIN);
    PwmOut          PWM(PWM_PIN);
    AnalogIn        ANALOG(ANALOG_IN_PIN);

    InterruptIn     pb(DIGITAL_IN_PIN);
    uint8_t dig_pin_num = LED_DIG_OUT_PIN;
#endif
//Serial pc(USBTX, USBRX);
static uint8_t old_state = 0;
neopixel_strip_t m_strip;

uint8_t slow_count = 0;
//uint8_t error;
uint8_t led_to_enable = 2; //10;
uint8_t red = 255;
uint8_t green = 0;
uint8_t blue = 0;
uint8_t pattern = 0;
uint8_t mPiezoOn = 0;
uint8_t mHapticOn = 0;
uint8_t mAlarmOn = 0;
uint8_t mHapticDur, mHapticPattern;
uint8_t mPiezoDur, mPiezoPattern;
uint8_t mAlarmDur, mAlarmPiezoOn, mAlarmTone, mAlarmPattern;

char mDeviceName[128];
int  mLength;

uint8_t LEDS_ON_FLAG = 0;

Timer t_alarm;
float mBeginAlarm, mEndAlarm;

/* Setup auxiliary services. */
//const static char     DEVICE_NAME[]        = "RRVA BLE";
static const uint16_t uuid16_list[]        = {GattService::UUID_DEVICE_INFORMATION_SERVICE};
DeviceInformationService *deviceInfo;

// The Nordic UART Service
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};

int freq_shave[] = {NOTE_C4, NOTE_G3, NOTE_G3, NOTE_A3, NOTE_G3, 1, NOTE_B3, NOTE_C4};
int beat_shave[] = {4, 8, 8, 4, 4, 4, 4, 4 };
int freq_coll[] = {NOTE_C4, NOTE_B4, NOTE_B4, NOTE_A4, NOTE_G4, NOTE_A4, NOTE_G4, NOTE_G4, 
                   NOTE_F4, NOTE_E4, NOTE_D3, NOTE_E4, NOTE_F4, NOTE_G4, NOTE_A4, NOTE_F4,
                   NOTE_D4, NOTE_C3, NOTE_E4, NOTE_G4, NOTE_C4, NOTE_E5, NOTE_D4, NOTE_C4, 
                   NOTE_G4, NOTE_G4, NOTE_C4, NOTE_G4};
int beat_coll[] = {6, 2, 2, 2, 4, 6, 2, 2, 2, 4, 4, 2, 2, 2,
                   2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 1, 1, 2, 2};

uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic};
GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));
void setup_advertising(void);

void rainbowCycle(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void candyChase(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void snowflakes(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void iceflakes(int delay, uint8_t numLEDs, neopixel_strip_t m_strip);
void xmas(int delay, uint8_t numLEDs, neopixel_strip_t m_strip);
void collegiate(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void irondude(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void easter(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void spring(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void memorial(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);

//extern uint32_t ble_radio_notification_init(nrf_app_irq_priority_t irq_priority,
//        nrf_radio_notification_distance_t    distance,
//       ble_radio_notification_evt_handler_t evt_handler);