#include "mbed.h" // remove line if not using mbed

#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include "nrf_delay.h"
#include "nrf_gpio.h"
#include "neopixel.h"

// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t Wheel(uint8_t WheelPos, neopixel_strip_t m_strip, uint8_t led_to_enable) {
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85) {
    return neopixel_set_color(&m_strip, led_to_enable, 255 - WheelPos * 3, 0, WheelPos * 3);
  }
  if(WheelPos < 170) {
    WheelPos -= 85;
    return neopixel_set_color(&m_strip, 0, led_to_enable, WheelPos * 3, 255 - WheelPos * 3);
  }
  WheelPos -= 170;
  return neopixel_set_color(&m_strip, led_to_enable, WheelPos * 3, 255 - WheelPos * 3, 0);
}

void rainbowCycle(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {
   uint16_t i, j;
   uint32_t ret;

  for(j=0; j<256; j++) {
    for(i=0; i<numLEDs; i++) {
      //neopixel_set_color(&m_strip, i, Wheel((i+j) & 255));
      ret = Wheel((i+j) & 255, m_strip, i);
    }
    neopixel_show(&m_strip);
    wait_ms(delay);
  }
}

void candyChase(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {
    
    for (int i=0; i < numLEDs; i++) 
        neopixel_set_color(&m_strip, i, 255,255,255);  //turn every pixel white
  
    for (int i=0; i < numLEDs-1; i++) {
        neopixel_set_color(&m_strip, i, 255,255,255);
        neopixel_set_color(&m_strip, i+1, 255,0,0);    //turn on a red pixel and move it
        neopixel_show(&m_strip);
        wait_ms(delay); 
    }
    wait_ms(delay);
    
    for (int i=0; i < numLEDs; i++) 
        neopixel_set_color(&m_strip, i, 255,0,0);  //turn every pixel red
  
    for (int i=0; i < numLEDs-1; i++) {
        neopixel_set_color(&m_strip, i, 255,0,0);
        neopixel_set_color(&m_strip, i+1, 255,255,255);    //turn on a white pixel and move it
        neopixel_show(&m_strip);
        wait_ms(delay); 
    }
}

void snowflakes(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {

    for (int i=0; i < numLEDs; i++) 
        neopixel_set_color(&m_strip, i, 0,0,235);  //turn every pixel blue
  
    for (int i=0; i < numLEDs-1; i++) {
        neopixel_set_color(&m_strip, i, 0,0,235);
        neopixel_set_color(&m_strip, i+1, 255,255,255);    //turn on a white pixel and move it
        neopixel_show(&m_strip);
        wait_ms(delay); 
    }
}

void collegiate(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {

    for (int i=0; i < numLEDs; i++) 
        neopixel_set_color(&m_strip, i, 224,193,36);  //turn every pixel gold
  
    for (int i=0; i < numLEDs-1; i++) {
        neopixel_set_color(&m_strip, i, 224,193,36);
        neopixel_set_color(&m_strip, i+1, 0,255,0);    //turn on a green pixel and move it
        neopixel_show(&m_strip);
        wait_ms(delay); 
    }
    wait_ms(delay);
    
    for (int i=0; i < numLEDs; i++) 
        neopixel_set_color(&m_strip, i, 0,255,0);  //turn every pixel green
  
    for (int i=0; i < numLEDs-1; i++) {
        neopixel_set_color(&m_strip, i, 0,255,0);
        neopixel_set_color(&m_strip, i+1, 224,193,36);    //turn on a gold pixel and move it
        neopixel_show(&m_strip);
        wait_ms(delay); 
    }
}

void iceflakes(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {
    uint8_t led;
    
    for (uint8_t i=0; i < numLEDs; i++) 
        neopixel_set_color(&m_strip, i, 235,235,235);  //turn every pixel white
  
    led = rand()%numLEDs;
    neopixel_set_color(&m_strip, led, 0, 0, 235); // set random blue
    neopixel_show(&m_strip);
    wait_ms(delay); 
}  

void xmas(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {
    //All green
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 0,255,0);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //All red
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 255,0,0);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //Green with a red mover
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 0,255,0);
    neopixel_show(&m_strip);
    wait_ms(500);
    for (int j=0; j<numLEDs; j++) 
    {
        neopixel_set_color(&m_strip, j, 255,0,0);
        neopixel_show(&m_strip);
        wait_ms(delay);  
    }   
    //Red with a green mover
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 255,0,0);
    neopixel_show(&m_strip);
    wait_ms(delay);
    for (int j=0; j<numLEDs; j++) 
    {
        neopixel_set_color(&m_strip, j, 0,255,0);
        neopixel_show(&m_strip);
        wait_ms(delay);  
    }   
}

void irondude(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {
    
    for (int i=0; i < numLEDs; i++) 
        neopixel_set_color(&m_strip, i, 255,255,255);  //turn every pixel white
  
    for (int i=0; i < numLEDs; i++) {
        neopixel_set_color(&m_strip, i, 255,0,0);    //change whites to reds
        neopixel_show(&m_strip);
        wait_ms(delay); 
    }
    wait_ms(delay);
  
    for (int i=0; i <= numLEDs; i++) {
        neopixel_set_color(&m_strip, numLEDs - i, 255,255,255);    //change reds to white, in reverse
        neopixel_show(&m_strip);
        wait_ms(delay); 
    }
}

void easter(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {
    //All purple
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 102,0,102);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //All white
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 255,255,255);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //All gold
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 255,204,0);
    neopixel_show(&m_strip);
    wait_ms(1000);
}

void spring(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {
    //All pink
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 255,102,255);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //All blue
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 153,204,255);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //All green
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 153,255,153);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //All yellow
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 255,255,153);
    neopixel_show(&m_strip);
    wait_ms(1000);
}

void memorial(int delay, uint8_t numLEDs, neopixel_strip_t m_strip) {
    //All red
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 255,0,0);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //All white
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 255,255,255);
    neopixel_show(&m_strip);
    wait_ms(1000);
    //All blue
    for (int j=0; j<numLEDs; j++) 
        neopixel_set_color(&m_strip, j, 0,0,255);
    neopixel_show(&m_strip);
    wait_ms(1000);
}