/*

Copyright (c) 2017 Radiant RVA

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#define DK_52

#include <events/mbed_events.h>
#include "vector_iq.h"

#ifdef DK_52
    DigitalOut led1(LED1, 1);
#endif

static EventQueue eventQueue(/* event count */ 16 * EVENTS_EVENT_SIZE);

void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
#ifdef VIQ
    neopixel_init(&m_strip, dig_pin_num, NUM_LEDS);
    neopixel_clear(&m_strip);
    LEDS_ON_FLAG = 0;
#endif
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising(); // restart advertising
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{
#ifdef VIQ
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead;

    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);

        //for(index=0; index<bytesRead; index++)
        //pc.putc(buf[index]);

        if(buf[0] == ONOFF_HEADER) {
            //pc.printf("LED value received \r\n");
            if(buf[1] == LEDS_ON) {
                LEDS_ON_FLAG = 1;
            } else if(buf[1] == LEDS_OFF) {
                LEDS_ON_FLAG = 0;
                neopixel_init(&m_strip, dig_pin_num, NUM_LEDS);
                neopixel_clear(&m_strip);
            }
        } else if(buf[0] == COLOR_HEADER) {
            red = buf[1];
            green = buf[2];
            blue = buf[3];
            pattern = buf[5];
        } else if(buf[0] == PIEZO_HEADER) {
            mPiezoOn = buf[1];
            //mPiezoDur = buf[2];
            mPiezoPattern = buf[2];
        } else if(buf[0] == HAPTIC_HEADER) {
            mHapticOn = buf[1];
            mHapticDur = buf[2];
            mHapticPattern = buf[3];
        } else if(buf[0] == ALARM_HEADER) {
            mAlarmOn = buf[1];
            //mAlarmStart = buf[2];
            mAlarmDur = buf[2];
            mAlarmPiezoOn = buf[4];
            mAlarmTone = buf[5];
            mAlarmPattern = buf[6];
            pattern = mAlarmPattern;
            if (mAlarmOn == ALARM_ON) {
                // Setup the timer
                t_alarm.start();
                mBeginAlarm = t_alarm.read();
                mEndAlarm = mBeginAlarm + mAlarmDur;
                mPiezoOn = mAlarmPiezoOn;
                LEDS_ON_FLAG = 1; 
            } else if (mAlarmOn == ALARM_OFF) {
                // Stop the timer
                t_alarm.stop();
                // Kill all the effects
                mHapticOn = HAPTIC_OFF;
                mPiezoOn = PIEZO_OFF;
                LEDS_ON_FLAG = 0;
            }
        }   
        else
        {
            LEDS_ON_FLAG = 1;
            red = buf[1];
            green = buf[2];
            blue = buf[3];
            pattern = buf[5];
        }
    }
#endif
}

// pb Interrupt routine - is interrupt activated by a falling edge of pb input
void pb_hit_interrupt (void) {
    pattern++;
    if (pattern >= PATTERN_MEM)
        pattern = PATTERN_ON;
}

void m_status_check_handle(void)
{
    //uint8_t buf[3];
    
    //if (BUTTON == 1) {
        // Cycle through display patterns
        //pattern++;
        //if (pattern >= PATTERN_MEM)
           // pattern = PATTERN_NONE;
    //}
}

void updateLEDs()
{
#ifdef VIQ    
        if (mAlarmOn == ALARM_ON) {
            if (t_alarm.read() > mEndAlarm) {
                // end alarm 
                t_alarm.stop();
                mHapticOn = HAPTIC_OFF;
                mPiezoOn = PIEZO_OFF;
                LEDS_ON_FLAG = 0;
            }
        } 
        if (mHapticOn == HAPTIC_ON) {
            BUZZER = 1;
            wait_ms(1000);
        } else {
            BUZZER = 0;
            //wait_ms(1000); 
        }
        if (mPiezoOn == PIEZO_ON) {
            for (int i = 0; i < (sizeof(freq_coll) / sizeof(int)); i++) {
                // Keep checking for an "Off"
                //if (mPiezoOn == PIEZO_OFF)
                    //break;
                PIEZO.period(1.0 / freq_coll[i]);
                PIEZO.write(0.9);
                wait(1.0 / beat_coll[i]);
                PIEZO.write(0);
                wait(0.05);
            }
            wait_ms(500);
        } 
        if (LEDS_ON_FLAG == 1) {          
            if (pattern == PATTERN_ON) {
                for (uint8_t i = 0; i <= NUM_LEDS; i++)
                    neopixel_set_color(&m_strip, i, red, green, blue);
                neopixel_show(&m_strip);
                
            } else if (pattern == PATTERN_FAST) {
                //neopixel_clear(&m_strip);
                for (uint8_t i = 0; i <= NUM_LEDS; i++)
                    neopixel_set_color(&m_strip, i, 0, 0, 0);
                if (led_to_enable > NUM_LEDS)
                    led_to_enable = 0;
                neopixel_set_color(&m_strip, led_to_enable, red, green, blue);
                neopixel_show(&m_strip);
                led_to_enable++;
            } else if (pattern == PATTERN_SLOW) {
                for (uint8_t i = 0; i <= NUM_LEDS; i++)
                    neopixel_set_color(&m_strip, i, 0, 0, 0);
                if (led_to_enable > NUM_LEDS)
                    led_to_enable = 0;
                neopixel_set_color(&m_strip, led_to_enable, red, green, blue);
                neopixel_show(&m_strip);
                led_to_enable++;
                wait_ms(1000);
                
            } else if (pattern == PATTERN_CHASE) {
                for (uint8_t i = 0; i <= NUM_LEDS; i++)
                    neopixel_set_color(&m_strip, i, 0, 0, 0);
                if (led_to_enable > NUM_LEDS)
                    led_to_enable = 0;
                for (uint8_t i = 0; i <= NUM_LEDS; i++)
                    neopixel_set_color(&m_strip, led_to_enable, red, green, blue);
                neopixel_show(&m_strip);
                led_to_enable++;
                wait_ms(100);
                
            } else if (pattern == PATTERN_MRB) {
                //neopixel_clear(&m_strip);
                for (uint8_t i = 0; i <= NUM_LEDS; i++)
                    neopixel_set_color(&m_strip, i, 0, 0, 0);
                led_to_enable = rand()%NUM_LEDS;
                neopixel_set_color(&m_strip, led_to_enable, red, green, blue);
                neopixel_show(&m_strip);
            }
    
            else if (pattern == PATTERN_RAINBOW)
                rainbowCycle(20, NUM_LEDS, m_strip);
    
            else if (pattern == PATTERN_CANDY)
                candyChase(100, NUM_LEDS, m_strip);
    
            else if (pattern == PATTERN_SNOW)
                snowflakes(250, NUM_LEDS, m_strip);
                
            else if (pattern == PATTERN_ICE)
                iceflakes(150, NUM_LEDS, m_strip);
                
            else if (pattern == PATTERN_XMAS)
                xmas(200, NUM_LEDS, m_strip);
                
            else if (pattern == PATTERN_COL)
                collegiate(100, NUM_LEDS, m_strip);
                
            else if (pattern == PATTERN_IRON)
                irondude(250, NUM_LEDS, m_strip);
                
            else if (pattern == PATTERN_EASTER)
                easter(250, NUM_LEDS, m_strip);
                
            else if (pattern == PATTERN_SPRING)
                spring(250, NUM_LEDS, m_strip);
                
            else if (pattern == PATTERN_MEM)
                memorial(250, NUM_LEDS, m_strip);
                
            else
                neopixel_clear(&m_strip);
        }
 #endif   
}

void periodicCallback(void)
{
#ifdef DK_52
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
#endif
    if (BLE::Instance().getGapState().connected) {
        eventQueue.call(updateLEDs);
    }
}

void onBleInitError(BLE &ble, ble_error_t error)
{
    (void)ble;
    (void)error;
   /* Initialization error handling should go here */
}

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
   
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        onBleInitError(ble, error);
        return;
    }

    if (ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    
    /* Setup primary (UART) service */
    ble.gattServer().addService(uartService); 
    
    /* Setup auxiliary service. */
    deviceInfo = new DeviceInformationService(ble, "RRVA", "VectorIQ", "SN1", "hw-rev1", "fw-rev1-1-0", "soft-rev1"); 
    //deviceInfo = new DeviceInformationService(ble, "RRVA", "VIQ", "", "", "1-0-0", ""); 
     
    // setup advertising
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED); // | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, 
                                     (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)&mDeviceName, mLength);
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(500); /* ms */
    ble.gap().startAdvertising();
    //ble.startAdvertising();
    //pc.printf("Advertising Start \r\n");
}

void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context) {
    BLE &ble = BLE::Instance();
    eventQueue.call(Callback<void()>(&ble, &BLE::processEvents));
}

int main(void)
{    
    set_time(1256729737  );  // Set RTC time to Wed, 28 Oct 2009 11:35:37
    
    strcpy(mDeviceName, "VIQ");
    mLength = strlen(mDeviceName);

    //pc.printf("neoPixel Init \r\n");
#ifdef VIQ
    neopixel_init(&m_strip, dig_pin_num, NUM_LEDS);
    neopixel_clear(&m_strip);
#endif    
    eventQueue.call_every(500, periodicCallback);

    BLE &ble = BLE::Instance();
    ble.onEventsToProcess(scheduleBleEventsProcessing);
    ble.init(bleInitComplete);

    eventQueue.dispatch_forever();
}