/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "mbed.h"
#include "neopixel.h"
#include "ble/BLE.h"
#include "GattCallbackParamTypes.h"
extern "C" {
#include "ble_radio_notification.h"
}
#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

#define TXRX_BUF_LEN                     20

#define DIGITAL_OUT_PIN                  P0_17  //D7
#define BOARD_LED                        P0_19  //
#define DIGITAL_IN_PIN                   P0_9   //P0_5   //A4
#define PWM_PIN                          P0_16  //D6
#define SERVO_PIN                        P0_14  //D10
#define ANALOG_IN_PIN                    P0_6   //A5
#define LED_DIG_OUT_PIN                  P0_8   //RTS

#define LED_HEADER                       0x01
#define ONOFF_HEADER                     0x11
#define COLOR_HEADER                     0x22
#define PATTERN_HEADER                   0x33

#define NUM_LEDS                         12

#define PATTERN_ON                       0x01
#define PATTERN_FAST                     0x02
#define PATTERN_SLOW                     0x03
#define PATTERN_CHASE                    0x04
#define PATTERN_MRB                      0x05
#define PATTERN_RAINBOW                  0x06
#define PATTERN_CANDY                    0x07
#define PATTERN_SNOW                     0x08
#define PATTERN_XMAS                     0x09
#define PATTERN_ICE                      0x0A
#define PATTERN_COL                      0x0B
#define PATTERN_IRON                     0x0C
#define LEDS_ON                          0x01
#define LEDS_OFF                         0x02

BLE             ble;

//DigitalOut      LED_SET(DIGITAL_OUT_PIN);
DigitalOut      LED_SET(BOARD_LED);
DigitalIn       BUTTON(DIGITAL_IN_PIN);
//PwmOut          PWM(PWM_PIN);
//AnalogIn        ANALOG(ANALOG_IN_PIN);

//Serial pc(USBTX, USBRX);
static uint8_t old_state = 0;
neopixel_strip_t m_strip;
uint8_t dig_pin_num = LED_DIG_OUT_PIN;
uint8_t slow_count = 0;
//uint8_t error;
uint8_t led_to_enable = 2; 
uint8_t red = 255;
uint8_t green = 0;
uint8_t blue = 0;
uint8_t pattern = 0;

char mDeviceName[128];

uint8_t LEDS_ON_FLAG = 0;

// The Nordic UART Service
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};

uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic};
GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));
void setup_advertising(void);

void rainbowCycle(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void candyChase(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void snowflakes(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void iceflakes(int delay, uint8_t numLEDs, neopixel_strip_t m_strip);
void xmas(int delay, uint8_t numLEDs, neopixel_strip_t m_strip);
void collegiate(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);
void irondude(int wait, uint8_t numLEDs, neopixel_strip_t m_strip);

//extern uint32_t ble_radio_notification_init(nrf_app_irq_priority_t irq_priority,
        nrf_radio_notification_distance_t    distance,
        ble_radio_notification_evt_handler_t evt_handler);

void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    neopixel_init(&m_strip, dig_pin_num, NUM_LEDS);
    neopixel_clear(&m_strip);
    LEDS_ON_FLAG = 0;
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    //pc.printf("Disconnected \r\n");
    //pc.printf("Restart advertising \r\n");
    
    ble.startAdvertising();
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead;

    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);

        //for(index=0; index<bytesRead; index++)
        //pc.putc(buf[index]);

        if(buf[0] == ONOFF_HEADER) {
            //pc.printf("LED value received \r\n");
            if(buf[1] == LEDS_ON) {
                LEDS_ON_FLAG = 1;
            } else if(buf[1] == LEDS_OFF) {
                LEDS_ON_FLAG = 0;
                neopixel_init(&m_strip, dig_pin_num, NUM_LEDS);
                neopixel_clear(&m_strip);
            }
        } else if(buf[0] == COLOR_HEADER) {
            red = buf[1];
            green = buf[2];
            blue = buf[3];
            pattern = buf[5];
        }
        else
        {
            LEDS_ON_FLAG = 1;
            red = buf[1];
            green = buf[2];
            blue = buf[3];
            pattern = buf[5];
        }
    }
}

void m_status_check_handle(void)
{
    uint8_t buf[3];

    // If digital in changes, report the state
    if (BUTTON != old_state) {
        old_state = BUTTON;
        if (LEDS_ON_FLAG)
            LEDS_ON_FLAG = 0;
        else
            LEDS_ON_FLAG = 1;
            
        if (BUTTON == 1) {
            buf[0] = (0x0A);
            buf[1] = (0x01);
            buf[2] = (0x00);
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3);
        } else {
            buf[0] = (0x0A);
            buf[1] = (0x00);
            buf[2] = (0x00);
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3);
        }
    }
}

void ble_on_radio_active_evt(bool radio_active)
{
    if ((radio_active == false) && (LEDS_ON_FLAG == 1)) {
        if (pattern == PATTERN_ON) {
            for (uint8_t i = 0; i <= NUM_LEDS; i++)
                neopixel_set_color(&m_strip, i, red, green, blue);
            neopixel_show(&m_strip);
            
        } else if (pattern == PATTERN_FAST) {
            //neopixel_clear(&m_strip);
            for (uint8_t i = 0; i <= NUM_LEDS; i++)
                neopixel_set_color(&m_strip, i, 0, 0, 0);
            if (led_to_enable > NUM_LEDS)
                led_to_enable = 0;
            neopixel_set_color(&m_strip, led_to_enable, red, green, blue);
            neopixel_show(&m_strip);
            led_to_enable++;
        } else if (pattern == PATTERN_SLOW) {
            for (uint8_t i = 0; i <= NUM_LEDS; i++)
                neopixel_set_color(&m_strip, i, 0, 0, 0);
            if (led_to_enable > NUM_LEDS)
                led_to_enable = 0;
            neopixel_set_color(&m_strip, led_to_enable, red, green, blue);
            neopixel_show(&m_strip);
            led_to_enable++;
            wait_ms(1000);
            
        } else if (pattern == PATTERN_CHASE) {
            for (uint8_t i = 0; i < NUM_LEDS; i++)
                neopixel_set_color(&m_strip, i, red, green, blue);
            neopixel_show(&m_strip);
            
        } else if (pattern == PATTERN_MRB) {
            //neopixel_clear(&m_strip);
            for (uint8_t i = 0; i <= NUM_LEDS; i++)
                neopixel_set_color(&m_strip, i, 0, 0, 0);
            led_to_enable = rand()%NUM_LEDS;
            neopixel_set_color(&m_strip, led_to_enable, red, green, blue);
            neopixel_show(&m_strip);
        }

        else if (pattern == PATTERN_RAINBOW)
            rainbowCycle(20, NUM_LEDS, m_strip);

        else if (pattern == PATTERN_CANDY)
            candyChase(100, NUM_LEDS, m_strip);

        else if (pattern == PATTERN_SNOW)
            snowflakes(250, NUM_LEDS, m_strip);
            
        else if (pattern == PATTERN_ICE)
            iceflakes(150, NUM_LEDS, m_strip);
            
        else if (pattern == PATTERN_XMAS)
            xmas(200, NUM_LEDS, m_strip);
            
        else if (pattern == PATTERN_COL)
            collegiate(100, NUM_LEDS, m_strip);
            
        else if (pattern == PATTERN_IRON)
            irondude(250, NUM_LEDS, m_strip);
            
        else
            neopixel_clear(&m_strip);

    }
}

static void radio_notification_init(void)
{
    //uint32_t err_code;
    ble_radio_notification_init(NRF_APP_PRIORITY_LOW,
                               NRF_RADIO_NOTIFICATION_DISTANCE_800US,
                                ble_on_radio_active_evt);
 //APP_ERROR_CHECK(err_code);
}

void setup_advertising(void)
{
    int length = strlen(mDeviceName);
    
    // setup advertising
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)&mDeviceName, length);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    // In multiples of 0.625ms.
    ble.setAdvertisingInterval(80);
    ble.addService(uartService);
    ble.startAdvertising();
    //pc.printf("Advertising Start \r\n");
}

int main(void)
{
    //uint8_t led_error;

    Ticker ticker;
    ticker.attach_us(m_status_check_handle, 200000);

    //pc.printf("neoPixel Init \r\n");
    neopixel_init(&m_strip, dig_pin_num, NUM_LEDS);
    neopixel_clear(&m_strip);

    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onConnection(connectionCallback);
    ble.onDataWritten(WrittenHandler);
    radio_notification_init();
    //pc.baud(9600);
    //pc.format(8, SerialBase::None, 1);
    //pc.printf("rbChromaBand Init \r\n");
    //pc.attach( uartCB , pc.RxIrq);
    
    strcpy(mDeviceName, "RRVA BLE");

    setup_advertising();

    while(1) {
        //pc.putc(pc.getc());
        ble.waitForEvent();
    }
}
































