#include "mbed.h"
#include "drv_canfdspi_api.h"
#include "drv_spi.h"
#include "drv_canfdspi_defines.h"
#include "drv_canfdspi_register.h"

DigitalOut myled(LED1);
DigitalOut led2(LED2);
DigitalOut standby0(p21);
DigitalOut standby1(p24);
Serial pc(USBTX,USBRX);
//DigitalIn int1(p14);
InterruptIn button(p14);

uint16_t txCounter = 0x500;
//CAN_OPERATION_MODE opMode;

#define APP_TX_FIFO CAN_FIFO_CH2
#define APP_RX_FIFO CAN_FIFO_CH1

void mcp2517_init(void)
{
    REG_CiFLTOBJ fObj;
    REG_CiMASK mObj;
    
    CAN_OSC_STATUS osc_status;
    
    DRV_SPI_Initialize();
    
    // Reset device
    DRV_CANFDSPI_Reset(DRV_CANFDSPI_INDEX_0);
   
    // Oscillator Configuration: divide by 10
    CAN_OSC_CTRL oscCtrl;
    DRV_CANFDSPI_OscillatorControlObjectReset(&oscCtrl);
    oscCtrl.ClkOutDivide = OSC_CLKO_DIV1;
    if (DRV_CANFDSPI_OscillatorControlSet(DRV_CANFDSPI_INDEX_0, oscCtrl) < 0)
        pc.printf("osc set error \r\n");
    else
        pc.printf("osc set correct \r\n");
    
    DRV_CANFDSPI_OscillatorStatusGet(DRV_CANFDSPI_INDEX_0, &osc_status);
    pc.printf("pll-%d, osc-%d, sclk-%d \r\n", osc_status.PllReady, osc_status.OscReady, osc_status.SclkReady);
    
                                            
    // Input/Output Configuration: use nINT0 and nINT1
    DRV_CANFDSPI_GpioInterruptPinsOpenDrainConfigure(DRV_CANFDSPI_INDEX_0, GPIO_OPEN_DRAIN);
    DRV_CANFDSPI_GpioModeConfigure(DRV_CANFDSPI_INDEX_0, GPIO_MODE_INT, GPIO_MODE_INT);
    DRV_CANFDSPI_GpioClockOutputConfigure(DRV_CANFDSPI_INDEX_0, GPIO_CLKO_SOF); 

    // CAN Configuration: ISO_CRC, enable TEF, enable TXQ
    CAN_CONFIG config;
    DRV_CANFDSPI_ConfigureObjectReset(&config);
    config.IsoCrcEnable = 1;
    config.StoreInTEF = 1;
    config.TXQEnable = 1;
    DRV_CANFDSPI_Configure(DRV_CANFDSPI_INDEX_0, &config);

    // Bit Time Configuration: 500K/2M, 80% sample point
    if (DRV_CANFDSPI_BitTimeConfigure(DRV_CANFDSPI_INDEX_0, CAN_500K_2M, CAN_SSP_MODE_AUTO, CAN_SYSCLK_20M) < 0)
        pc.printf("Bit time set error \r\n");
        else
        pc.printf("Bit time set ok \r\n");

    // TEF Configuration: 12 messages, time stamping enabled
    CAN_TEF_CONFIG tefConfig;
    tefConfig.FifoSize = 11;
    tefConfig.TimeStampEnable = 1;
    DRV_CANFDSPI_TefConfigure(DRV_CANFDSPI_INDEX_0, &tefConfig);

    // TXQ Configuration: 8 messages, 32 byte maximum payload, high priority
    CAN_TX_QUEUE_CONFIG txqConfig;
    DRV_CANFDSPI_TransmitQueueConfigureObjectReset(&txqConfig);
    txqConfig.TxPriority = 1;
    txqConfig.FifoSize = 7;
    txqConfig.PayLoadSize = CAN_PLSIZE_32;
    DRV_CANFDSPI_TransmitQueueConfigure(DRV_CANFDSPI_INDEX_0, &txqConfig);

    // FIFO 1: Transmit FIFO; 5 messages, 64 byte maximum payload, low priority
    CAN_TX_FIFO_CONFIG txfConfig;
    DRV_CANFDSPI_TransmitChannelConfigureObjectReset(&txfConfig);
    txfConfig.FifoSize = 4;
    txfConfig.PayLoadSize = CAN_PLSIZE_64;
    txfConfig.TxPriority = 0;
    DRV_CANFDSPI_TransmitChannelConfigure(DRV_CANFDSPI_INDEX_0, APP_TX_FIFO, &txfConfig);

    // FIFO 2: Receive FIFO; 16 messages, 64 byte maximum payload, time stamping enabled
    CAN_RX_FIFO_CONFIG rxfConfig;
    rxfConfig.FifoSize = 15;
    rxfConfig.PayLoadSize = CAN_PLSIZE_64;
    rxfConfig.RxTimeStampEnable = 1;
    DRV_CANFDSPI_ReceiveChannelConfigure(DRV_CANFDSPI_INDEX_0, APP_RX_FIFO, &rxfConfig);

    // Setup RX Filter
    fObj.word = 0;
    fObj.bF.SID = 0x0;
    fObj.bF.EXIDE = 0;
    fObj.bF.EID = 0x00;

    DRV_CANFDSPI_FilterObjectConfigure(DRV_CANFDSPI_INDEX_0, CAN_FILTER0, &fObj.bF);

    // Setup RX Mask
    mObj.word = 0;
    mObj.bF.MSID = 0x0;
    mObj.bF.MIDE = 0; 
    mObj.bF.MEID = 0x0;
    DRV_CANFDSPI_FilterMaskConfigure(DRV_CANFDSPI_INDEX_0, CAN_FILTER0, &mObj.bF);

    // Link FIFO and Filter
    DRV_CANFDSPI_FilterToFifoLink(DRV_CANFDSPI_INDEX_0, CAN_FILTER0, APP_RX_FIFO, true);
    
    // Double Check RAM Usage: 2040 Bytes out of a maximum of 2048 Bytes -> OK.
    // Enable ECC
    DRV_CANFDSPI_EccEnable(DRV_CANFDSPI_INDEX_0);

    // Initialize RAM
    DRV_CANFDSPI_RamInit(DRV_CANFDSPI_INDEX_0, 0xff);
    
    // Setup Transmit and Receive Interrupts
    DRV_CANFDSPI_GpioModeConfigure(DRV_CANFDSPI_INDEX_0, GPIO_MODE_INT, GPIO_MODE_INT);
    DRV_CANFDSPI_TransmitChannelEventEnable(DRV_CANFDSPI_INDEX_0, APP_TX_FIFO, CAN_TX_FIFO_NOT_FULL_EVENT);
    DRV_CANFDSPI_ReceiveChannelEventEnable(DRV_CANFDSPI_INDEX_0, APP_RX_FIFO, CAN_RX_FIFO_NOT_EMPTY_EVENT);

    DRV_CANFDSPI_ModuleEventEnable(DRV_CANFDSPI_INDEX_0, CAN_RX_EVENT);

    // Configuration Done: Select Normal Mode
    DRV_CANFDSPI_OperationModeSelect(DRV_CANFDSPI_INDEX_0, CAN_NORMAL_MODE);
    pc.printf("Init done \r\n");
}

void mcp2517_test_RAM(void)
{
    // Variables
    uint8_t txd[MAX_DATA_BYTES];
    uint8_t rxd[MAX_DATA_BYTES];
    uint8_t i;
    uint8_t length;

    // Verify read/write with different access length
    // Note: RAM can only be accessed in multiples of 4 bytes
    for (length = 4; length <= MAX_DATA_BYTES; length += 4) {
        for (i = 0; i < length; i++) {
            txd[i] = rand() & 0xff;
            rxd[i] = 0x01;
        }

        // Write data to RAM
        DRV_CANFDSPI_WriteByteArray(DRV_CANFDSPI_INDEX_0, cRAMADDR_START, txd, length);

        // Read data back from RAM
        DRV_CANFDSPI_ReadByteArray(DRV_CANFDSPI_INDEX_0, cRAMADDR_START, rxd, length);

        // Verify
        bool good = false;
        for (i = 0; i < length; i++) {
            good = txd[i] == rxd[i];

            if (!good) {
                //Nop();
                //Nop();
                wait_ms(100);

                // Data mismatch
            }
        }
        pc.printf("%s \r\n", good?"PASS":"FAIL");
        if (good == false) {
            for (i = 0; i < length; i++)
                pc.printf("%d %d \r\n", txd[i], rxd[i]);
        }
    }
}


void mcp2517_test_registers(void)
{
    // Variables
    uint8_t txd[MAX_DATA_BYTES];
    uint8_t rxd[MAX_DATA_BYTES];
    uint8_t i;
    uint8_t length;

    // Verify read/write with different access length
    // Note: registers can be accessed in multiples of bytes
    for (length = 1; length <= MAX_DATA_BYTES; length++) {
        for (i = 0; i < length; i++) {
            txd[i] = rand() & 0x7f; // Bit 31 of Filter objects is not implemented
            rxd[i] = 0xff;
        }
        // Write data to registers
        DRV_CANFDSPI_WriteByteArray(DRV_CANFDSPI_INDEX_0, cREGADDR_CiFLTOBJ, txd, length);

        // Read data back from registers
        DRV_CANFDSPI_ReadByteArray(DRV_CANFDSPI_INDEX_0, cREGADDR_CiFLTOBJ, rxd, length);

        // Verify
        bool good = false;
        for (i = 0; i < length; i++) {
            good = txd[i] == rxd[i];

            if (!good) {
                //Nop();
                //Nop();
                wait_ms(100);
                pc.printf("Reg test fail\r\n");
                // Data mismatch
            } else {
                pc.printf("..\r\n");
            }
        }
    }

    //Nop();
    //Nop();
    wait_ms(10);
}

void mcp2517_test_transmit(void)
{
    // Assemble transmit message: CAN FD Base frame with BRS, 64 data bytes
    CAN_TX_MSGOBJ txObj;
    uint8_t txd[MAX_DATA_BYTES];

    // Initialize ID and Control bits
    txObj.word[0] = 0;
    txObj.word[1] = 0;

    txObj.bF.id.SID = txCounter; // Standard or Base ID
    txObj.bF.id.EID = 0;

    txObj.bF.ctrl.FDF = 1; // CAN FD frame
    txObj.bF.ctrl.BRS = 1; // Switch bit rate
    txObj.bF.ctrl.IDE = 0; // Standard frame
    txObj.bF.ctrl.RTR = 0; // Not a remote frame request
    txObj.bF.ctrl.DLC = CAN_DLC_48;//CAN_DLC_8; // 64 data bytes
    // Sequence: doesn't get transmitted, but will be stored in TEF
    txObj.bF.ctrl.SEQ = 1;

    // Initialize transmit data
    uint8_t i;
    for (i = 0; i < DRV_CANFDSPI_DlcToDataBytes(txObj.bF.ctrl.DLC); i++) {
        txd[i] = i;
    }

    // Check that FIFO is not full
    CAN_TX_FIFO_EVENT txFlags;
    bool flush = true;

    // Just send don't check
  //  DRV_CANFDSPI_TransmitChannelEventGet(DRV_CANFDSPI_INDEX_0, CAN_FIFO_CH1, &txFlags);
  //  pc.printf("%x flags \r\n", (uint32_t)txFlags);
  //  if (txFlags & CAN_TX_FIFO_NOT_FULL_EVENT) {
        // Load message and transmit
        DRV_CANFDSPI_TransmitChannelLoad(DRV_CANFDSPI_INDEX_0, APP_TX_FIFO, &txObj, txd,
                                         DRV_CANFDSPI_DlcToDataBytes(txObj.bF.ctrl.DLC), flush);

        txCounter++;

        if (txCounter > 0x510) {
            wait_ms(10);
            txCounter = 0x500;
        }
 //   }

    wait_ms(10);
}




void mcp2517_recv_interrupt()
{
    led2 = led2 ^ 1;
    // Receive Message Object
    CAN_RX_MSGOBJ rxObj;
    uint8_t dlc, rxd[MAX_DATA_BYTES];
    CAN_RX_FIFO_EVENT rxFlags;
    static int rcv_count = 0;
    
    DRV_CANFDSPI_ReceiveChannelEventGet(DRV_CANFDSPI_INDEX_0, APP_RX_FIFO, &rxFlags);

    if (rxFlags & CAN_RX_FIFO_NOT_EMPTY_EVENT) {
       DRV_CANFDSPI_ReceiveMessageGet(DRV_CANFDSPI_INDEX_0, APP_RX_FIFO, &rxObj, rxd, MAX_DATA_BYTES);
       DRV_CANFDSPI_ModuleEventClear(DRV_CANFDSPI_INDEX_0, CAN_RX_EVENT);
       dlc = DRV_CANFDSPI_DlcToDataBytes( (CAN_DLC) rxObj.bF.ctrl.DLC);
       pc.printf("Received ID 0x%x  with %d bytes \r\n", rxObj.bF.id.SID, dlc);
       for(int i=0; i<dlc; i++) pc.printf("%02x ", rxd[i]);
       pc.printf("\r\n");
       rcv_count++;
    }
}

int main()
{
    pc.baud(115200);
    pc.printf("Starting .... \n");
    standby0 = 0;
    standby1 = 0;
    button.fall(&mcp2517_recv_interrupt);
    mcp2517_init();

/*  CAN_OPERATION_MODE opMode;
    button.fall(&mcp2517_recv_interrupt);
    standby0 = 0;
    standby1 = 0;

    DRV_CANFDSPI_OperationModeSelect(DRV_CANFDSPI_INDEX_0, CAN_CONFIGURATION_MODE);
    wait(1);
    opMode = DRV_CANFDSPI_OperationModeGet(DRV_CANFDSPI_INDEX_0);
    if (opMode != CAN_CONFIGURATION_MODE) {
        pc.printf("No Config mode !!");
    } else
        mcp2517_init();


    DRV_CANFDSPI_FilterDisable(DRV_CANFDSPI_INDEX_0, CAN_FILTER0);
    // Configure Filter Object 0
    CAN_FILTEROBJ_ID fObj;
    fObj.SID = 0x300; // IDs 0x300...
    fObj.SID11 = 0;
    fObj.EID = 0;
    fObj.EXIDE = 0; // Only except Standard frames
    DRV_CANFDSPI_FilterObjectConfigure(DRV_CANFDSPI_INDEX_0, CAN_FILTER0, &fObj);
    // Configure Mask Object 0
    CAN_MASKOBJ_ID mObj;
    mObj.MSID = 0x000; // 0 means don't care
    mObj.MSID11 = 0;
    mObj.MEID = 0;
    mObj.MIDE = 0; // Match IDE bit
    DRV_CANFDSPI_FilterMaskConfigure(DRV_CANFDSPI_INDEX_0, CAN_FILTER0, &mObj);
    // Link Filter to RX FIFO 2, and enable Filter
    bool filterEnable = true;
    DRV_CANFDSPI_FilterToFifoLink(DRV_CANFDSPI_INDEX_0, CAN_FILTER0, CAN_FIFO_CH2, filterEnable);
    DRV_CANFDSPI_TimeStampDisable(DRV_CANFDSPI_INDEX_0);

    // Configure pre-scaler so TBC increments every 1 us @ 40MHz clock: 40-1 = 39
    DRV_CANFDSPI_TimeStampPrescalerSet(DRV_CANFDSPI_INDEX_0, 39);
    // Set TBC to zero
    DRV_CANFDSPI_TimeStampSet(DRV_CANFDSPI_INDEX_0, 0);
    // Enable TBC
    DRV_CANFDSPI_TimeStampEnable(DRV_CANFDSPI_INDEX_0);
  

    DRV_CANFDSPI_ModuleEventClear(DRV_CANFDSPI_INDEX_0, CAN_ALL_EVENTS);
    // Configure receive interrupt for FIFO 2
    DRV_CANFDSPI_ReceiveChannelEventEnable(DRV_CANFDSPI_INDEX_0, CAN_FIFO_CH2, CAN_RX_FIFO_NOT_EMPTY_EVENT);
    DRV_CANFDSPI_ModuleEventEnable(DRV_CANFDSPI_INDEX_0, CAN_RX_EVENT); 

    DRV_CANFDSPI_ModuleEventClear(DRV_CANFDSPI_INDEX_0, CAN_ALL_EVENTS);
  */  
    while(1) {
        myled = 1;
        wait(0.5);
  
  //    mcp2517_test_transmit();        
   
        myled = 0;
        wait(0.5);
 //       if (int1==0)mcp2517_recv_interrupt();
   
    }
}
