#ifndef __frameclock_h__
#define __frameclock_h__

#include "LTCApp.h"

class frameclock
{
public:
    frameclock();
    frameclock(int hour, int minute, int second, int frame, int rate, bool drop);

    void setMode(int rate, bool drop);
    void setTime(int hour, int minute, int second, int frame);

    inline void getTime(int *hour, int *minute, int *second, int *frame)
    {
        *hour = _hour;
        *minute = _minute;
        *second = _second;
        *frame = _frame;
    }

    uint32_t getTimeMS() {
       return (_hour*3600+_minute*60+_second)*1000 + (1000*_frame)/_rate;
    }

    void nextFrame();
    inline int hours(){return _hour;}
    inline int minutes(){return _minute;}
    inline int seconds(){return _second;}
    inline int frame() {return _frame;}

private:

    int _hour;
    int _minute;
    int _second;
    int _frame;
    int _rate;
    bool _drop;


};



#endif
