#ifndef __LTCDECODE_H__
#define __LTCDECODE_H__

#include "mbed.h"


class LTCDecode
{

public:
    LTCDecode(const PinName pin);

    inline bool synced()
    {
        return LTCsynced;
    };

    void enable(bool enable);

    void attachFrame(void (*callback)(void))
    {
        FrameCallback.attach(callback);
    }

    inline void getTime(int *hour, int *minute, int *second, int *frame)
    {
        *hour = _hours;
        *minute = _minutes;
        *second = _seconds;
        *frame = _frame;
    }
    
    inline bool isFrameDrop() {return _frameDrop;}

    template<typename T>
    void attachFrame(T* tptr, void (T::*mptr)(void))
    {
        FrameCallback.attach(tptr, mptr);
    }

private:
    void LTCOnEdge(void);

    InterruptIn _LTCIn;
    Timer inputTimer;

    FunctionPointer FrameCallback;

    // add a bit. Return true if we got the end of frame pattern
    bool addBitToBuffer(bool bit);
    void decodeTime();
    int _hours;
    int _minutes;
    int _seconds;
    int _frame;
    bool _frameDrop;

    bool LTCsynced;

    volatile int newBitsWrite;
    int newBitsRead;

    // max bit period = 520.8 ms (1920 Hz)
    // min bit period = 416.7 ms (2400 Hz)
    // max period of a '1' symbol = 260.4ms (1920Hz * 2)

    uint32_t lastTransition;
    uint32_t lastBitStart;

    uint32_t LTCBuffer[3];
};

#endif
